/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog.edit;

import gde.GDE;
import gde.data.Record;
import gde.device.DataTypes;
import gde.device.DeviceConfiguration;
import gde.device.MeasurementPropertyTypes;
import gde.device.ObjectFactory;
import gde.device.PropertyType;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.edit.DevicePropertiesEditor;
import gde.ui.dialog.edit.MeasurementContextmenu;
import gde.ui.dialog.edit.MeasurementTypeTabItem;
import gde.utils.StringHelper;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PropertyTypeTabItem
extends CTabItem {
    static final Logger log = Logger.getLogger(PropertyTypeTabItem.class.getName());
    final CTabFolder parentTabFolder;
    final MeasurementTypeTabItem measurementTypeTabItem;
    Composite propertyTypeComposite;
    Label nameLabel;
    Label typeLabel;
    Label valueLabel;
    Label descriptionLabel;
    Text nameText;
    Text valueText;
    Text descriptionText;
    CCombo typeCombo;
    CCombo valueCombo;
    CCombo nameCombo;
    KeyAdapter valueKeyListener;
    VerifyListener valueVerifyListener;
    DeviceConfiguration deviceConfig;
    boolean isStateType;
    boolean isValueOnlyEnabledType;
    boolean isNameSelectionEnabledType;
    boolean isTypeSelectionEnabledType;
    Menu popupMenu;
    MeasurementContextmenu contextMenu;
    String tabName;
    PropertyType propertyType;
    final DevicePropertiesEditor propsEditor;

    public PropertyTypeTabItem(CTabFolder parent, int style, String useTabName, MeasurementTypeTabItem useMeasurementTypeTabItem2CreatePopupMenu) {
        super(parent, style);
        this.parentTabFolder = parent;
        this.propsEditor = DevicePropertiesEditor.getInstance();
        this.tabName = useTabName;
        this.measurementTypeTabItem = useMeasurementTypeTabItem2CreatePopupMenu;
        this.propertyType = new ObjectFactory().createPropertyType();
        this.propertyType.setName(Messages.getString("GDE_MSGT0473"));
        this.propertyType.setType(DataTypes.INTEGER);
        this.propertyType.setValue("0");
        this.propertyType.setDescription(Messages.getString("GDE_MSGT0474"));
        this.initGUI();
    }

    void enableContextMenu(boolean enable) {
        if (enable && this.measurementTypeTabItem != null) {
            this.popupMenu = new Menu((Decorations)this.measurementTypeTabItem.channelConfigMeasurementPropertiesTabFolder.getShell(), 8);
            this.contextMenu = new MeasurementContextmenu(this.popupMenu, this.measurementTypeTabItem, this.measurementTypeTabItem.channelConfigMeasurementPropertiesTabFolder);
            this.contextMenu.create();
        } else if (this.popupMenu != null) {
            this.popupMenu.dispose();
            this.popupMenu = null;
            this.contextMenu = null;
        }
        this.propertyTypeComposite.setMenu(this.popupMenu);
        this.nameLabel.setMenu(this.popupMenu);
        this.typeLabel.setMenu(this.popupMenu);
        this.valueLabel.setMenu(this.popupMenu);
        this.descriptionLabel.setMenu(this.popupMenu);
    }

    public void setNameComboItems(String[] items) {
        this.nameCombo.setItems(items);
    }

    public void setProperty(DeviceConfiguration useDeviceConfig, PropertyType useProperty, boolean enableEditName, String[] nameSelectionItems, String[] typeSelectionItems, boolean enableEditValue) {
        this.deviceConfig = useDeviceConfig;
        this.propertyType = useProperty;
        this.isStateType = enableEditName && nameSelectionItems != null && typeSelectionItems != null && !enableEditValue;
        this.isValueOnlyEnabledType = !enableEditName && nameSelectionItems != null && typeSelectionItems != null && enableEditValue;
        this.isNameSelectionEnabledType = !enableEditName && nameSelectionItems != null && nameSelectionItems.length > 1;
        this.isTypeSelectionEnabledType = !this.isStateType && typeSelectionItems != null && typeSelectionItems.length > 1;
        this.tabName = this.propertyType.getName();
        this.setText(this.tabName);
        if (this.isNameSelectionEnabledType) {
            this.nameText.setVisible(false);
            this.nameCombo.setVisible(true);
            this.nameCombo.setItems(nameSelectionItems);
        } else {
            this.nameText.setVisible(true);
            this.nameText.setEditable(enableEditName);
            this.nameText.setEnabled(enableEditName);
            this.nameCombo.setVisible(false);
        }
        this.typeCombo.setEnabled(this.isTypeSelectionEnabledType);
        if (this.propertyType.getType() == DataTypes.BOOLEAN) {
            this.valueText.setVisible(false);
            this.valueCombo.setVisible(true);
        } else if (this.propertyType.getName().equals(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value()) || this.propertyType.getName().equals(MeasurementPropertyTypes.DATA_TYPE.value())) {
            this.valueText.setVisible(false);
            this.valueCombo.setVisible(true);
        } else {
            this.valueCombo.setVisible(false);
            this.valueText.setVisible(true);
            this.valueText.setEnabled(enableEditValue);
            this.valueText.setEditable(enableEditValue);
        }
        this.initialize();
    }

    public static String[] getDataTypesItems(PropertyType property, String[] dataTypeItems) {
        if (!MeasurementPropertyTypes.isNoneSpecified(property.getName())) {
            switch (MeasurementPropertyTypes.fromValue(property.getName())) {
                case OFFSET: 
                case FACTOR: 
                case REDUCTION: 
                case REVOLUTION_FACTOR: {
                    dataTypeItems = new String[]{DataTypes.DOUBLE.value()};
                    break;
                }
                case REGRESSION_INTERVAL_SEC: 
                case NUMBER_MOTOR: 
                case NUMBER_CELLS: 
                case PROP_N_100_W: 
                case SCALE_SYNC_REF_ORDINAL: {
                    dataTypeItems = new String[]{DataTypes.INTEGER.value()};
                    break;
                }
                case REGRESSION_TYPE_CURVE: 
                case REGRESSION_TYPE_LINEAR: 
                case DATA_TYPE: {
                    dataTypeItems = new String[]{DataTypes.STRING.value()};
                    break;
                }
                case IS_INVERT_CURRENT: 
                case DO_SUBTRACT_FIRST: 
                case DO_SUBTRACT_LAST: {
                    dataTypeItems = new String[]{DataTypes.BOOLEAN.value()};
                    break;
                }
                default: {
                    dataTypeItems = new String[]{""};
                }
            }
        }
        return dataTypeItems;
    }

    private void initGUI() {
        try {
            SWTResourceManager.registerResourceUser((Widget)this);
            this.setText(this.tabName);
            this.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeevent) {
                    log.log(java.util.logging.Level.FINEST, "propertyTypeTabItem.widgetDisposed, event=" + String.valueOf(disposeevent));
                    if (PropertyTypeTabItem.this.deviceConfig != null && PropertyTypeTabItem.this.propsEditor != null && PropertyTypeTabItem.this.propsEditor.saveButton != null && !PropertyTypeTabItem.this.propsEditor.saveButton.isDisposed()) {
                        PropertyTypeTabItem.this.measurementTypeTabItem.measurementType.getProperty().remove(PropertyTypeTabItem.this.propertyType);
                        PropertyTypeTabItem.this.deviceConfig.setChangePropery(true);
                        PropertyTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.propertyTypeComposite = new Composite((Composite)this.parentTabFolder, 0);
            this.setControl((Control)this.propertyTypeComposite);
            this.propertyTypeComposite.setLayout(null);
            this.propertyTypeComposite.setSize(300, 160);
            this.propertyTypeComposite.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINEST, "propertyTypeComposite.helpRequested " + String.valueOf(evt));
                    DataExplorer.getInstance().openHelpDialog("", "HelpInfo_A.html");
                }
            });
            this.nameLabel = new Label(this.propertyTypeComposite, 131072);
            this.nameLabel.setText(Messages.getString("GDE_MSGT0549"));
            this.nameLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.nameLabel.setBounds(5, 12, 80, 20);
            this.typeLabel = new Label(this.propertyTypeComposite, 131072);
            this.typeLabel.setText(Messages.getString("GDE_MSGT0552"));
            this.typeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.typeLabel.setBounds(5, 38, 80, 20);
            this.valueLabel = new Label(this.propertyTypeComposite, 131072);
            this.valueLabel.setText(Messages.getString("GDE_MSGT0553"));
            this.valueLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.valueLabel.setBounds(5, 65, 80, 20);
            this.descriptionLabel = new Label(this.propertyTypeComposite, 131072);
            this.descriptionLabel.setText(Messages.getString("GDE_MSGT0554"));
            this.descriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.descriptionLabel.setBounds(5, 92, 80, 20);
            this.nameText = new Text(this.propertyTypeComposite, 2048);
            this.nameText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.nameText.setBounds(90, 10, 200, 20);
            this.nameText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "nameText.keyReleased, event=" + String.valueOf(evt));
                    PropertyTypeTabItem.this.propertyType.setName(PropertyTypeTabItem.this.nameText.getText());
                    if (PropertyTypeTabItem.this.deviceConfig != null) {
                        PropertyTypeTabItem.this.deviceConfig.setChangePropery(true);
                        PropertyTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    PropertyTypeTabItem.this.tabName = PropertyTypeTabItem.this.nameText.getText();
                    PropertyTypeTabItem.this.setText(PropertyTypeTabItem.this.tabName);
                }
            });
            this.nameCombo = new CCombo(this.propertyTypeComposite, 2048);
            this.nameCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.nameCombo.setBounds(90, 10, 200, 20);
            this.nameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "nameCombo.widgetSelected, event=" + String.valueOf(evt));
                    PropertyTypeTabItem.this.propertyType.setName(PropertyTypeTabItem.this.nameCombo.getText().toLowerCase());
                }
            });
            this.typeCombo = new CCombo(this.propertyTypeComposite, 2048);
            this.typeCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.typeCombo.setItems(DataTypes.valuesAsStingArray());
            this.typeCombo.setBounds(90, 37, 120, 20);
            this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "typeCombo.widgetSelected, event=" + String.valueOf(evt));
                    PropertyTypeTabItem.this.propertyType.setType(DataTypes.fromValue(PropertyTypeTabItem.this.typeCombo.getText()));
                    if (PropertyTypeTabItem.this.propertyType.getType() == DataTypes.BOOLEAN) {
                        PropertyTypeTabItem.this.valueText.setVisible(false);
                        PropertyTypeTabItem.this.valueCombo.setVisible(true);
                        PropertyTypeTabItem.this.propertyType.setValue(StringHelper.verifyTypedString(DataTypes.BOOLEAN, PropertyTypeTabItem.this.valueCombo.getText()));
                        if (PropertyTypeTabItem.this.deviceConfig != null) {
                            PropertyTypeTabItem.this.deviceConfig.setChangePropery(true);
                            PropertyTypeTabItem.this.propsEditor.enableSaveButton(true);
                        }
                        PropertyTypeTabItem.this.valueCombo.select(PropertyTypeTabItem.this.valueCombo.getText().equals("true") ? 0 : 1);
                    } else {
                        PropertyTypeTabItem.this.valueText.setVisible(true);
                        PropertyTypeTabItem.this.valueCombo.setVisible(false);
                        try {
                            PropertyTypeTabItem.this.propertyType.setValue(StringHelper.verifyTypedString(PropertyTypeTabItem.this.propertyType.getType(), PropertyTypeTabItem.this.valueText.getText()));
                        }
                        catch (Exception e) {
                            PropertyTypeTabItem.this.propertyType.setValue("0");
                        }
                        PropertyTypeTabItem.this.valueText.setText(PropertyTypeTabItem.this.propertyType.getValue());
                    }
                }
            });
            this.valueText = new Text(this.propertyTypeComposite, 2048);
            this.valueText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.valueText.setBounds(90, 65, 120, 20);
            this.valueKeyListener = new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "valueText.keyReleased, event=" + String.valueOf(evt));
                    PropertyTypeTabItem.this.propertyType.setValue(PropertyTypeTabItem.this.valueText.getText());
                    if (PropertyTypeTabItem.this.deviceConfig != null) {
                        PropertyTypeTabItem.this.deviceConfig.setChangePropery(true);
                        PropertyTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            };
            this.valueText.addKeyListener((KeyListener)this.valueKeyListener);
            this.valueVerifyListener = new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "valueText.verifyText, event=" + String.valueOf(evt));
                    log.log(java.util.logging.Level.FINE, evt.text);
                    evt.doit = PropertyTypeTabItem.this.propertyType.getType() == null ? true : StringHelper.verifyTypedInput(PropertyTypeTabItem.this.propertyType.getType(), evt.text);
                }
            };
            this.valueText.addVerifyListener(this.valueVerifyListener);
            this.valueCombo = new CCombo(this.propertyTypeComposite, 2048);
            this.valueCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.valueCombo.setBounds(90, 65, 120, 20);
            this.valueCombo.setEditable(false);
            this.valueCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
            this.valueCombo.setItems(GDE.STRING_ARRAY_TRUE_FALSE);
            this.valueCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "valueCombo.widgetSelected, event=" + String.valueOf(evt));
                    if (PropertyTypeTabItem.this.deviceConfig != null) {
                        if (PropertyTypeTabItem.this.propertyType.getName().equals(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value())) {
                            PropertyTypeTabItem.this.propertyType.setValue("" + PropertyTypeTabItem.this.valueCombo.getSelectionIndex());
                        } else {
                            try {
                                PropertyTypeTabItem.this.propertyType.setValue(DataTypes.fromValue(PropertyTypeTabItem.this.valueCombo.getText()).value());
                            }
                            catch (Exception e) {
                                PropertyTypeTabItem.this.propertyType.setValue(PropertyTypeTabItem.this.valueCombo.getText());
                            }
                        }
                    } else {
                        PropertyTypeTabItem.this.propertyType.setValue(PropertyTypeTabItem.this.valueCombo.getText());
                    }
                    if (PropertyTypeTabItem.this.deviceConfig != null) {
                        PropertyTypeTabItem.this.deviceConfig.setChangePropery(true);
                        PropertyTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.descriptionText = new Text(this.propertyTypeComposite, 18496);
            this.descriptionText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.descriptionText.setBounds(90, 92, 200, 55);
            this.descriptionText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "descriptionText.keyReleased, event=" + String.valueOf(evt));
                    PropertyTypeTabItem.this.propertyType.setDescription(PropertyTypeTabItem.this.descriptionText.getText());
                    if (PropertyTypeTabItem.this.deviceConfig != null) {
                        PropertyTypeTabItem.this.deviceConfig.setChangePropery(true);
                        PropertyTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.propertyTypeComposite.layout();
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PropertyType getProperty() {
        return this.propertyType;
    }

    private void initialize() {
        if (this.propertyType != null) {
            this.nameText.setText(this.propertyType.getName());
            if (this.nameCombo.isVisible()) {
                this.nameCombo.select(MeasurementPropertyTypes.fromValue(this.propertyType.getName()).ordinal());
            }
            if (this.propertyType.getType() != null) {
                this.typeCombo.select(this.propertyType.getType().ordinal());
                if (this.propertyType.getType() == DataTypes.BOOLEAN) {
                    this.valueText.setVisible(false);
                    this.valueCombo.setVisible(true);
                    int selectionIndex = this.propertyType.getValue().equals(this.valueCombo.getItems()[0]) ? 0 : 1;
                    this.valueCombo.select(selectionIndex);
                } else if (this.propertyType.getName().equals(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value())) {
                    this.valueText.setVisible(false);
                    this.valueCombo.setVisible(true);
                    this.valueCombo.setItems(DevicePropertiesEditor.getInstance().getMeasurementNames(this.measurementTypeTabItem.channelConfigNumber));
                    this.valueCombo.select(Integer.valueOf(this.propertyType.getValue()).intValue());
                } else if (this.propertyType.getName().equals(MeasurementPropertyTypes.DATA_TYPE.value())) {
                    this.valueText.setVisible(false);
                    this.valueCombo.setVisible(true);
                    this.valueCombo.setItems(Record.DataType.getValuesAsList().toArray(new String[1]));
                    this.valueCombo.select(Record.DataType.fromValue(this.propertyType.getValue()).ordinal());
                } else {
                    this.valueText.setVisible(true);
                    this.valueCombo.setVisible(false);
                    this.valueText.setText(StringHelper.verifyTypedString(this.propertyType.getType(), this.propertyType.getValue()));
                }
            } else {
                this.typeCombo.select(0);
            }
            this.descriptionText.setText(this.propertyType.getDescription());
        } else {
            this.nameText.setText("");
            this.nameCombo.setText("");
            this.descriptionText.setText("");
        }
    }
}

