/*
 * Decompiled with CFR 0.152.
 */
package gde.device.opentx;

import gde.DataAccess;
import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.PropertyType;
import gde.device.opentx.CSVReaderWriter;
import gde.device.opentx.OpenTxAdapterDialog;
import gde.exception.DataInconsitsentException;
import gde.io.FileHandler;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class OpenTxAdapter
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(OpenTxAdapter.class.getName());
    static final Properties properties = new Properties();
    final DataExplorer application;
    final Channels channels;
    final OpenTxAdapterDialog dialog;

    public OpenTxAdapter(String xmlFileName) throws FileNotFoundException, JAXBException {
        super(xmlFileName);
        Messages.setDeviceResourceBundle((String)"gde.device.opentx.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new OpenTxAdapterDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT3303"), Messages.getString((String)"GDE_MSGT3303"));
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
        }
        this.readProperties();
    }

    public OpenTxAdapter(String xmlFileName, Unmarshaller tmpUnmarshaller) throws FileNotFoundException, JAXBException {
        super(xmlFileName, tmpUnmarshaller);
        Messages.setDeviceResourceBundle((String)"gde.device.opentx.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new OpenTxAdapterDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT3303"), Messages.getString((String)"GDE_MSGT3303"));
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
        }
        this.readProperties();
    }

    public OpenTxAdapter(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.opentx.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new OpenTxAdapterDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT3303"), Messages.getString((String)"GDE_MSGT3303"));
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
        }
        this.readProperties();
    }

    private void readProperties() {
        DataAccess.getInstance().checkMappingFileAndCreate(((Object)((Object)this)).getClass(), "OpenTxMeasurementMappings.xml");
        try (InputStream stream = DataAccess.getInstance().getMappingInputStream("OpenTxMeasurementMappings.xml");){
            properties.loadFromXML(stream);
        }
        catch (Exception e) {
            String preopertyFilePath = "Mapping/OpenTxMeasurementMappings.xml";
            this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE3300", (Object[])new String[]{preopertyFilePath}));
        }
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT3304", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT3304"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "importDeviceLogItem action performed! " + String.valueOf(e));
                    OpenTxAdapter.this.importCsvFiles();
                }
            });
        }
    }

    public void updateFileExportMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT3311"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKMZ3DRelativeItem action performed! " + String.valueOf(e));
                    OpenTxAdapter.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT3312"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKMZDAbsoluteItem action performed! " + String.valueOf(e));
                    OpenTxAdapter.this.export2KMZ3D(1);
                }
            });
            convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT3313"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKMZDAbsoluteItem action performed! " + String.valueOf(e));
                    OpenTxAdapter.this.export2KMZ3D(2);
                }
            });
        }
    }

    public OpenTxAdapterDialog getDialog() {
        return this.dialog;
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int i;
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        byte[] timeStampBuffer = new byte[timeStampBufferSize];
        if (!recordSet.isTimeStepConstant()) {
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
        }
        log.log(java.util.logging.Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (i = 0; i < recordDataSize; ++i) {
            log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((convertBuffer[0 + j * 4] & 0xFF) << 24) + ((convertBuffer[1 + j * 4] & 0xFF) << 16) + ((convertBuffer[2 + j * 4] & 0xFF) << 8) + ((convertBuffer[3 + j * 4] & 0xFF) << 0);
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    public static String getFormattedTime(int timeValue) {
        int tmpHH = timeValue / 10000000;
        int tmpMM = timeValue / 100000 - tmpHH * 100;
        int tmpSS = timeValue / 1000 - tmpMM * 100 - tmpHH * 10000;
        return String.format("%02d:%02d:%02d", tmpHH, tmpMM, tmpSS);
    }

    public static String getFormattedDate(int dateValue) {
        int tmpYY = dateValue / 1000000;
        int tmpMM = dateValue / 10000 - tmpYY * 100;
        int tmpDD = dateValue / 100 - tmpMM * 100 - tmpYY * 10000;
        return String.format("%02d-%02d-%02d", tmpYY, tmpMM, tmpDD);
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                dataTableRow[index + 1] = record.getUnit().startsWith("yy-mm-dd") ? OpenTxAdapter.getFormattedDate(record.realGet(rowIndex) / 10) : (record.getUnit().startsWith("HH:mm:ss") ? OpenTxAdapter.getFormattedTime(record.realGet(rowIndex)) : record.getFormattedTableValue(rowIndex));
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
        property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
        try {
            if (subtractFirst) {
                reduction = (double)record.getFirst().intValue() / 1000.0;
            }
            if (subtractLast) {
                reduction = (double)record.getLast().intValue() / 1000.0;
            }
        }
        finally {
            double newValue = 0.0;
        }
        {
        }
    }

    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
        property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
        try {
            if (subtractFirst) {
                reduction = (double)record.getFirst().intValue() / 1000.0;
            }
            if (subtractLast) {
                reduction = (double)record.getLast().intValue() / 1000.0;
            }
        }
        finally {
            double newValue = 0.0;
        }
        {
        }
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int i;
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        String[] measurementNames = recordSet.getRecordNames();
        for (i = 0; i < measurementNames.length; ++i) {
            if (this.getMeasurement(channelConfigNumber, i).getProperty(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value()) == null) continue;
            Iterator iterator = this.getMeasurement(channelConfigNumber, i).getProperty().iterator();
            while (iterator.hasNext()) {
                PropertyType propertyType = (PropertyType)iterator.next();
                if (!propertyType.getName().equals(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value())) continue;
                log.log(Level.FINE, "remove synch from " + measurementNames[i]);
                iterator.remove();
            }
        }
        for (i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (log.isLoggable(java.util.logging.Level.FINE)) {
                log.log(java.util.logging.Level.FINE, record.getName() + " = " + measurementNames[i]);
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData());
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, i + " " + record.getName() + " hasReasonableData = " + record.hasReasonableData());
                }
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            if (log.isLoggable(java.util.logging.Level.FINE)) {
                log.log(java.util.logging.Level.FINE, "add to displayable counter: " + record.getName());
            }
            ++displayableCounter;
        }
        if (log.isLoggable(java.util.logging.Level.FINER)) {
            log.log(java.util.logging.Level.FINER, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
        for (i = 0; i < measurementNames.length; ++i) {
            for (int j = i; j < measurementNames.length; ++j) {
                String[] nameParts = measurementNames[j].split(" ");
                if (nameParts.length <= 1 || !measurementNames[i].split(" ")[0].equals(nameParts[0]) || i == j || this.getMeasruementProperty(channelConfigNumber, j, MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value()) != null || !recordSet.get(i).getUnit().equals(recordSet.get(j).getUnit()) || recordSet.get(j).getDataType() != Record.DataType.DEFAULT) continue;
                log.log(Level.FINE, "do synch " + measurementNames[j] + " to " + measurementNames[i]);
                this.setMeasurementPropertyValue(channelConfigNumber, j, MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value(), DataTypes.INTEGER, i);
            }
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        this.application.updateStatisticsData();
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public void open_closeCommPort() {
        this.importCsvFiles();
    }

    public void importCsvFiles() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT3300"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    OpenTxAdapter.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        log.log(java.util.logging.Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        try {
                            RecordSet activeRecordSet = CSVReaderWriter.read(OpenTxAdapter.this.getDataBlockSeparator().value().charAt(0), selectedImportFile, OpenTxAdapter.this.getRecordSetStemNameReplacement());
                            OpenTxAdapter.this.updateVisibilityStatus(activeRecordSet, true);
                        }
                        catch (Throwable e) {
                            log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    OpenTxAdapter.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            for (int i = 0; i < activeRecordSet.size(); ++i) {
                Record record = activeRecordSet.get(i);
                if (!record.getDataType().equals((Object)Record.DataType.GPS_LATITUDE) && !record.getDataType().equals((Object)Record.DataType.GPS_LONGITUDE) && !record.getDataType().equals((Object)Record.DataType.GPS_LATITUDE_DEGREE) && !record.getDataType().equals((Object)Record.DataType.GPS_LONGITUDE_DEGREE)) continue;
                containsGPSdata = record.hasReasonableData();
                break;
            }
        }
        return containsGPSdata;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        RecordSet actualRecordSet = this.application.getActiveRecordSet();
        if (this.kmzMeasurementOrdinal == null && actualRecordSet != null) {
            return this.findRecordByType(this.application.getActiveRecordSet(), Record.DataType.GPS_SPEED);
        }
        return this.kmzMeasurementOrdinal != null ? this.kmzMeasurementOrdinal : -1;
    }

    public String exportFile(String fileEndingType, boolean isExportTmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz")) {
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            int ordinalLongitude = this.findRecordByType(activeRecordSet, Record.DataType.GPS_LONGITUDE);
            ordinalLongitude = ordinalLongitude == -1 ? this.findRecordByType(activeRecordSet, Record.DataType.GPS_LONGITUDE_DEGREE) : ordinalLongitude;
            int ordinalLatitude = this.findRecordByType(activeRecordSet, Record.DataType.GPS_LATITUDE);
            ordinalLatitude = ordinalLatitude == -1 ? this.findRecordByType(activeRecordSet, Record.DataType.GPS_LATITUDE_DEGREE) : ordinalLatitude;
            exportFileName = new FileHandler().exportFileKMZ(ordinalLongitude, ordinalLatitude, this.findRecordByType(activeRecordSet, Record.DataType.GPS_ALTITUDE), additionalMeasurementOrdinal, this.findRecordByUnit(activeRecordSet, "m/s"), this.findRecordByUnit(activeRecordSet, "km"), -1, true, isExportTmpDir);
        }
        return exportFileName;
    }

    private int findRecordByUnit(RecordSet recordSet, String unit) {
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (!record.getUnit().equalsIgnoreCase(unit)) continue;
            return record.getOrdinal();
        }
        return -1;
    }

    private int findRecordByType(RecordSet recordSet, Record.DataType dataType) {
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (!record.getDataType().equals((Object)dataType)) continue;
            return record.getOrdinal();
        }
        return -1;
    }

    public boolean isGPSCoordinates(Record record) {
        return record.getDataType() == Record.DataType.GPS_LATITUDE || record.getDataType() == Record.DataType.GPS_LONGITUDE || record.getDataType() == Record.DataType.GPS_LATITUDE_DEGREE || record.getDataType() == Record.DataType.GPS_LONGITUDE_DEGREE;
    }

    public void export2KMZ3D(int type) {
        int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
        RecordSet activeRecordSet = this.application.getActiveRecordSet();
        if (activeRecordSet != null) {
            int ordinalLongitude = this.findRecordByType(activeRecordSet, Record.DataType.GPS_LONGITUDE);
            ordinalLongitude = ordinalLongitude == -1 ? this.findRecordByType(activeRecordSet, Record.DataType.GPS_LONGITUDE_DEGREE) : ordinalLongitude;
            int ordinalLatitude = this.findRecordByType(activeRecordSet, Record.DataType.GPS_LATITUDE);
            ordinalLatitude = ordinalLatitude == -1 ? this.findRecordByType(activeRecordSet, Record.DataType.GPS_LATITUDE_DEGREE) : ordinalLatitude;
            new FileHandler().exportFileKMZ(ordinalLongitude, ordinalLatitude, this.findRecordByType(activeRecordSet, Record.DataType.GPS_ALTITUDE), additionalMeasurementOrdinal, this.findRecordByUnit(activeRecordSet, "m/s"), this.findRecordByUnit(activeRecordSet, "km"), -1, type == 0, type == 2);
        }
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        String[] tmpRecordNames = recordSet.getRecordNames();
        for (int i = 0; i < tmpRecordNames.length; ++i) {
            recordSet.replaceRecordName(recordSet.get(i), String.format("%d????", i));
        }
        String[] recordKeys = recordSet.getRecordNames();
        Vector<String> cleanedRecordNames = new Vector<String>();
        int numberRecordSetEntries = recordKeys.length;
        if (numberRecordSetEntries - fileRecordsProperties.length > 0) {
            int i;
            for (i = 0; i < fileRecordsProperties.length; ++i) {
                cleanedRecordNames.add(recordKeys[i]);
            }
            for (i = fileRecordsProperties.length; i < numberRecordSetEntries; ++i) {
                recordSet.remove(recordKeys[i]);
            }
            recordKeys = cleanedRecordNames.toArray(new String[1]);
        }
        return recordKeys;
    }
}

