/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.RotateTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Transition;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tornadofx.AnimationKt;
import tornadofx.NodesKt;
import tornadofx.UIComponent;
import tornadofx.ViewTransition;
import tornadofx.ViewTransition$Cover$WhenMappings;
import tornadofx.ViewTransition$Direction$WhenMappings;
import tornadofx.ViewTransition$Metro$WhenMappings;
import tornadofx.ViewTransition$Reveal$WhenMappings;
import tornadofx.ViewTransition$Slide$WhenMappings;
import tornadofx.ViewTransition$Swap$WhenMappings;
import tornadofx.ViewTransition$Wipe$WhenMappings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b&\u0018\u0000 \u001c2\u00020\u0001:\u0010\u001c\u001d\u001e\u001f !\"#$%&'()*+B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\u0004H\u0000\u00a2\u0006\u0002\b\u0011J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0005H&J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u001f\u0010\u0003\u001a\u00020\u00062\u0017\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0014\u0010\u0017\u001a\u00020\u0006*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000eH\u0004J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0004R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006,"}, d2={"Ltornadofx/ViewTransition;", "", "()V", "setup", "Lkotlin/Function1;", "Ljavafx/scene/layout/StackPane;", "", "Lkotlin/ExtensionFunctionType;", "getSetup", "()Lkotlin/jvm/functions/Function1;", "setSetup", "(Lkotlin/jvm/functions/Function1;)V", "call", "current", "Ljavafx/scene/Node;", "replacement", "attach", "call$tornadofx", "create", "Ljavafx/animation/Animation;", "stack", "onComplete", "removed", "moveToTop", "node", "toCanvas", "Ljavafx/scene/canvas/Canvas;", "Ljavafx/scene/image/Image;", "Companion", "Cover", "Direction", "Dissolve", "Explode", "Fade", "FadeThrough", "Flip", "Implode", "Metro", "NewsFlash", "Reveal", "ReversibleViewTransition", "Slide", "Swap", "Wipe", "tornadofx"})
public abstract class ViewTransition {
    @NotNull
    private Function1<? super StackPane, Unit> setup = setup.1.INSTANCE;
    @NotNull
    private static final Function3<UIComponent, UIComponent, Function0<Unit>, Unit> SlideIn;
    @NotNull
    private static final Function3<UIComponent, UIComponent, Function0<Unit>, Unit> SlideOut;
    public static final Companion Companion;

    @NotNull
    public abstract Animation create(@NotNull Node var1, @NotNull Node var2, @NotNull StackPane var3);

    public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
        Intrinsics.checkParameterIsNotNull(removed, "removed");
        Intrinsics.checkParameterIsNotNull(replacement, "replacement");
    }

    @NotNull
    public final Function1<StackPane, Unit> getSetup() {
        return this.setup;
    }

    public final void setSetup(@NotNull Function1<? super StackPane, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, "<set-?>");
        this.setup = function1;
    }

    public final void setup(@NotNull Function1<? super StackPane, Unit> setup2) {
        Intrinsics.checkParameterIsNotNull(setup2, "setup");
        this.setup = setup2;
    }

    public final void call$tornadofx(@NotNull Node current, @NotNull Node replacement, @NotNull Function1<? super Node, Unit> attach2) {
        Animation animation;
        Intrinsics.checkParameterIsNotNull(current, "current");
        Intrinsics.checkParameterIsNotNull(replacement, "replacement");
        Intrinsics.checkParameterIsNotNull(attach2, "attach");
        NodesKt.setTransitioning(current, true);
        NodesKt.setTransitioning(replacement, true);
        Object object = current.getProperties().get((Object)"tornadofx.uicomponent");
        if (!(object instanceof UIComponent)) {
            object = null;
        }
        UIComponent currentUIComponent = (UIComponent)object;
        Object object2 = replacement.getProperties().get((Object)"tornadofx.uicomponent");
        if (!(object2 instanceof UIComponent)) {
            object2 = null;
        }
        UIComponent replacementUIComponent = (UIComponent)object2;
        UIComponent uIComponent = currentUIComponent;
        if (uIComponent != null) {
            uIComponent.setMuteDocking$tornadofx(true);
        }
        UIComponent uIComponent2 = replacementUIComponent;
        if (uIComponent2 != null) {
            uIComponent2.setMuteDocking$tornadofx(true);
        }
        StackPane stack = this.stack(current, replacement);
        this.setup.invoke((StackPane)stack);
        attach2.invoke((Node)stack);
        Animation $receiver = animation = this.create(current, replacement, stack);
        EventHandler oldFinish = $receiver.getOnFinished();
        $receiver.setOnFinished((EventHandler)new EventHandler<ActionEvent>(oldFinish, this, stack, current, replacement, currentUIComponent, replacementUIComponent, attach2){
            final /* synthetic */ EventHandler $oldFinish;
            final /* synthetic */ ViewTransition this$0;
            final /* synthetic */ StackPane $stack$inlined;
            final /* synthetic */ Node $current$inlined;
            final /* synthetic */ Node $replacement$inlined;
            final /* synthetic */ UIComponent $currentUIComponent$inlined;
            final /* synthetic */ UIComponent $replacementUIComponent$inlined;
            final /* synthetic */ Function1 $attach$inlined;
            {
                this.$oldFinish = eventHandler;
                this.this$0 = viewTransition;
                this.$stack$inlined = stackPane;
                this.$current$inlined = node;
                this.$replacement$inlined = node2;
                this.$currentUIComponent$inlined = uIComponent;
                this.$replacementUIComponent$inlined = uIComponent2;
                this.$attach$inlined = function1;
            }

            public final void handle(ActionEvent it) {
                this.$stack$inlined.getChildren().clear();
                NodesKt.removeFromParent((EventTarget)this.$current$inlined);
                NodesKt.removeFromParent((EventTarget)this.$replacement$inlined);
                NodesKt.removeFromParent((EventTarget)this.$stack$inlined);
                UIComponent uIComponent = this.$currentUIComponent$inlined;
                if (uIComponent != null) {
                    UIComponent uIComponent2;
                    UIComponent it2 = uIComponent2 = uIComponent;
                    it2.setMuteDocking$tornadofx(false);
                    it2.callOnUndock$tornadofx();
                }
                UIComponent uIComponent3 = this.$replacementUIComponent$inlined;
                if (uIComponent3 != null) {
                    uIComponent3.setMuteDocking$tornadofx(false);
                }
                this.$attach$inlined.invoke(this.$replacement$inlined);
                EventHandler eventHandler = this.$oldFinish;
                if (eventHandler != null) {
                    eventHandler.handle((Event)it);
                }
                this.this$0.onComplete(this.$current$inlined, this.$replacement$inlined);
                NodesKt.setTransitioning(this.$current$inlined, false);
                NodesKt.setTransitioning(this.$replacement$inlined, false);
            }
        });
        animation.play();
    }

    protected final void moveToTop(@NotNull StackPane $receiver, @NotNull Node node) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(node, "node");
        if ($receiver.getChildren().remove((Object)node)) {
            $receiver.getChildren().add((Object)node);
        }
    }

    @NotNull
    protected final Canvas toCanvas(@NotNull Image $receiver) {
        Canvas canvas2;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Canvas it = canvas2 = new Canvas($receiver.getWidth(), $receiver.getHeight());
        it.getGraphicsContext2D().drawImage($receiver, 0.0, 0.0);
        return canvas2;
    }

    @NotNull
    public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
        Intrinsics.checkParameterIsNotNull(current, "current");
        Intrinsics.checkParameterIsNotNull(replacement, "replacement");
        return new StackPane(new Node[]{replacement, current});
    }

    static {
        Companion = new Companion(null);
        SlideIn = Companion.SlideIn.1.INSTANCE;
        SlideOut = Companion.SlideOut.1.INSTANCE;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0000j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ltornadofx/ViewTransition$Direction;", "", "(Ljava/lang/String;I)V", "reversed", "UP", "RIGHT", "DOWN", "LEFT", "tornadofx"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction UP;
        public static final /* enum */ Direction RIGHT;
        public static final /* enum */ Direction DOWN;
        public static final /* enum */ Direction LEFT;
        private static final /* synthetic */ Direction[] $VALUES;

        static {
            Direction[] directionArray = new Direction[4];
            Direction[] directionArray2 = directionArray;
            directionArray[0] = UP = new Direction();
            directionArray[1] = RIGHT = new Direction();
            directionArray[2] = DOWN = new Direction();
            directionArray[3] = LEFT = new Direction();
            $VALUES = directionArray;
        }

        @NotNull
        public final Direction reversed() {
            Direction direction;
            switch (ViewTransition$Direction$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    direction = DOWN;
                    break;
                }
                case 2: {
                    direction = LEFT;
                    break;
                }
                case 3: {
                    direction = UP;
                    break;
                }
                case 4: {
                    direction = RIGHT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return direction;
        }

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String string2) {
            return Enum.valueOf(Direction.class, string2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Ltornadofx/ViewTransition$Fade;", "Ltornadofx/ViewTransition;", "duration", "Ljavafx/util/Duration;", "(Ljavafx/util/Duration;)V", "getDuration", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/FadeTransition;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "tornadofx"})
    public static final class Fade
    extends ViewTransition {
        @NotNull
        private final Duration duration;

        @NotNull
        public FadeTransition create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            return AnimationKt.fade$default(current, this.duration, (Number)0, null, false, false, null, 44, null);
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(removed, "removed");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            removed.setOpacity(1.0);
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        public Fade(@NotNull Duration duration) {
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            this.duration = duration;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Ltornadofx/ViewTransition$FadeThrough;", "Ltornadofx/ViewTransition;", "duration", "Ljavafx/util/Duration;", "color", "Ljavafx/scene/paint/Paint;", "(Ljavafx/util/Duration;Ljavafx/scene/paint/Paint;)V", "bg", "Ljavafx/scene/layout/Pane;", "getColor", "()Ljavafx/scene/paint/Paint;", "halfTime", "getHalfTime", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/SequentialTransition;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "tornadofx"})
    public static final class FadeThrough
    extends ViewTransition {
        private final Pane bg;
        @NotNull
        private final Duration halfTime;
        @NotNull
        private final Paint color;

        @NotNull
        public final Duration getHalfTime() {
            return this.halfTime;
        }

        @NotNull
        public SequentialTransition create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Number number = 0;
            Interpolator interpolator = Interpolator.EASE_IN;
            Intrinsics.checkExpressionValueIsNotNull(interpolator, "Interpolator.EASE_IN");
            Animation animation = (Animation)AnimationKt.fade$default(current, this.halfTime, number, interpolator, false, false, null, 40, null);
            Number number2 = 0;
            Interpolator interpolator2 = Interpolator.EASE_OUT;
            Intrinsics.checkExpressionValueIsNotNull(interpolator2, "Interpolator.EASE_OUT");
            return AnimationKt.then(animation, (Animation)AnimationKt.fade$default(replacement, this.halfTime, number2, interpolator2, true, false, null, 32, null));
        }

        @Override
        @NotNull
        public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            return new StackPane(new Node[]{(Node)this.bg, replacement, current});
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(removed, "removed");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            removed.setOpacity(1.0);
        }

        @NotNull
        public final Paint getColor() {
            return this.color;
        }

        public FadeThrough(@NotNull Duration duration, @NotNull Paint color) {
            Pane pane2;
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            Intrinsics.checkParameterIsNotNull(color, "color");
            this.color = color;
            Pane pane3 = new Pane();
            FadeThrough fadeThrough = this;
            Pane $receiver = pane3;
            $receiver.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.color, null, null)}));
            fadeThrough.bg = pane2 = pane3;
            Duration duration2 = duration.divide(2.0);
            Intrinsics.checkExpressionValueIsNotNull(duration2, "duration.divide(2.0)");
            this.halfTime = duration2;
        }

        public /* synthetic */ FadeThrough(Duration duration, Paint paint, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                Color color = Color.TRANSPARENT;
                Intrinsics.checkExpressionValueIsNotNull(color, "Color.TRANSPARENT");
                paint = (Paint)color;
            }
            this(duration, paint);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0005J&\u0010\u0004\u001a\u00028\u00002\u0019\b\u0002\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Ltornadofx/ViewTransition$ReversibleViewTransition;", "T", "Ltornadofx/ViewTransition;", "()V", "reversed", "()Ltornadofx/ViewTransition;", "op", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ltornadofx/ViewTransition;", "tornadofx"})
    public static abstract class ReversibleViewTransition<T extends ViewTransition>
    extends ViewTransition {
        @NotNull
        protected abstract T reversed();

        @NotNull
        public final T reversed(@NotNull Function1<? super T, Unit> op) {
            Intrinsics.checkParameterIsNotNull(op, "op");
            T t = this.reversed();
            op.invoke(t);
            return t;
        }

        @NotNull
        public static /* synthetic */ ViewTransition reversed$default(ReversibleViewTransition reversibleViewTransition, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reversed");
            }
            if ((n & 1) != 0) {
                function1 = reversed.1.INSTANCE;
            }
            return reversibleViewTransition.reversed(function1);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u0000H\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Ltornadofx/ViewTransition$Slide;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "duration", "Ljavafx/util/Duration;", "direction", "Ltornadofx/ViewTransition$Direction;", "(Ljavafx/util/Duration;Ltornadofx/ViewTransition$Direction;)V", "getDirection", "()Ltornadofx/ViewTransition$Direction;", "getDuration", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "reversed", "tornadofx"})
    public static final class Slide
    extends ReversibleViewTransition<Slide> {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Direction direction;

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Point2D point2D;
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Bounds bounds = current.getBoundsInLocal();
            switch (ViewTransition$Slide$WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1: {
                    Number number = 0;
                    Bounds bounds2 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds2, "bounds");
                    point2D = NodesKt.point(number, -bounds2.getHeight());
                    break;
                }
                case 2: {
                    Bounds bounds3 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds3, "bounds");
                    point2D = NodesKt.point(bounds3.getWidth(), 0);
                    break;
                }
                case 3: {
                    Number number = 0;
                    Bounds bounds4 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds4, "bounds");
                    point2D = NodesKt.point(number, bounds4.getHeight());
                    break;
                }
                case 4: {
                    Bounds bounds5 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds5, "bounds");
                    point2D = NodesKt.point(-bounds5.getWidth(), 0);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Point2D destination = point2D;
            Animation animation = (Animation)AnimationKt.move$default(current, this.duration, destination, null, false, false, null, 44, null);
            Point2D point2D2 = destination.multiply(-1.0);
            Intrinsics.checkExpressionValueIsNotNull(point2D2, "destination.multiply(-1.0)");
            return (Animation)AnimationKt.and(animation, (Animation)AnimationKt.move$default(replacement, this.duration, point2D2, null, true, false, null, 36, null));
        }

        @Override
        @NotNull
        public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            return super.stack(replacement, current);
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(removed, "removed");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            removed.setTranslateX(0.0);
            removed.setTranslateY(0.0);
        }

        @Override
        @NotNull
        protected Slide reversed() {
            Slide slide;
            Slide it = slide = new Slide(this.duration, this.direction.reversed());
            it.setSetup(this.getSetup());
            return slide;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public Slide(@NotNull Duration duration, @NotNull Direction direction) {
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
            this.duration = duration;
            this.direction = direction;
        }

        public /* synthetic */ Slide(Duration duration, Direction direction, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                direction = Direction.LEFT;
            }
            this(duration, direction);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0002H\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Ltornadofx/ViewTransition$Cover;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "Ltornadofx/ViewTransition$Reveal;", "duration", "Ljavafx/util/Duration;", "direction", "Ltornadofx/ViewTransition$Direction;", "(Ljavafx/util/Duration;Ltornadofx/ViewTransition$Direction;)V", "getDirection", "()Ltornadofx/ViewTransition$Direction;", "getDuration", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "reversed", "tornadofx"})
    public static final class Cover
    extends ReversibleViewTransition<Reveal> {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Direction direction;

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Point2D point2D;
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Bounds bounds = current.getBoundsInLocal();
            switch (ViewTransition$Cover$WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1: {
                    Number number = 0;
                    Bounds bounds2 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds2, "bounds");
                    point2D = NodesKt.point(number, bounds2.getHeight());
                    break;
                }
                case 2: {
                    Bounds bounds3 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds3, "bounds");
                    point2D = NodesKt.point(-bounds3.getWidth(), 0);
                    break;
                }
                case 3: {
                    Number number = 0;
                    Bounds bounds4 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds4, "bounds");
                    point2D = NodesKt.point(number, -bounds4.getHeight());
                    break;
                }
                case 4: {
                    Bounds bounds5 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds5, "bounds");
                    point2D = NodesKt.point(bounds5.getWidth(), 0);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Point2D destination = point2D;
            return (Animation)AnimationKt.move$default(replacement, this.duration, destination, null, true, false, null, 36, null);
        }

        @Override
        @NotNull
        public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            return super.stack(replacement, current);
        }

        @Override
        @NotNull
        protected Reveal reversed() {
            Reveal reveal;
            Reveal it = reveal = new Reveal(this.duration, this.direction.reversed());
            it.setSetup(this.getSetup());
            return reveal;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public Cover(@NotNull Duration duration, @NotNull Direction direction) {
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
            this.duration = duration;
            this.direction = direction;
        }

        public /* synthetic */ Cover(Duration duration, Direction direction, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                direction = Direction.LEFT;
            }
            this(duration, direction);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0002H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ltornadofx/ViewTransition$Reveal;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "Ltornadofx/ViewTransition$Cover;", "duration", "Ljavafx/util/Duration;", "direction", "Ltornadofx/ViewTransition$Direction;", "(Ljavafx/util/Duration;Ltornadofx/ViewTransition$Direction;)V", "getDirection", "()Ltornadofx/ViewTransition$Direction;", "getDuration", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "reversed", "tornadofx"})
    public static final class Reveal
    extends ReversibleViewTransition<Cover> {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Direction direction;

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Point2D point2D;
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Bounds bounds = current.getBoundsInLocal();
            switch (ViewTransition$Reveal$WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1: {
                    Number number = 0;
                    Bounds bounds2 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds2, "bounds");
                    point2D = NodesKt.point(number, -bounds2.getHeight());
                    break;
                }
                case 2: {
                    Bounds bounds3 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds3, "bounds");
                    point2D = NodesKt.point(bounds3.getWidth(), 0);
                    break;
                }
                case 3: {
                    Number number = 0;
                    Bounds bounds4 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds4, "bounds");
                    point2D = NodesKt.point(number, bounds4.getHeight());
                    break;
                }
                case 4: {
                    Bounds bounds5 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds5, "bounds");
                    point2D = NodesKt.point(-bounds5.getWidth(), 0);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Point2D destination = point2D;
            return (Animation)AnimationKt.move$default(current, this.duration, destination, null, false, false, null, 44, null);
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(removed, "removed");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            removed.setTranslateX(0.0);
            removed.setTranslateY(0.0);
        }

        @Override
        @NotNull
        protected Cover reversed() {
            Cover cover;
            Cover it = cover = new Cover(this.duration, this.direction.reversed());
            it.setSetup(this.getSetup());
            return cover;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public Reveal(@NotNull Duration duration, @NotNull Direction direction) {
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
            this.duration = duration;
            this.direction = direction;
        }

        public /* synthetic */ Reveal(Duration duration, Direction direction, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                direction = Direction.LEFT;
            }
            this(duration, direction);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0000H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ltornadofx/ViewTransition$Metro;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "duration", "Ljavafx/util/Duration;", "direction", "Ltornadofx/ViewTransition$Direction;", "distancePercentage", "", "(Ljavafx/util/Duration;Ltornadofx/ViewTransition$Direction;D)V", "getDirection", "()Ltornadofx/ViewTransition$Direction;", "getDistancePercentage", "()D", "getDuration", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "reversed", "tornadofx"})
    public static final class Metro
    extends ReversibleViewTransition<Metro> {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Direction direction;
        private final double distancePercentage;

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Point2D point2D;
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Bounds bounds = current.getBoundsInLocal();
            switch (ViewTransition$Metro$WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1: {
                    Number number = 0;
                    Bounds bounds2 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds2, "bounds");
                    point2D = NodesKt.point(number, -bounds2.getHeight() * this.distancePercentage);
                    break;
                }
                case 2: {
                    Bounds bounds3 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds3, "bounds");
                    point2D = NodesKt.point(bounds3.getWidth() * this.distancePercentage, 0);
                    break;
                }
                case 3: {
                    Number number = 0;
                    Bounds bounds4 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds4, "bounds");
                    point2D = NodesKt.point(number, bounds4.getHeight() * this.distancePercentage);
                    break;
                }
                case 4: {
                    Bounds bounds5 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds5, "bounds");
                    point2D = NodesKt.point(-bounds5.getWidth() * this.distancePercentage, 0);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Point2D destination = point2D;
            Duration duration = this.duration.divide(2.0);
            Intrinsics.checkExpressionValueIsNotNull(duration, "duration.divide(2.0)");
            Animation animation = (Animation)AnimationKt.transform$default(current, duration, destination, (Number)0, NodesKt.point(1, 1), (Number)0, null, false, false, null, 352, null);
            Duration duration2 = this.duration.divide(2.0);
            Intrinsics.checkExpressionValueIsNotNull(duration2, "duration.divide(2.0)");
            Point2D point2D2 = destination.multiply(-1.0);
            Intrinsics.checkExpressionValueIsNotNull(point2D2, "destination.multiply(-1.0)");
            return (Animation)AnimationKt.then(animation, (Animation)AnimationKt.transform$default(replacement, duration2, point2D2, (Number)0, NodesKt.point(1, 1), (Number)0, null, true, false, null, 288, null));
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(removed, "removed");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            removed.setTranslateX(0.0);
            removed.setTranslateY(0.0);
            removed.setOpacity(1.0);
        }

        @Override
        @NotNull
        protected Metro reversed() {
            Metro metro;
            Metro it = metro = new Metro(this.duration, this.direction.reversed(), this.distancePercentage);
            it.setSetup(this.getSetup());
            return metro;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public final double getDistancePercentage() {
            return this.distancePercentage;
        }

        public Metro(@NotNull Duration duration, @NotNull Direction direction, double distancePercentage) {
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
            this.duration = duration;
            this.direction = direction;
            this.distancePercentage = distancePercentage;
        }

        public /* synthetic */ Metro(Duration duration, Direction direction, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                direction = Direction.LEFT;
            }
            if ((n & 4) != 0) {
                d = 0.1;
            }
            this(duration, direction, d);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0000H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ltornadofx/ViewTransition$Swap;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "duration", "Ljavafx/util/Duration;", "direction", "Ltornadofx/ViewTransition$Direction;", "scale", "Ljavafx/geometry/Point2D;", "(Ljavafx/util/Duration;Ltornadofx/ViewTransition$Direction;Ljavafx/geometry/Point2D;)V", "getDirection", "()Ltornadofx/ViewTransition$Direction;", "getDuration", "()Ljavafx/util/Duration;", "getScale", "()Ljavafx/geometry/Point2D;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "reversed", "tornadofx"})
    public static final class Swap
    extends ReversibleViewTransition<Swap> {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Direction direction;
        @NotNull
        private final Point2D scale;

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Point2D point2D;
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Bounds bounds = current.getBoundsInLocal();
            switch (ViewTransition$Swap$WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1: {
                    Number number = 0;
                    Bounds bounds2 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds2, "bounds");
                    point2D = NodesKt.point(number, -bounds2.getHeight() * 0.5);
                    break;
                }
                case 2: {
                    Bounds bounds3 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds3, "bounds");
                    point2D = NodesKt.point(bounds3.getWidth() * 0.5, 0);
                    break;
                }
                case 3: {
                    Number number = 0;
                    Bounds bounds4 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds4, "bounds");
                    point2D = NodesKt.point(number, bounds4.getHeight() * 0.5);
                    break;
                }
                case 4: {
                    Bounds bounds5 = bounds;
                    Intrinsics.checkExpressionValueIsNotNull(bounds5, "bounds");
                    point2D = NodesKt.point(-bounds5.getWidth() * 0.5, 0);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Point2D destination = point2D;
            Duration halfTime = this.duration.divide(2.0);
            Animation animation = (Animation)AnimationKt.and((Animation)AnimationKt.scale$default(current, this.duration, this.scale, null, false, false, null, 44, null), (Animation)AnimationKt.scale$default(replacement, this.duration, this.scale, null, true, false, null, 36, null));
            Duration duration = halfTime;
            Intrinsics.checkExpressionValueIsNotNull(duration, "halfTime");
            Animation animation2 = (Animation)AnimationKt.move$default(current, duration, destination, null, false, false, null, 60, null);
            Animation[] animationArray = new Animation[1];
            Point2D point2D2 = destination.multiply(-1.0);
            Intrinsics.checkExpressionValueIsNotNull(point2D2, "destination.multiply(-1.0)");
            animationArray[0] = (Animation)AnimationKt.move$default(replacement, halfTime, point2D2, null, false, false, null, 60, null);
            Animation animation3 = (Animation)AnimationKt.and(animation2, animationArray, (Function1<? super ParallelTransition, Unit>)new Function1<ParallelTransition, Unit>(this, stack, replacement){
                final /* synthetic */ Swap this$0;
                final /* synthetic */ StackPane $stack;
                final /* synthetic */ Node $replacement;

                public final void invoke(@NotNull ParallelTransition $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                    $receiver.setOnFinished((EventHandler)new EventHandler<ActionEvent>(this){
                        final /* synthetic */ create.1 this$0;

                        public final void handle(ActionEvent it) {
                            this.this$0.this$0.moveToTop(this.this$0.$stack, this.this$0.$replacement);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = swap;
                    this.$stack = stackPane;
                    this.$replacement = node;
                    super(1);
                }
            });
            Point2D point2D3 = Point2D.ZERO;
            Intrinsics.checkExpressionValueIsNotNull(point2D3, "Point2D.ZERO");
            Animation animation4 = (Animation)AnimationKt.move$default(current, halfTime, point2D3, null, false, false, null, 60, null);
            Point2D point2D4 = Point2D.ZERO;
            Intrinsics.checkExpressionValueIsNotNull(point2D4, "Point2D.ZERO");
            return (Animation)AnimationKt.and(animation, (Animation)AnimationKt.then(animation3, (Animation)AnimationKt.and(animation4, (Animation)AnimationKt.move$default(replacement, halfTime, point2D4, null, false, false, null, 60, null))));
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(removed, "removed");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            removed.setTranslateX(0.0);
            removed.setTranslateY(0.0);
            removed.setScaleX(1.0);
            removed.setScaleY(1.0);
        }

        @Override
        @NotNull
        protected Swap reversed() {
            Swap swap;
            Swap it = swap = new Swap(this.duration, this.direction.reversed(), this.scale);
            it.setSetup(this.getSetup());
            return swap;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        @NotNull
        public final Point2D getScale() {
            return this.scale;
        }

        public Swap(@NotNull Duration duration, @NotNull Direction direction, @NotNull Point2D scale2) {
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
            Intrinsics.checkParameterIsNotNull(scale2, "scale");
            this.duration = duration;
            this.direction = direction;
            this.scale = scale2;
        }

        public /* synthetic */ Swap(Duration duration, Direction direction, Point2D point2D, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                direction = Direction.LEFT;
            }
            if ((n & 4) != 0) {
                point2D = NodesKt.point(0.75, 0.75);
            }
            this(duration, direction, point2D);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Ltornadofx/ViewTransition$Flip;", "Ltornadofx/ViewTransition;", "duration", "Ljavafx/util/Duration;", "vertical", "", "(Ljavafx/util/Duration;Z)V", "halfTime", "getHalfTime", "()Ljavafx/util/Duration;", "targetAxis", "Ljavafx/geometry/Point3D;", "getTargetAxis", "()Ljavafx/geometry/Point3D;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "tornadofx"})
    public static final class Flip
    extends ViewTransition {
        @NotNull
        private final Duration halfTime;
        @NotNull
        private final Point3D targetAxis;

        @NotNull
        public final Duration getHalfTime() {
            return this.halfTime;
        }

        @NotNull
        public final Point3D getTargetAxis() {
            return this.targetAxis;
        }

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Number number = 90;
            Interpolator interpolator = Interpolator.EASE_IN;
            Intrinsics.checkExpressionValueIsNotNull(interpolator, "Interpolator.EASE_IN");
            Animation animation = (Animation)AnimationKt.rotate$default(current, this.halfTime, number, interpolator, false, false, (Function1)new Function1<RotateTransition, Unit>(this){
                final /* synthetic */ Flip this$0;

                public final void invoke(@NotNull RotateTransition $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                    $receiver.setAxis(this.this$0.getTargetAxis());
                }
                {
                    this.this$0 = flip;
                    super(1);
                }
            }, 8, null);
            Number number2 = 90;
            Interpolator interpolator2 = Interpolator.EASE_OUT;
            Intrinsics.checkExpressionValueIsNotNull(interpolator2, "Interpolator.EASE_OUT");
            return (Animation)AnimationKt.then(animation, (Animation)AnimationKt.rotate(replacement, this.halfTime, number2, interpolator2, true, false, (Function1<? super RotateTransition, Unit>)new Function1<RotateTransition, Unit>(this){
                final /* synthetic */ Flip this$0;

                public final void invoke(@NotNull RotateTransition $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                    $receiver.setAxis(this.this$0.getTargetAxis());
                }
                {
                    this.this$0 = flip;
                    super(1);
                }
            }));
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(removed, "removed");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            removed.setRotate(0.0);
            removed.setRotationAxis(Rotate.Z_AXIS);
            replacement.setRotationAxis(Rotate.Z_AXIS);
        }

        public Flip(@NotNull Duration duration, boolean vertical) {
            Point3D point3D;
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            Duration duration2 = duration.divide(2.0);
            Intrinsics.checkExpressionValueIsNotNull(duration2, "duration.divide(2.0)");
            this.halfTime = duration2;
            if (vertical) {
                Point3D point3D2 = Rotate.X_AXIS;
                point3D = point3D2;
                Intrinsics.checkExpressionValueIsNotNull(point3D2, "Rotate.X_AXIS");
            } else {
                Point3D point3D3 = Rotate.Y_AXIS;
                point3D = point3D3;
                Intrinsics.checkExpressionValueIsNotNull(point3D3, "Rotate.Y_AXIS");
            }
            this.targetAxis = point3D;
        }

        public /* synthetic */ Flip(Duration duration, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(duration, bl);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Ltornadofx/ViewTransition$NewsFlash;", "Ltornadofx/ViewTransition;", "duration", "Ljavafx/util/Duration;", "rotations", "", "(Ljavafx/util/Duration;Ljava/lang/Number;)V", "getDuration", "()Ljavafx/util/Duration;", "getRotations", "()Ljava/lang/Number;", "create", "Ljavafx/animation/ParallelTransition;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "tornadofx"})
    public static final class NewsFlash
    extends ViewTransition {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Number rotations;

        @NotNull
        public ParallelTransition create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Point2D point2D = Point2D.ZERO;
            Intrinsics.checkExpressionValueIsNotNull(point2D, "Point2D.ZERO");
            Number number = this.rotations.doubleValue() * (double)360;
            Point2D point2D2 = Point2D.ZERO;
            Intrinsics.checkExpressionValueIsNotNull(point2D2, "Point2D.ZERO");
            Number number2 = 1;
            Interpolator interpolator = Interpolator.EASE_IN;
            Intrinsics.checkExpressionValueIsNotNull(interpolator, "Interpolator.EASE_IN");
            return AnimationKt.transform$default(replacement, this.duration, point2D, number, point2D2, number2, interpolator, true, false, null, 256, null);
        }

        @Override
        @NotNull
        public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            return super.stack(replacement, current);
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Number getRotations() {
            return this.rotations;
        }

        public NewsFlash(@NotNull Duration duration, @NotNull Number rotations) {
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            Intrinsics.checkParameterIsNotNull(rotations, "rotations");
            this.duration = duration;
            this.rotations = rotations;
        }

        public /* synthetic */ NewsFlash(Duration duration, Number number, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                number = 2;
            }
            this(duration, number);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0002H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ltornadofx/ViewTransition$Explode;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "Ltornadofx/ViewTransition$Implode;", "duration", "Ljavafx/util/Duration;", "scale", "Ljavafx/geometry/Point2D;", "(Ljavafx/util/Duration;Ljavafx/geometry/Point2D;)V", "getDuration", "()Ljavafx/util/Duration;", "getScale", "()Ljavafx/geometry/Point2D;", "create", "Ljavafx/animation/ParallelTransition;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "onComplete", "", "removed", "reversed", "tornadofx"})
    public static final class Explode
    extends ReversibleViewTransition<Implode> {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Point2D scale;

        @NotNull
        public ParallelTransition create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Point2D point2D = Point2D.ZERO;
            Intrinsics.checkExpressionValueIsNotNull(point2D, "Point2D.ZERO");
            return AnimationKt.transform$default(current, this.duration, point2D, (Number)0, this.scale, (Number)0, null, false, false, null, 352, null);
        }

        @Override
        public void onComplete(@NotNull Node removed, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(removed, "removed");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            removed.setScaleX(1.0);
            removed.setScaleY(1.0);
            removed.setOpacity(1.0);
        }

        @Override
        @NotNull
        protected Implode reversed() {
            Implode implode;
            Implode it = implode = new Implode(this.duration, this.scale);
            it.setSetup(this.getSetup());
            return implode;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Point2D getScale() {
            return this.scale;
        }

        public Explode(@NotNull Duration duration, @NotNull Point2D scale2) {
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            Intrinsics.checkParameterIsNotNull(scale2, "scale");
            this.duration = duration;
            this.scale = scale2;
        }

        public /* synthetic */ Explode(Duration duration, Point2D point2D, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                point2D = NodesKt.point(2, 2);
            }
            this(duration, point2D);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0002H\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Ltornadofx/ViewTransition$Implode;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "Ltornadofx/ViewTransition$Explode;", "duration", "Ljavafx/util/Duration;", "scale", "Ljavafx/geometry/Point2D;", "(Ljavafx/util/Duration;Ljavafx/geometry/Point2D;)V", "getDuration", "()Ljavafx/util/Duration;", "getScale", "()Ljavafx/geometry/Point2D;", "create", "Ljavafx/animation/ParallelTransition;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "reversed", "tornadofx"})
    public static final class Implode
    extends ReversibleViewTransition<Explode> {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Point2D scale;

        @NotNull
        public ParallelTransition create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Point2D point2D = Point2D.ZERO;
            Intrinsics.checkExpressionValueIsNotNull(point2D, "Point2D.ZERO");
            return AnimationKt.transform$default(replacement, this.duration, point2D, (Number)0, this.scale, (Number)0, null, true, false, null, 288, null);
        }

        @Override
        @NotNull
        public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            return super.stack(replacement, current);
        }

        @Override
        @NotNull
        protected Explode reversed() {
            Explode explode;
            Explode it = explode = new Explode(this.duration, this.scale);
            it.setSetup(this.getSetup());
            return explode;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Point2D getScale() {
            return this.scale;
        }

        public Implode(@NotNull Duration duration, @NotNull Point2D scale2) {
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            Intrinsics.checkParameterIsNotNull(scale2, "scale");
            this.duration = duration;
            this.scale = scale2;
        }

        public /* synthetic */ Implode(Duration duration, Point2D point2D, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                point2D = NodesKt.point(2, 2);
            }
            this(duration, point2D);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0000H\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Ltornadofx/ViewTransition$Wipe;", "Ltornadofx/ViewTransition$ReversibleViewTransition;", "duration", "Ljavafx/util/Duration;", "direction", "Ltornadofx/ViewTransition$Direction;", "(Ljavafx/util/Duration;Ltornadofx/ViewTransition$Direction;)V", "getDirection", "()Ltornadofx/ViewTransition$Direction;", "getDuration", "()Ljavafx/util/Duration;", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "reversed", "tornadofx"})
    public static final class Wipe
    extends ReversibleViewTransition<Wipe> {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Direction direction;

        @Override
        @NotNull
        public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Node[] nodeArray = new Node[2];
            nodeArray[0] = replacement;
            WritableImage writableImage = current.snapshot(null, null);
            Intrinsics.checkExpressionValueIsNotNull(writableImage, "current.snapshot(null, null)");
            nodeArray[1] = (Node)this.toCanvas((Image)writableImage);
            return new StackPane(nodeArray);
        }

        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Object object = stack.getChildren().get(1);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type javafx.scene.canvas.Canvas");
            }
            Canvas canvas2 = (Canvas)object;
            GraphicsContext gc = canvas2.getGraphicsContext2D();
            return (Animation)new Transition(this, canvas2, gc){
                private double x;
                private double y;
                private double width;
                private double height;
                final /* synthetic */ Wipe this$0;
                final /* synthetic */ Canvas $canvas;
                final /* synthetic */ GraphicsContext $gc;

                public final double getX() {
                    return this.x;
                }

                public final void setX(double d) {
                    this.x = d;
                }

                public final double getY() {
                    return this.y;
                }

                public final void setY(double d) {
                    this.y = d;
                }

                public final double getWidth() {
                    return this.width;
                }

                public final void setWidth(double d) {
                    this.width = d;
                }

                public final double getHeight() {
                    return this.height;
                }

                public final void setHeight(double d) {
                    this.height = d;
                }

                protected void interpolate(double frac) {
                    switch (ViewTransition$Wipe$WhenMappings.$EnumSwitchMapping$0[this.this$0.getDirection().ordinal()]) {
                        case 1: 
                        case 2: {
                            this.height = frac * this.$canvas.getHeight();
                            if (this.this$0.getDirection() != Direction.UP) break;
                            this.y = this.$canvas.getHeight() - this.height;
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.width = frac * this.$canvas.getWidth();
                            if (this.this$0.getDirection() != Direction.LEFT) break;
                            this.x = this.$canvas.getWidth() - this.width;
                        }
                    }
                    this.$gc.clearRect(this.x, this.y, this.width, this.height);
                }
                {
                    this.this$0 = $outer;
                    this.$canvas = $captured_local_variable$1;
                    this.$gc = $captured_local_variable$2;
                    this.width = $captured_local_variable$1.getWidth();
                    this.height = $captured_local_variable$1.getHeight();
                    this.setCycleDuration($outer.getDuration());
                }
            };
        }

        @Override
        @NotNull
        protected Wipe reversed() {
            Wipe wipe;
            Wipe it = wipe = new Wipe(this.duration, this.direction.reversed());
            it.setSetup(this.getSetup());
            return wipe;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public Wipe(@NotNull Duration duration, @NotNull Direction direction) {
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
            this.duration = duration;
            this.direction = direction;
        }

        public /* synthetic */ Wipe(Duration duration, Direction direction, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                direction = Direction.LEFT;
            }
            this(duration, direction);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0014"}, d2={"Ltornadofx/ViewTransition$Dissolve;", "Ltornadofx/ViewTransition;", "duration", "Ljavafx/util/Duration;", "hChunks", "", "vChunks", "(Ljavafx/util/Duration;II)V", "getDuration", "()Ljavafx/util/Duration;", "getHChunks", "()I", "getVChunks", "create", "Ljavafx/animation/Animation;", "current", "Ljavafx/scene/Node;", "replacement", "stack", "Ljavafx/scene/layout/StackPane;", "tornadofx"})
    public static final class Dissolve
    extends ViewTransition {
        @NotNull
        private final Duration duration;
        private final int hChunks;
        private final int vChunks;

        @Override
        @NotNull
        public StackPane stack(@NotNull Node current, @NotNull Node replacement) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Node[] nodeArray = new Node[2];
            nodeArray[0] = replacement;
            WritableImage writableImage = current.snapshot(null, null);
            Intrinsics.checkExpressionValueIsNotNull(writableImage, "current.snapshot(null, null)");
            nodeArray[1] = (Node)this.toCanvas((Image)writableImage);
            return new StackPane(nodeArray);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Animation create(@NotNull Node current, @NotNull Node replacement, @NotNull StackPane stack) {
            Intrinsics.checkParameterIsNotNull(current, "current");
            Intrinsics.checkParameterIsNotNull(replacement, "replacement");
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Object object = stack.getChildren().get(1);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type javafx.scene.canvas.Canvas");
            }
            Canvas canvas2 = (Canvas)object;
            double width = canvas2.getWidth() / (double)this.hChunks;
            double height = canvas2.getHeight() / (double)this.vChunks;
            GraphicsContext gc = canvas2.getGraphicsContext2D();
            int originalSize = this.hChunks * this.vChunks;
            List<Integer> list2 = new ArrayList<Integer>(originalSize);
            int n = 0;
            int n2 = originalSize;
            while (n < n2) {
                void it;
                int n3;
                int n4 = n3 = n++;
                ArrayList<Integer> arrayList = list2;
                Integer n5 = (int)it;
                arrayList.add(n5);
            }
            List indices = list2;
            list2 = indices;
            Collections.shuffle(list2);
            return (Animation)new Transition(this, indices, originalSize, gc, width, height){
                final /* synthetic */ Dissolve this$0;
                final /* synthetic */ List $indices;
                final /* synthetic */ int $originalSize;
                final /* synthetic */ GraphicsContext $gc;
                final /* synthetic */ double $width;
                final /* synthetic */ double $height;

                protected void interpolate(double frac) {
                    if (this.$indices.isEmpty()) {
                        return;
                    }
                    int n = (int)(frac * (double)this.$originalSize) - this.$originalSize + CollectionsKt.getLastIndex(this.$indices);
                    int n2 = 0;
                    int n3 = n;
                    while (n2 < n3) {
                        int it = n2++;
                        int index = ((Number)this.$indices.remove(CollectionsKt.getLastIndex(this.$indices))).intValue();
                        this.$gc.clearRect((double)(index % this.this$0.getHChunks()) * this.$width, (double)(index / this.this$0.getHChunks()) * this.$height, this.$width, this.$height);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$indices = $captured_local_variable$1;
                    this.$originalSize = $captured_local_variable$2;
                    this.$gc = $captured_local_variable$3;
                    this.$width = $captured_local_variable$4;
                    this.$height = $captured_local_variable$5;
                    this.setCycleDuration($outer.getDuration());
                }
            };
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        public final int getHChunks() {
            return this.hChunks;
        }

        public final int getVChunks() {
            return this.vChunks;
        }

        public Dissolve(@NotNull Duration duration, int hChunks, int vChunks) {
            Intrinsics.checkParameterIsNotNull(duration, "duration");
            this.duration = duration;
            this.hChunks = hChunks;
            this.vChunks = vChunks;
        }

        public /* synthetic */ Dissolve(Duration duration, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = 50;
            }
            if ((n3 & 4) != 0) {
                n2 = 50;
            }
            this(duration, n, n2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R:\u0010\u0003\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR:\u0010\u000b\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Ltornadofx/ViewTransition$Companion;", "", "()V", "SlideIn", "Lkotlin/Function3;", "Ltornadofx/UIComponent;", "Lkotlin/Function0;", "", "SlideIn$annotations", "getSlideIn", "()Lkotlin/jvm/functions/Function3;", "SlideOut", "SlideOut$annotations", "getSlideOut", "tornadofx"})
    public static final class Companion {
        @Deprecated(message="Use `Slide(0.2.seconds)`", replaceWith=@ReplaceWith(imports={}, expression="Slide(0.2.seconds)"))
        public static /* synthetic */ void SlideIn$annotations() {
        }

        @NotNull
        public final Function3<UIComponent, UIComponent, Function0<Unit>, Unit> getSlideIn() {
            return SlideIn;
        }

        @Deprecated(message="Use `Slide(0.2.seconds, Direction.LEFT)`", replaceWith=@ReplaceWith(imports={}, expression="Slide(0.2.seconds, Direction.RIGHT)"))
        public static /* synthetic */ void SlideOut$annotations() {
        }

        @NotNull
        public final Function3<UIComponent, UIComponent, Function0<Unit>, Unit> getSlideOut() {
            return SlideOut;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

