/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.device.smmodellbau.JLog2;
import gde.device.smmodellbau.JLog2Dialog;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JLog2Configuration
extends Composite {
    static final Logger log = Logger.getLogger(JLog2Configuration.class.getName());
    private CCombo jlogVersionCombo;
    private CCombo jlogFirmwareCombo;
    private Group mainConfigGroup;
    private CLabel jlcUrlLabel;
    private CLabel logModeLabel;
    private CLabel flagsLabel;
    private Button jlcDownloadButton;
    private Button jlcForumButton;
    private Button resetButton;
    private Button directRatioButton;
    private Button extRpmButton;
    private Button logStopButton;
    private Button highPulsWidthButton;
    private Button gearSelectionButton;
    private CLabel dotLabel;
    private CLabel sysModeLabel;
    private CLabel gearRatioLabel;
    private CLabel baudrateLabel;
    private CLabel motorPolsLabel;
    private CCombo jlogConfigurationCombo;
    private CCombo logModeCombo;
    private CCombo sysModeCombo;
    private CCombo baudrateCombo;
    private CCombo motorShuntCombo;
    private CCombo motorPolsCombo;
    private CCombo directGearRatioMajorCombo;
    private CCombo directGearRatioDecimalsCombo;
    private CCombo gearMainWheelDecimalsCombo;
    private CCombo gearMainWheelCombo;
    private CCombo gearPinionWheelCombo;
    private CLabel mainConfigLabel;
    private CLabel gearMainWheelLabel;
    private CLabel percentLabel;
    private CLabel motorShuntLabel;
    private Text mainExplanationText;
    private Group alarmGroup;
    private CLabel uBecDipDetectLabel;
    private CLabel fetTempMaxLabel;
    private CLabel voltageLabel;
    private CLabel mAhLabel;
    private CLabel uBatMinAlarmLabel;
    private CLabel capacityAlarmLabel;
    private CLabel temperaureLabel;
    private CLabel temperaure1Label;
    private CCombo fetTempMaxCombo;
    private CCombo voltageBatteryAlarmDecimalsCombo;
    private CCombo voltageBatteryAlarmCombo;
    private CCombo capacityAlarmCombo;
    private Button alarmsClearButton;
    private Button uBecDipDetectButton;
    private Button ext1smallerButton;
    private Button ext2smallerButton;
    private Button ext3smallerButton;
    private Button ext4smallerButton;
    private Button ext5smallerButton;
    private Button speedSensorButton;
    private CLabel speedSensorLabel;
    private CCombo hv2BecCombo;
    private CLabel hv2BecLabel;
    private CCombo extern1Combo;
    private CCombo extern2Combo;
    private CCombo extern3Combo;
    private CCombo extern4Combo;
    private CCombo extern5Combo;
    private CLabel ext1Label;
    private CLabel ext2Label;
    private CLabel ext3Label;
    private CLabel ext4Label;
    private CLabel ext5Label;
    private Group optionalGroup;
    private Composite optionalStuff;
    private Button sensorAdapterButton;
    private Button motorButton;
    private Button brushLessButton;
    private CCombo alarmLinesCombo;
    private CCombo telemetryCombo;
    private CCombo pulsPerRevolutionSensorCombo;
    private CCombo tempSensorTypeCombo;
    private CCombo subDevicesCombo;
    private CCombo line1signalTypeCombo;
    private CLabel telemetryLabel;
    private CLabel rpmSensorLabel;
    private CLabel tempSensorTypeLabel;
    private CLabel subDevicesLabel;
    private CLabel line1signalTypeLabel;
    private CLabel alarmLinesLabel;
    private CLabel mpxAddessesLabel;
    private MpxAddressComposite[] mpxAddresses = new MpxAddressComposite[16];
    final DataExplorer application;
    final JLog2Dialog dialog;
    final JLog2 device;
    final String[] jlogFirmware = new String[]{"3.2.2", "4.0.0"};
    final String[] jlogConfigurations322 = new String[]{"---- normal ----", Messages.getString((String)"GDE_MSGT2894"), Messages.getString((String)"GDE_MSGI2878"), Messages.getString((String)"GDE_MSGI2879"), Messages.getString((String)"GDE_MSGI2880"), Messages.getString((String)"GDE_MSGI2881"), Messages.getString((String)"GDE_MSGI2882"), Messages.getString((String)"GDE_MSGT2817"), Messages.getString((String)"GDE_MSGT2818"), Messages.getString((String)"GDE_MSGT2819"), Messages.getString((String)"GDE_MSGT2820"), Messages.getString((String)"GDE_MSGT2821"), Messages.getString((String)"GDE_MSGT2822"), Messages.getString((String)"GDE_MSGT2823"), Messages.getString((String)"GDE_MSGT2824"), Messages.getString((String)"GDE_MSGT2825"), Messages.getString((String)"GDE_MSGT2831"), Messages.getString((String)"GDE_MSGT2837"), Messages.getString((String)"GDE_MSGT2843"), Messages.getString((String)"GDE_MSGT2846"), Messages.getString((String)"GDE_MSGT2852"), Messages.getString((String)"GDE_MSGT2856"), Messages.getString((String)"GDE_MSGT2862")};
    final String[] jlogConfigurations400 = new String[]{" none selected", " Jive basic", " Jive JETI EX", " Jive HoTT v4", " Jive Futaba SBUS2", " Jive HiTec", " Jive Spektrum", " Castle Creations Jeti EX", " Castle Creations HoTT v4", " Castle Creations Futaba SBUS2", " Castle Creations HiTec", " Castle Creations Spektrum", " C200 current sensor HoTT V4", " C200 current sensor Futaba SBUS2"};
    final String[] baudrates = new String[]{"JIVE", "2400", "4800", "9600", "38400", "57600", "115200", "CMT"};
    final String[] sysModes = new String[]{"NEWLOG", "SEQLOG"};
    final String[] logModes = new String[]{"(0) OF/LV", "(2) SER", "(8) JLV"};
    final String[] motorPols = new String[]{"2", "4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26", "38", "30", "32", "34", "36", "38", "40", "42", "44", "46", "48"};
    final String[] currentShuntAdjust = new String[121];
    final String[] zeroTo9 = new String[10];
    final String[] zeroTo99 = new String[100];
    final String[] zeroTo50 = new String[51];
    final String[] oneTo50 = new String[50];
    final String[] eightTo30 = new String[23];
    final String[] eightTo255 = new String[248];
    final String[] zeroTo127 = new String[127];
    final String[] zeroTo25500 = new String[256];
    final String[] zeroAlarms = new String[]{"0"};
    final String[] oneAlarms = new String[]{"0", "1"};
    final String[] greaterOneAlarms = new String[]{"0", "1", "2"};
    final String comOutputString = " ----------- , FTDI livestream, JETI, MPX, Unidisplay";
    final StringBuilder comOutput = new StringBuilder().append(this.comOutputString);
    final String hottOutput = ", HoTT";
    final String[] comOutputBase = new String[]{" ----------- ", " FTDI livestream", " Unidisplay", " MPX", " JETI v1"};
    final String[] comOutputJetiEx = new String[]{" ----------- ", " FTDI livestream", " JETI EX"};
    final String[] comOutputHoTTv4 = new String[]{" ----------- ", " FTDI livestream", " JETI v1", " HoTT v4"};
    final String[] comOutputFutabaSbus2 = new String[]{" ----------- ", " FTDI livestream", " JETI v1", " MPX", " S.BUS2"};
    final String[] comOutputHiTec = new String[]{" HiTec"};
    final String[] comOutputSpektrum = new String[]{" Spektrum"};
    Configuration configuration;

    public void loadConfiuration(String configString, int version) {
        if (version == 322) {
            this.jlogFirmwareCombo.select(0);
            this.jlogConfigurationCombo.setItems(this.jlogConfigurations322);
            this.configuration = new Configuration322(configString);
            this.configuration.update(configString);
        } else {
            this.jlogFirmwareCombo.select(1);
            this.jlogConfigurationCombo.setItems(this.jlogConfigurations400);
            this.configuration = new Configuration400(configString);
            this.configuration.update(configString);
        }
        this.jlogConfigurationCombo.select(0);
        this.initialyzeGUI(this.configuration, true);
    }

    public static void main(String[] args) {
        JLog2Configuration.showGUI();
    }

    public static void showGUI() {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        JLog2Configuration inst = new JLog2Configuration((Composite)shell, 0, null, null);
        Point size = inst.getSize();
        shell.setLayout((Layout)new FillLayout());
        shell.layout();
        if (size.x == 0 && size.y == 0) {
            inst.pack();
            shell.pack();
        } else {
            Rectangle shellBounds = shell.computeTrim(0, 0, size.x, size.y);
            shell.setSize(shellBounds.width, shellBounds.height);
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public JLog2Configuration(Composite parent, int style, JLog2Dialog useDialog, JLog2 useDevice) {
        super(parent, style);
        int i;
        this.application = DataExplorer.getInstance();
        this.dialog = useDialog;
        this.device = useDevice;
        for (i = 0; i < this.currentShuntAdjust.length; ++i) {
            this.currentShuntAdjust[i] = "" + (i - 60);
        }
        for (i = 0; i < this.zeroTo9.length; ++i) {
            this.zeroTo9[i] = "" + i;
        }
        for (i = 0; i < this.zeroTo99.length; ++i) {
            this.zeroTo99[i] = (i < 10 ? "0" : "") + i;
        }
        for (i = 0; i < this.zeroTo50.length; ++i) {
            this.zeroTo50[i] = "" + i;
        }
        for (i = 0; i < this.oneTo50.length; ++i) {
            this.oneTo50[i] = "" + (i + 1);
        }
        for (i = 0; i < this.eightTo30.length; ++i) {
            this.eightTo30[i] = "" + (i + 8);
        }
        for (i = 0; i < this.eightTo255.length; ++i) {
            this.eightTo255[i] = "" + (i + 8);
        }
        for (i = 0; i < this.zeroTo127.length; ++i) {
            this.zeroTo127[i] = "" + i;
        }
        for (i = 0; i < this.zeroTo25500.length; ++i) {
            this.zeroTo25500[i] = "" + i * 100;
        }
        this.configuration = new Configuration400();
        this.initGUI();
    }

    public void enableSaveSettings() {
        this.dialog.isConfigChanged = true;
        this.dialog.liveGathererButton.setEnabled(true);
    }

    private void initGUI() {
        try {
            this.dialog.isConfigChanged = false;
            this.setLayout((Layout)new FormLayout());
            this.setSize(675, 600);
            this.mainConfigGroup = new Group((Composite)this, 0);
            RowLayout mainConfigGroupLayout = new RowLayout(256);
            this.mainConfigGroup.setLayout((Layout)mainConfigGroupLayout);
            FormData mainConfigGroupLData = new FormData();
            mainConfigGroupLData.width = 650;
            mainConfigGroupLData.left = new FormAttachment(0, 1000, 7);
            mainConfigGroupLData.top = new FormAttachment(0, 1000, 3);
            mainConfigGroupLData.right = new FormAttachment(1000, 1000, -7);
            mainConfigGroupLData.height = 280;
            this.mainConfigGroup.setLayoutData((Object)mainConfigGroupLData);
            this.mainConfigGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 2 : 0)), (int)0));
            this.mainConfigGroup.setText(Messages.getString((String)"GDE_MSGT2828"));
            this.jlcUrlLabel = new CLabel((Composite)this.mainConfigGroup, 0x1000000);
            RowData jlcUrlLabelLData = new RowData();
            jlcUrlLabelLData.width = 154;
            jlcUrlLabelLData.height = 25;
            this.jlcUrlLabel.setLayoutData((Object)jlcUrlLabelLData);
            this.jlcUrlLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.jlcUrlLabel.setText(Messages.getString((String)"GDE_MSGT2829"));
            this.jlcDownloadButton = new Button((Composite)this.mainConfigGroup, 0x1000008);
            RowData jlcDownloadButtonLData = new RowData();
            jlcDownloadButtonLData.width = 114;
            jlcDownloadButtonLData.height = 25;
            this.jlcDownloadButton.setLayoutData((Object)jlcDownloadButtonLData);
            this.jlcDownloadButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.jlcDownloadButton.setText("Homepage");
            this.jlcDownloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "jlcDownloadButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.application.openWebBrowser("https://jlog.hacknet.eu/jlog/");
                }
            });
            this.jlcForumButton = new Button((Composite)this.mainConfigGroup, 0x1000008);
            RowData jlcForumButtonLData = new RowData();
            jlcForumButtonLData.width = 114;
            jlcForumButtonLData.height = 25;
            this.jlcForumButton.setLayoutData((Object)jlcForumButtonLData);
            this.jlcForumButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.jlcForumButton.setText("Forum");
            this.jlcForumButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "jlcForumButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.application.openWebBrowser("https://jlog.hacknet.eu/jlog/forum/");
                }
            });
            new Label((Composite)this.mainConfigGroup, 0).setLayoutData((Object)new RowData(this.getClientArea().width - (GDE.IS_MAC ? 35 : (GDE.IS_LINUX ? 0 : 45)), 5));
            this.mainConfigLabel = new CLabel((Composite)this.mainConfigGroup, 0);
            this.mainConfigLabel.setLayoutData((Object)new RowData(80, 20));
            this.mainConfigLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.mainConfigLabel.setText(Messages.getString((String)"GDE_MSGT2830"));
            this.jlogVersionCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            this.jlogVersionCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.jlogVersionCombo.setText("JLog2");
            this.jlogVersionCombo.setEditable(false);
            this.jlogVersionCombo.setBackground(SWTResourceManager.getColor((int)255, (int)128, (int)0));
            this.jlogVersionCombo.setLayoutData((Object)new RowData(60, 17));
            this.jlogVersionCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "jlogVersionCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2824"));
                }
            });
            this.jlogFirmwareCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            this.jlogFirmwareCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.jlogFirmwareCombo.setItems(this.jlogFirmware);
            this.jlogFirmwareCombo.setBackground(SWTResourceManager.getColor((int)255, (int)128, (int)0));
            this.jlogFirmwareCombo.setLayoutData((Object)new RowData(60, 17));
            this.jlogFirmwareCombo.setEditable(false);
            this.jlogFirmwareCombo.select(1);
            this.jlogFirmwareCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "cCombo1.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2825"));
                }
            });
            this.jlogConfigurationCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            this.jlogConfigurationCombo.setLayoutData((Object)new RowData(420, 17));
            this.jlogConfigurationCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.jlogConfigurationCombo.setItems(this.jlogConfigurations400);
            this.jlogConfigurationCombo.setVisibleItemCount(10);
            this.jlogConfigurationCombo.setBackground(SWTResourceManager.getColor((int)255, (int)128, (int)0));
            this.jlogConfigurationCombo.setEditable(false);
            this.jlogConfigurationCombo.select(0);
            this.jlogConfigurationCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "jlogConfigurationCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2826"));
                }
            });
            this.jlogConfigurationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "jlogConfigurationCombo.widgetSelected, event=" + String.valueOf(evt));
                    if (JLog2Configuration.this.configuration.version == 322 && JLog2Configuration.this.jlogConfigurationCombo.getSelectionIndex() > 0) {
                        JLog2Configuration.this.application.openMessageDialogAsync(JLog2Configuration.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGI2826"));
                    }
                    JLog2Configuration.this.configuration.switchConfig();
                    JLog2Configuration.this.initialyzeGUI(JLog2Configuration.this.configuration, true);
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.baudrateLabel = new CLabel((Composite)this.mainConfigGroup, 0);
            RowData baudrateLabelLData = new RowData();
            baudrateLabelLData.width = 105;
            baudrateLabelLData.height = 20;
            this.baudrateLabel.setLayoutData((Object)baudrateLabelLData);
            this.baudrateLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.baudrateLabel.setText(Messages.getString((String)"GDE_MSGT2835"));
            this.baudrateCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            RowData baudrateComboLData = new RowData();
            baudrateComboLData.width = 99;
            baudrateComboLData.height = 17;
            this.baudrateCombo.setLayoutData((Object)baudrateComboLData);
            this.baudrateCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.baudrateCombo.setItems(this.baudrates);
            this.baudrateCombo.setEditable(false);
            this.baudrateCombo.setVisibleItemCount(10);
            this.baudrateCombo.select(0);
            this.baudrateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "baudrateCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setBaudRate(JLog2Configuration.this.baudrateCombo.getSelectionIndex());
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.baudrateCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "baudrateCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2827"));
                }
            });
            this.gearRatioLabel = new CLabel((Composite)this.mainConfigGroup, 0x1000000);
            RowData gearRatioLabelLData = new RowData();
            gearRatioLabelLData.width = 395;
            gearRatioLabelLData.height = 20;
            this.gearRatioLabel.setLayoutData((Object)gearRatioLabelLData);
            this.gearRatioLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.gearRatioLabel.setText(Messages.getString((String)"GDE_MSGT2839"));
            this.sysModeLabel = new CLabel((Composite)this.mainConfigGroup, 0);
            RowData sysModeLabelLData = new RowData();
            sysModeLabelLData.width = 105;
            sysModeLabelLData.height = 20;
            this.sysModeLabel.setLayoutData((Object)sysModeLabelLData);
            this.sysModeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.sysModeLabel.setText("SYSmode");
            this.sysModeCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            RowData sysModeComboLData = new RowData();
            sysModeComboLData.width = 99;
            sysModeComboLData.height = 17;
            this.sysModeCombo.setLayoutData((Object)sysModeComboLData);
            this.sysModeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.sysModeCombo.setItems(this.sysModes);
            this.sysModeCombo.setEditable(false);
            this.sysModeCombo.select(0);
            this.sysModeCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "sysModeCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2828"));
                }
            });
            this.sysModeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "sysModeCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setSysMode(JLog2Configuration.this.sysModeCombo.getSelectionIndex());
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            new Label((Composite)this.mainConfigGroup, 0).setLayoutData((Object)new RowData(19, 19));
            this.directRatioButton = new Button((Composite)this.mainConfigGroup, 131104);
            RowData directRatioButtonLData = new RowData();
            directRatioButtonLData.width = 73;
            directRatioButtonLData.height = 21;
            this.directRatioButton.setLayoutData((Object)directRatioButtonLData);
            this.directRatioButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.directRatioButton.setText(Messages.getString((String)"GDE_MSGT2841"));
            this.directRatioButton.setSelection(true);
            this.directRatioButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "directRatioButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2829"));
                }
            });
            this.directRatioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "directRatioButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.gearSelectionButton.setSelection(!JLog2Configuration.this.directRatioButton.getSelection());
                    JLog2Configuration.this.configuration.setGearDirectConfig(JLog2Configuration.this.directRatioButton.getSelection());
                    JLog2Configuration.this.directGearRatioMajorCombo.setEnabled(JLog2Configuration.this.directRatioButton.getSelection());
                    JLog2Configuration.this.directGearRatioDecimalsCombo.setEnabled(JLog2Configuration.this.directRatioButton.getSelection());
                    JLog2Configuration.this.gearPinionWheelCombo.setEnabled(!JLog2Configuration.this.directRatioButton.getSelection());
                    JLog2Configuration.this.gearMainWheelCombo.setEnabled(!JLog2Configuration.this.directRatioButton.getSelection());
                    JLog2Configuration.this.gearMainWheelDecimalsCombo.setEnabled(!JLog2Configuration.this.directRatioButton.getSelection());
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.directGearRatioMajorCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            RowData directRatioComboLData = new RowData();
            directRatioComboLData.width = GDE.IS_LINUX ? 55 : 45;
            directRatioComboLData.height = 17;
            this.directGearRatioMajorCombo.setLayoutData((Object)directRatioComboLData);
            this.directGearRatioMajorCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.directGearRatioMajorCombo.setItems(this.oneTo50);
            this.directGearRatioMajorCombo.setVisibleItemCount(10);
            this.directGearRatioMajorCombo.setEditable(false);
            this.directGearRatioMajorCombo.select(0);
            this.directGearRatioMajorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "directRatioCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setGearRatioMinor(JLog2Configuration.this.directGearRatioMajorCombo.getText());
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.directGearRatioMajorCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "directRatioCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2830"));
                }
            });
            this.dotLabel = new CLabel((Composite)this.mainConfigGroup, 0);
            RowData dotLabelLData = new RowData();
            dotLabelLData.width = 8;
            dotLabelLData.height = 20;
            this.dotLabel.setLayoutData((Object)dotLabelLData);
            this.dotLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
            this.dotLabel.setText(".");
            this.directGearRatioDecimalsCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            RowData gearRatioMinorComboLData = new RowData();
            gearRatioMinorComboLData.width = GDE.IS_LINUX ? 55 : 45;
            gearRatioMinorComboLData.height = 17;
            this.directGearRatioDecimalsCombo.setLayoutData((Object)gearRatioMinorComboLData);
            this.directGearRatioDecimalsCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.directGearRatioDecimalsCombo.setItems(this.zeroTo99);
            this.directGearRatioDecimalsCombo.setVisibleItemCount(10);
            this.directGearRatioDecimalsCombo.setEditable(false);
            this.directGearRatioDecimalsCombo.select(0);
            this.directGearRatioDecimalsCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "gearRatioMinorCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2831"));
                }
            });
            this.directGearRatioDecimalsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "gearRatioMinorCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setGearRatioDecimals(JLog2Configuration.this.directGearRatioDecimalsCombo.getText());
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            new Label((Composite)this.mainConfigGroup, 0).setLayoutData((Object)new RowData(GDE.IS_LINUX ? 190 : 150, 19));
            this.logModeLabel = new CLabel((Composite)this.mainConfigGroup, 0);
            RowData logModeLabelLData = new RowData();
            logModeLabelLData.width = 105;
            logModeLabelLData.height = 20;
            this.logModeLabel.setLayoutData((Object)logModeLabelLData);
            this.logModeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.logModeLabel.setText("LOGmode");
            this.logModeCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            RowData logModeComboLData = new RowData();
            logModeComboLData.width = 99;
            logModeComboLData.height = 17;
            this.logModeCombo.setLayoutData((Object)logModeComboLData);
            this.logModeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.logModeCombo.setItems(this.logModes);
            this.logModeCombo.setEditable(false);
            this.logModeCombo.select(0);
            this.logModeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "logModeCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setLogMode(JLog2Configuration.this.logModeCombo.getSelectionIndex());
                    if (JLog2Configuration.this.logModeCombo.getSelectionIndex() != 1) {
                        JLog2Configuration.this.enableAll(true);
                        JLog2Configuration.this.initialyzeGUI(JLog2Configuration.this.configuration, true);
                    } else {
                        JLog2Configuration.this.enableAll(false);
                    }
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.logModeCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "logModeCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2832"));
                }
            });
            new Label((Composite)this.mainConfigGroup, 0).setLayoutData((Object)new RowData(19, 19));
            this.gearSelectionButton = new Button((Composite)this.mainConfigGroup, 131104);
            RowData gearSelectionButtonLData = new RowData();
            gearSelectionButtonLData.width = 73;
            gearSelectionButtonLData.height = 21;
            this.gearSelectionButton.setLayoutData((Object)gearSelectionButtonLData);
            this.gearSelectionButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.gearSelectionButton.setText(Messages.getString((String)"GDE_MSGT2848"));
            this.gearSelectionButton.setSelection(false);
            this.gearSelectionButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "gearSelectionButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2833"));
                }
            });
            this.gearSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "gearSelectionButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.directRatioButton.setSelection(!JLog2Configuration.this.gearSelectionButton.getSelection());
                    JLog2Configuration.this.configuration.setGearDirectConfig(JLog2Configuration.this.directRatioButton.getSelection());
                    JLog2Configuration.this.directGearRatioMajorCombo.setEnabled(!JLog2Configuration.this.gearSelectionButton.getSelection());
                    JLog2Configuration.this.directGearRatioDecimalsCombo.setEnabled(!JLog2Configuration.this.gearSelectionButton.getSelection());
                    JLog2Configuration.this.gearPinionWheelCombo.setEnabled(JLog2Configuration.this.gearSelectionButton.getSelection());
                    JLog2Configuration.this.gearMainWheelCombo.setEnabled(JLog2Configuration.this.gearSelectionButton.getSelection());
                    JLog2Configuration.this.gearMainWheelDecimalsCombo.setEnabled(JLog2Configuration.this.gearSelectionButton.getSelection());
                    JLog2Configuration.this.updateGearRatio();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.gearPinionWheelCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            RowData pinionComboLData = new RowData();
            pinionComboLData.width = GDE.IS_LINUX ? 55 : 45;
            pinionComboLData.height = 17;
            this.gearPinionWheelCombo.setLayoutData((Object)pinionComboLData);
            this.gearPinionWheelCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.gearPinionWheelCombo.setItems(this.eightTo30);
            this.gearPinionWheelCombo.setVisibleItemCount(10);
            this.gearPinionWheelCombo.setEnabled(false);
            this.gearPinionWheelCombo.setEditable(false);
            this.gearPinionWheelCombo.select(2);
            this.gearPinionWheelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "pinionCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setGearPinionWheel(JLog2Configuration.this.gearPinionWheelCombo.getText());
                    JLog2Configuration.this.updateGearRatio();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.gearPinionWheelCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "pinionCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2834"));
                }
            });
            this.gearMainWheelLabel = new CLabel((Composite)this.mainConfigGroup, 131072);
            RowData mainGearLabelLData = new RowData();
            mainGearLabelLData.width = 80;
            mainGearLabelLData.height = 20;
            this.gearMainWheelLabel.setLayoutData((Object)mainGearLabelLData);
            this.gearMainWheelLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.gearMainWheelLabel.setText(Messages.getString((String)"GDE_MSGT2851"));
            this.gearMainWheelCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            this.gearMainWheelCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.gearMainWheelCombo.setItems(this.eightTo255);
            this.gearMainWheelCombo.setVisibleItemCount(10);
            RowData mainGearComboLData = new RowData();
            mainGearComboLData.width = GDE.IS_LINUX ? 55 : 45;
            mainGearComboLData.height = 17;
            this.gearMainWheelCombo.setLayoutData((Object)mainGearComboLData);
            this.gearMainWheelCombo.setEnabled(false);
            this.gearMainWheelCombo.setEditable(false);
            this.gearMainWheelCombo.select(2);
            this.gearMainWheelCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "mainGearCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2835"));
                }
            });
            this.gearMainWheelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "mainGearCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setGearMajorWheel(JLog2Configuration.this.gearMainWheelCombo.getText());
                    JLog2Configuration.this.updateGearRatio();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.dotLabel = new CLabel((Composite)this.mainConfigGroup, 0);
            this.dotLabel.setLayoutData((Object)new RowData(8, 20));
            this.dotLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
            this.dotLabel.setText(".");
            this.gearMainWheelDecimalsCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            this.gearMainWheelDecimalsCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.gearMainWheelDecimalsCombo.setItems(this.zeroTo99);
            this.gearMainWheelDecimalsCombo.setVisibleItemCount(10);
            RowData secondgearComboLData = new RowData();
            secondgearComboLData.width = GDE.IS_LINUX ? 55 : 45;
            secondgearComboLData.height = 17;
            this.gearMainWheelDecimalsCombo.setLayoutData((Object)secondgearComboLData);
            this.gearMainWheelDecimalsCombo.setEnabled(false);
            this.gearMainWheelDecimalsCombo.setEditable(false);
            this.gearMainWheelDecimalsCombo.select(0);
            this.gearMainWheelDecimalsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "secondgearCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setGearMajorWheelDecimals(JLog2Configuration.this.gearMainWheelDecimalsCombo.getText());
                    JLog2Configuration.this.updateGearRatio();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.gearMainWheelDecimalsCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "secondgearCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2836"));
                }
            });
            new Label((Composite)this.mainConfigGroup, 0).setLayoutData((Object)new RowData(GDE.IS_LINUX ? 85 : 75, 19));
            this.motorPolsLabel = new CLabel((Composite)this.mainConfigGroup, 0);
            RowData motoPolsLabelLData = new RowData();
            motoPolsLabelLData.width = 105;
            motoPolsLabelLData.height = 20;
            this.motorPolsLabel.setLayoutData((Object)motoPolsLabelLData);
            this.motorPolsLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.motorPolsLabel.setText(Messages.getString((String)"GDE_MSGT2854"));
            this.motorPolsCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            RowData motorPolsComboLData = new RowData();
            motorPolsComboLData.width = 99;
            motorPolsComboLData.height = 17;
            this.motorPolsCombo.setLayoutData((Object)motorPolsComboLData);
            this.motorPolsCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.motorPolsCombo.setItems(this.motorPols);
            this.motorPolsCombo.setVisibleItemCount(10);
            this.motorPolsCombo.setEditable(false);
            this.motorPolsCombo.select(6);
            this.motorPolsCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "motorPolsCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2837"));
                }
            });
            this.motorPolsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "motorPolsCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setMotorPols(JLog2Configuration.this.motorPolsCombo.getText());
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.motorShuntLabel = new CLabel((Composite)this.mainConfigGroup, 131072);
            RowData motorShuntLabelLData = new RowData();
            motorShuntLabelLData.width = 231;
            motorShuntLabelLData.height = 20;
            this.motorShuntLabel.setLayoutData((Object)motorShuntLabelLData);
            this.motorShuntLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.motorShuntLabel.setText(Messages.getString((String)"GDE_MSGT2826"));
            this.motorShuntCombo = new CCombo((Composite)this.mainConfigGroup, 2048);
            RowData motorShuntComboLData = new RowData();
            motorShuntComboLData.width = GDE.IS_LINUX ? 55 : 45;
            motorShuntComboLData.height = 17;
            this.motorShuntCombo.setLayoutData((Object)motorShuntComboLData);
            this.motorShuntCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.motorShuntCombo.setItems(this.currentShuntAdjust);
            this.motorShuntCombo.setVisibleItemCount(10);
            this.motorShuntCombo.setEditable(false);
            this.motorShuntCombo.select(60);
            this.motorShuntCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "motorShuntCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setMotorCalibration(JLog2Configuration.this.motorShuntCombo.getText());
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.motorShuntCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "motorShuntCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2839"));
                }
            });
            this.percentLabel = new CLabel((Composite)this.mainConfigGroup, 0);
            this.percentLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.percentLabel.setText("[%]");
            this.mainExplanationText = new Text((Composite)this.mainConfigGroup, 2114);
            RowData mainExplanationTextLData = new RowData();
            mainExplanationTextLData.width = this.getClientArea().width - (GDE.IS_MAC ? 35 : (GDE.IS_LINUX ? 0 : 45));
            mainExplanationTextLData.height = 80;
            this.mainExplanationText.setLayoutData((Object)mainExplanationTextLData);
            this.mainExplanationText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2801"));
            this.mainExplanationText.setEditable(false);
            this.mainExplanationText.setBackground(SWTResourceManager.getColor((int)255, (int)255, (int)128));
            this.flagsLabel = new CLabel((Composite)this.mainConfigGroup, 0);
            RowData flagsLabelLData = new RowData();
            flagsLabelLData.width = 93;
            flagsLabelLData.height = 20;
            this.flagsLabel.setLayoutData((Object)flagsLabelLData);
            this.flagsLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.flagsLabel.setText(Messages.getString((String)"GDE_MSGT2860"));
            this.resetButton = new Button((Composite)this.mainConfigGroup, 16416);
            RowData rstButtonLData = new RowData();
            rstButtonLData.width = 130;
            rstButtonLData.height = 23;
            this.resetButton.setLayoutData((Object)rstButtonLData);
            this.resetButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.resetButton.setText(Messages.getString((String)"GDE_MSGT2861"));
            this.resetButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
            this.resetButton.setForeground(SWTResourceManager.getColor((int)255, (int)0, (int)0));
            this.resetButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "rstButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2802"));
                }
            });
            this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "rstButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setReset(JLog2Configuration.this.resetButton.getSelection() ? "1" : "0");
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.highPulsWidthButton = new Button((Composite)this.mainConfigGroup, 16416);
            RowData hpwButtonLData = new RowData();
            hpwButtonLData.width = 130;
            hpwButtonLData.height = 23;
            this.highPulsWidthButton.setLayoutData((Object)hpwButtonLData);
            this.highPulsWidthButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.highPulsWidthButton.setText(Messages.getString((String)"GDE_MSGT2863"));
            this.highPulsWidthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "hpwButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setHighPwmWarning(JLog2Configuration.this.highPulsWidthButton.getSelection() ? 2 : 0);
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.highPulsWidthButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "hpwButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2803"));
                }
            });
            this.logStopButton = new Button((Composite)this.mainConfigGroup, 16416);
            RowData logStopButtonLData = new RowData();
            logStopButtonLData.width = 130;
            logStopButtonLData.height = 23;
            this.logStopButton.setLayoutData((Object)logStopButtonLData);
            this.logStopButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.logStopButton.setText(Messages.getString((String)"GDE_MSGT2864"));
            this.logStopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "logStopButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setLogStop(JLog2Configuration.this.logStopButton.getSelection() ? 1 : 0);
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.logStopButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "logStopButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2804"));
                }
            });
            this.extRpmButton = new Button((Composite)this.mainConfigGroup, 16416);
            RowData extRpmButtonLData = new RowData();
            extRpmButtonLData.width = 130;
            extRpmButtonLData.height = 23;
            this.extRpmButton.setLayoutData((Object)extRpmButtonLData);
            this.extRpmButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.extRpmButton.setText(Messages.getString((String)"GDE_MSGT2836"));
            this.extRpmButton.setEnabled(false);
            this.extRpmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "extRpmButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setLogStopExtRpmSensor(JLog2Configuration.this.extRpmButton.getSelection() ? 4 : 0);
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.extRpmButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "extRpmButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2805"));
                }
            });
            this.alarmGroup = new Group((Composite)this, 0);
            RowLayout alarmGroupLayout = new RowLayout(256);
            this.alarmGroup.setLayout((Layout)alarmGroupLayout);
            FormData alarmGroupLData = new FormData();
            alarmGroupLData.left = new FormAttachment(0, 1000, 5);
            alarmGroupLData.top = new FormAttachment(0, 1000, 305);
            alarmGroupLData.width = GDE.IS_LINUX ? 265 : 235;
            alarmGroupLData.height = 255;
            this.alarmGroup.setLayoutData((Object)alarmGroupLData);
            this.alarmGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 2 : 0)), (int)0));
            this.alarmGroup.setText(Messages.getString((String)"GDE_MSGT2866"));
            this.alarmsClearButton = new Button((Composite)this.alarmGroup, 0x1000008);
            RowData alarmsClearButtonLData = new RowData();
            alarmsClearButtonLData.width = 200;
            alarmsClearButtonLData.height = 25;
            this.alarmsClearButton.setLayoutData((Object)alarmsClearButtonLData);
            this.alarmsClearButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmsClearButton.setText(Messages.getString((String)"GDE_MSGT2867"));
            this.alarmsClearButton.setEnabled(false);
            this.alarmsClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "alarmsClearButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.clearAlarms();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.alarmsClearButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "alarmsClearButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2806"));
                }
            });
            this.uBecDipDetectLabel = new CLabel((Composite)this.alarmGroup, 0);
            RowData capacityAlarmLabelLData = new RowData();
            capacityAlarmLabelLData.width = 106;
            capacityAlarmLabelLData.height = 20;
            this.uBecDipDetectLabel.setLayoutData((Object)capacityAlarmLabelLData);
            this.uBecDipDetectLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.uBecDipDetectLabel.setText(Messages.getString((String)"GDE_MSGT2868"));
            this.uBecDipDetectButton = new Button((Composite)this.alarmGroup, 0x1000020);
            RowData uBecDipDetectButtonLData = new RowData();
            uBecDipDetectButtonLData.width = 106;
            uBecDipDetectButtonLData.height = 20;
            this.uBecDipDetectButton.setLayoutData((Object)uBecDipDetectButtonLData);
            this.uBecDipDetectButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.uBecDipDetectButton.setText("> 500 [mV]");
            this.uBecDipDetectButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "uBecDipDetectButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2807"));
                }
            });
            this.uBecDipDetectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "uBecDipDetectButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setBecDip(JLog2Configuration.this.uBecDipDetectButton.getSelection());
                    JLog2Configuration.this.checkNumberAlarms();
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.capacityAlarmLabel = new CLabel((Composite)this.alarmGroup, 0);
            capacityAlarmLabelLData = new RowData();
            capacityAlarmLabelLData.width = 106;
            capacityAlarmLabelLData.height = 20;
            this.capacityAlarmLabel.setLayoutData((Object)capacityAlarmLabelLData);
            this.capacityAlarmLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.capacityAlarmLabel.setText(Messages.getString((String)"GDE_MSGT2869"));
            this.capacityAlarmCombo = new CCombo((Composite)this.alarmGroup, 2048);
            RowData capacityAlarmComboLData = new RowData();
            capacityAlarmComboLData.width = GDE.IS_LINUX ? 77 : 57;
            capacityAlarmComboLData.height = 17;
            this.capacityAlarmCombo.setLayoutData((Object)capacityAlarmComboLData);
            this.capacityAlarmCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.capacityAlarmCombo.setItems(this.zeroTo25500);
            this.capacityAlarmCombo.setVisibleItemCount(10);
            this.capacityAlarmCombo.setEditable(false);
            this.capacityAlarmCombo.select(0);
            this.capacityAlarmCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "capacityAlarmCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setCapacityAlarm(Integer.parseInt(JLog2Configuration.this.capacityAlarmCombo.getText().trim()) / 100);
                    JLog2Configuration.this.checkNumberAlarms();
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.capacityAlarmCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "capacityAlarmCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2808"));
                }
            });
            this.mAhLabel = new CLabel((Composite)this.alarmGroup, 0);
            RowData mAhLabelLData = new RowData();
            mAhLabelLData.width = 41;
            mAhLabelLData.height = 20;
            this.mAhLabel.setLayoutData((Object)mAhLabelLData);
            this.mAhLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.mAhLabel.setText("[mAh]");
            this.uBatMinAlarmLabel = new CLabel((Composite)this.alarmGroup, 0);
            RowData uBatMinAlarmLabelLData = new RowData();
            uBatMinAlarmLabelLData.width = 106;
            uBatMinAlarmLabelLData.height = 20;
            this.uBatMinAlarmLabel.setLayoutData((Object)uBatMinAlarmLabelLData);
            this.uBatMinAlarmLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.uBatMinAlarmLabel.setText(Messages.getString((String)"GDE_MSGT2871"));
            this.voltageBatteryAlarmCombo = new CCombo((Composite)this.alarmGroup, 2048);
            RowData voltagebatteryMinCombo1LData = new RowData();
            voltagebatteryMinCombo1LData.width = GDE.IS_LINUX ? 45 : 35;
            voltagebatteryMinCombo1LData.height = 17;
            this.voltageBatteryAlarmCombo.setLayoutData((Object)voltagebatteryMinCombo1LData);
            this.voltageBatteryAlarmCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageBatteryAlarmCombo.setItems(this.zeroTo50);
            this.voltageBatteryAlarmCombo.setVisibleItemCount(10);
            this.voltageBatteryAlarmCombo.setEditable(false);
            this.voltageBatteryAlarmCombo.select(0);
            this.voltageBatteryAlarmCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "voltagebatteryMinCombo1.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2809"));
                }
            });
            this.voltageBatteryAlarmCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "voltagebatteryMinCombo1.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setBatteryAlarmMajor(JLog2Configuration.this.voltageBatteryAlarmCombo.getText().trim());
                    JLog2Configuration.this.checkNumberAlarms();
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.dotLabel = new CLabel((Composite)this.alarmGroup, 0);
            this.dotLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
            this.dotLabel.setText(".");
            RowData RALData = new RowData();
            RALData.width = 8;
            RALData.height = 20;
            this.dotLabel.setLayoutData((Object)RALData);
            this.voltageBatteryAlarmDecimalsCombo = new CCombo((Composite)this.alarmGroup, 2048);
            RowData voltagebatteryAlarmMaxCombo2LData = new RowData();
            voltagebatteryAlarmMaxCombo2LData.width = GDE.IS_LINUX ? 45 : 35;
            voltagebatteryAlarmMaxCombo2LData.height = 17;
            this.voltageBatteryAlarmDecimalsCombo.setLayoutData((Object)voltagebatteryAlarmMaxCombo2LData);
            this.voltageBatteryAlarmDecimalsCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageBatteryAlarmDecimalsCombo.setItems(this.zeroTo9);
            this.voltageBatteryAlarmDecimalsCombo.setVisibleItemCount(10);
            this.voltageBatteryAlarmDecimalsCombo.setEditable(false);
            this.voltageBatteryAlarmDecimalsCombo.select(0);
            this.voltageBatteryAlarmDecimalsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "voltagebatteryAlarmMaxCombo2.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setBatteryAlarmDecimals(JLog2Configuration.this.voltageBatteryAlarmDecimalsCombo.getText().trim());
                    JLog2Configuration.this.checkNumberAlarms();
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.voltageBatteryAlarmDecimalsCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "voltagebatteryAlarmMaxCombo2.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2810"));
                }
            });
            this.voltageLabel = new CLabel((Composite)this.alarmGroup, 0);
            RowData voltageLabelLData = new RowData();
            voltageLabelLData.width = 23;
            voltageLabelLData.height = 19;
            this.voltageLabel.setLayoutData((Object)voltageLabelLData);
            this.voltageLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageLabel.setText("[V]");
            this.fetTempMaxLabel = new CLabel((Composite)this.alarmGroup, 0);
            RowData paTempMaxLabelLData = new RowData();
            paTempMaxLabelLData.width = 106;
            paTempMaxLabelLData.height = 20;
            this.fetTempMaxLabel.setLayoutData((Object)paTempMaxLabelLData);
            this.fetTempMaxLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.fetTempMaxLabel.setText(Messages.getString((String)"GDE_MSGT2873"));
            this.fetTempMaxCombo = new CCombo((Composite)this.alarmGroup, 2048);
            RowData paTempMaxComboLData = new RowData();
            paTempMaxComboLData.width = GDE.IS_LINUX ? 55 : 45;
            paTempMaxComboLData.height = 17;
            this.fetTempMaxCombo.setLayoutData((Object)paTempMaxComboLData);
            this.fetTempMaxCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.fetTempMaxCombo.setItems(this.zeroTo127);
            this.fetTempMaxCombo.setVisibleItemCount(10);
            this.fetTempMaxCombo.setEditable(false);
            this.fetTempMaxCombo.select(0);
            this.fetTempMaxCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "paTempMaxCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2811"));
                }
            });
            this.fetTempMaxCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "paTempMaxCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setPaMaxTempAlarm(JLog2Configuration.this.fetTempMaxCombo.getText().trim());
                    JLog2Configuration.this.checkNumberAlarms();
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.temperaureLabel = new CLabel((Composite)this.alarmGroup, 0);
            RowData temperaureLabelLData = new RowData();
            temperaureLabelLData.width = 27;
            temperaureLabelLData.height = 19;
            this.temperaureLabel.setLayoutData((Object)temperaureLabelLData);
            this.temperaureLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.temperaureLabel.setText("[\u00b0C]");
            this.ext1Label = new CLabel((Composite)this.alarmGroup, 16416);
            RowData ext1LabelLData = new RowData();
            ext1LabelLData.width = 106;
            ext1LabelLData.height = 20;
            this.ext1Label.setLayoutData((Object)ext1LabelLData);
            this.ext1Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.ext1Label.setText(Messages.getString((String)"GDE_MSGT2874"));
            this.extern1Combo = new CCombo((Composite)this.alarmGroup, 2048);
            RowData extern1ComboLData = new RowData();
            extern1ComboLData.width = GDE.IS_LINUX ? 55 : 45;
            extern1ComboLData.height = 17;
            this.extern1Combo.setLayoutData((Object)extern1ComboLData);
            this.extern1Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.extern1Combo.setItems(this.zeroTo127);
            this.extern1Combo.setVisibleItemCount(10);
            this.extern1Combo.setEnabled(false);
            this.extern1Combo.setEditable(false);
            this.extern1Combo.select(0);
            this.extern1Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "extern1Combo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setExtTemp1(JLog2Configuration.this.extern1Combo.getText().trim());
                    if (JLog2Configuration.this.extern1Combo.getSelectionIndex() > 0) {
                        JLog2Configuration.this.configuration.setExtTemp1LowerThan(JLog2Configuration.this.ext1smallerButton.getSelection() ? 1 : 0);
                    } else {
                        JLog2Configuration.this.configuration.setExtTemp1LowerThan(0);
                    }
                    JLog2Configuration.this.checkNumberAlarms();
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.extern1Combo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "extern1Combo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2812"));
                }
            });
            this.temperaure1Label = new CLabel((Composite)this.alarmGroup, 0);
            this.temperaure1Label.setLayoutData((Object)new RowData(27, 19));
            this.temperaure1Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.temperaure1Label.setText("[\u00b0C]");
            this.ext1smallerButton = new Button((Composite)this.alarmGroup, 16416);
            RowData ext1smallerButtonLData = new RowData();
            ext1smallerButtonLData.width = GDE.IS_LINUX ? 45 : 32;
            ext1smallerButtonLData.height = 20;
            this.ext1smallerButton.setLayoutData((Object)ext1smallerButtonLData);
            this.ext1smallerButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.ext1smallerButton.setText(" <");
            this.ext1smallerButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.ext1smallerButton.setEnabled(false);
            this.ext1smallerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "ext1smallerButton.widgetSelected, event=" + String.valueOf(evt));
                    if (JLog2Configuration.this.extern1Combo.getSelectionIndex() > 0) {
                        JLog2Configuration.this.configuration.setExtTemp1LowerThan(JLog2Configuration.this.ext1smallerButton.getSelection() ? 1 : 0);
                    }
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.ext1smallerButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "ext1smallerButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2812"));
                }
            });
            this.ext2Label = new CLabel((Composite)this.alarmGroup, 16416);
            RowData ext2LabelLData = new RowData();
            ext2LabelLData.width = 106;
            ext2LabelLData.height = 20;
            this.ext2Label.setLayoutData((Object)ext2LabelLData);
            this.ext2Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.ext2Label.setText(Messages.getString((String)"GDE_MSGT2875"));
            this.extern2Combo = new CCombo((Composite)this.alarmGroup, 2048);
            RowData extern2ComboLData = new RowData();
            extern2ComboLData.width = GDE.IS_LINUX ? 55 : 45;
            extern2ComboLData.height = 17;
            this.extern2Combo.setLayoutData((Object)extern2ComboLData);
            this.extern2Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.extern2Combo.setItems(this.zeroTo127);
            this.extern2Combo.setVisibleItemCount(10);
            this.extern2Combo.setEnabled(false);
            this.extern2Combo.setEditable(false);
            this.extern2Combo.select(0);
            this.extern2Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "extern2Combo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setExtTemp2(JLog2Configuration.this.extern2Combo.getText().trim());
                    if (JLog2Configuration.this.extern2Combo.getSelectionIndex() > 0) {
                        JLog2Configuration.this.configuration.setExtTemp2LowerThan(JLog2Configuration.this.ext2smallerButton.getSelection() ? 1 : 0);
                    } else {
                        JLog2Configuration.this.configuration.setExtTemp2LowerThan(0);
                    }
                    JLog2Configuration.this.checkNumberAlarms();
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.extern2Combo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "extern2Combo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2812"));
                }
            });
            this.temperaureLabel = new CLabel((Composite)this.alarmGroup, 0);
            this.temperaureLabel.setLayoutData((Object)new RowData(27, 19));
            this.temperaureLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.temperaureLabel.setText("[\u00b0C]");
            this.ext2smallerButton = new Button((Composite)this.alarmGroup, 16416);
            RowData ext2smallerButtonLData = new RowData();
            ext2smallerButtonLData.width = GDE.IS_LINUX ? 45 : 32;
            ext2smallerButtonLData.height = 20;
            this.ext2smallerButton.setLayoutData((Object)ext2smallerButtonLData);
            this.ext2smallerButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.ext2smallerButton.setText(" <");
            this.ext2smallerButton.setEnabled(false);
            this.ext2smallerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "ext2smallerButton.widgetSelected, event=" + String.valueOf(evt));
                    if (JLog2Configuration.this.extern2Combo.getSelectionIndex() > 0) {
                        JLog2Configuration.this.configuration.setExtTemp2LowerThan(JLog2Configuration.this.ext2smallerButton.getSelection() ? 1 : 0);
                    }
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.ext2smallerButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "ext2smallerButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2812"));
                }
            });
            this.ext3Label = new CLabel((Composite)this.alarmGroup, 16416);
            RowData ext3LabelLData = new RowData();
            ext3LabelLData.width = 106;
            ext3LabelLData.height = 20;
            this.ext3Label.setLayoutData((Object)ext3LabelLData);
            this.ext3Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.ext3Label.setText(Messages.getString((String)"GDE_MSGT2876"));
            this.extern3Combo = new CCombo((Composite)this.alarmGroup, 2048);
            RowData extern3ComboLData = new RowData();
            extern3ComboLData.width = GDE.IS_LINUX ? 55 : 45;
            extern3ComboLData.height = 17;
            this.extern3Combo.setLayoutData((Object)extern3ComboLData);
            this.extern3Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.extern3Combo.setItems(this.zeroTo127);
            this.extern3Combo.setVisibleItemCount(10);
            this.extern3Combo.setEnabled(false);
            this.extern3Combo.setEditable(false);
            this.extern3Combo.select(0);
            this.extern3Combo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "extern3Combo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2812"));
                }
            });
            this.extern3Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "extern3Combo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setExtTemp3(JLog2Configuration.this.extern3Combo.getText().trim());
                    if (JLog2Configuration.this.extern3Combo.getSelectionIndex() > 0) {
                        JLog2Configuration.this.configuration.setExtTemp3LowerThan(JLog2Configuration.this.ext3smallerButton.getSelection() ? 1 : 0);
                    } else {
                        JLog2Configuration.this.configuration.setExtTemp3LowerThan(0);
                    }
                    JLog2Configuration.this.checkNumberAlarms();
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.temperaureLabel = new CLabel((Composite)this.alarmGroup, 0);
            this.temperaureLabel.setLayoutData((Object)new RowData(27, 19));
            this.temperaureLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.temperaureLabel.setText("[\u00b0C]");
            this.ext3smallerButton = new Button((Composite)this.alarmGroup, 16416);
            RowData ext3smallerButtonLData = new RowData();
            ext3smallerButtonLData.width = GDE.IS_LINUX ? 45 : 32;
            ext3smallerButtonLData.height = 20;
            this.ext3smallerButton.setLayoutData((Object)ext3smallerButtonLData);
            this.ext3smallerButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.ext3smallerButton.setText(" <");
            this.ext3smallerButton.setEnabled(false);
            this.ext3smallerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "ext3smallerButton.widgetSelected, event=" + String.valueOf(evt));
                    if (JLog2Configuration.this.extern3Combo.getSelectionIndex() > 0) {
                        JLog2Configuration.this.configuration.setExtTemp3LowerThan(JLog2Configuration.this.ext3smallerButton.getSelection() ? 1 : 0);
                    }
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.ext3smallerButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "ext3smallerButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2812"));
                }
            });
            this.ext4Label = new CLabel((Composite)this.alarmGroup, 16416);
            RowData ext4LabelLData = new RowData();
            ext4LabelLData.width = 106;
            ext4LabelLData.height = 20;
            this.ext4Label.setLayoutData((Object)ext4LabelLData);
            this.ext4Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.ext4Label.setText(Messages.getString((String)"GDE_MSGT2879"));
            this.extern4Combo = new CCombo((Composite)this.alarmGroup, 2048);
            RowData extern4ComboLData = new RowData();
            extern4ComboLData.width = GDE.IS_LINUX ? 55 : 45;
            extern4ComboLData.height = 17;
            this.extern4Combo.setLayoutData((Object)extern4ComboLData);
            this.extern4Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.extern4Combo.setItems(this.zeroTo127);
            this.extern4Combo.setVisibleItemCount(10);
            this.extern4Combo.setEnabled(false);
            this.extern4Combo.setEditable(false);
            this.extern4Combo.select(0);
            this.extern4Combo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "extern4Combo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2812"));
                }
            });
            this.extern4Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "extern4Combo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setExtTemp4(JLog2Configuration.this.extern4Combo.getText().trim());
                    if (JLog2Configuration.this.extern4Combo.getSelectionIndex() > 0) {
                        JLog2Configuration.this.configuration.setExtTemp4LowerThan(JLog2Configuration.this.ext4smallerButton.getSelection() ? 1 : 0);
                    } else {
                        JLog2Configuration.this.configuration.setExtTemp4LowerThan(0);
                    }
                    JLog2Configuration.this.checkNumberAlarms();
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.temperaureLabel = new CLabel((Composite)this.alarmGroup, 0);
            this.temperaureLabel.setLayoutData((Object)new RowData(27, 19));
            this.temperaureLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.temperaureLabel.setText("[\u00b0C]");
            this.ext4smallerButton = new Button((Composite)this.alarmGroup, 16416);
            RowData ext4smallerButtonLData = new RowData();
            ext4smallerButtonLData.width = GDE.IS_LINUX ? 45 : 32;
            ext4smallerButtonLData.height = 20;
            this.ext4smallerButton.setLayoutData((Object)ext4smallerButtonLData);
            this.ext4smallerButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.ext4smallerButton.setText(" <");
            this.ext4smallerButton.setEnabled(false);
            this.ext4smallerButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "ext4smallerButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2812"));
                }
            });
            this.ext4smallerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "ext4smallerButton.widgetSelected, event=" + String.valueOf(evt));
                    if (JLog2Configuration.this.extern4Combo.getSelectionIndex() > 0) {
                        JLog2Configuration.this.configuration.setExtTemp4LowerThan(JLog2Configuration.this.ext4smallerButton.getSelection() ? 1 : 0);
                    }
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.ext5Label = new CLabel((Composite)this.alarmGroup, 16416);
            RowData ext5LabelLData = new RowData();
            ext5LabelLData.width = 106;
            ext5LabelLData.height = 20;
            this.ext5Label.setLayoutData((Object)ext5LabelLData);
            this.ext5Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.ext5Label.setText(Messages.getString((String)"GDE_MSGT2880"));
            this.extern5Combo = new CCombo((Composite)this.alarmGroup, 2048);
            RowData extern5ComboLData = new RowData();
            extern5ComboLData.width = GDE.IS_LINUX ? 55 : 45;
            extern5ComboLData.height = 17;
            this.extern5Combo.setLayoutData((Object)extern5ComboLData);
            this.extern5Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.extern5Combo.setItems(this.zeroTo127);
            this.extern5Combo.setVisibleItemCount(10);
            this.extern5Combo.setEnabled(false);
            this.extern5Combo.setEditable(false);
            this.extern5Combo.select(0);
            this.extern5Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "extern5Combo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setExtTemp5(JLog2Configuration.this.extern5Combo.getText().trim());
                    if (JLog2Configuration.this.extern5Combo.getSelectionIndex() > 0) {
                        JLog2Configuration.this.configuration.setExtTemp5LowerThan(JLog2Configuration.this.ext5smallerButton.getSelection() ? 1 : 0);
                    } else {
                        JLog2Configuration.this.configuration.setExtTemp5LowerThan(0);
                    }
                    JLog2Configuration.this.checkNumberAlarms();
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.extern5Combo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "extern5Combo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2812"));
                }
            });
            this.temperaureLabel = new CLabel((Composite)this.alarmGroup, 0);
            this.temperaureLabel.setLayoutData((Object)new RowData(27, 19));
            this.temperaureLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.temperaureLabel.setText("[\u00b0C]");
            this.ext5smallerButton = new Button((Composite)this.alarmGroup, 16416);
            RowData ext5smallerButtonLData = new RowData();
            ext5smallerButtonLData.width = GDE.IS_LINUX ? 45 : 32;
            ext5smallerButtonLData.height = 20;
            this.ext5smallerButton.setLayoutData((Object)ext5smallerButtonLData);
            this.ext5smallerButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.ext5smallerButton.setText(" <");
            this.ext5smallerButton.setEnabled(false);
            this.ext5smallerButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "ext5smallerButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2812"));
                }
            });
            this.ext5smallerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "ext5smallerButton.widgetSelected, event=" + String.valueOf(evt));
                    if (JLog2Configuration.this.extern5Combo.getSelectionIndex() > 0) {
                        JLog2Configuration.this.configuration.setExtTemp5LowerThan(JLog2Configuration.this.ext5smallerButton.getSelection() ? 1 : 0);
                    }
                    JLog2Configuration.this.checkClearButtonState();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.optionalGroup = new Group((Composite)this, 0);
            RowLayout optionalGroupLayout = new RowLayout(256);
            this.optionalGroup.setLayout((Layout)optionalGroupLayout);
            FormData optionalGroupLData = new FormData();
            optionalGroupLData.top = new FormAttachment(0, 1000, 305);
            optionalGroupLData.right = new FormAttachment(1000, 1000, -7);
            optionalGroupLData.width = GDE.IS_LINUX ? 440 : 400;
            optionalGroupLData.height = 255;
            this.optionalGroup.setLayoutData((Object)optionalGroupLData);
            this.optionalGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 2 : 0)), (int)0));
            this.optionalGroup.setText(Messages.getString((String)"GDE_MSGT2881"));
            this.alarmLinesLabel = new CLabel((Composite)this.optionalGroup, 0x1000000);
            RowData alarmLinesButtonLData = new RowData();
            alarmLinesButtonLData.width = 115;
            alarmLinesButtonLData.height = 20;
            this.alarmLinesLabel.setLayoutData((Object)alarmLinesButtonLData);
            this.alarmLinesLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmLinesLabel.setText(Messages.getString((String)"GDE_MSGT2882"));
            this.alarmLinesCombo = new CCombo((Composite)this.optionalGroup, 2048);
            RowData alarmLinesComboLData = new RowData();
            alarmLinesComboLData.width = GDE.IS_LINUX ? 45 : 32;
            alarmLinesComboLData.height = 17;
            this.alarmLinesCombo.setLayoutData((Object)alarmLinesComboLData);
            this.alarmLinesCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.alarmLinesCombo.setItems(this.zeroAlarms);
            this.alarmLinesCombo.setEditable(false);
            this.alarmLinesCombo.select(0);
            this.alarmLinesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "alarmLinesCombo.widgetSelected, event=" + String.valueOf(evt));
                    if (JLog2Configuration.this.alarmLinesCombo.getSelectionIndex() >= 1) {
                        JLog2Configuration.this.alarmLinesLabel.setForeground(DataExplorer.getInstance().COLOR_RED);
                    } else {
                        JLog2Configuration.this.alarmLinesLabel.setForeground(DataExplorer.getInstance().COLOR_BLACK);
                    }
                    JLog2Configuration.this.checkAdapterRequired();
                    JLog2Configuration.this.configuration.setNumberAlarmLines(JLog2Configuration.this.alarmLinesCombo.getSelectionIndex());
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.alarmLinesCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "alarmLinesCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2813"));
                }
            });
            this.line1signalTypeLabel = new CLabel((Composite)this.optionalGroup, 131072);
            RowData Line1signalLabelLData = new RowData();
            Line1signalLabelLData.width = 128;
            Line1signalLabelLData.height = 20;
            this.line1signalTypeLabel.setLayoutData((Object)Line1signalLabelLData);
            this.line1signalTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.line1signalTypeLabel.setText(Messages.getString((String)"GDE_MSGT2883"));
            this.line1signalTypeCombo = new CCombo((Composite)this.optionalGroup, 2048);
            RowData line1signalComboLData = new RowData();
            line1signalComboLData.width = GDE.IS_LINUX ? 85 : 75;
            line1signalComboLData.height = 17;
            this.line1signalTypeCombo.setLayoutData((Object)line1signalComboLData);
            this.line1signalTypeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.line1signalTypeCombo.setItems(new String[]{"switched", "flash", "interval", "Morse"});
            this.line1signalTypeCombo.setEditable(false);
            this.line1signalTypeCombo.select(0);
            this.line1signalTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "line1signalCombo.widgetSelected, event=" + String.valueOf(evt));
                    switch (JLog2Configuration.this.line1signalTypeCombo.getSelectionIndex()) {
                        case 0: {
                            JLog2Configuration.this.configuration.setLine1signalType(0);
                            break;
                        }
                        case 1: {
                            JLog2Configuration.this.configuration.setLine1signalType(64);
                            break;
                        }
                        case 2: {
                            JLog2Configuration.this.configuration.setLine1signalType(32);
                            break;
                        }
                        case 3: {
                            JLog2Configuration.this.configuration.setLine1signalType(128);
                        }
                    }
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.line1signalTypeCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "line1signalCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2814"));
                }
            });
            this.subDevicesLabel = new CLabel((Composite)this.optionalGroup, 0x1000000);
            RowData subDevicesButtonLData = new RowData();
            subDevicesButtonLData.width = 115;
            subDevicesButtonLData.height = 20;
            this.subDevicesLabel.setLayoutData((Object)subDevicesButtonLData);
            this.subDevicesLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.subDevicesLabel.setText(Messages.getString((String)"GDE_MSGT2884"));
            this.subDevicesLabel.setEnabled(false);
            this.subDevicesCombo = new CCombo((Composite)this.optionalGroup, 2048);
            this.subDevicesCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.subDevicesCombo.setText(Messages.getString((String)"GDE_MSGT2885"));
            this.subDevicesCombo.setEditable(false);
            RowData subDevicesComboLData = new RowData();
            subDevicesComboLData.width = GDE.IS_LINUX ? 75 : 65;
            subDevicesComboLData.height = 17;
            this.subDevicesCombo.setLayoutData((Object)subDevicesComboLData);
            this.subDevicesCombo.setEnabled(false);
            this.tempSensorTypeLabel = new CLabel((Composite)this.optionalGroup, 131072);
            RowData tempSensorTypeButtonLData = new RowData();
            tempSensorTypeButtonLData.width = 95;
            tempSensorTypeButtonLData.height = 20;
            this.tempSensorTypeLabel.setLayoutData((Object)tempSensorTypeButtonLData);
            this.tempSensorTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.tempSensorTypeLabel.setText(Messages.getString((String)"GDE_MSGT2886"));
            this.tempSensorTypeCombo = new CCombo((Composite)this.optionalGroup, 2048);
            RowData tempSensorTypeComboLData = new RowData();
            tempSensorTypeComboLData.width = GDE.IS_LINUX ? 85 : 75;
            tempSensorTypeComboLData.height = 17;
            this.tempSensorTypeCombo.setLayoutData((Object)tempSensorTypeComboLData);
            this.tempSensorTypeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.tempSensorTypeCombo.setItems(new String[]{" --- ", "analog", "digital"});
            this.tempSensorTypeCombo.setEditable(false);
            this.tempSensorTypeCombo.select(0);
            this.tempSensorTypeCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "tempSensorTypeCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2815"));
                }
            });
            this.tempSensorTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "tempSensorTypeCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.setTemperaturSensorType(JLog2Configuration.this.tempSensorTypeCombo.getSelectionIndex());
                    JLog2Configuration.this.configuration.setTemperaturSensorType(JLog2Configuration.this.tempSensorTypeCombo.getSelectionIndex());
                    JLog2Configuration.this.checkNumberAlarms();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.rpmSensorLabel = new CLabel((Composite)this.optionalGroup, 0x1000000);
            RowData rpmSensorButtonLData = new RowData();
            rpmSensorButtonLData.width = 115;
            rpmSensorButtonLData.height = 20;
            this.rpmSensorLabel.setLayoutData((Object)rpmSensorButtonLData);
            this.rpmSensorLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.rpmSensorLabel.setText(Messages.getString((String)"GDE_MSGT2887"));
            this.pulsPerRevolutionSensorCombo = new CCombo((Composite)this.optionalGroup, 2048);
            RowData rpmSensorComboLData = new RowData();
            rpmSensorComboLData.width = GDE.IS_LINUX ? 75 : 65;
            rpmSensorComboLData.height = 17;
            this.pulsPerRevolutionSensorCombo.setLayoutData((Object)rpmSensorComboLData);
            this.pulsPerRevolutionSensorCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.pulsPerRevolutionSensorCombo.setItems(this.zeroTo127);
            this.pulsPerRevolutionSensorCombo.setEditable(false);
            this.pulsPerRevolutionSensorCombo.select(0);
            this.pulsPerRevolutionSensorCombo.setVisibleItemCount(10);
            this.pulsPerRevolutionSensorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "rpmSensorCombo.widgetSelected, event=" + String.valueOf(evt));
                    if (JLog2Configuration.this.brushLessButton.getSelection()) {
                        JLog2Configuration.this.configuration.setIsBrushlessMotor(true, JLog2Configuration.this.pulsPerRevolutionSensorCombo.getSelectionIndex() * 2 + 2);
                    } else {
                        JLog2Configuration.this.configuration.setPulsePerRevolution(JLog2Configuration.this.pulsPerRevolutionSensorCombo.getSelectionIndex());
                    }
                    if (JLog2Configuration.this.pulsPerRevolutionSensorCombo.getSelectionIndex() < 1 && !JLog2Configuration.this.brushLessButton.getSelection()) {
                        JLog2Configuration.this.motorButton.setSelection(false);
                        JLog2Configuration.this.configuration.setIsMotor(false);
                        JLog2Configuration.this.motorButton.setEnabled(false);
                        JLog2Configuration.this.extRpmButton.setEnabled(false);
                    } else if (JLog2Configuration.this.motorButton.getSelection() && Integer.parseInt(JLog2Configuration.this.pulsPerRevolutionSensorCombo.getText().trim()) >= 2) {
                        JLog2Configuration.this.brushLessButton.setEnabled(true);
                    } else {
                        JLog2Configuration.this.motorButton.setEnabled(true);
                        JLog2Configuration.this.extRpmButton.setEnabled(true);
                    }
                    JLog2Configuration.this.checkAdapterRequired();
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.pulsPerRevolutionSensorCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "rpmSensorCombo.mouseMove, event=" + String.valueOf(evt));
                    if (JLog2Configuration.this.brushLessButton.getSelection()) {
                        JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2816"));
                    } else {
                        JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2817"));
                    }
                }
            });
            new Label((Composite)this.optionalGroup, 0).setLayoutData((Object)new RowData(9, 19));
            this.motorButton = new Button((Composite)this.optionalGroup, 0x1000020);
            RowData motorButtonLData = new RowData();
            motorButtonLData.width = 80;
            motorButtonLData.height = 20;
            this.motorButton.setLayoutData((Object)motorButtonLData);
            this.motorButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.motorButton.setText(Messages.getString((String)"GDE_MSGT2888"));
            this.motorButton.setEnabled(false);
            this.motorButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "motorButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2818"));
                }
            });
            this.motorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "motorButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setIsMotor(JLog2Configuration.this.motorButton.getSelection());
                    if (JLog2Configuration.this.motorButton.getSelection() && Integer.parseInt(JLog2Configuration.this.pulsPerRevolutionSensorCombo.getText().trim()) >= 2) {
                        JLog2Configuration.this.brushLessButton.setEnabled(true);
                    } else {
                        JLog2Configuration.this.brushLessButton.setEnabled(false);
                    }
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.brushLessButton = new Button((Composite)this.optionalGroup, 0x1000020);
            RowData brushLessButtonLData = new RowData();
            brushLessButtonLData.width = 100;
            brushLessButtonLData.height = 20;
            this.brushLessButton.setLayoutData((Object)brushLessButtonLData);
            this.brushLessButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.brushLessButton.setText(Messages.getString((String)"GDE_MSGT2889"));
            this.brushLessButton.setEnabled(false);
            this.brushLessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "brushLessButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setIsBrushlessMotor(JLog2Configuration.this.brushLessButton.getSelection(), JLog2Configuration.this.motorPolsCombo.getSelectionIndex() * 2 + 2);
                    if (JLog2Configuration.this.brushLessButton.getSelection()) {
                        JLog2Configuration.this.pulsPerRevolutionSensorCombo.setItems(JLog2Configuration.this.motorPols);
                        JLog2Configuration.this.pulsPerRevolutionSensorCombo.select(JLog2Configuration.this.motorPolsCombo.getSelectionIndex());
                        JLog2Configuration.this.rpmSensorLabel.setText(Messages.getString((String)"GDE_MSGT2890"));
                        JLog2Configuration.this.rpmSensorLabel.setForeground(DataExplorer.getInstance().COLOR_RED);
                        JLog2Configuration.this.configuration.setPulsePerRevolution(1);
                    } else {
                        JLog2Configuration.this.pulsPerRevolutionSensorCombo.setItems(JLog2Configuration.this.zeroTo127);
                        JLog2Configuration.this.pulsPerRevolutionSensorCombo.select(1);
                        JLog2Configuration.this.rpmSensorLabel.setText(Messages.getString((String)"GDE_MSGT2891"));
                        JLog2Configuration.this.rpmSensorLabel.setForeground(DataExplorer.getInstance().COLOR_BLACK);
                        JLog2Configuration.this.configuration.setPulsePerRevolution(1);
                    }
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.brushLessButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "brushLessButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2819"));
                }
            });
            this.telemetryLabel = new CLabel((Composite)this.optionalGroup, 0x1000000);
            RowData telemetryButtonLData = new RowData();
            telemetryButtonLData.width = 115;
            telemetryButtonLData.height = 20;
            this.telemetryLabel.setLayoutData((Object)telemetryButtonLData);
            this.telemetryLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.telemetryLabel.setText(Messages.getString((String)"GDE_MSGT2892"));
            this.telemetryCombo = new CCombo((Composite)this.optionalGroup, 2048);
            RowData telemetryComboLData = new RowData();
            telemetryComboLData.width = GDE.IS_LINUX ? 123 : 113;
            telemetryComboLData.height = 17;
            this.telemetryCombo.setLayoutData((Object)telemetryComboLData);
            this.telemetryCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.telemetryCombo.setItems(this.comOutputString.split(","));
            this.telemetryCombo.setEditable(false);
            this.telemetryCombo.select(0);
            this.telemetryCombo.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "telemetryCombo.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2820"));
                }
            });
            this.telemetryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "telemetryCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.application.openMessageDialogAsync(JLog2Configuration.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGI2820"));
                    JLog2Configuration.this.enableMpxAddressSelection(false);
                    JLog2Configuration.this.configuration.setTelemetryType(JLog2Configuration.this.telemetryCombo.getSelectionIndex());
                    switch (JLog2Configuration.this.telemetryCombo.getSelectionIndex()) {
                        case 0: {
                            JLog2Configuration.this.configuration.setTelemetryBaudrateType(0);
                            break;
                        }
                        case 1: {
                            JLog2Configuration.this.configuration.setTelemetryBaudrateType(4);
                            break;
                        }
                        case 3: {
                            if (!JLog2Configuration.this.telemetryCombo.getText().contains("MPX")) break;
                            JLog2Configuration.this.enableMpxAddressSelection(true);
                        }
                    }
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.sensorAdapterButton = new Button((Composite)this.optionalGroup, 0x1000008);
            RowData sensorAdapterButtonLData = new RowData();
            sensorAdapterButtonLData.width = 145;
            sensorAdapterButtonLData.height = 26;
            this.sensorAdapterButton.setLayoutData((Object)sensorAdapterButtonLData);
            this.sensorAdapterButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.sensorAdapterButton.setText(Messages.getString((String)"GDE_MSGT2893"));
            this.sensorAdapterButton.setEnabled(false);
            this.sensorAdapterButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "sensorAdapterButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2821"));
                }
            });
            this.sensorAdapterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "sensorAdapterButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.application.openHelpDialog(JLog2Configuration.this.device.getName(), "HelpInfo.html", true);
                }
            });
            this.optionalStuff = new Composite((Composite)this.optionalGroup, 0);
            RowLayout optionalStuffLayout = new RowLayout(256);
            this.optionalStuff.setLayout((Layout)optionalStuffLayout);
            this.optionalStuff.setLayoutData((Object)new RowData(385, 25));
            this.hv2BecLabel = new CLabel(this.optionalStuff, 131072);
            RowData hv2BecLabelLData = new RowData();
            hv2BecLabelLData.width = 75;
            hv2BecLabelLData.height = 20;
            this.hv2BecLabel.setLayoutData((Object)hv2BecLabelLData);
            this.hv2BecLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.hv2BecLabel.setText("HV\u00b2BEC [V]");
            this.hv2BecCombo = new CCombo(this.optionalStuff, 2048);
            this.hv2BecCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.hv2BecCombo.setItems(new String[]{"6.0", "6.5", "7.0", "7.5", "8.0", "8.5"});
            this.hv2BecCombo.setLayoutData((Object)new RowData(GDE.IS_LINUX ? 70 : 60, 17));
            this.hv2BecCombo.setVisible(false);
            this.hv2BecCombo.setEditable(false);
            this.hv2BecCombo.select(0);
            this.hv2BecCombo.addMouseWheelListener(new MouseWheelListener(){

                public void mouseScrolled(MouseEvent evt) {
                    log.log(Level.FINEST, "hv2BecCombo.mouseScrolled, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2822"));
                }
            });
            this.hv2BecCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "hv2BecCombo.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setHV2BecVoltage(JLog2Configuration.this.hv2BecCombo.getSelectionIndex());
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
            this.speedSensorLabel = new CLabel(this.optionalStuff, 131072);
            RowData speedSensorLabelLData = new RowData();
            speedSensorLabelLData.width = 140;
            speedSensorLabelLData.height = 20;
            this.speedSensorLabel.setLayoutData((Object)speedSensorLabelLData);
            this.speedSensorLabel.setText(Messages.getString((String)"GDE_MSGT2895"));
            this.speedSensorLabel.setVisible(false);
            this.speedSensorButton = new Button(this.optionalStuff, 16416);
            RowData speedSensorButtonLData = new RowData();
            speedSensorButtonLData.width = 90;
            speedSensorButtonLData.height = 20;
            this.speedSensorButton.setLayoutData((Object)speedSensorButtonLData);
            this.speedSensorButton.setText(Messages.getString((String)"GDE_MSGT2896"));
            this.speedSensorButton.setVisible(false);
            this.speedSensorButton.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent evt) {
                    log.log(Level.FINEST, "speedSensorButton.mouseMove, event=" + String.valueOf(evt));
                    JLog2Configuration.this.mainExplanationText.setText(Messages.getString((String)"GDE_MSGI2823"));
                }
            });
            this.speedSensorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "speedSensorButton.widgetSelected, event=" + String.valueOf(evt));
                    JLog2Configuration.this.configuration.setHV2BecVoltage(JLog2Configuration.this.speedSensorButton.getSelection() ? 1 : 0);
                }
            });
            this.mpxAddessesLabel = new CLabel((Composite)this.optionalGroup, 0x1000000);
            RowData mpxAddessesLabelLData = new RowData();
            mpxAddessesLabelLData.width = 384;
            mpxAddessesLabelLData.height = 17;
            this.mpxAddessesLabel.setLayoutData((Object)mpxAddessesLabelLData);
            this.mpxAddessesLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.mpxAddessesLabel.setText(Messages.getString((String)"GDE_MSGT2897"));
            this.mpxAddresses[0] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGT2898"), this.configuration, 0);
            this.mpxAddresses[1] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGT2899"), this.configuration, 1);
            this.mpxAddresses[2] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2860"), this.configuration, 2);
            this.mpxAddresses[3] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2861"), this.configuration, 3);
            this.mpxAddresses[4] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2862"), this.configuration, 4);
            this.mpxAddresses[5] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2863"), this.configuration, 5);
            this.mpxAddresses[6] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2864"), this.configuration, 6);
            this.mpxAddresses[7] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2865"), this.configuration, 7);
            this.mpxAddresses[8] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2866"), this.configuration, 8);
            this.mpxAddresses[9] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2867"), this.configuration, 9);
            this.mpxAddresses[10] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2868"), this.configuration, 10);
            this.mpxAddresses[11] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2869"), this.configuration, 11);
            this.mpxAddresses[12] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2870"), this.configuration, 12);
            this.mpxAddresses[13] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2871"), this.configuration, 13);
            this.mpxAddresses[14] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2872"), this.configuration, 14);
            this.mpxAddresses[15] = new MpxAddressComposite((Composite)this.optionalGroup, 0, Messages.getString((String)"GDE_MSGI2873"), this.configuration, 15);
            this.layout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initialyzeGUI(Configuration config, boolean isInitialLoad) {
        if (isInitialLoad) {
            this.setBaudrate(config.get(0));
            this.sysModeCombo.select(config.get(1) & 1);
            this.setMotorShuntCalibration(config.get(1));
            this.motorPolsCombo.select(config.get(3) > 0 ? config.get(3) / 2 - 1 : 0);
            this.setGearRatio(config);
            this.resetButton.setSelection(config.get(11) == 1);
            this.logStopButton.setSelection((config.get(10) & 1) == 1);
            this.highPulsWidthButton.setSelection((config.get(10) & 2) == 2);
            this.extRpmButton.setSelection((config.get(10) & 4) == 4);
            this.uBecDipDetectButton.setSelection((config.get(16) & 1) == 1);
            this.capacityAlarmCombo.select(config.get(12));
            this.voltageBatteryAlarmCombo.select(config.get(13));
            this.voltageBatteryAlarmDecimalsCombo.select(config.get(14));
            this.fetTempMaxCombo.select(config.get(15));
        }
        this.extern1Combo.select(config.get(17));
        this.extern2Combo.select(config.get(18));
        this.extern3Combo.select(config.get(19));
        this.extern4Combo.select(config.get(20));
        this.extern5Combo.select(config.get(21));
        this.ext1smallerButton.setSelection((config.get(22) & 1) != 0);
        this.ext2smallerButton.setSelection((config.get(22) & 2) != 0);
        this.ext3smallerButton.setSelection((config.get(22) & 4) != 0);
        this.ext4smallerButton.setSelection((config.get(22) & 8) != 0);
        this.ext5smallerButton.setSelection((config.get(22) & 0x10) != 0);
        this.alarmLinesCombo.select(config.get(23));
        if (config.get(23) > 0) {
            this.alarmLinesLabel.setForeground(this.application.COLOR_RED);
        }
        this.setLine1SignalType(config.get(46));
        this.setTemperaturSensorType(config.get(24));
        this.telemetryCombo.select(config.get(26) <= 3 ? config.get(26) + 1 : 0);
        this.pulsPerRevolutionSensorCombo.select(config.get(27));
        if (this.pulsPerRevolutionSensorCombo.getSelectionIndex() > 0) {
            this.extRpmButton.setEnabled(true);
        }
        this.setPulsPerRevolutionSensor(config.get(28));
        this.setIsMotorButton((config.get(29) & 4) > 0 && config.get(28) > 0);
        this.extRpmButton.setEnabled((config.get(29) & 4) > 0 && config.get(28) > 0);
        this.setIsBrushlessMotor((config.get(29) & 0x80) > 0 && (config.get(29) & 4) > 0 && config.get(28) > 0);
        this.mpxAddresses[0].mpxAddressCombo.select(config.get(30));
        this.mpxAddresses[1].mpxAddressCombo.select(config.get(31));
        this.mpxAddresses[2].mpxAddressCombo.select(config.get(32));
        this.mpxAddresses[3].mpxAddressCombo.select(config.get(33));
        this.mpxAddresses[4].mpxAddressCombo.select(config.get(34));
        this.mpxAddresses[5].mpxAddressCombo.select(config.get(35));
        this.mpxAddresses[6].mpxAddressCombo.select(config.get(36));
        this.mpxAddresses[7].mpxAddressCombo.select(config.get(37));
        this.mpxAddresses[8].mpxAddressCombo.select(config.get(38));
        this.mpxAddresses[9].mpxAddressCombo.select(config.get(39));
        this.mpxAddresses[10].mpxAddressCombo.select(config.get(40));
        this.mpxAddresses[11].mpxAddressCombo.select(config.get(41));
        this.mpxAddresses[12].mpxAddressCombo.select(config.get(42));
        this.mpxAddresses[13].mpxAddressCombo.select(config.get(43));
        this.mpxAddresses[14].mpxAddressCombo.select(config.get(44));
        this.mpxAddresses[15].mpxAddressCombo.select(config.get(45));
        this.enableMpxAddressSelection(false);
        if (isInitialLoad) {
            this.setLogMode(config.get(2));
        }
        try {
            this.updateSubDevices(config.get(47));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkClearButtonState();
    }

    private void setIsBrushlessMotor(boolean isBrushless) {
        this.brushLessButton.setSelection(isBrushless);
        if (isBrushless) {
            this.pulsPerRevolutionSensorCombo.setItems(this.motorPols);
            this.pulsPerRevolutionSensorCombo.select(this.motorPolsCombo.getSelectionIndex());
            this.rpmSensorLabel.setText(Messages.getString((String)"GDE_MSGI2874"));
            this.rpmSensorLabel.setForeground(this.application.COLOR_RED);
        } else {
            int selectionIndex = this.pulsPerRevolutionSensorCombo.getSelectionIndex();
            this.pulsPerRevolutionSensorCombo.setItems(this.zeroTo127);
            if (selectionIndex > 0) {
                this.pulsPerRevolutionSensorCombo.select(1);
            } else {
                this.pulsPerRevolutionSensorCombo.select(0);
            }
            this.rpmSensorLabel.setText(Messages.getString((String)"GDE_MSGI2875"));
            this.rpmSensorLabel.setForeground(this.application.COLOR_BLACK);
        }
    }

    private void setIsMotorButton(boolean isMotor) {
        this.motorButton.setSelection(isMotor);
        if (isMotor) {
            this.brushLessButton.setEnabled(true);
        } else {
            this.brushLessButton.setEnabled(false);
        }
    }

    private void setPulsPerRevolutionSensor(int value) {
        this.pulsPerRevolutionSensorCombo.select(value);
        if (this.pulsPerRevolutionSensorCombo.getSelectionIndex() < 1) {
            this.motorButton.setEnabled(false);
        } else {
            this.motorButton.setEnabled(true);
        }
    }

    private void setTemperaturSensorType(int value) {
        this.tempSensorTypeCombo.select(value);
        switch (value) {
            case 1: {
                this.enableExternTempeartureAll(false);
                this.enableExternTempearture1(true);
                break;
            }
            case 2: {
                this.enableExternTempeartureAll(true);
                this.tempSensorTypeLabel.setForeground(this.application.COLOR_RED);
                break;
            }
            default: {
                this.enableExternTempeartureAll(false);
                this.tempSensorTypeLabel.setForeground(this.application.COLOR_BLACK);
            }
        }
    }

    private void setLine1SignalType(int value) {
        switch (value & 0xE0) {
            default: {
                this.line1signalTypeCombo.select(0);
                break;
            }
            case 32: {
                this.line1signalTypeCombo.select(1);
                break;
            }
            case 64: {
                this.line1signalTypeCombo.select(2);
                break;
            }
            case 128: {
                this.line1signalTypeCombo.select(3);
            }
        }
    }

    private void setGearRatio(Configuration config) {
        if (config.get(4) == 1) {
            this.directRatioButton.setSelection(false);
            this.directGearRatioMajorCombo.setEnabled(false);
            this.directGearRatioDecimalsCombo.setEnabled(false);
            this.gearSelectionButton.setSelection(true);
            this.gearPinionWheelCombo.setEnabled(true);
            this.gearMainWheelCombo.setEnabled(true);
            this.gearMainWheelDecimalsCombo.setEnabled(true);
        } else {
            this.directRatioButton.setSelection(true);
            this.directGearRatioMajorCombo.setEnabled(true);
            this.directGearRatioDecimalsCombo.setEnabled(true);
            this.gearSelectionButton.setSelection(false);
            this.gearPinionWheelCombo.setEnabled(false);
            this.gearMainWheelCombo.setEnabled(false);
            this.gearMainWheelDecimalsCombo.setEnabled(false);
        }
        this.directGearRatioMajorCombo.select(config.get(5) - 1);
        this.directGearRatioDecimalsCombo.select(config.get(6) > 0 ? config.get(6) : 0);
        this.gearPinionWheelCombo.select(config.get(7) - 8);
        this.gearMainWheelCombo.select(config.get(8) - 8);
        this.gearMainWheelDecimalsCombo.select(config.get(9) > 0 ? config.get(9) : 0);
    }

    private void setMotorShuntCalibration(int value) {
        if ((value & 0x80) == 0) {
            this.motorShuntCombo.select((value & 0x7E) / 2 + 60);
        } else {
            this.motorShuntCombo.select(60 - (value & 0x7E) / 2);
        }
    }

    private void setLogMode(int value) {
        switch (value & 0xB) {
            default: {
                this.logModeCombo.select(0);
                break;
            }
            case 2: {
                this.logModeCombo.select(1);
                this.enableAll(false);
                break;
            }
            case 8: {
                this.logModeCombo.select(2);
            }
        }
    }

    private void enableAll(boolean isEnabled) {
        this.directRatioButton.setEnabled(isEnabled);
        this.logStopButton.setEnabled(isEnabled);
        this.highPulsWidthButton.setEnabled(isEnabled);
        this.gearSelectionButton.setEnabled(isEnabled);
        this.motorPolsCombo.setEnabled(isEnabled);
        this.directGearRatioMajorCombo.setEnabled(isEnabled);
        this.directGearRatioDecimalsCombo.setEnabled(isEnabled);
        this.alarmsClearButton.setEnabled(isEnabled);
        this.uBecDipDetectButton.setEnabled(isEnabled);
        this.fetTempMaxCombo.setEnabled(isEnabled);
        this.voltageBatteryAlarmDecimalsCombo.setEnabled(isEnabled);
        this.voltageBatteryAlarmCombo.setEnabled(isEnabled);
        this.capacityAlarmCombo.setEnabled(isEnabled);
        if (!isEnabled) {
            this.extRpmButton.setEnabled(false);
            this.enableExternTempeartureAll(false);
            this.enableMpxAddressSelection(false);
        }
        this.sensorAdapterButton.setEnabled(isEnabled);
        this.motorButton.setEnabled(isEnabled);
        this.brushLessButton.setEnabled(isEnabled);
        this.alarmLinesCombo.setEnabled(isEnabled);
        this.telemetryCombo.setEnabled(isEnabled);
        this.pulsPerRevolutionSensorCombo.setEnabled(isEnabled);
        this.tempSensorTypeCombo.setEnabled(isEnabled);
        this.subDevicesCombo.setEnabled(isEnabled);
        this.line1signalTypeCombo.setEnabled(isEnabled);
    }

    private void setBaudrate(int value) {
        switch (value) {
            case 2400: {
                this.baudrateCombo.select(1);
                break;
            }
            case 4800: {
                this.baudrateCombo.select(2);
                break;
            }
            case 9600: {
                this.baudrateCombo.select(0);
                break;
            }
            case 38400: {
                this.baudrateCombo.select(4);
                break;
            }
            case 57600: {
                this.baudrateCombo.select(5);
                break;
            }
            case 115200: {
                this.baudrateCombo.select(6);
            }
        }
    }

    private void checkNumberAlarms() {
        boolean isTemperatureSensorType;
        int numAlarms = 0;
        boolean bl = isTemperatureSensorType = this.tempSensorTypeCombo.getSelectionIndex() > 0;
        if (this.extern1Combo.getSelectionIndex() > 0) {
            ++numAlarms;
        }
        if (this.ext1smallerButton.getSelection()) {
            ++numAlarms;
        }
        if (this.extern2Combo.getSelectionIndex() > 0) {
            ++numAlarms;
        }
        if (this.ext2smallerButton.getSelection()) {
            ++numAlarms;
        }
        if (this.extern3Combo.getSelectionIndex() > 0) {
            ++numAlarms;
        }
        if (this.ext3smallerButton.getSelection()) {
            ++numAlarms;
        }
        if (this.extern4Combo.getSelectionIndex() > 0) {
            ++numAlarms;
        }
        if (this.ext4smallerButton.getSelection()) {
            ++numAlarms;
        }
        if (this.extern5Combo.getSelectionIndex() > 0) {
            ++numAlarms;
        }
        if (this.ext5smallerButton.getSelection()) {
            ++numAlarms;
        }
        int selectionIndex = this.alarmLinesCombo.getSelectionIndex();
        if (numAlarms == 1) {
            this.alarmLinesCombo.setItems(this.oneAlarms);
            if (selectionIndex > 1) {
                selectionIndex = 1;
                this.configuration.setNumberAlarmLines(1);
            }
            this.alarmLinesCombo.select(selectionIndex);
        } else if (isTemperatureSensorType && numAlarms > 1) {
            this.alarmLinesCombo.setItems(this.oneAlarms);
            if (selectionIndex > 1) {
                selectionIndex = 1;
                this.configuration.setNumberAlarmLines(1);
            }
            this.alarmLinesCombo.select(selectionIndex);
        } else if (numAlarms > 1) {
            this.alarmLinesCombo.setItems(this.greaterOneAlarms);
            this.alarmLinesCombo.select(2);
        } else {
            this.alarmLinesCombo.setItems(this.zeroAlarms);
            this.alarmLinesCombo.select(0);
            this.configuration.setNumberAlarmLines(0);
            this.alarmLinesLabel.setForeground(this.application.COLOR_BLACK);
            this.sensorAdapterButton.setBackground(this.application.COLOR_LIGHT_GREY);
            this.sensorAdapterButton.setEnabled(false);
        }
        this.checkAdapterRequired();
    }

    private void checkClearButtonState() {
        if (this.uBecDipDetectButton.getSelection() || this.capacityAlarmCombo.getSelectionIndex() > 0 || this.voltageBatteryAlarmCombo.getSelectionIndex() > 0 || this.voltageBatteryAlarmDecimalsCombo.getSelectionIndex() > 0 || this.fetTempMaxCombo.getSelectionIndex() > 0 || this.extern1Combo.getSelectionIndex() > 0 || this.ext1smallerButton.getSelection() || this.extern2Combo.getSelectionIndex() > 0 || this.ext2smallerButton.getSelection() || this.extern3Combo.getSelectionIndex() > 0 || this.ext3smallerButton.getSelection() || this.extern4Combo.getSelectionIndex() > 0 || this.ext4smallerButton.getSelection() || this.extern5Combo.getSelectionIndex() > 0 || this.ext5smallerButton.getSelection()) {
            this.alarmsClearButton.setBackground(this.application.COLOR_RED);
            this.alarmsClearButton.setEnabled(true);
        } else {
            this.alarmsClearButton.setBackground(this.application.COLOR_LIGHT_GREY);
            this.alarmsClearButton.setEnabled(false);
        }
        this.checkNumberAlarms();
    }

    private void clearAlarms() {
        this.uBecDipDetectButton.setSelection(false);
        this.configuration.setBecDip(false);
        this.capacityAlarmCombo.select(0);
        this.configuration.setCapacityAlarm(0);
        this.voltageBatteryAlarmDecimalsCombo.select(0);
        this.configuration.setBatteryAlarmMajor("0");
        this.voltageBatteryAlarmCombo.select(0);
        this.configuration.setBatteryAlarmDecimals("0");
        this.fetTempMaxCombo.select(0);
        this.configuration.setPaMaxTempAlarm("0");
        this.extern1Combo.select(0);
        this.ext1smallerButton.setSelection(false);
        this.configuration.setExtTemp1("0");
        this.configuration.setExtTemp1LowerThan(0);
        this.configuration.setExtTemp2("0");
        this.configuration.setExtTemp2LowerThan(0);
        this.configuration.setExtTemp3("0");
        this.configuration.setExtTemp3LowerThan(0);
        this.configuration.setExtTemp4("0");
        this.configuration.setExtTemp4LowerThan(0);
        this.configuration.setExtTemp5("0");
        this.configuration.setExtTemp5LowerThan(0);
        this.alarmLinesLabel.setForeground(this.application.COLOR_BLACK);
        this.alarmLinesCombo.select(0);
        this.checkClearButtonState();
    }

    private void enableExternTempearture1(boolean isEnabled) {
        this.extern1Combo.setEnabled(isEnabled);
        this.ext1smallerButton.setEnabled(isEnabled);
        this.configuration.setExtTemp1("0");
        this.configuration.setExtTemp1LowerThan(0);
    }

    private void enableExternTempeartureAll(boolean isEnabled) {
        this.extern1Combo.setEnabled(isEnabled);
        this.ext1smallerButton.setEnabled(isEnabled);
        this.extern2Combo.setEnabled(isEnabled);
        this.ext2smallerButton.setEnabled(isEnabled);
        this.extern3Combo.setEnabled(isEnabled);
        this.ext3smallerButton.setEnabled(isEnabled);
        this.extern4Combo.setEnabled(isEnabled);
        this.ext4smallerButton.setEnabled(isEnabled);
        this.extern5Combo.setEnabled(isEnabled);
        this.ext5smallerButton.setEnabled(isEnabled);
        this.configuration.setExtTemp2("0");
        this.configuration.setExtTemp2LowerThan(0);
        this.configuration.setExtTemp3("0");
        this.configuration.setExtTemp3LowerThan(0);
        this.configuration.setExtTemp4("0");
        this.configuration.setExtTemp4LowerThan(0);
        this.configuration.setExtTemp5("0");
        this.configuration.setExtTemp5LowerThan(0);
    }

    private void updateSubDevices(int value) {
        this.subDevicesLabel.setForeground(this.application.COLOR_BLACK);
        this.subDevicesCombo.setText(Messages.getString((String)"GDE_MSGT2865"));
        this.sensorAdapterButton.setEnabled(false);
        this.sensorAdapterButton.setBackground(this.application.COLOR_LIGHT_GREY);
        this.telemetryCombo.setEnabled(true);
        this.alarmLinesCombo.setEnabled(true);
        this.line1signalTypeCombo.setEnabled(true);
        this.alarmLinesLabel.setForeground(this.application.COLOR_BLACK);
        this.tempSensorTypeCombo.setEnabled(true);
        this.pulsPerRevolutionSensorCombo.setEnabled(true);
        this.ext1Label.setText(Messages.getString((String)"GDE_MSGT2874"));
        this.temperaure1Label.setText("[\u00b0C]");
        this.alarmLinesCombo.setItems(this.zeroAlarms);
        this.alarmLinesCombo.select(0);
        this.hv2BecLabel.setVisible(false);
        this.hv2BecCombo.setVisible(false);
        this.speedSensorLabel.setVisible(false);
        this.speedSensorButton.setVisible(false);
        if (this.configuration.version == 322) {
            if (this.comOutput.lastIndexOf(this.hottOutput) > 0) {
                this.comOutput.substring(0, this.comOutput.lastIndexOf(this.hottOutput));
            }
            this.telemetryCombo.setItems(this.comOutputString.split(","));
            switch (value) {
                case 1: {
                    this.jlogConfigurationCombo.select(13);
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    this.enableExternTempearture1(true);
                    this.ext1Label.setText(Messages.getString((String)"GDE_MSGI2877"));
                    this.temperaure1Label.setText("[V]");
                    break;
                }
                case 2: {
                    this.jlogConfigurationCombo.select(16);
                    this.subDevicesLabel.setForeground(this.application.COLOR_RED);
                    this.subDevicesCombo.setText("BID");
                    this.alarmLinesCombo.setEnabled(false);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    break;
                }
                case 92: {
                    this.jlogConfigurationCombo.select(24);
                    this.subDevicesLabel.setForeground(this.application.COLOR_RED);
                    this.subDevicesCombo.setText("BID");
                    this.alarmLinesCombo.setEnabled(false);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    break;
                }
                case 3: {
                    this.jlogConfigurationCombo.select(21);
                    this.alarmLinesCombo.setItems(this.greaterOneAlarms);
                    this.alarmLinesCombo.select(2);
                    this.alarmLinesCombo.setEnabled(false);
                    this.alarmLinesLabel.setForeground(this.application.COLOR_RED);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.telemetryCombo.select(4);
                    this.enableExternTempeartureAll(true);
                    break;
                }
                case 4: {
                    this.jlogConfigurationCombo.select(22);
                    this.alarmLinesCombo.setItems(this.greaterOneAlarms);
                    this.alarmLinesCombo.select(2);
                    this.alarmLinesCombo.setEnabled(false);
                    this.alarmLinesLabel.setForeground(this.application.COLOR_RED);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.telemetryCombo.select(4);
                    this.enableExternTempeartureAll(true);
                    this.ext1Label.setText(Messages.getString((String)"GDE_MSGI2877"));
                    this.temperaure1Label.setText("[V]");
                    break;
                }
                case 5: {
                    this.jlogConfigurationCombo.select(19);
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("JTX");
                    break;
                }
                case 6: {
                    this.jlogConfigurationCombo.select(20);
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("JTX");
                    this.enableExternTempearture1(true);
                    this.ext1Label.setText(Messages.getString((String)"GDE_MSGI2877"));
                    this.temperaure1Label.setText("[V]");
                    break;
                }
                case 10: {
                    this.jlogConfigurationCombo.select(8);
                    this.subDevicesCombo.setText("none");
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("MBS");
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    break;
                }
                case 11: {
                    this.subDevicesCombo.setText("none");
                    this.telemetryCombo.setItems(this.comOutput.append(this.hottOutput).toString().split(","));
                    this.telemetryCombo.select(5);
                    break;
                }
                case 15: {
                    this.jlogConfigurationCombo.select(9);
                    this.subDevicesCombo.setText("none");
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("MPX");
                    this.enableMpxAddressSelection(true);
                    break;
                }
                case 16: {
                    this.jlogConfigurationCombo.select(15);
                    this.subDevicesCombo.setText("none");
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("MPX");
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    this.enableExternTempearture1(true);
                    this.ext1Label.setText(Messages.getString((String)"GDE_MSGI2877"));
                    this.temperaure1Label.setText("[V]");
                    break;
                }
                case 20: {
                    this.jlogConfigurationCombo.select(17);
                    this.subDevicesLabel.setForeground(this.application.COLOR_RED);
                    this.subDevicesCombo.setText("BID");
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("MBS");
                    this.alarmLinesCombo.setEnabled(false);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    break;
                }
                case 23: {
                    this.jlogConfigurationCombo.select(14);
                    this.subDevicesCombo.setText("none");
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("MBS");
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    this.enableExternTempearture1(true);
                    this.ext1Label.setText(Messages.getString((String)"GDE_MSGI2877"));
                    this.temperaure1Label.setText("[V]");
                    break;
                }
                case 25: {
                    this.jlogConfigurationCombo.select(18);
                    this.subDevicesLabel.setForeground(this.application.COLOR_RED);
                    this.subDevicesCombo.setText("BID");
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("MPX");
                    this.alarmLinesCombo.setEnabled(false);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    this.enableMpxAddressSelection(true);
                    break;
                }
                case 40: {
                    this.jlogConfigurationCombo.select(10);
                    this.subDevicesCombo.setText("none");
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("MPX");
                    break;
                }
                case 91: {
                    this.jlogConfigurationCombo.select(23);
                    this.subDevicesLabel.setForeground(this.application.COLOR_RED);
                    break;
                }
                case 110: {
                    this.jlogConfigurationCombo.select(11);
                    this.subDevicesCombo.setText("none");
                    this.speedSensorLabel.setVisible(true);
                    this.speedSensorButton.setVisible(true);
                    break;
                }
                case 111: {
                    this.jlogConfigurationCombo.select(12);
                    this.subDevicesCombo.setText("none");
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("MBS");
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    this.speedSensorLabel.setVisible(true);
                    this.speedSensorButton.setVisible(true);
                    break;
                }
                case 200: {
                    this.jlogConfigurationCombo.select(1);
                    this.subDevicesLabel.setForeground(this.application.COLOR_RED);
                    this.subDevicesCombo.setText("HTS-SS");
                    this.alarmLinesCombo.setEnabled(false);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    break;
                }
                case 201: {
                    this.jlogConfigurationCombo.select(2);
                    this.subDevicesLabel.setForeground(this.application.COLOR_RED);
                    this.subDevicesCombo.setText("HTS-SS");
                    this.alarmLinesCombo.setEnabled(false);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("MBS");
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    break;
                }
                case 202: {
                    this.jlogConfigurationCombo.select(3);
                    this.subDevicesLabel.setForeground(this.application.COLOR_RED);
                    this.subDevicesCombo.setText("HTS-SS");
                    this.alarmLinesCombo.setEnabled(false);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.tempSensorTypeCombo.select(0);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("digital COM");
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    break;
                }
                case 210: {
                    this.jlogConfigurationCombo.select(4);
                    this.subDevicesLabel.setForeground(this.application.COLOR_RED);
                    this.subDevicesCombo.setText("HV\u00b2BEC");
                    this.ext1Label.setText("HV\u00b2BEC Temp");
                    this.alarmLinesCombo.setEnabled(false);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.tempSensorTypeCombo.select(0);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.enableExternTempearture1(true);
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    this.hv2BecLabel.setVisible(true);
                    this.hv2BecCombo.setVisible(true);
                    break;
                }
                case 211: {
                    this.jlogConfigurationCombo.select(5);
                    this.subDevicesLabel.setForeground(this.application.COLOR_RED);
                    this.subDevicesCombo.setText("HV\u00b2BEC");
                    this.ext1Label.setText("HV\u00b2BEC Temp");
                    this.alarmLinesCombo.setEnabled(false);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.tempSensorTypeCombo.select(0);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.enableExternTempearture1(true);
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    this.hv2BecLabel.setVisible(true);
                    this.hv2BecCombo.setVisible(true);
                    break;
                }
                case 212: {
                    this.jlogConfigurationCombo.select(6);
                    this.subDevicesLabel.setForeground(this.application.COLOR_RED);
                    this.subDevicesCombo.setText("HV\u00b2BEC/HTSS");
                    this.ext1Label.setText("HV\u00b2BEC Temp");
                    this.alarmLinesCombo.setEnabled(false);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.tempSensorTypeCombo.select(0);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.enableExternTempearture1(true);
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    this.hv2BecLabel.setVisible(true);
                    this.hv2BecCombo.setVisible(true);
                    break;
                }
                case 213: {
                    this.jlogConfigurationCombo.select(7);
                    this.subDevicesLabel.setForeground(this.application.COLOR_RED);
                    this.subDevicesCombo.setText("HV\u00b2BEC/HTSS");
                    this.ext1Label.setText("HV\u00b2BEC Temp");
                    this.alarmLinesCombo.setEnabled(false);
                    this.line1signalTypeCombo.setEnabled(false);
                    this.pulsPerRevolutionSensorCombo.setEnabled(false);
                    this.telemetryCombo.setEnabled(false);
                    this.telemetryCombo.setText("digital COM");
                    this.tempSensorTypeCombo.select(0);
                    this.tempSensorTypeCombo.setEnabled(false);
                    this.enableExternTempearture1(true);
                    this.sensorAdapterButton.setEnabled(true);
                    this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
                    this.hv2BecLabel.setVisible(true);
                    this.hv2BecCombo.setVisible(true);
                }
            }
        } else {
            switch (value) {
                default: {
                    this.jlogConfigurationCombo.select(1);
                    this.telemetryCombo.setItems(this.comOutputBase);
                    this.telemetryCombo.select(0);
                    break;
                }
                case 61: 
                case 71: {
                    this.jlogConfigurationCombo.select(value == 61 ? 2 : 7);
                    this.telemetryCombo.setItems(this.comOutputJetiEx);
                    this.telemetryCombo.select(2);
                    break;
                }
                case 62: 
                case 72: 
                case 81: {
                    this.jlogConfigurationCombo.select(value == 62 ? 3 : (value == 72 ? 8 : 12));
                    this.telemetryCombo.setItems(this.comOutputHoTTv4);
                    this.telemetryCombo.select(3);
                    break;
                }
                case 63: 
                case 73: 
                case 82: {
                    this.jlogConfigurationCombo.select(value == 63 ? 4 : (value == 73 ? 9 : 13));
                    this.telemetryCombo.setItems(this.comOutputFutabaSbus2);
                    this.telemetryCombo.select(4);
                    break;
                }
                case 64: 
                case 74: {
                    this.jlogConfigurationCombo.select(value == 64 ? 5 : 10);
                    this.telemetryCombo.setItems(this.comOutputHiTec);
                    this.telemetryCombo.select(0);
                    break;
                }
                case 65: 
                case 75: {
                    this.jlogConfigurationCombo.select(value == 65 ? 6 : 11);
                    this.telemetryCombo.setItems(this.comOutputSpektrum);
                    this.telemetryCombo.select(0);
                }
            }
        }
        log.log(Level.FINE, "telemetryCombo selection index = " + this.telemetryCombo.getSelectionIndex() + " jlogConfigurationCombo selection index = " + this.jlogConfigurationCombo.getSelectionIndex());
        log.log(Level.FINER, StringHelper.printBinary((byte)((byte)(value & 0xFF)), (boolean)false));
    }

    private void enableMpxAddressSelection(boolean isEnabled) {
        for (MpxAddressComposite tmpMpxAddress : this.mpxAddresses) {
            tmpMpxAddress.mpxAddressCombo.setEnabled(isEnabled);
        }
    }

    private void updateGearRatio() {
        double gearRatio = Double.valueOf(this.gearMainWheelCombo.getText().trim() + "." + this.gearMainWheelDecimalsCombo.getText().trim()) / Double.valueOf(this.gearPinionWheelCombo.getText().trim());
        this.directGearRatioMajorCombo.select((int)gearRatio - 1);
        this.directGearRatioDecimalsCombo.select((int)(gearRatio % 1.0 * 100.0));
        this.configuration.setGearRatioMinor("" + (int)gearRatio);
        this.configuration.setGearRatioDecimals("" + (int)(gearRatio % 1.0 * 100.0));
    }

    private void checkAdapterRequired() {
        if (this.alarmLinesCombo.getSelectionIndex() > 1 || this.tempSensorTypeCombo.getSelectionIndex() == 2 || this.tempSensorTypeCombo.getSelectionIndex() >= 1 && this.pulsPerRevolutionSensorCombo.getSelectionIndex() > 0) {
            this.sensorAdapterButton.setEnabled(true);
            this.sensorAdapterButton.setBackground(this.application.COLOR_RED);
        } else {
            this.sensorAdapterButton.setEnabled(false);
            this.sensorAdapterButton.setBackground(this.application.COLOR_LIGHT_GREY);
        }
    }

    public class Configuration322
    extends Configuration {
        static final String normal = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,2,3,4,5,6,7,8,12,13,16,16,16,14,9,10,11,36,0";
        final String HSS = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,9,0,0,6,2,3,4,5,6,7,8,12,13,16,16,16,14,9,10,11,36,200";
        final String HSSG2 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,201";
        final String HSST = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,202";
        final String BH = "9600,0,128,6,2,1,0,10,10,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,210,0";
        final String BM = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,211,0";
        final String BHSS = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,212,0";
        final String BHSST = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,213,0";
        final String G = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,10";
        final String S = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,15";
        final String L = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,6,2,3,4,5,6,7,8,16,16,16,16,16,12,9,10,11,36,40";
        final String T = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,9,0,0,6,2,3,4,5,6,7,8,16,16,16,16,16,12,9,10,11,36,110";
        final String GT = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,111";
        final String V = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,1";
        final String VG = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,23";
        final String VS = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,6,4,5,6,7,8,9,10,16,14,16,16,16,16,11,12,13,36,16";
        final String BID = "9600,0,192,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,4,5,6,7,8,9,10,16,14,16,16,16,16,11,12,13,36,2";
        final String BIDG = "9600,0,192,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,20";
        final String BIDS = "9600,0,192,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,25";
        final String A = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,5";
        final String AV = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,6";
        final String B = "0,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,3,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,132,3";
        final String BV = "0,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,3,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,132,4";
        final String P1 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,91";
        final String P2 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,92";
        final String AVP1 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,180";
        final String AP2 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,170";

        Configuration322() {
            super(normal, 322);
            this.HSS = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,9,0,0,6,2,3,4,5,6,7,8,12,13,16,16,16,14,9,10,11,36,200";
            this.HSSG2 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,201";
            this.HSST = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,202";
            this.BH = "9600,0,128,6,2,1,0,10,10,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,210,0";
            this.BM = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,211,0";
            this.BHSS = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,212,0";
            this.BHSST = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,213,0";
            this.G = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,10";
            this.S = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,15";
            this.L = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,6,2,3,4,5,6,7,8,16,16,16,16,16,12,9,10,11,36,40";
            this.T = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,9,0,0,6,2,3,4,5,6,7,8,16,16,16,16,16,12,9,10,11,36,110";
            this.GT = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,111";
            this.V = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,1";
            this.VG = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,23";
            this.VS = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,6,4,5,6,7,8,9,10,16,14,16,16,16,16,11,12,13,36,16";
            this.BID = "9600,0,192,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,4,5,6,7,8,9,10,16,14,16,16,16,16,11,12,13,36,2";
            this.BIDG = "9600,0,192,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,20";
            this.BIDS = "9600,0,192,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,25";
            this.A = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,5";
            this.AV = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,6";
            this.B = "0,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,3,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,132,3";
            this.BV = "0,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,3,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,132,4";
            this.P1 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,91";
            this.P2 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,92";
            this.AVP1 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,180";
            this.AP2 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,170";
        }

        Configuration322(String newConfiguration) {
            super(newConfiguration, 322);
            this.HSS = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,9,0,0,6,2,3,4,5,6,7,8,12,13,16,16,16,14,9,10,11,36,200";
            this.HSSG2 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,201";
            this.HSST = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,202";
            this.BH = "9600,0,128,6,2,1,0,10,10,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,210,0";
            this.BM = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,211,0";
            this.BHSS = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,212,0";
            this.BHSST = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,213,0";
            this.G = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,10";
            this.S = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,15";
            this.L = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,6,2,3,4,5,6,7,8,16,16,16,16,16,12,9,10,11,36,40";
            this.T = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,9,0,0,6,2,3,4,5,6,7,8,16,16,16,16,16,12,9,10,11,36,110";
            this.GT = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,111";
            this.V = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,1";
            this.VG = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,23";
            this.VS = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,6,4,5,6,7,8,9,10,16,14,16,16,16,16,11,12,13,36,16";
            this.BID = "9600,0,192,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,4,5,6,7,8,9,10,16,14,16,16,16,16,11,12,13,36,2";
            this.BIDG = "9600,0,192,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,36,20";
            this.BIDS = "9600,0,192,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,25";
            this.A = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,5";
            this.AV = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,6";
            this.B = "0,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,3,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,132,3";
            this.BV = "0,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,3,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,132,4";
            this.P1 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,91";
            this.P2 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,92";
            this.AVP1 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,180";
            this.AP2 = "9600,0,128,6,2,1,0,10,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,6,4,5,6,7,8,9,10,16,16,16,16,16,14,11,12,13,36,170";
        }

        @Override
        public void switchConfig() {
            switch (JLog2Configuration.this.jlogConfigurationCombo.getSelectionIndex()) {
                default: {
                    JLog2Configuration.this.configuration.update(normal);
                    break;
                }
                case 1: {
                    JLog2Configuration.this.configuration.update(this.HSS);
                    break;
                }
                case 2: {
                    JLog2Configuration.this.configuration.update(this.HSSG2);
                    break;
                }
                case 3: {
                    JLog2Configuration.this.configuration.update(this.HSST);
                    break;
                }
                case 4: {
                    JLog2Configuration.this.configuration.update(this.BH);
                    break;
                }
                case 5: {
                    JLog2Configuration.this.configuration.update(this.BM);
                    break;
                }
                case 6: {
                    JLog2Configuration.this.configuration.update(this.BHSS);
                    break;
                }
                case 7: {
                    JLog2Configuration.this.configuration.update(this.BHSST);
                    break;
                }
                case 8: {
                    JLog2Configuration.this.configuration.update(this.G);
                    break;
                }
                case 9: {
                    JLog2Configuration.this.configuration.update(this.S);
                    break;
                }
                case 10: {
                    JLog2Configuration.this.configuration.update(this.L);
                    break;
                }
                case 11: {
                    JLog2Configuration.this.configuration.update(this.T);
                    break;
                }
                case 12: {
                    JLog2Configuration.this.configuration.update(this.GT);
                    break;
                }
                case 13: {
                    JLog2Configuration.this.configuration.update(this.V);
                    break;
                }
                case 14: {
                    JLog2Configuration.this.configuration.update(this.VG);
                    break;
                }
                case 15: {
                    JLog2Configuration.this.configuration.update(this.VS);
                    break;
                }
                case 16: {
                    JLog2Configuration.this.configuration.update(this.BID);
                    break;
                }
                case 17: {
                    JLog2Configuration.this.configuration.update(this.BIDG);
                    break;
                }
                case 18: {
                    JLog2Configuration.this.configuration.update(this.BIDS);
                    break;
                }
                case 19: {
                    JLog2Configuration.this.configuration.update(this.A);
                    break;
                }
                case 20: {
                    JLog2Configuration.this.configuration.update(this.AV);
                    break;
                }
                case 21: {
                    JLog2Configuration.this.configuration.update(this.B);
                    break;
                }
                case 22: {
                    JLog2Configuration.this.configuration.update(this.BV);
                    break;
                }
                case 23: {
                    JLog2Configuration.this.configuration.update(this.P1);
                    break;
                }
                case 24: {
                    JLog2Configuration.this.configuration.update(this.P2);
                    break;
                }
                case 25: {
                    JLog2Configuration.this.configuration.update(this.AVP1);
                    break;
                }
                case 26: {
                    JLog2Configuration.this.configuration.update(this.AP2);
                }
            }
        }
    }

    public abstract class Configuration {
        String[] config;
        int version = 400;

        Configuration(String newConfiguration, int newVersion) {
            String[] tmpConfig = newConfiguration.split(",");
            this.config = new String[tmpConfig.length];
            for (int i = 0; i < tmpConfig.length; ++i) {
                this.config[i] = tmpConfig[i];
            }
            this.version = newVersion;
        }

        public void update(String updatedConfig) {
            String[] tmpConfig = updatedConfig.split(",");
            this.config = new String[tmpConfig.length];
            for (int i = 0; i < tmpConfig.length; ++i) {
                this.config[i] = tmpConfig[i];
            }
            log.log(Level.FINE, this.getConfiguration());
        }

        public int get(int index) {
            return Integer.valueOf(this.config[index]);
        }

        public String getConfiguration() {
            StringBuilder sb = new StringBuilder();
            for (String element : this.config) {
                sb.append(element).append(",");
            }
            return sb.delete(sb.length() - 1, sb.length()).toString();
        }

        public void setBaudRate(int baudeRateIndex) {
            String baudeRate = "9600";
            switch (baudeRateIndex) {
                case 1: {
                    baudeRate = "2400";
                    break;
                }
                case 2: {
                    baudeRate = "4800";
                    break;
                }
                case 3: {
                    baudeRate = "9600";
                    break;
                }
                case 4: 
                case 7: {
                    baudeRate = "38400";
                    break;
                }
                case 5: {
                    baudeRate = "57600";
                    break;
                }
                case 6: {
                    baudeRate = "115200";
                    break;
                }
                default: {
                    baudeRate = "9600";
                }
            }
            this.config[0] = baudeRate;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void set(int index, int value) {
            this.config[index] = "" + value;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setSysMode(int sysMode) {
            this.config[1] = "" + sysMode;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMotorCalibration(String calibration) {
            int value = Integer.valueOf(calibration.trim());
            this.config[1] = (value & 0x80) == 0 ? "" + ((value << 1) + (Integer.valueOf(this.config[1]) & 1)) : "" + ((Integer.valueOf(this.config[1]) & 1) - ((value << 1) - 128));
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setLogMode(int logMode) {
            switch (logMode) {
                default: {
                    this.config[2] = "" + (Integer.valueOf(this.config[2]) & 0xF4);
                    break;
                }
                case 1: {
                    this.config[2] = "" + (2 + (Integer.valueOf(this.config[2]) & 0xF4));
                    break;
                }
                case 2: {
                    this.config[2] = "" + (8 + (Integer.valueOf(this.config[2]) & 0xF4));
                }
            }
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMotorPols(String numMotorPols) {
            this.config[3] = numMotorPols;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setGearDirectConfig(boolean isConfig) {
            this.config[4] = "" + (isConfig ? 2 : 1);
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setGearRatioMinor(String gearRatioMajor) {
            this.config[5] = gearRatioMajor;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setGearRatioDecimals(String gearRatioDecimals) {
            this.config[6] = "" + Integer.valueOf(gearRatioDecimals);
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setGearPinionWheel(String gearPinionWheel) {
            this.config[7] = gearPinionWheel;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setGearMajorWheel(String gearMainWheel) {
            this.config[8] = gearMainWheel;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setGearMajorWheelDecimals(String gearMainWheelDecimals) {
            this.config[9] = gearMainWheelDecimals;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setLogStop(int logStop) {
            this.config[10] = "" + ((logStop & 1) + (Integer.valueOf(this.config[10]) & 0xFFFE));
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setHighPwmWarning(int highPwmWarning) {
            this.config[10] = "" + ((highPwmWarning & 2) + (this.get(10) & 0xFFFD));
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setLogStopExtRpmSensor(int extRpmSensorEffect) {
            this.config[10] = "" + ((extRpmSensorEffect & 4) + (Integer.valueOf(this.config[10]) & 0xFFFB));
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setReset(String reset) {
            this.config[11] = reset;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setCapacityAlarm(int capacity) {
            this.config[12] = "" + capacity;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setBatteryAlarmMajor(String alarmVoltageMajor) {
            this.config[13] = alarmVoltageMajor;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setBatteryAlarmDecimals(String alarmVoltageMinor) {
            this.config[14] = alarmVoltageMinor;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setPaMaxTempAlarm(String pamaxTemperature) {
            this.config[15] = pamaxTemperature;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setBecDip(boolean isUbecDip) {
            this.config[16] = "" + (isUbecDip ? 1 : 0);
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setExtTemp1(String extTemp1) {
            this.config[17] = extTemp1;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setExtTemp2(String extTemp2) {
            this.config[18] = extTemp2;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setExtTemp3(String extTemp3) {
            this.config[19] = extTemp3;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setExtTemp4(String extTemp4) {
            this.config[20] = extTemp4;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setExtTemp5(String extTemp5) {
            this.config[21] = extTemp5;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setExtTemp1LowerThan(int ltExtTemp1) {
            this.config[22] = "" + ((Integer.valueOf(this.config[22]) & 0xFE) + (ltExtTemp1 & 1));
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setExtTemp2LowerThan(int ltExtTemp2) {
            this.config[22] = "" + ((Integer.valueOf(this.config[22]) & 0xFD) + (ltExtTemp2 << 1 & 2));
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setExtTemp3LowerThan(int ltExtTemp3) {
            this.config[22] = "" + ((Integer.valueOf(this.config[22]) & 0xFB) + (ltExtTemp3 << 2 & 4));
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setExtTemp4LowerThan(int ltExtTemp4) {
            this.config[22] = "" + ((Integer.valueOf(this.config[22]) & 0xF7) + (ltExtTemp4 << 3 & 8));
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setExtTemp5LowerThan(int ltExtTemp5) {
            this.config[22] = "" + ((Integer.valueOf(this.config[22]) & 0xEF) + (ltExtTemp5 << 4 & 0x10));
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setNumberAlarmLines(int numAddressLines) {
            this.config[23] = "" + numAddressLines;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setTemperaturSensorType(int tempSensorType) {
            this.config[24] = "" + tempSensorType;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void set25Type(int type) {
            this.config[25] = "" + type;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setTelemetryType(int type) {
            this.config[26] = "" + (type > 1 ? type - 1 : 0);
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setPulsePerRevolution(int rpmSensorPulsePerRevolution) {
            this.config[27] = rpmSensorPulsePerRevolution >= 1 ? "1" : "0";
            this.config[28] = rpmSensorPulsePerRevolution >= 1 ? "" + rpmSensorPulsePerRevolution : "0";
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setIsMotor(boolean isMotor) {
            this.config[29] = isMotor ? "" + (Integer.valueOf(this.config[29]) | 0x40) : "" + (Integer.valueOf(this.config[29]) & 0xFFBF);
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setIsBrushlessMotor(boolean isBrushLessMotor, int numMotorPols) {
            this.config[29] = isBrushLessMotor ? "" + (128 + numMotorPols) : "" + (Integer.valueOf(this.config[29]) & 0xFF7F);
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress0(int mpxSensorAddress) {
            this.config[30] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress1(int mpxSensorAddress) {
            this.config[31] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress2(int mpxSensorAddress) {
            this.config[32] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress3(int mpxSensorAddress) {
            this.config[33] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress4(int mpxSensorAddress) {
            this.config[34] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress5(int mpxSensorAddress) {
            this.config[35] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress6(int mpxSensorAddress) {
            this.config[36] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress7(int mpxSensorAddress) {
            this.config[37] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress8(int mpxSensorAddress) {
            this.config[38] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress9(int mpxSensorAddress) {
            this.config[39] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress10(int mpxSensorAddress) {
            this.config[40] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress11(int mpxSensorAddress) {
            this.config[41] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress12(int mpxSensorAddress) {
            this.config[42] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress13(int mpxSensorAddress) {
            this.config[43] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress14(int mpxSensorAddress) {
            this.config[44] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setMpxSensorAddress15(int mpxSensorAddress) {
            this.config[45] = mpxSensorAddress >= 16 ? "16" : "" + mpxSensorAddress;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setLine1signalType(int signalType) {
            this.config[46] = "" + (signalType & 0xE0);
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setTelemetryBaudrateType(int type) {
            this.config[46] = "" + ((Integer.valueOf(this.config[46]) & 0xFFF0) + (type & 0xF));
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setSubDeviceType(int type) {
            this.config[46] = "" + ((Integer.valueOf(this.config[46]) & 0xFFF0) + (type & 0xF));
            log.log(Level.FINER, this.getConfiguration());
        }

        public void set47Type(int type) {
            this.config[47] = "" + type;
            log.log(Level.FINER, this.getConfiguration());
        }

        public void setHV2BecVoltage(int slectionIndex) {
            if (this.config.length < 49) {
                String[] tmpConfig = new String[49];
                for (int i = 0; i < this.config.length; ++i) {
                    tmpConfig[i] = this.config[i];
                }
                this.config = tmpConfig;
            }
            this.config[48] = "" + slectionIndex;
            log.log(Level.FINER, this.getConfiguration());
        }

        public abstract void switchConfig();
    }

    public class Configuration400
    extends Configuration {
        static final String noneSelected = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132";
        final String jiveBasic = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,60,0,0";
        final String jiveJetiEx = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,61,0,0";
        final String jiveHoTTv4 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,62,0,0";
        final String jiveFutabaSbus2 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,63,0,0";
        final String jiveHiTec = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,64";
        final String jiveSpektrum = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,65";
        final String castleJetiEx = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,71";
        final String castleHoTTv4 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,72";
        final String castleFutabaSbus2 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,73";
        final String castleHiTec = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,74";
        final String castleSpektrum = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,75";
        final String c200HoTTv4 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,81";
        final String c200FutabaSbus = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,82";

        Configuration400() {
            super(noneSelected, 400);
            this.jiveBasic = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,60,0,0";
            this.jiveJetiEx = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,61,0,0";
            this.jiveHoTTv4 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,62,0,0";
            this.jiveFutabaSbus2 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,63,0,0";
            this.jiveHiTec = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,64";
            this.jiveSpektrum = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,65";
            this.castleJetiEx = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,71";
            this.castleHoTTv4 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,72";
            this.castleFutabaSbus2 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,73";
            this.castleHiTec = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,74";
            this.castleSpektrum = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,75";
            this.c200HoTTv4 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,81";
            this.c200FutabaSbus = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,82";
        }

        Configuration400(String newConfiguration) {
            super(newConfiguration, 400);
            this.jiveBasic = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,60,0,0";
            this.jiveJetiEx = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,61,0,0";
            this.jiveHoTTv4 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,62,0,0";
            this.jiveFutabaSbus2 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,63,0,0";
            this.jiveHiTec = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,64";
            this.jiveSpektrum = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,65";
            this.castleJetiEx = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,71";
            this.castleHoTTv4 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,72";
            this.castleFutabaSbus2 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,73";
            this.castleHiTec = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,74";
            this.castleSpektrum = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,75";
            this.c200HoTTv4 = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,81";
            this.c200FutabaSbus = "9600,0,128,6,2,1,0,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,6,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,132,82";
        }

        @Override
        public void switchConfig() {
            switch (JLog2Configuration.this.jlogConfigurationCombo.getSelectionIndex()) {
                default: {
                    JLog2Configuration.this.configuration.update(noneSelected);
                    break;
                }
                case 1: {
                    JLog2Configuration.this.configuration.update(this.jiveBasic);
                    break;
                }
                case 2: {
                    JLog2Configuration.this.configuration.update(this.jiveJetiEx);
                    break;
                }
                case 3: {
                    JLog2Configuration.this.configuration.update(this.jiveHoTTv4);
                    break;
                }
                case 4: {
                    JLog2Configuration.this.configuration.update(this.jiveFutabaSbus2);
                    break;
                }
                case 5: {
                    JLog2Configuration.this.configuration.update(this.jiveHiTec);
                    break;
                }
                case 6: {
                    JLog2Configuration.this.configuration.update(this.jiveSpektrum);
                    break;
                }
                case 7: {
                    JLog2Configuration.this.configuration.update(this.castleJetiEx);
                    break;
                }
                case 8: {
                    JLog2Configuration.this.configuration.update(this.castleHoTTv4);
                    break;
                }
                case 9: {
                    JLog2Configuration.this.configuration.update(this.castleFutabaSbus2);
                    break;
                }
                case 10: {
                    JLog2Configuration.this.configuration.update(this.castleHiTec);
                    break;
                }
                case 11: {
                    JLog2Configuration.this.configuration.update(this.castleSpektrum);
                    break;
                }
                case 12: {
                    JLog2Configuration.this.configuration.update(this.c200HoTTv4);
                    break;
                }
                case 13: {
                    JLog2Configuration.this.configuration.update(this.c200FutabaSbus);
                }
            }
        }
    }

    public class MpxAddressComposite
    extends Composite {
        private CCombo mpxAddressCombo;
        private CLabel mpxAddressLabel;

        public MpxAddressComposite(Composite parent, int style, String labelText, final Configuration configuration, final int index) {
            super(parent, style);
            RowLayout mpxAddressCompositeLayout = new RowLayout(256);
            RowData mpxAddressCompositeLData = new RowData();
            mpxAddressCompositeLData.width = GDE.IS_LINUX ? 105 : 95;
            mpxAddressCompositeLData.height = 22;
            this.setLayoutData(mpxAddressCompositeLData);
            this.setLayout((Layout)mpxAddressCompositeLayout);
            this.mpxAddressLabel = new CLabel((Composite)this, 131072);
            RowData mpxAddressLabelLData = new RowData();
            mpxAddressLabelLData.width = 50;
            mpxAddressLabelLData.height = 20;
            this.mpxAddressLabel.setLayoutData((Object)mpxAddressLabelLData);
            this.mpxAddressLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.mpxAddressLabel.setText(labelText);
            RowData mpxAddressComboLData = new RowData();
            mpxAddressComboLData.width = GDE.IS_LINUX ? 45 : 35;
            mpxAddressComboLData.height = 16;
            this.mpxAddressCombo = new CCombo((Composite)this, 2048);
            this.mpxAddressCombo.setLayoutData((Object)mpxAddressComboLData);
            this.mpxAddressCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.mpxAddressCombo.setItems(new String[]{" 0", " 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8", " 9", " 10", " 11", " 12", " 13", " 14", " 15", " --"});
            this.mpxAddressCombo.select(16);
            this.mpxAddressCombo.setVisibleItemCount(10);
            this.mpxAddressCombo.setEnabled(false);
            this.mpxAddressCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "mpxAddressCombo.widgetSelected, event=" + String.valueOf(evt));
                    int address = MpxAddressComposite.this.mpxAddressCombo.getSelectionIndex();
                    for (int i = 0; i < 16; ++i) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, i + " != " + index + "; " + configuration.get(i + 30) + " == " + address);
                        }
                        if (i == index || configuration.get(i + 30) != address) continue;
                        JLog2Configuration.this.application.openMessageDialog(JLog2Configuration.this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGW2803"));
                        MpxAddressComposite.this.mpxAddressCombo.select(16);
                        address = 16;
                        break;
                    }
                    switch (index) {
                        case 0: {
                            configuration.setMpxSensorAddress0(address);
                            break;
                        }
                        case 1: {
                            configuration.setMpxSensorAddress1(address);
                            break;
                        }
                        case 2: {
                            configuration.setMpxSensorAddress2(address);
                            break;
                        }
                        case 3: {
                            configuration.setMpxSensorAddress3(address);
                            break;
                        }
                        case 4: {
                            configuration.setMpxSensorAddress4(address);
                            break;
                        }
                        case 5: {
                            configuration.setMpxSensorAddress5(address);
                            break;
                        }
                        case 6: {
                            configuration.setMpxSensorAddress6(address);
                            break;
                        }
                        case 7: {
                            configuration.setMpxSensorAddress7(address);
                            break;
                        }
                        case 8: {
                            configuration.setMpxSensorAddress8(address);
                            break;
                        }
                        case 9: {
                            configuration.setMpxSensorAddress9(address);
                            break;
                        }
                        case 10: {
                            configuration.setMpxSensorAddress10(address);
                            break;
                        }
                        case 11: {
                            configuration.setMpxSensorAddress11(address);
                            break;
                        }
                        case 12: {
                            configuration.setMpxSensorAddress12(address);
                            break;
                        }
                        case 13: {
                            configuration.setMpxSensorAddress13(address);
                            break;
                        }
                        case 14: {
                            configuration.setMpxSensorAddress14(address);
                            break;
                        }
                        case 15: {
                            configuration.setMpxSensorAddress15(address);
                        }
                    }
                    JLog2Configuration.this.enableSaveSettings();
                }
            });
        }

        public void setSelection(int addressIndex) {
            this.mpxAddressCombo.select(addressIndex);
        }
    }
}

