/*
 * Decompiled with CFR 0.152.
 */
package gde.ui;

import gde.config.Settings;
import gde.device.IDevice;
import gde.log.Level;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SWTResourceManager {
    private static Logger log = Logger.getLogger(SWTResourceManager.class.getName());
    static int accessCounter = 0;
    static HashMap<String, Object> resources = new HashMap();
    static HashMap<String, Integer> widgets = new HashMap();
    static Vector<Widget> users = new Vector();
    static SWTResourceManager instance = new SWTResourceManager();
    private static DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            users.remove(e.getSource());
            if (widgets.get(e.getSource().getClass().getSimpleName()) != null) {
                int newCount = widgets.get(e.getSource().getClass().getSimpleName()) - 1;
                if (newCount > 0) {
                    widgets.put(e.getSource().getClass().getSimpleName(), widgets.get(e.getSource().getClass().getSimpleName()) - 1);
                } else {
                    widgets.remove(e.getSource().getClass().getSimpleName());
                }
            }
            if (users.size() == 0) {
                SWTResourceManager.dispose();
            }
        }
    };

    public static void registerResourceUser(Widget widget) {
        if (users.contains(widget)) {
            return;
        }
        users.add(widget);
        if (widgets.get(widget.getClass().getSimpleName()) == null) {
            widgets.put(widget.getClass().getSimpleName(), 1);
        } else {
            widgets.put(widget.getClass().getSimpleName(), widgets.get(widget.getClass().getSimpleName()) + 1);
        }
        widget.addDisposeListener(disposeListener);
    }

    public static void listResourceStatus(String callIdentifier) {
        Iterator<String> it = resources.keySet().iterator();
        log.log(Level.WARNING, callIdentifier + ": number collected resources = " + resources.size());
        int numFonts = 0;
        int numColors = 0;
        int numImage = 0;
        int numCursor = 0;
        int numMenu = 0;
        while (it.hasNext()) {
            Object resource = resources.get(it.next());
            if (resource instanceof Font) {
                ++numFonts;
                continue;
            }
            if (resource instanceof Color) {
                ++numColors;
                continue;
            }
            if (resource instanceof Image) {
                ++numImage;
                continue;
            }
            if (resource instanceof Cursor) {
                ++numCursor;
                continue;
            }
            if (!(resource instanceof Menu)) continue;
            ++numMenu;
        }
        log.log(Level.WARNING, users.size() + " widgets, " + numFonts + " font, " + numColors + " colors, " + numImage + " images, " + numCursor + " cursors " + numMenu + " menus ");
        StringBuffer sb = new StringBuffer();
        for (String key : widgets.keySet()) {
            sb.append(key).append(" ").append(widgets.get(key)).append(",");
        }
        log.log(Level.WARNING, sb.toString());
    }

    public static void dispose() {
        Iterator<String> it = resources.keySet().iterator();
        while (it.hasNext()) {
            Object resource = resources.get(it.next());
            if (resource instanceof Font) {
                ((Font)resource).dispose();
                continue;
            }
            if (resource instanceof Color) {
                ((Color)resource).dispose();
                continue;
            }
            if (resource instanceof Image) {
                ((Image)resource).dispose();
                continue;
            }
            if (!(resource instanceof Cursor)) continue;
            ((Cursor)resource).dispose();
        }
        resources.clear();
    }

    public static Menu getMenu(final String implClassName, Shell shell, int style) {
        String name = "MENU:" + implClassName;
        if (resources.containsKey(name) && !((Menu)resources.get(name)).isDisposed()) {
            return (Menu)resources.get(name);
        }
        if (resources.containsKey(name) && ((Menu)resources.get(name)).isDisposed() && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "menu isDisposed = " + implClassName);
        }
        Menu menu = new Menu((Decorations)shell, style);
        menu.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeevent) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "menu.widgetDisposed " + implClassName);
                }
                resources.remove(implClassName);
            }
        });
        resources.put(implClassName, menu);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "new menu created for " + implClassName);
        }
        return menu;
    }

    public static Font getFont(FontData fd) {
        return SWTResourceManager.getFont(fd.getName(), fd.getHeight(), fd.getStyle(), false, false);
    }

    public static Font getFont(Control control, int style) {
        FontData[] fd = control.getFont().getFontData();
        fd[0].setStyle(style);
        if (fd[0].getHeight() > 10) {
            fd[0].setHeight(10);
        }
        return SWTResourceManager.getFont(fd[0]);
    }

    public static Font getFont(Control control, int size, int style) {
        FontData[] fd = control.getFont().getFontData();
        fd[0].setHeight(size);
        fd[0].setStyle(style);
        return SWTResourceManager.getFont(fd[0]);
    }

    public static Font getFont(GC gc, int style) {
        FontData[] fd = gc.getFont().getFontData();
        fd[0].setStyle(style);
        if (fd[0].getHeight() > 10) {
            fd[0].setHeight(10);
        }
        return SWTResourceManager.getFont(fd[0]);
    }

    public static Font getFont(String name, int size, int style) {
        return SWTResourceManager.getFont(name, size, style, false, false);
    }

    public static Font getFont(String name, int size, int style, boolean strikeout, boolean underline) {
        String fontName = name + "-" + size + "-" + style + "-" + strikeout + "-" + underline;
        if (resources.containsKey(fontName)) {
            return (Font)resources.get(fontName);
        }
        FontData fd = new FontData(name, size, style);
        if (strikeout || underline) {
            try {
                Class<?> lfCls = Class.forName("org.eclipse.swt.internal.win32.LOGFONT");
                Object lf = FontData.class.getField("data").get(fd);
                if (lf != null && lfCls != null) {
                    if (strikeout) {
                        lfCls.getField("lfStrikeOut").set(lf, (byte)1);
                    }
                    if (underline) {
                        lfCls.getField("lfUnderline").set(lf, (byte)1);
                    }
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        Font font = new Font((Device)Display.getDefault(), fd);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "new font created = " + fontName);
        }
        resources.put(fontName, font);
        return font;
    }

    public static Image getImage(String url, Control widget) {
        Image img = SWTResourceManager.getImage(url);
        if (img != null && widget != null) {
            img.setBackground(widget.getBackground());
        }
        return img;
    }

    public static Image getImage(int x, int y) {
        String key = "IMAGE:" + x + "_" + y;
        try {
            if (resources.containsKey(key)) {
                return (Image)resources.get(key);
            }
            Image img = new Image((Device)Display.getDefault(), x, y);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "new image created = " + key);
            }
            resources.put(key, img);
            return img;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static Image getImage(int x, int y, String imgKey) {
        String key = "IMAGE:" + x + "_" + y + "_" + imgKey;
        try {
            if (resources.containsKey(key)) {
                return (Image)resources.get(key);
            }
            Image img = new Image((Device)Display.getDefault(), x, y);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "new image created = " + key);
            }
            resources.put(key, img);
            return img;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static Image getImage(Point pt, String imageURL, String text) {
        String key = "IMAGE:" + pt.x + "_" + pt.y + "_" + imageURL + "_" + text;
        try {
            if (resources.containsKey(key)) {
                return (Image)resources.get(key);
            }
            Image buttonImage = SWTResourceManager.getImage(imageURL);
            Image img = SWTResourceManager.getImage(pt.x, pt.y);
            GC gc = new GC((Drawable)img);
            gc.setBackground(SWTResourceManager.getColor(22));
            gc.setForeground(SWTResourceManager.getColor(2));
            gc.fillRoundRectangle(0, 0, pt.x, pt.y, 3, 3);
            gc.drawImage(buttonImage, 0, 0);
            Point textExtend = gc.textExtent(text);
            gc.drawText(text, buttonImage.getBounds().width + (pt.x - buttonImage.getBounds().width - textExtend.x) / 2, (pt.y - textExtend.y) / 2);
            gc.dispose();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "new image created = " + key);
            }
            resources.put(key, img);
            return img;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static Image getRotatedImage(Image image, int style, String imgKey) {
        Image resultImg = null;
        ImageData sd = image.getImageData();
        boolean up = (style & 0x80) == 128;
        String key = "IMAGE:" + sd.width + "_" + sd.height + "_" + style + "_" + imgKey;
        try {
            if (resources.containsKey(key)) {
                resultImg = (Image)resources.get(key);
            } else {
                ImageData dd = new ImageData(sd.height, sd.width, sd.depth, sd.palette);
                int dx = 0;
                int dy = 0;
                for (int sx = 0; sx < sd.width; ++sx) {
                    for (int sy = 0; sy < sd.height; ++sy) {
                        dx = up ? sy : sd.height - sy - 1;
                        dy = up ? sd.width - sx - 1 : sx;
                        dd.setPixel(dx, dy, sd.getPixel(sx, sy));
                    }
                }
                Image vertical = new Image((Device)Display.getDefault(), dd);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "new image created = " + key);
                }
                resources.put(key, vertical);
                resultImg = vertical;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return resultImg;
    }

    public static Image getImage(ImageData imageData) {
        String key = "IMAGE_DATA:" + imageData.height + "_" + imageData.width + "_" + imageData.depth;
        try {
            if (resources.containsKey(key)) {
                return (Image)resources.get(key);
            }
            Image img = new Image((Device)Display.getDefault(), imageData);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "new image created = " + key);
            }
            resources.put(key, img);
            return img;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static Image getImage(ImageData imageData, String imgKey) {
        String key = "IMAGE_DATA:" + imageData.height + "_" + imageData.width + "_" + imgKey;
        try {
            if (resources.containsKey(key)) {
                return (Image)resources.get(key);
            }
            Image img = new Image((Device)Display.getDefault(), imageData);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "new image created = " + key);
            }
            resources.put(key, img);
            return img;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static Image getImage(ImageData imageData, String imgKey, int newWidth, int newHeight, boolean forceRefresh) {
        String key = "IMAGE_DATA:" + newWidth + "_" + newHeight + "_" + imgKey;
        try {
            if (resources.containsKey(key) && !forceRefresh) {
                return (Image)resources.get(key);
            }
            if (forceRefresh) {
                resources.remove(key);
            }
            Image img = new Image((Device)Display.getDefault(), imageData.scaledTo(newWidth, newHeight));
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "new image created = " + key);
            }
            resources.put(key, img);
            return img;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static Image getImage(String url) {
        String tmpUrl = null;
        try {
            tmpUrl = url.replace('\\', '/');
            if (tmpUrl.startsWith("/")) {
                tmpUrl = tmpUrl.substring(1);
            }
            if (resources.containsKey(tmpUrl)) {
                return (Image)resources.get(tmpUrl);
            }
            Image img = new Image((Device)Display.getDefault(), instance.getClass().getClassLoader().getResourceAsStream(tmpUrl));
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "new image created = " + tmpUrl);
            }
            resources.put(tmpUrl, img);
            return img;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, instance.getClass().getName() + " - " + tmpUrl);
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static Image getImage(IDevice activeDeviceInstance, String url) {
        String tmpUrl = null;
        try {
            tmpUrl = url.replace('\\', '/');
            if (tmpUrl.startsWith("/")) {
                tmpUrl = tmpUrl.substring(1);
            }
            if (resources.containsKey(tmpUrl)) {
                return (Image)resources.get(tmpUrl);
            }
            Image img = new Image((Device)Display.getDefault(), activeDeviceInstance.getClass().getClassLoader().getResourceAsStream(tmpUrl));
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "new image created = " + tmpUrl);
            }
            resources.put(tmpUrl, img);
            return img;
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, activeDeviceInstance.getName() + " - " + tmpUrl + " not found");
                Image img = new Image((Device)Display.getDefault(), (InputStream)new FileInputStream(Settings.getDevicesPath() + url.substring(url.lastIndexOf(47))));
                if (log.isLoggable(Level.FINE)) {
                    Settings.getInstance();
                    log.log(Level.FINE, "new image created = " + Settings.getDevicesPath() + url.substring(url.lastIndexOf(47)));
                }
                resources.put(tmpUrl, img);
                return img;
            }
            catch (Throwable t) {
                Settings.getInstance();
                log.log(Level.SEVERE, activeDeviceInstance.getName() + " - " + Settings.getDevicesPath() + url.substring(url.lastIndexOf(47)));
                log.log(Level.SEVERE, e.getMessage(), e);
                return SWTResourceManager.getImage(activeDeviceInstance, "resource/NoDevicePicture.jpg");
            }
        }
    }

    public static Color getColor(String rgb) {
        String name = "COLOR:" + rgb;
        if (resources.containsKey(name)) {
            return (Color)resources.get(name);
        }
        Color color = new Color((Device)Display.getDefault(), Integer.parseInt(rgb.split(",")[0]), Integer.parseInt(rgb.split(",")[1]), Integer.parseInt(rgb.split(",")[2]));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "new color created = " + name);
        }
        resources.put(name, color);
        return color;
    }

    public static Color getColor(int swtColor) {
        String name = "COLOR:" + swtColor;
        if (resources.containsKey(name)) {
            return (Color)resources.get(name);
        }
        Color color = Display.getDefault().getSystemColor(swtColor);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "new color created = " + name);
        }
        resources.put(name, color);
        return color;
    }

    public static Color getColor(int red, int green, int blue) {
        String name = "COLOR:" + red + "," + green + "," + blue;
        if (resources.containsKey(name)) {
            return (Color)resources.get(name);
        }
        Color color = new Color((Device)Display.getDefault(), red, green, blue);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "new color created = " + name);
        }
        resources.put(name, color);
        return color;
    }

    public static Color getColor(Color inColor) {
        String name = "COLOR:" + inColor.getRed() + "," + inColor.getGreen() + "," + inColor.getBlue();
        if (resources.containsKey(name)) {
            return (Color)resources.get(name);
        }
        Color color = new Color((Device)Display.getDefault(), inColor.getRed(), inColor.getGreen(), inColor.getBlue());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "new color created = " + name);
        }
        resources.put(name, color);
        return color;
    }

    public static Pattern getPattern(float x1, float y1, float x2, float y2, int swtColor1, int alpha1, int swtColor2, int alpha2) {
        String name = "PATTERN:" + x1 + "," + y1 + "," + x2 + "," + y2 + swtColor1 + "," + alpha1 + "," + swtColor2 + "," + alpha2;
        if (resources.containsKey(name)) {
            return (Pattern)resources.get(name);
        }
        Pattern pattern = new Pattern((Device)Display.getDefault(), x1, y1, x2, y2, SWTResourceManager.getColor(swtColor1), alpha1, SWTResourceManager.getColor(swtColor2), alpha2);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "new pattern created = " + name);
        }
        resources.put(name, pattern);
        return pattern;
    }

    public static Pattern getPattern(float x1, float y1, float x2, float y2, int swtColor1, int swtColor2) {
        String name = "PATTERN:" + x1 + "," + y1 + "," + x2 + "," + y2 + swtColor1 + "," + swtColor2;
        if (resources.containsKey(name)) {
            return (Pattern)resources.get(name);
        }
        Pattern pattern = new Pattern((Device)Display.getDefault(), x1, y1, x2, y2, SWTResourceManager.getColor(swtColor1), SWTResourceManager.getColor(swtColor2));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "new pattern created = " + name);
        }
        resources.put(name, pattern);
        return pattern;
    }

    public static Cursor getCursor(int type) {
        String name = "CURSOR:" + type;
        if (resources.containsKey(name)) {
            return (Cursor)resources.get(name);
        }
        Cursor cursor = new Cursor((Device)Display.getDefault(), type);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "new cursor created = " + name);
        }
        resources.put(name, cursor);
        return cursor;
    }

    public static Cursor getCursor(String url) {
        try {
            String tmpUrl = url.replace('\\', '/');
            if (tmpUrl.startsWith("/")) {
                tmpUrl = tmpUrl.substring(1);
            }
            if (resources.containsKey(tmpUrl)) {
                return (Cursor)resources.get(tmpUrl);
            }
            ImageData imgCur = new ImageData(instance.getClass().getClassLoader().getResourceAsStream(tmpUrl));
            Cursor cursor = new Cursor((Device)Display.getDefault(), imgCur, imgCur.width / 2, imgCur.height / 2);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "new cursor created = " + tmpUrl);
            }
            resources.put(url, cursor);
            return cursor;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

