/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi;

import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.InputTypes;
import gde.device.junsi.iCharger;
import gde.exception.DataInconsitsentException;
import gde.io.DataParser;
import gde.log.Level;
import java.io.FileNotFoundException;
import javax.xml.bind.JAXBException;

public class iCharger3010B
extends iCharger {
    public iCharger3010B(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
    }

    public iCharger3010B(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int deviceDataBufferSize = this.getLovDataByteSize();
        int[] points = new int[this.getNumberOfMeasurements(1)];
        int offset = 0;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        byte[] convertBuffer = new byte[deviceDataBufferSize];
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            lovDataSize = deviceDataBufferSize / 3;
            System.arraycopy(dataBuffer, offset, convertBuffer, 0, deviceDataBufferSize / 3);
            for (int j = deviceDataBufferSize / 3; j < deviceDataBufferSize; ++j) {
                convertBuffer[j] = dataBuffer[offset + j];
                ++lovDataSize;
                if (dataBuffer[offset + j] == 10 && dataBuffer[offset + j - 1] == 13) break;
            }
            recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
            offset += lovDataSize + 8;
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        DataParser data = new DataParser(this.getDataBlockTimeUnitFactor(), this.getDataBlockLeader(), this.getDataBlockSeparator().value(), null, null, Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)), this.getDataBlockFormat(InputTypes.SERIAL_IO), false);
        int[] startLength = new int[]{0, 0};
        byte[] lineBuffer = null;
        double timeStep_h = 5.555555555555556E-4;
        try {
            this.setDataLineStartAndLength(dataBuffer, startLength);
            lineBuffer = new byte[startLength[1]];
            System.arraycopy(dataBuffer, startLength[0], lineBuffer, 0, startLength[1]);
            data.parse(new String(lineBuffer), 1);
            int[] values = data.getValues();
            int cellOffset = this.getNumberOfLithiumCells() + 2;
            points[0] = values[0];
            points[1] = values[1];
            points[2] = values[2];
            points[3] = values[cellOffset + 3] * 1000;
            points[4] = Double.valueOf((double)(points[1] * points[2]) / 100.0).intValue();
            if (points[3] != 0) {
                points[5] = Double.valueOf(energySum += (double)points[4] * timeStep_h).intValue();
            } else {
                points[5] = 0;
                energySum = 0.0;
            }
            points[6] = values[cellOffset + 1];
            points[7] = values[cellOffset + 2];
            for (int i = 0; i < this.getNumberOfLithiumCells(); ++i) {
                points[i + 9] = values[i + 3];
                if (points[i + 9] <= 0) continue;
                maxVotage = points[i + 9] > maxVotage ? points[i + 9] : maxVotage;
                minVotage = points[i + 9] < minVotage ? points[i + 9] : minVotage;
            }
            points[8] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        double energy = 0.0;
        double timeStep_h = 5.555555555555556E-4;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
            points[3] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
            points[4] = Double.valueOf((double)points[1] / 1000.0 * ((double)points[2] / 1000.0) * 10000.0).intValue();
            if (i != 0) {
                energy += (double)points[4] * timeStep_h;
            }
            points[5] = Double.valueOf(energy).intValue();
            points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
            points[7] = ((convertBuffer[20] & 0xFF) << 24) + ((convertBuffer[21] & 0xFF) << 16) + ((convertBuffer[22] & 0xFF) << 8) + ((convertBuffer[23] & 0xFF) << 0);
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            int j = 0;
            int k = 0;
            while (j < 10) {
                points[j + 9] = ((convertBuffer[k + 24] & 0xFF) << 24) + ((convertBuffer[k + 25] & 0xFF) << 16) + ((convertBuffer[k + 26] & 0xFF) << 8) + ((convertBuffer[k + 27] & 0xFF) << 0);
                if (points[j + 9] > 0) {
                    maxVotage = points[j + 9] > maxVotage ? points[j + 9] : maxVotage;
                    minVotage = points[j + 9] < minVotage ? points[j + 9] : minVotage;
                }
                ++j;
                k += 4;
            }
            points[8] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public int getNumberOfLithiumCells() {
        return 10;
    }
}

