/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScroller;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    NSScroller view;
    Scrollable parent;
    int minimum;
    int maximum = 100;
    int thumb = 10;
    int increment = 1;
    int pageIncrement = 10;
    id target;
    long actionSelector;

    ScrollBar() {
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ScrollBar.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
    }

    @Override
    boolean getDrawing() {
        return this.parent.getDrawing();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        NSScroller widget = this.view;
        double value = widget.doubleValue();
        return (int)(0.5 + ((double)(this.maximum - this.thumb - this.minimum) * value + (double)this.minimum));
    }

    public Point getSize() {
        this.checkWidget();
        NSRect rect = this.view.frame();
        return new Point((int)rect.width, (int)rect.height);
    }

    public int getThumb() {
        this.checkWidget();
        return this.thumb;
    }

    public Rectangle getThumbBounds() {
        this.checkWidget();
        NSRect rect = this.view.rectForPart(2L);
        rect = this.view.convertRect_toView_(rect, this.parent.view);
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    public Rectangle getThumbTrackBounds() {
        this.checkWidget();
        NSRect rect = this.view.rectForPart(6L);
        rect = this.view.convertRect_toView_(rect, this.parent.view);
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0 && !this.view.isHidden();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    @Override
    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener2);
        this.eventTable.unhook(14, listener2);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.view, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.view != null) {
            this.view.release();
        }
        this.view = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    @Override
    void sendSelection() {
        NSPoint point;
        NSWindow window = this.view.window();
        if (this.target == null) {
            this.parent.getShell().deferFlushing();
        }
        int value = 0;
        if (this.target != null) {
            this.view.sendAction(this.actionSelector, this.target);
        } else {
            value = this.getSelection();
        }
        NSEvent nsEvent = NSApplication.sharedApplication().currentEvent();
        if (nsEvent != null) {
            point = nsEvent.locationInWindow();
            if (nsEvent.window() == null) {
                point = window.convertScreenToBase(point);
            }
        } else {
            point = window.mouseLocationOutsideOfEventStream();
        }
        int hitPart = (int)this.view.testPart(point);
        Event event = new Event();
        switch (hitPart) {
            case 4: {
                value -= this.increment;
                event.detail = 0x1000001;
                break;
            }
            case 1: {
                value -= this.pageIncrement;
                event.detail = 0x1000005;
                break;
            }
            case 5: {
                value += this.increment;
                event.detail = 0x1000002;
                break;
            }
            case 3: {
                value += this.pageIncrement;
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 1;
            }
        }
        if (this.target == null && event.detail != 1) {
            this.setSelection(value);
        }
        this.sendSelectionEvent(13, event, true);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    @Override
    void setClipRegion(NSView view) {
        this.parent.setClipRegion(view);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            if ((this.state & 8) == 0) {
                return;
            }
            this.state &= 0xFFFFFFF7;
        } else {
            if ((this.state & 8) != 0) {
                return;
            }
            this.state |= 8;
        }
        this.enableWidget(enabled);
    }

    void enableWidget(boolean enabled) {
        if (!enabled || (this.state & 8) == 0) {
            this.view.setEnabled(enabled);
        }
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        if (value <= this.minimum) {
            return;
        }
        if (value - this.minimum < this.thumb) {
            this.thumb = value - this.minimum;
        }
        int selection2 = Math.max(this.minimum, Math.min(this.getSelection(), value - this.thumb));
        this.maximum = value;
        this.updateBar(selection2, this.minimum, value, this.thumb);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        if (value >= this.maximum) {
            return;
        }
        if (this.maximum - value < this.thumb) {
            this.thumb = this.maximum - value;
        }
        int selection2 = Math.min(this.maximum - this.thumb, Math.max(this.getSelection(), value));
        this.minimum = value;
        this.updateBar(selection2, value, this.maximum, this.thumb);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int selection2) {
        this.checkWidget();
        this.updateBar(selection2, this.minimum, this.maximum, this.thumb);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        value = Math.min(value, this.maximum - this.minimum);
        this.updateBar(this.getSelection(), this.minimum, this.maximum, value);
        this.thumb = value;
    }

    public void setValues(int selection2, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        this.thumb = thumb = Math.min(thumb, maximum - minimum);
        this.maximum = maximum;
        this.minimum = minimum;
        this.increment = increment;
        this.pageIncrement = pageIncrement;
        this.updateBar(selection2, minimum, maximum, thumb);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.parent.setScrollBarVisible(this, visible);
    }

    void updateBar(int selection2, int minimum, int maximum, int thumb) {
        NSScroller widget = this.view;
        selection2 = Math.max(minimum, Math.min(maximum - thumb, selection2));
        int range = maximum - thumb - minimum;
        float fraction = range <= 0 ? 1.0f : (float)(selection2 - minimum) / (float)range;
        float knob = range <= 0 ? 1.0f : (float)thumb / (float)(maximum - minimum);
        double oldFraction = widget.doubleValue();
        double oldKnob = widget.knobProportion();
        widget.setDoubleValue(fraction);
        widget.setKnobProportion(knob);
        widget.setEnabled(range > 0);
        if (OS.VERSION >= 4208 && this.target == null && ((double)knob != oldKnob || (double)fraction != oldFraction)) {
            OS.objc_msgSend(this.parent.scrollView.id, OS.sel_flashScrollers);
        }
    }
}

