/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableCursor
extends Canvas {
    Table table;
    TableItem row = null;
    TableColumn column = null;
    Listener listener;
    Listener tableListener;
    Listener resizeListener;
    Listener disposeItemListener;
    Listener disposeColumnListener;
    Color background = null;
    Color foreground = null;
    static final int BACKGROUND = 27;
    static final int FOREGROUND = 26;

    public TableCursor(Table parent, int style) {
        super(parent, style);
        ScrollBar vBar;
        this.table = parent;
        this.setBackground(null);
        this.setForeground(null);
        this.listener = event -> {
            switch (event.type) {
                case 12: {
                    this.onDispose(event);
                    break;
                }
                case 15: 
                case 16: {
                    this.redraw();
                    break;
                }
                case 1: {
                    this.keyDown(event);
                    break;
                }
                case 9: {
                    this.paint(event);
                    break;
                }
                case 31: {
                    event.doit = true;
                    switch (event.detail) {
                        case 4: 
                        case 32: 
                        case 64: {
                            event.doit = false;
                        }
                    }
                }
            }
        };
        int[] events = new int[]{12, 15, 16, 1, 9, 31};
        int i2 = 0;
        while (i2 < events.length) {
            this.addListener(events[i2], this.listener);
            ++i2;
        }
        this.tableListener = event -> {
            switch (event.type) {
                case 3: {
                    this.tableMouseDown(event);
                    break;
                }
                case 15: {
                    this.tableFocusIn(event);
                }
            }
        };
        this.table.addListener(15, this.tableListener);
        this.table.addListener(3, this.tableListener);
        this.disposeItemListener = event -> {
            this.unhookRowColumnListeners();
            this.row = null;
            this.column = null;
            this._resize();
        };
        this.disposeColumnListener = event -> {
            this.unhookRowColumnListeners();
            this.row = null;
            this.column = null;
            this._resize();
        };
        this.resizeListener = event -> this._resize();
        ScrollBar hBar = this.table.getHorizontalBar();
        if (hBar != null) {
            hBar.addListener(13, this.resizeListener);
        }
        if ((vBar = this.table.getVerticalBar()) != null) {
            vBar.addListener(13, this.resizeListener);
        }
        this.getAccessible().addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getRole(AccessibleControlEvent e) {
                e.detail = 29;
            }
        });
        this.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent e) {
                if (TableCursor.this.row == null) {
                    return;
                }
                int columnIndex = TableCursor.this.column == null ? 0 : TableCursor.this.table.indexOf(TableCursor.this.column);
                e.result = TableCursor.this.row.getText(columnIndex);
            }
        });
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void onDispose(Event event) {
        ScrollBar vBar;
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.table.removeListener(15, this.tableListener);
        this.table.removeListener(3, this.tableListener);
        this.unhookRowColumnListeners();
        ScrollBar hBar = this.table.getHorizontalBar();
        if (hBar != null) {
            hBar.removeListener(13, this.resizeListener);
        }
        if ((vBar = this.table.getVerticalBar()) != null) {
            vBar.removeListener(13, this.resizeListener);
        }
    }

    void keyDown(Event event) {
        if (this.row == null) {
            return;
        }
        switch (event.character) {
            case '\r': {
                this.notifyListeners(14, new Event());
                return;
            }
        }
        int rowIndex = this.table.indexOf(this.row);
        int columnIndex = this.column == null ? 0 : this.table.indexOf(this.column);
        switch (event.keyCode) {
            case 0x1000001: {
                this.setRowColumn(Math.max(0, rowIndex - 1), columnIndex, true);
                break;
            }
            case 0x1000002: {
                this.setRowColumn(Math.min(rowIndex + 1, this.table.getItemCount() - 1), columnIndex, true);
                break;
            }
            case 0x1000003: 
            case 0x1000004: {
                int leadKey;
                int columnCount = this.table.getColumnCount();
                if (columnCount == 0) break;
                int[] order = this.table.getColumnOrder();
                int index = 0;
                while (index < order.length) {
                    if (order[index] == columnIndex) break;
                    ++index;
                }
                if (index == order.length) {
                    index = 0;
                }
                int n = leadKey = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                if (event.keyCode == leadKey) {
                    this.setRowColumn(rowIndex, order[Math.max(0, index - 1)], true);
                    break;
                }
                this.setRowColumn(rowIndex, order[Math.min(columnCount - 1, index + 1)], true);
                break;
            }
            case 0x1000007: {
                this.setRowColumn(0, columnIndex, true);
                break;
            }
            case 0x1000008: {
                int i2 = this.table.getItemCount() - 1;
                this.setRowColumn(i2, columnIndex, true);
                break;
            }
            case 0x1000005: {
                int index = this.table.getTopIndex();
                if (index == rowIndex) {
                    Rectangle rect = this.table.getClientArea();
                    TableItem item2 = this.table.getItem(index);
                    Rectangle itemRect = item2.getBounds(0);
                    rect.height -= itemRect.y;
                    int height = this.table.getItemHeight();
                    int page = Math.max(1, rect.height / height);
                    index = Math.max(0, index - page + 1);
                }
                this.setRowColumn(index, columnIndex, true);
                break;
            }
            case 0x1000006: {
                int index = this.table.getTopIndex();
                Rectangle rect = this.table.getClientArea();
                TableItem item3 = this.table.getItem(index);
                Rectangle itemRect = item3.getBounds(0);
                rect.height -= itemRect.y;
                int height = this.table.getItemHeight();
                int page = Math.max(1, rect.height / height);
                int end = this.table.getItemCount() - 1;
                index = Math.min(end, index + page - 1);
                if (index == rowIndex) {
                    index = Math.min(end, index + page - 1);
                }
                this.setRowColumn(index, columnIndex, true);
            }
        }
    }

    void paint(Event event) {
        String text2;
        if (this.row == null) {
            return;
        }
        int columnIndex = this.column == null ? 0 : this.table.indexOf(this.column);
        GC gc = event.gc;
        gc.setBackground(this.getBackground());
        gc.setForeground(this.getForeground());
        gc.fillRectangle(event.x, event.y, event.width, event.height);
        int x = 0;
        Point size = this.getSize();
        Image image = this.row.getImage(columnIndex);
        if (image != null) {
            Rectangle imageSize = image.getBounds();
            int imageY = (size.y - imageSize.height) / 2;
            gc.drawImage(image, x, imageY);
            x += imageSize.width;
        }
        if ((text2 = this.row.getText(columnIndex)).length() > 0) {
            int alignmnent;
            Rectangle bounds = this.row.getBounds(columnIndex);
            Point extent = gc.stringExtent(text2);
            String platform = SWT.getPlatform();
            if ("win32".equals(platform)) {
                if (this.table.getColumnCount() == 0 || columnIndex == 0) {
                    x += 2;
                } else {
                    alignmnent = this.column.getAlignment();
                    switch (alignmnent) {
                        case 16384: {
                            x += 6;
                            break;
                        }
                        case 131072: {
                            x = bounds.width - extent.x - 6;
                            break;
                        }
                        case 0x1000000: {
                            x += (bounds.width - x - extent.x) / 2;
                        }
                    }
                }
            } else if (this.table.getColumnCount() == 0) {
                x += 5;
            } else {
                alignmnent = this.column.getAlignment();
                switch (alignmnent) {
                    case 16384: {
                        x += 5;
                        break;
                    }
                    case 131072: {
                        x = bounds.width - extent.x - 2;
                        break;
                    }
                    case 0x1000000: {
                        x += (bounds.width - x - extent.x) / 2 + 2;
                    }
                }
            }
            int textY = (size.y - extent.y) / 2;
            gc.drawString(text2, x, textY);
        }
        if (this.isFocusControl()) {
            Display display = this.getDisplay();
            gc.setBackground(display.getSystemColor(2));
            gc.setForeground(display.getSystemColor(1));
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    void tableFocusIn(Event event) {
        if (this.isDisposed()) {
            return;
        }
        if (this.isVisible()) {
            if (this.row == null && this.column == null) {
                return;
            }
            this.setFocus();
        }
    }

    void tableMouseDown(Event event) {
        if (this.isDisposed() || !this.isVisible()) {
            return;
        }
        Point pt = new Point(event.x, event.y);
        int lineWidth = this.table.getLinesVisible() ? this.table.getGridLineWidth() : 0;
        TableItem item2 = this.table.getItem(pt);
        if ((this.table.getStyle() & 0x10000) != 0) {
            if (item2 == null) {
                return;
            }
        } else {
            int start = item2 != null ? this.table.indexOf(item2) : this.table.getTopIndex();
            int end = this.table.getItemCount();
            Rectangle clientRect = this.table.getClientArea();
            int i2 = start;
            while (i2 < end) {
                TableItem nextItem = this.table.getItem(i2);
                Rectangle rect = nextItem.getBounds(0);
                if (pt.y >= rect.y && pt.y < rect.y + rect.height + lineWidth) {
                    item2 = nextItem;
                    break;
                }
                if (rect.y > clientRect.y + clientRect.height) {
                    return;
                }
                ++i2;
            }
            if (item2 == null) {
                return;
            }
        }
        TableColumn newColumn = null;
        int columnCount = this.table.getColumnCount();
        if (columnCount == 0) {
            if ((this.table.getStyle() & 0x10000) == 0) {
                Rectangle rect = item2.getBounds(0);
                rect.width += lineWidth;
                rect.height += lineWidth;
                if (!rect.contains(pt)) {
                    return;
                }
            }
        } else {
            int i3 = 0;
            while (i3 < columnCount) {
                Rectangle rect = item2.getBounds(i3);
                rect.width += lineWidth;
                rect.height += lineWidth;
                if (rect.contains(pt)) {
                    newColumn = this.table.getColumn(i3);
                    break;
                }
                ++i3;
            }
            if (newColumn == null) {
                if ((this.table.getStyle() & 0x10000) == 0) {
                    return;
                }
                newColumn = this.table.getColumn(0);
            }
        }
        this.setRowColumn(item2, newColumn, true);
        this.setFocus();
    }

    void setRowColumn(int row2, int column2, boolean notify) {
        TableItem item2 = row2 == -1 ? null : this.table.getItem(row2);
        TableColumn col = column2 == -1 || this.table.getColumnCount() == 0 ? null : this.table.getColumn(column2);
        this.setRowColumn(item2, col, notify);
    }

    void setRowColumn(TableItem row2, TableColumn column2, boolean notify) {
        if (this.row == row2 && this.column == column2) {
            return;
        }
        if (this.row != null && this.row != row2) {
            this.row.removeListener(12, this.disposeItemListener);
            this.row = null;
        }
        if (this.column != null && this.column != column2) {
            this.column.removeListener(12, this.disposeColumnListener);
            this.column.removeListener(10, this.resizeListener);
            this.column.removeListener(11, this.resizeListener);
            this.column = null;
        }
        if (row2 != null) {
            if (this.row != row2) {
                this.row = row2;
                row2.addListener(12, this.disposeItemListener);
                this.table.showItem(row2);
            }
            if (this.column != column2 && column2 != null) {
                this.column = column2;
                column2.addListener(12, this.disposeColumnListener);
                column2.addListener(10, this.resizeListener);
                column2.addListener(11, this.resizeListener);
                this.table.showColumn(column2);
            }
            int columnIndex = column2 == null ? 0 : this.table.indexOf(column2);
            this.setBounds(row2.getBounds(columnIndex));
            this.redraw();
            if (notify) {
                this.notifyListeners(13, new Event());
            }
        }
        this.getAccessible().setFocus(-1);
    }

    @Override
    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            this._resize();
        }
        super.setVisible(visible);
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener2);
        this.removeListener(14, listener2);
    }

    void _resize() {
        if (this.row == null) {
            this.setBounds(-200, -200, 0, 0);
        } else {
            int columnIndex = this.column == null ? 0 : this.table.indexOf(this.column);
            this.setBounds(this.row.getBounds(columnIndex));
        }
    }

    public int getColumn() {
        this.checkWidget();
        return this.column == null ? 0 : this.table.indexOf(this.column);
    }

    @Override
    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.getDisplay().getSystemColor(27);
        }
        return this.background;
    }

    @Override
    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.getDisplay().getSystemColor(26);
        }
        return this.foreground;
    }

    public TableItem getRow() {
        this.checkWidget();
        return this.row;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
        super.setBackground(this.getBackground());
        this.redraw();
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
        super.setForeground(this.getForeground());
        this.redraw();
    }

    public void setSelection(int row2, int column2) {
        int maxColumnIndex;
        this.checkWidget();
        int columnCount = this.table.getColumnCount();
        int n = maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
        if (row2 < 0 || row2 >= this.table.getItemCount() || column2 < 0 || column2 > maxColumnIndex) {
            SWT.error(5);
        }
        this.setRowColumn(row2, column2, false);
    }

    public void setSelection(TableItem row2, int column2) {
        int maxColumnIndex;
        this.checkWidget();
        int columnCount = this.table.getColumnCount();
        int n = maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
        if (row2 == null || row2.isDisposed() || column2 < 0 || column2 > maxColumnIndex) {
            SWT.error(5);
        }
        this.setRowColumn(this.table.indexOf(row2), column2, false);
    }

    void unhookRowColumnListeners() {
        if (this.column != null) {
            this.column.removeListener(12, this.disposeColumnListener);
            this.column.removeListener(10, this.resizeListener);
            this.column.removeListener(11, this.resizeListener);
            this.column = null;
        }
        if (this.row != null) {
            this.row.removeListener(12, this.disposeItemListener);
            this.row = null;
        }
    }
}

