/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class CharValue
extends IntegerValueConstant<Character> {
    @Override
    @NotNull
    public SimpleType getType(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        SimpleType simpleType2 = module.getBuiltIns().getCharType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "module.builtIns.charType");
        return simpleType2;
    }

    @Override
    @NotNull
    public String toString() {
        String string2 = "\\u%04X ('%s')";
        Object[] objectArray = new Object[]{(int)((Character)this.getValue()).charValue(), this.getPrintablePart(((Character)this.getValue()).charValue())};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
        return string3;
    }

    private final String getPrintablePart(char c) {
        String string2;
        switch (c) {
            case '\b': {
                string2 = "\\b";
                break;
            }
            case '\t': {
                string2 = "\\t";
                break;
            }
            case '\n': {
                string2 = "\\n";
                break;
            }
            case '\f': {
                string2 = "\\f";
                break;
            }
            case '\r': {
                string2 = "\\r";
                break;
            }
            default: {
                String string3 = this.isPrintableUnicode(c) ? Character.toString(c) : "?";
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull(string3, "if (isPrintableUnicode(c\u2026cter.toString(c) else \"?\"");
            }
        }
        return string2;
    }

    private final boolean isPrintableUnicode(char c) {
        byte t = (byte)Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    public CharValue(char value) {
        super(Character.valueOf(value));
    }
}

