/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.util.WrapperTemplateModel;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateModelWithAPISupport;
import freemarker.template.WrappingTemplateModel;
import freemarker.template.utility.ObjectWrapperWithAPISupport;
import java.io.Serializable;
import java.util.Iterator;

public class DefaultIteratorAdapter
extends WrappingTemplateModel
implements TemplateCollectionModel,
AdapterTemplateModel,
WrapperTemplateModel,
TemplateModelWithAPISupport,
Serializable {
    private final Iterator iterator;
    private boolean iteratorOwnedBySomeone;

    public static DefaultIteratorAdapter adapt(Iterator iterator2, ObjectWrapper wrapper) {
        return new DefaultIteratorAdapter(iterator2, wrapper);
    }

    private DefaultIteratorAdapter(Iterator iterator2, ObjectWrapper wrapper) {
        super(wrapper);
        this.iterator = iterator2;
    }

    public Object getWrappedObject() {
        return this.iterator;
    }

    public Object getAdaptedObject(Class hint) {
        return this.getWrappedObject();
    }

    public TemplateModelIterator iterator() throws TemplateModelException {
        return new SimpleTemplateModelIterator();
    }

    public TemplateModel getAPI() throws TemplateModelException {
        return ((ObjectWrapperWithAPISupport)this.getObjectWrapper()).wrapAsAPI(this.iterator);
    }

    private class SimpleTemplateModelIterator
    implements TemplateModelIterator {
        private boolean iteratorOwnedByMe;

        private SimpleTemplateModelIterator() {
        }

        public TemplateModel next() throws TemplateModelException {
            if (!this.iteratorOwnedByMe) {
                this.checkNotOwner();
                DefaultIteratorAdapter.this.iteratorOwnedBySomeone = true;
                this.iteratorOwnedByMe = true;
            }
            if (!DefaultIteratorAdapter.this.iterator.hasNext()) {
                throw new TemplateModelException("The collection has no more items.");
            }
            Object value = DefaultIteratorAdapter.this.iterator.next();
            return value instanceof TemplateModel ? (TemplateModel)value : DefaultIteratorAdapter.this.wrap(value);
        }

        public boolean hasNext() throws TemplateModelException {
            if (!this.iteratorOwnedByMe) {
                this.checkNotOwner();
            }
            return DefaultIteratorAdapter.this.iterator.hasNext();
        }

        private void checkNotOwner() throws TemplateModelException {
            if (DefaultIteratorAdapter.this.iteratorOwnedBySomeone) {
                throw new TemplateModelException("This collection value wraps a java.util.Iterator, thus it can be listed only once.");
            }
        }
    }
}

