/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.servlet;

import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HttpRequestHashModel
implements TemplateHashModelEx {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ObjectWrapper wrapper;

    public HttpRequestHashModel(HttpServletRequest request, ObjectWrapper wrapper) {
        this(request, null, wrapper);
    }

    public HttpRequestHashModel(HttpServletRequest request, HttpServletResponse response, ObjectWrapper wrapper) {
        this.request = request;
        this.response = response;
        this.wrapper = wrapper;
    }

    public TemplateModel get(String key2) throws TemplateModelException {
        return this.wrapper.wrap(this.request.getAttribute(key2));
    }

    public boolean isEmpty() {
        return !this.request.getAttributeNames().hasMoreElements();
    }

    public int size() {
        int result2 = 0;
        Enumeration enumeration = this.request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++result2;
        }
        return result2;
    }

    public TemplateCollectionModel keys() {
        ArrayList keys2 = new ArrayList();
        Enumeration enumeration = this.request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            keys2.add(enumeration.nextElement());
        }
        return new SimpleCollection(keys2.iterator());
    }

    public TemplateCollectionModel values() {
        ArrayList<Object> values2 = new ArrayList<Object>();
        Enumeration enumeration = this.request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            values2.add(this.request.getAttribute((String)enumeration.nextElement()));
        }
        return new SimpleCollection(values2.iterator(), this.wrapper);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ObjectWrapper getObjectWrapper() {
        return this.wrapper;
    }
}

