/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.voice;

import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\"\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/treichels/hott/voice/VolumeControlAudioInputStream;", "Ljavax/sound/sampled/AudioInputStream;", "source", "volume", "", "(Ljavax/sound/sampled/AudioInputStream;D)V", "Ljava/io/InputStream;", "streamFormat", "Ljavax/sound/sampled/AudioFormat;", "(Ljava/io/InputStream;Ljavax/sound/sampled/AudioFormat;D)V", "read", "", "b", "", "off", "len", "HoTT-Voice"})
public final class VolumeControlAudioInputStream
extends AudioInputStream {
    private final InputStream source;
    private final AudioFormat streamFormat;
    private final double volume;

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(@Nullable byte[] b, int off, int len) {
        if (b == null) {
            return 0;
        }
        int bytesRead = super.read(b, off, len);
        IntProgression intProgression = RangesKt.step(RangesKt.until(0, bytesRead), 2);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i2;
                short value = (short)(b[i2] & 0xFF | (b[i2 + true] & 0xFF) << 8);
                int value2 = (int)((double)value * this.volume);
                value2 = Math.max(value2, Short.MIN_VALUE);
                value2 = Math.min(value2, Short.MAX_VALUE);
                b[i2] = (byte)(value2 & 0xFF);
                b[i2 + true] = (byte)((value2 & 0xFF00) >>> 8);
                if (i2 == n2) break;
                i2 += n3;
            }
        }
        return bytesRead;
    }

    public VolumeControlAudioInputStream(@NotNull InputStream source, @NotNull AudioFormat streamFormat, double volume) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(streamFormat, "streamFormat");
        super(source, streamFormat, -1);
        this.source = source;
        this.streamFormat = streamFormat;
        this.volume = volume;
    }

    public VolumeControlAudioInputStream(@NotNull AudioInputStream source, double volume) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        InputStream inputStream2 = source;
        AudioFormat audioFormat = source.getFormat();
        Intrinsics.checkExpressionValueIsNotNull(audioFormat, "source.format");
        this(inputStream2, audioFormat, volume);
    }
}

