/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.LogManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\bJ\u0012\u0010\u0018\u001a\u00020\b2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aJ\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J\u0012\u0010\u001d\u001a\u00020\b2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/treichels/hott/util/Util;", "", "()V", "DEBUG", "", "getDEBUG", "()Z", "LATEST_VERSIONS_URL", "", "OFFLINE", "getOFFLINE", "PARAM_DEBUG", "PARAM_OFFLINE", "latestVersions", "Ljava/util/Properties;", "dumpData", "data", "", "baseAddress", "", "enableLogging", "", "getLatestVersion", "key", "programDir", "clazz", "Lkotlin/reflect/KClass;", "sourceLocation", "Ljava/io/File;", "sourceVersion", "HoTT-Util"})
public final class Util {
    private static final String PARAM_OFFLINE = "offline";
    private static final String PARAM_DEBUG = "debug";
    private static final String LATEST_VERSIONS_URL = "https://drive.google.com/uc?export=download&id=0B_uPguA0xiT4SUl1V1VKYXFjWHc";
    private static final Properties latestVersions;
    private static final boolean OFFLINE;
    private static final boolean DEBUG;
    public static final Util INSTANCE;

    public final boolean getOFFLINE() {
        return OFFLINE;
    }

    public final boolean getDEBUG() {
        return DEBUG;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String dumpData(@Nullable byte[] data2, int baseAddress) {
        StringBuilder sb = new StringBuilder();
        if (data2 != null) {
            void addr;
            int len = data2.length;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            while (addr.element < len) {
                void $receiver$iv;
                int i22;
                String string2;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string3 = "0x%04x: ";
                Object object = new Object[]{baseAddress + addr.element};
                StringBuilder stringBuilder = sb;
                Intrinsics.checkExpressionValueIsNotNull(String.format(string3, Arrays.copyOf(object, ((Object[])object).length)), "java.lang.String.format(format, *args)");
                stringBuilder.append(string2);
                int n = 0;
                int n2 = 15;
                while (n <= n2) {
                    if (addr.element + i22 < len) {
                        switch (i22) {
                            case 4: 
                            case 12: {
                                sb.append(':');
                                break;
                            }
                            case 0: 
                            case 8: {
                                sb.append('|');
                                break;
                            }
                            default: {
                                sb.append(' ');
                            }
                        }
                        object = StringCompanionObject.INSTANCE;
                        String string4 = "%02x";
                        Object[] objectArray = new Object[]{data2[addr.element + i22]};
                        stringBuilder = sb;
                        Intrinsics.checkExpressionValueIsNotNull(String.format(string4, Arrays.copyOf(objectArray, objectArray.length)), "java.lang.String.format(format, *args)");
                        stringBuilder.append(string2);
                    } else {
                        sb.append("   ");
                    }
                    ++i22;
                }
                sb.append("| ");
                i22 = 0;
                Sequence i22 = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence(new IntRange(i22, 15)), (Function1)new Function1<Integer, Boolean>(len, (Ref.IntRef)addr){
                    final /* synthetic */ int $len;
                    final /* synthetic */ Ref.IntRef $addr;

                    public final boolean invoke(int it) {
                        return this.$addr.element + it < this.$len;
                    }
                    {
                        this.$len = n;
                        this.$addr = intRef;
                        super(1);
                    }
                }), (Function1)new Function1<Integer, Character>(data2, (Ref.IntRef)addr){
                    final /* synthetic */ byte[] $data;
                    final /* synthetic */ Ref.IntRef $addr;

                    public final char invoke(int it) {
                        return (char)(this.$data[this.$addr.element + it] & 0xFF);
                    }
                    {
                        this.$data = byArray;
                        this.$addr = intRef;
                        super(1);
                    }
                });
                for (Object element$iv : $receiver$iv) {
                    char it = ((Character)element$iv).charValue();
                    char c = it;
                    if (' ' <= c && '~' >= c) {
                        sb.append(it);
                        continue;
                    }
                    sb.append('.');
                }
                sb.append('\n');
                addr.element += 16;
            }
        }
        String string5 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string5, "sb.toString()");
        return string5;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ String dumpData$default(Util util, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return util.dumpData(byArray, n);
    }

    @JvmOverloads
    @NotNull
    public final String dumpData(@Nullable byte[] data2) {
        return Util.dumpData$default(this, data2, 0, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getLatestVersion(@NotNull String key2) {
        Intrinsics.checkParameterIsNotNull(key2, "key");
        if (latestVersions.isEmpty()) {
            try {
                Closeable closeable = new URL(LATEST_VERSIONS_URL).openStream();
                Throwable throwable = null;
                try {
                    Object object;
                    InputStream is = (InputStream)closeable;
                    Closeable closeable2 = new InputStreamReader(is);
                    Throwable throwable2 = null;
                    try {
                        InputStreamReader reader = (InputStreamReader)closeable2;
                        latestVersions.load(reader);
                        object = latestVersions.setProperty(PARAM_OFFLINE, String.valueOf(Boolean.FALSE));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable2, throwable2);
                    }
                    Object object2 = object;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (IOException e) {
                latestVersions.setProperty(PARAM_OFFLINE, String.valueOf(Boolean.TRUE));
            }
        }
        return latestVersions.getProperty(key2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String sourceVersion(@NotNull KClass<?> clazz) {
        File file;
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        File source = file = this.sourceLocation(clazz);
        String string2 = source.getName();
        Intrinsics.checkExpressionValueIsNotNull(string2, "source.name");
        if (!StringsKt.endsWith$default(string2, ".jar", false, 2, null)) {
            String string3 = source.getName();
            Intrinsics.checkExpressionValueIsNotNull(string3, "source.name");
            if (!StringsKt.endsWith$default(string3, ".exe", false, 2, null)) return "Unknown";
        }
        Closeable closeable = new JarFile(source);
        Throwable throwable = null;
        try {
            JarFile jarFile = (JarFile)closeable;
            Manifest manifest = jarFile.getManifest();
            Intrinsics.checkExpressionValueIsNotNull(manifest, "jarFile.manifest");
            Attributes attributes = manifest.getMainAttributes();
            String version = attributes.getValue("Implementation-Version");
            String build = attributes.getValue("Implementation-Build");
            String string4 = 'v' + version + '.' + build;
            String string5 = string4;
            return string5;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @NotNull
    public final String programDir(@NotNull KClass<?> clazz) {
        String string2;
        File programDir;
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        File file = programDir = this.sourceLocation(clazz).getParentFile();
        Intrinsics.checkExpressionValueIsNotNull(file, "programDir");
        if (Intrinsics.areEqual(file.getName(), "target")) {
            File file2 = programDir.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull(file2, "programDir.parentFile");
            string2 = file2.getAbsolutePath();
        } else {
            string2 = programDir.getAbsolutePath();
        }
        String result2 = string2;
        System.setProperty("program.dir", result2);
        String string3 = result2;
        Intrinsics.checkExpressionValueIsNotNull(string3, "result");
        return string3;
    }

    private final File sourceLocation(KClass<?> clazz) {
        ProtectionDomain protectionDomain = JvmClassMappingKt.getJavaClass(clazz).getProtectionDomain();
        Intrinsics.checkExpressionValueIsNotNull(protectionDomain, "clazz.java.protectionDomain");
        CodeSource codeSource = protectionDomain.getCodeSource();
        Intrinsics.checkExpressionValueIsNotNull(codeSource, "clazz.java.protectionDomain.codeSource");
        return new File(codeSource.getLocation().toURI());
    }

    public final void enableLogging() {
        if (DEBUG) {
            LogManager.getLogManager().readConfiguration(ClassLoader.getSystemResourceAsStream("logging.properties"));
        }
    }

    private Util() {
    }

    static {
        Util util;
        INSTANCE = util = new Util();
        latestVersions = new Properties();
        OFFLINE = Boolean.getBoolean(PARAM_OFFLINE);
        DEBUG = Boolean.getBoolean(PARAM_DEBUG);
    }
}

