/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder.internal.commands;

import de.treichels.hott.decoder.internal.commands.BaseCommand;
import de.treichels.hott.decoder.internal.commands.BaseResponse;
import de.treichels.hott.decoder.internal.commands.PCMD;
import de.treichels.hott.decoder.internal.io.HoTTReader;
import de.treichels.hott.model.HoTTException;
import de.treichels.hott.serial.FileType;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lde/treichels/hott/decoder/internal/commands/FileStatus;", "Lde/treichels/hott/decoder/internal/commands/BaseCommand;", "path", "", "(Ljava/lang/String;)V", "response", "Lde/treichels/hott/decoder/internal/commands/FileStatus$Response;", "getResponse", "()Lde/treichels/hott/decoder/internal/commands/FileStatus$Response;", "Companion", "Response", "HoTT-Decoder"})
public final class FileStatus
extends BaseCommand {
    @NotNull
    private final Response response;
    @NotNull
    private static final Calendar calendar;
    public static final Companion Companion;

    @Override
    @NotNull
    public Response getResponse() {
        return this.response;
    }

    public FileStatus(@NotNull String path2) {
        Intrinsics.checkParameterIsNotNull(path2, "path");
        super(PCMD.FILE_STATUS, path2.length() + 1);
        this.getWriter().writeString(path2 + '\u0000');
        this.response = new Response();
    }

    static {
        Companion = new Companion(null);
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull(calendar, "Calendar.getInstance()");
        FileStatus.calendar = calendar;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lde/treichels/hott/decoder/internal/commands/FileStatus$Response;", "Lde/treichels/hott/decoder/internal/commands/BaseResponse;", "()V", "fileType", "Lde/treichels/hott/serial/FileType;", "getFileType", "()Lde/treichels/hott/serial/FileType;", "setFileType", "(Lde/treichels/hott/serial/FileType;)V", "modifyDate", "Ljava/util/Date;", "getModifyDate", "()Ljava/util/Date;", "setModifyDate", "(Ljava/util/Date;)V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "size", "", "getSize", "()I", "setSize", "(I)V", "dumpData", "initData", "", "HoTT-Decoder"})
    public static final class Response
    extends BaseResponse {
        private int size;
        @NotNull
        public Date modifyDate;
        @NotNull
        public String name;
        @NotNull
        public FileType fileType;

        public final int getSize() {
            return this.size;
        }

        public final void setSize(int n) {
            this.size = n;
        }

        @NotNull
        public final Date getModifyDate() {
            Date date = this.modifyDate;
            if (date == null) {
                Intrinsics.throwUninitializedPropertyAccessException("modifyDate");
            }
            return date;
        }

        public final void setModifyDate(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull(date, "<set-?>");
            this.modifyDate = date;
        }

        @NotNull
        public final String getName() {
            String string2 = this.name;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("name");
            }
            return string2;
        }

        public final void setName(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull(string2, "<set-?>");
            this.name = string2;
        }

        @NotNull
        public final FileType getFileType() {
            FileType fileType = this.fileType;
            if (fileType == null) {
                Intrinsics.throwUninitializedPropertyAccessException("fileType");
            }
            return fileType;
        }

        public final void setFileType(@NotNull FileType fileType) {
            Intrinsics.checkParameterIsNotNull((Object)fileType, "<set-?>");
            this.fileType = fileType;
        }

        @Override
        protected void initData() {
            if (this.getData().length >= 9) {
                FileType fileType;
                HoTTReader hoTTReader;
                HoTTReader $receiver = hoTTReader = this.getReader();
                this.size = $receiver.readInt();
                int date = $receiver.readShort();
                int day = date & 0x1F;
                int month = (date & 0x1E0) >> 5;
                int year = 1980 + ((date & 0xFE00) >> 9);
                int time = $receiver.readShort();
                int second = (time & 0x1F) * 2;
                int minute = (time & 0x7E0) >> 5;
                int hour = (time & 0xF800) >> 11;
                Companion.getCalendar().set(year, month - 1, day, hour, minute, second);
                Date date2 = Companion.getCalendar().getTime();
                Intrinsics.checkExpressionValueIsNotNull(date2, "calendar.time");
                this.modifyDate = date2;
                int type2 = this.getData()[8] & 0x30;
                switch (type2) {
                    case 16: {
                        fileType = FileType.Dir;
                        break;
                    }
                    case 32: {
                        fileType = FileType.File;
                        break;
                    }
                    default: {
                        throw (Throwable)new HoTTException("FileStatus.UnknownFileType", type2);
                    }
                }
                this.fileType = fileType;
                this.name = $receiver.readString(this.getData().length - 10);
            }
        }

        @Override
        @NotNull
        protected String dumpData() {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "Name: %3$s, Size %1$d, Modify Date: %2$tF %2$tT";
            Object[] objectArray = new Object[3];
            objectArray[0] = this.size;
            Date date = this.modifyDate;
            if (date == null) {
                Intrinsics.throwUninitializedPropertyAccessException("modifyDate");
            }
            objectArray[1] = date;
            String string3 = this.name;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("name");
            }
            objectArray[2] = string3;
            Object[] objectArray2 = objectArray;
            String string4 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull(string4, "java.lang.String.format(format, *args)");
            return string4;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/treichels/hott/decoder/internal/commands/FileStatus$Companion;", "", "()V", "calendar", "Ljava/util/Calendar;", "getCalendar", "()Ljava/util/Calendar;", "HoTT-Decoder"})
    public static final class Companion {
        @NotNull
        public final Calendar getCalendar() {
            return calendar;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

