/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.IDN;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

final class PublicSuffixes {
    private static final PlatformLogger logger = PlatformLogger.getLogger(PublicSuffixes.class.getName());
    private static final Map<String, Rule> RULES = PublicSuffixes.loadRules("effective_tld_names.dat");

    private PublicSuffixes() {
        throw new AssertionError();
    }

    static boolean isPublicSuffix(String string2) {
        String string3;
        if (string2.length() == 0) {
            return false;
        }
        Rule rule = RULES.get(string2);
        if (rule == Rule.EXCEPTION_RULE) {
            return false;
        }
        if (rule == Rule.SIMPLE_RULE || rule == Rule.WILDCARD_RULE) {
            return true;
        }
        int n = string2.indexOf(46) + 1;
        if (n == 0) {
            n = string2.length();
        }
        return RULES.get(string3 = string2.substring(n)) == Rule.WILDCARD_RULE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Rule> loadRules(String string2) {
        logger.finest("resourceName: [{0}]", string2);
        Map<String, Rule> map2 = null;
        InputStream inputStream2 = PublicSuffixes.class.getResourceAsStream(string2);
        if (inputStream2 != null) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream2, "UTF-8"));
                map2 = PublicSuffixes.loadRules(bufferedReader);
            }
            catch (IOException iOException) {
                logger.warning("Unexpected error", iOException);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    logger.warning("Unexpected error", iOException);
                }
            }
        } else {
            logger.warning("Resource not found: [{0}]", string2);
        }
        Map<Object, Object> map3 = map2 = map2 != null ? Collections.unmodifiableMap(map2) : Collections.emptyMap();
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("result: {0}", PublicSuffixes.toLogString(map2));
        }
        return map2;
    }

    private static Map<String, Rule> loadRules(BufferedReader bufferedReader) throws IOException {
        String string2;
        LinkedHashMap<String, Rule> linkedHashMap = new LinkedHashMap<String, Rule>();
        while ((string2 = bufferedReader.readLine()) != null) {
            Rule rule;
            if ((string2 = string2.split("\\s+", 2)[0]).length() == 0 || string2.startsWith("//")) continue;
            if (string2.startsWith("!")) {
                string2 = string2.substring(1);
                rule = Rule.EXCEPTION_RULE;
            } else if (string2.startsWith("*.")) {
                string2 = string2.substring(2);
                rule = Rule.WILDCARD_RULE;
            } else {
                rule = Rule.SIMPLE_RULE;
            }
            try {
                string2 = IDN.toASCII(string2, 1);
            }
            catch (Exception exception) {
                logger.warning(String.format("Error parsing rule: [%s]", string2), exception);
                continue;
            }
            linkedHashMap.put(string2, rule);
        }
        return linkedHashMap;
    }

    private static String toLogString(Map<String, Rule> map2) {
        if (map2.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Rule> entry : map2.entrySet()) {
            stringBuilder.append(String.format("%n    ", new Object[0]));
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append((Object)entry.getValue());
        }
        return stringBuilder.toString();
    }

    private static enum Rule {
        SIMPLE_RULE,
        WILDCARD_RULE,
        EXCEPTION_RULE;

    }
}

