/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.KeyBinding;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class TabPaneBehavior
extends BehaviorBase<TabPane> {
    private final InputMap<TabPane> tabPaneInputMap = this.createInputMap();

    public TabPaneBehavior(TabPane tabPane) {
        super(tabPane);
        this.addDefaultMapping(this.tabPaneInputMap, new InputMap.KeyMapping(KeyCode.UP, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.selectPreviousTab())), new InputMap.KeyMapping(KeyCode.DOWN, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.selectNextTab())), new InputMap.KeyMapping(KeyCode.LEFT, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.rtl((Node)tabPane, this::selectNextTab, this::selectPreviousTab))), new InputMap.KeyMapping(KeyCode.RIGHT, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.rtl((Node)tabPane, this::selectPreviousTab, this::selectNextTab))), new InputMap.KeyMapping(KeyCode.HOME, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> {
            if (((TabPane)this.getNode()).isFocused()) {
                this.moveSelection(-1, 1);
            }
        })), new InputMap.KeyMapping(KeyCode.END, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> {
            if (((TabPane)this.getNode()).isFocused()) {
                this.moveSelection(((TabPane)this.getNode()).getTabs().size(), -1);
            }
        })), new InputMap.KeyMapping(new KeyBinding(KeyCode.PAGE_UP).ctrl(), (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.selectPreviousTab())), new InputMap.KeyMapping(new KeyBinding(KeyCode.PAGE_DOWN).ctrl(), (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.selectNextTab())), new InputMap.KeyMapping(new KeyBinding(KeyCode.TAB).ctrl(), (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.selectNextTab())), new InputMap.KeyMapping(new KeyBinding(KeyCode.TAB).ctrl().shift(), (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.selectPreviousTab())), new InputMap.MouseMapping((EventType<MouseEvent>)MouseEvent.MOUSE_PRESSED, (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> ((TabPane)this.getNode()).requestFocus())));
    }

    @Override
    public InputMap<TabPane> getInputMap() {
        return this.tabPaneInputMap;
    }

    public void selectTab(Tab tab2) {
        ((TabPane)this.getNode()).getSelectionModel().select((Object)tab2);
    }

    public boolean canCloseTab(Tab tab2) {
        Event event = new Event((Object)tab2, (EventTarget)tab2, Tab.TAB_CLOSE_REQUEST_EVENT);
        Event.fireEvent((EventTarget)tab2, (Event)event);
        return !event.isConsumed();
    }

    public void closeTab(Tab tab2) {
        TabPane tabPane = (TabPane)this.getNode();
        int n = tabPane.getTabs().indexOf((Object)tab2);
        if (n != -1) {
            tabPane.getTabs().remove(n);
        }
        if (tab2.getOnClosed() != null) {
            Event.fireEvent((EventTarget)tab2, (Event)new Event(Tab.CLOSED_EVENT));
        }
    }

    public void selectNextTab() {
        this.moveSelection(1);
    }

    public void selectPreviousTab() {
        this.moveSelection(-1);
    }

    private void moveSelection(int n) {
        this.moveSelection(((TabPane)this.getNode()).getSelectionModel().getSelectedIndex(), n);
    }

    private void moveSelection(int n, int n2) {
        TabPane tabPane = (TabPane)this.getNode();
        if (tabPane.getTabs().isEmpty()) {
            return;
        }
        int n3 = this.findValidTab(n, n2);
        if (n3 > -1) {
            SingleSelectionModel singleSelectionModel = tabPane.getSelectionModel();
            singleSelectionModel.select(n3);
        }
        tabPane.requestFocus();
    }

    private int findValidTab(int n, int n2) {
        TabPane tabPane = (TabPane)this.getNode();
        ObservableList observableList = tabPane.getTabs();
        int n3 = observableList.size();
        int n4 = n;
        do {
            Tab tab2;
            if ((tab2 = (Tab)observableList.get(n4 = this.nextIndex(n4 + n2, n3))) == null || tab2.isDisable()) continue;
            return n4;
        } while (n4 != n);
        return -1;
    }

    private int nextIndex(int n, int n2) {
        int n3 = n % n2;
        if (n3 > 0 && n2 < 0) {
            n3 = n3 + n2 - 0;
        } else if (n3 < 0 && n2 > 0) {
            n3 = n3 + n2 - 0;
        }
        return n3;
    }
}

