/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;

public abstract class SelectedItemsReadOnlyObservableList<E>
extends ObservableListBase<E> {
    private final ObservableList<Integer> selectedIndices;
    private ObservableList<E> itemsList;
    private boolean itemsListChanged = false;
    private ListChangeListener.Change<? extends E> itemsListChange;
    private final ListChangeListener itemsListListener = change -> {
        this.itemsListChanged = true;
        this.itemsListChange = change;
    };
    private final Supplier<Integer> modelSizeSupplier;
    private final List<WeakReference<E>> itemsRefList;

    public SelectedItemsReadOnlyObservableList(ObservableList<Integer> observableList, Supplier<Integer> supplier) {
        this.modelSizeSupplier = supplier;
        this.selectedIndices = observableList;
        this.itemsRefList = new ArrayList<WeakReference<E>>();
        observableList.addListener(change -> {
            this.beginChange();
            while (change.next()) {
                if (change.wasReplaced()) {
                    List<E> list2;
                    List<E> list3 = this.getRemovedElements((ListChangeListener.Change<Integer>)change);
                    if (list3.equals(list2 = this.getAddedElements((ListChangeListener.Change<Integer>)change))) continue;
                    this.nextReplace(change.getFrom(), change.getTo(), list3);
                    continue;
                }
                if (change.wasAdded()) {
                    this.nextAdd(change.getFrom(), change.getTo());
                    continue;
                }
                if (change.wasRemoved()) {
                    int n = change.getRemovedSize();
                    if (n == 1) {
                        this.nextRemove(change.getFrom(), this.getRemovedModelItem(change.getFrom()));
                        continue;
                    }
                    this.nextRemove(change.getFrom(), this.getRemovedElements((ListChangeListener.Change<Integer>)change));
                    continue;
                }
                if (change.wasPermutated()) {
                    int[] nArray = new int[this.size()];
                    for (int j = 0; j < this.size(); ++j) {
                        nArray[j] = change.getPermutation(j);
                    }
                    this.nextPermutation(change.getFrom(), change.getTo(), nArray);
                    continue;
                }
                if (!change.wasUpdated()) continue;
                for (int j = change.getFrom(); j < change.getTo(); ++j) {
                    this.nextUpdate(j);
                }
            }
            this.itemsRefList.clear();
            Iterator iterator2 = observableList.iterator();
            while (iterator2.hasNext()) {
                int n = (Integer)iterator2.next();
                this.itemsRefList.add(new WeakReference<E>(this.getModelItem(n)));
            }
            this.itemsListChanged = false;
            this.itemsListChange = null;
            this.endChange();
        });
    }

    protected abstract E getModelItem(int var1);

    public E get(int n) {
        int n2 = (Integer)this.selectedIndices.get(n);
        return this.getModelItem(n2);
    }

    public int size() {
        return this.selectedIndices.size();
    }

    public void setItemsList(ObservableList<E> observableList) {
        if (this.itemsList != null) {
            this.itemsList.removeListener(this.itemsListListener);
        }
        this.itemsList = observableList;
        if (observableList != null) {
            observableList.addListener(this.itemsListListener);
        }
    }

    private E _getModelItem(int n) {
        if (n >= this.modelSizeSupplier.get()) {
            return this.getRemovedModelItem(n);
        }
        return this.getModelItem(n);
    }

    private E getRemovedModelItem(int n) {
        return n < 0 || n >= this.itemsRefList.size() ? null : (E)this.itemsRefList.get(n).get();
    }

    private List<E> getRemovedElements(ListChangeListener.Change<? extends Integer> change) {
        int n;
        ArrayList<E> arrayList = new ArrayList<E>(change.getRemovedSize());
        int n2 = n + change.getRemovedSize();
        for (int j = n = change.getFrom(); j < n2; ++j) {
            arrayList.add(this.getRemovedModelItem(j));
        }
        return arrayList;
    }

    private List<E> getAddedElements(ListChangeListener.Change<? extends Integer> change) {
        ArrayList<E> arrayList = new ArrayList<E>(change.getAddedSize());
        Iterator iterator2 = change.getAddedSubList().iterator();
        while (iterator2.hasNext()) {
            int n = (Integer)iterator2.next();
            arrayList.add(this._getModelItem(n));
        }
        return arrayList;
    }
}

