/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.logging;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class PlatformLogger
implements System.Logger {
    private static final Map<String, WeakReference<PlatformLogger>> loggers = new HashMap<String, WeakReference<PlatformLogger>>();
    private final System.Logger loggerProxy;
    private boolean loggingEnabled = true;

    private System.Logger.Level getSystemLoggerLevel(Level level) {
        switch (level) {
            case ALL: {
                return System.Logger.Level.ALL;
            }
            case FINEST: {
                return System.Logger.Level.TRACE;
            }
            case FINER: {
                return System.Logger.Level.TRACE;
            }
            case FINE: {
                return System.Logger.Level.DEBUG;
            }
            case INFO: {
                return System.Logger.Level.INFO;
            }
            case WARNING: {
                return System.Logger.Level.WARNING;
            }
            case SEVERE: {
                return System.Logger.Level.ERROR;
            }
            case OFF: {
                return System.Logger.Level.OFF;
            }
        }
        return System.Logger.Level.ALL;
    }

    public static synchronized PlatformLogger getLogger(String string2) {
        PlatformLogger platformLogger = null;
        WeakReference<PlatformLogger> weakReference = loggers.get(string2);
        if (weakReference != null) {
            platformLogger = (PlatformLogger)weakReference.get();
        }
        if (platformLogger == null) {
            platformLogger = new PlatformLogger(System.getLogger(string2));
            loggers.put(string2, new WeakReference<PlatformLogger>(platformLogger));
        }
        return platformLogger;
    }

    protected PlatformLogger(System.Logger logger) {
        this.loggerProxy = logger;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle resourceBundle, String string2, Object ... objectArray) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle resourceBundle, String string2, Throwable throwable) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isLoggable(Level level) {
        if (level == null) {
            throw new NullPointerException();
        }
        return this.loggerProxy.isLoggable(this.getSystemLoggerLevel(level));
    }

    public void severe(String string2) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.ERROR, string2, (Object[])null);
    }

    public void severe(String string2, Throwable throwable) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.ERROR, string2, throwable);
    }

    public void severe(String string2, Object ... objectArray) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.ERROR, string2, objectArray);
    }

    public void warning(String string2) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.WARNING, string2, (Object[])null);
    }

    public void warning(String string2, Throwable throwable) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.WARNING, string2, throwable);
    }

    public void warning(String string2, Object ... objectArray) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.WARNING, string2, objectArray);
    }

    public void info(String string2) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.INFO, string2, (Object[])null);
    }

    public void info(String string2, Throwable throwable) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.INFO, string2, throwable);
    }

    public void info(String string2, Object ... objectArray) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.INFO, string2, objectArray);
    }

    public void fine(String string2) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.DEBUG, string2, (Object[])null);
    }

    public void fine(String string2, Throwable throwable) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.DEBUG, string2, throwable);
    }

    public void fine(String string2, Object ... objectArray) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.DEBUG, string2, objectArray);
    }

    public void finer(String string2) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.TRACE, string2, (Object[])null);
    }

    public void finer(String string2, Throwable throwable) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.TRACE, string2, throwable);
    }

    public void finer(String string2, Object ... objectArray) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.TRACE, string2, objectArray);
    }

    public void finest(String string2) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.TRACE, string2, (Object[])null);
    }

    public void finest(String string2, Throwable throwable) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.TRACE, string2, throwable);
    }

    public void finest(String string2, Object ... objectArray) {
        if (!this.loggingEnabled) {
            return;
        }
        this.loggerProxy.log(System.Logger.Level.TRACE, string2, objectArray);
    }

    public void enableLogging() {
        this.loggingEnabled = true;
    }

    public void disableLogging() {
        this.loggingEnabled = false;
    }

    public static enum Level {
        ALL(System.Logger.Level.ALL),
        FINEST(System.Logger.Level.TRACE),
        FINER(System.Logger.Level.TRACE),
        FINE(System.Logger.Level.DEBUG),
        INFO(System.Logger.Level.INFO),
        WARNING(System.Logger.Level.WARNING),
        SEVERE(System.Logger.Level.ERROR),
        OFF(System.Logger.Level.OFF);

        final System.Logger.Level systemLevel;

        private Level(System.Logger.Level level) {
            this.systemLevel = level;
        }
    }
}

