/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import javafx.application.Application;

public abstract class HostServicesDelegate {
    public static HostServicesDelegate getInstance(Application application) {
        return StandaloneHostService.getInstance(application);
    }

    protected HostServicesDelegate() {
    }

    public abstract String getCodeBase();

    public abstract String getDocumentBase();

    public abstract void showDocument(String var1);

    private static class StandaloneHostService
    extends HostServicesDelegate {
        private static HostServicesDelegate instance = null;
        private Class appClass = null;
        static final String[] browsers = new String[]{"google-chrome", "firefox", "opera", "konqueror", "mozilla"};

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static HostServicesDelegate getInstance(Application application) {
            Class<StandaloneHostService> clazz = StandaloneHostService.class;
            synchronized (StandaloneHostService.class) {
                if (instance == null) {
                    instance = new StandaloneHostService(application);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
        }

        private StandaloneHostService(Application application) {
            this.appClass = application.getClass();
        }

        @Override
        public String getCodeBase() {
            String string2;
            String string3;
            Object object = this.appClass.getName();
            int n = ((String)object).lastIndexOf(".");
            if (n >= 0) {
                object = ((String)object).substring(n + 1);
            }
            if (!(string3 = this.appClass.getResource((String)(object = (String)object + ".class")).toString()).startsWith("jar:file:") || string3.indexOf("!") == -1) {
                return "";
            }
            String string4 = string3.substring(4, string3.lastIndexOf("!"));
            File file = null;
            try {
                file = new File(new URI(string4).getPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file != null && (string2 = file.getParent()) != null) {
                return this.toURIString(string2);
            }
            return "";
        }

        private String toURIString(String string2) {
            try {
                return new File(string2).toURI().toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "";
            }
        }

        @Override
        public String getDocumentBase() {
            return this.toURIString(System.getProperty("user.dir"));
        }

        @Override
        public void showDocument(String string2) {
            String string3 = System.getProperty("os.name");
            try {
                if (string3.startsWith("Mac OS")) {
                    Desktop.getDesktop().browse(URI.create(string2));
                } else if (string3.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string2);
                } else {
                    String string4 = null;
                    for (String string5 : browsers) {
                        if (string4 != null || Runtime.getRuntime().exec(new String[]{"which", string5}).getInputStream().read() == -1) continue;
                        Runtime.getRuntime().exec(new String[]{string4 = string5, string2});
                    }
                    if (string4 == null) {
                        throw new Exception("No web browser found");
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

