/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.comm.DeviceCommPort;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.graupner.FileTransferTabItem;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.Transmitter;
import gde.exception.FailedQueryException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.FileUtils;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;

public class HoTTAdapterSerialPort
extends DeviceCommPort {
    static final String $CLASS_NAME = HoTTAdapterSerialPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    static final int READ_TIMEOUT_MS = 1000;
    static final byte[] QUERY_SENSOR_DATA = new byte[]{-128};
    static final byte[] ANSWER = new byte[1];
    static final byte DATA_BEGIN = 124;
    static final byte DATA_END = 125;
    static final byte[] QUERY_SENSOR_DATA_DBM = new byte[]{4, 51};
    static final byte[] QUERY_SENSOR_DATA_RECEIVER = new byte[]{4, 52};
    static final byte[] QUERY_SENSOR_DATA_GENERAL = new byte[]{4, 53};
    static final byte[] QUERY_SENSOR_DATA_ELECTRIC = new byte[]{4, 54};
    static final byte[] QUERY_SENSOR_DATA_VARIO = new byte[]{4, 55};
    static final byte[] QUERY_SENSOR_DATA_GPS = new byte[]{4, 56};
    static final byte[] QUERY_SENSOR_DATA_MOTOR_DRIVER = new byte[]{4, 57};
    static final byte[] QUERY_SERVO_POSITIONS = new byte[]{4, 64};
    static final byte[] QUERY_PURPIL_POSITIONS = new byte[]{4, 65};
    static final byte[] QUERY_CONTROL_POSITIONS1 = new byte[]{4, 66};
    static final byte[] QUERY_CONTROL_POSITIONS2 = new byte[]{4, 67};
    static final byte[] answerRx = new byte[21];
    byte[] ANSWER_DATA = new byte[50];
    byte[] answerDBM = new byte[234];
    int DATA_LENGTH = 50;
    byte[] SENSOR_TYPE = new byte[]{-128};
    byte[] QUERY_SENSOR_TYPE;
    static final int xferErrorLimit = 1000;
    boolean isQueryRetry = false;
    HoTTAdapter.Protocol protocolType = HoTTAdapter.Protocol.TYPE_19200_V4;
    private static byte[] root = new byte[5];
    static final int CMD_GAP_MS = 5;
    static final int FILE_TRANSFER_SIZE = 2048;
    static final byte[] cmd1 = new byte[7];
    byte cntUp = 0;
    byte cntDown = (byte)-1;
    static final byte[] QUERY_TX_INFO = new byte[]{0, 17};
    static final byte[] WRITE_SCREEN = new byte[]{0, 33};
    static final byte[] RESET_SCREEN = new byte[]{0, 34};
    static final byte[] CLEAR_SCREEN = new byte[]{0, 35};
    static final byte[] CLOSE_SCREEN = new byte[]{0, 36};
    static final byte[] PREPARE_FILE_TRANSFER = new byte[]{3, 48};
    static final byte[] PREPARE_LIST_MDL = new byte[]{5, 50};
    static final byte[] QUERY_MDL_NAMES = new byte[]{5, 51};
    static final byte[] SELECT_SD_CARD = new byte[]{6, 48};
    static final byte[] QUERY_SD_SIZES = new byte[]{6, 51};
    static final byte[] FILE_XFER_INIT = new byte[]{6, 53};
    static final byte[] FILE_XFER_CLOSE = new byte[]{6, 54};
    static final byte[] FILE_UPLOAD = new byte[]{6, 56};
    static final byte[] FILE_DELETE = new byte[]{6, 57};
    static final byte[] FILE_DOWNLOAD = new byte[]{6, 58};
    static final byte[] LIST_DIR = new byte[]{6, 60};
    static final byte[] CHANGE_DIR = new byte[]{6, 61};
    static final byte[] MK_DIR = new byte[]{6, 62};
    static final byte[] FILE_INFO = new byte[]{6, 63};
    byte[] mx_20_AM_0011 = new byte[]{0, 79, -80, 53, 0, 0, 1, 116, 50, -12, 0, 96, 4, 0, 0, 116, 50, -12, 0, -47, 7, 0, 0, 77, 88, 45, 50, 48, 32, 72, 111, 84, 84, 32, 82, 97, 100, 105, 111, 71, 114, 97, 117, 112, 110, 101, 114, 32, 32, 32, 32, 32, 32, 32, 32, 0, -22, 3, 0, 0, 89, 26};
    byte[] mx_20_RH_0011 = new byte[]{0, 10, -11, 53, 0, 0, 1, 116, 50, -12, 0, 96, 4, 0, 0, 116, 50, -12, 0, -47, 7, 0, 0, 77, 88, 45, 50, 48, 32, 72, 111, 84, 84, 32, 82, 97, 100, 105, 111, 71, 114, 97, 117, 112, 110, 101, 114, 32, 32, 32, 32, 32, 32, 32, 32, 0, -22, 3, 0, 0, 89, 26};
    byte[] mc_32_RH_0011 = new byte[]{0, -121, 120, 53, 0, 0, 1, 4, 52, -12, 0, 7, 4, 0, 0, 4, 52, -12, 0, -47, 7, 0, 0, 77, 67, 45, 51, 50, 32, 50, 46, 52, 71, 32, 82, 97, 100, 105, 111, 71, 114, 97, 117, 112, 110, 101, 114, 32, 32, 32, 32, 32, 32, 32, 32, 1, -24, 3, 0, 0, -12, 122};
    byte[] mx_16_RH_0011 = new byte[]{0, 9, -10, 53, 0, 0, 1, -28, 48, -12, 0, -77, 6, 0, 0, -28, 48, -12, 0, -47, 7, 0, 0, 77, 88, 45, 49, 54, 32, 72, 111, 84, 84, 32, 82, 97, 100, 105, 111, 71, 114, 97, 117, 112, 110, 101, 114, 32, 32, 32, 32, 32, 32, 32, 32, 0, -23, 3, 0, 0, -47, 87};
    byte[] mx_20_AM_0532 = new byte[]{0, 80, -81, 38, 1, 5, 1, 24, 0, 10, 0, 49, 0, 0, 32, 0, 48, 0, 32, 4, 32, 7, 32, 10, 32, 127, 32, -122, 32, -96, 32, 90, 35, 93, 35, 105, 35, 2, 0, 1, 0, 1, 0, 115, 0, 5, 0, 24, 0, -72, 2, 1, 0, 10, 0, 52, 1, -1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, 1, 0, 0, 0, 118, 0, -40, 0, -22, 0, -72, 4, 122, 5, -76, 5, -26, 5, 64, 6, 96, 6, -78, 6, 52, 7, 68, 7, 89, 7, -69, 7, -51, 7, -37, 7, 17, 8, 46, 8, 64, 8, -118, 9, -72, 10, -64, 10, -59, 10, -31, 14, -23, 14, 0, 16, -62, 17, -116, 19, 10, 21, -24, 19, 110, 20, -122, 20, -100, 20, -40, 20, -34, 20, 60, 21, 70, 21, 73, 21, 77, 21, -127, 21, -124, 21, -121, 21, -95, 21, -62, 21, -56, 21, -50, 21, -47, 21, 3, 22, 116, 0, 96, 0, 16, 0, -52, 3, -64, 0, 56, 0, 48, 0, 88, 0, 30, 0, 80, 0, -128, 0, 14, 0, 19, 0, 96, 0, 16, 0, 12, 0, 52, 0, 27, 0, 16, 0, 72, 1, 44, 1, 6, 0, 3, 0, 26, 4, 6, 0, -80, 0, -64, 1, -56, 1, 52, 0, 48, 0, -124, 0, 22, 0, 20, 0, 58, 0, 4, 0, 42, 0, 8, 0, 1, 0, 2, 0, 50, 0, 1, 0, 1, 0, 24, 0, 31, 0, 4, 0, 4, 0, 1, 0, 48, 0, 82, 1, -76, 65};
    byte[] mx_20_RH_0532 = new byte[]{0, 11, -12, 38, 1, 5, 1, 24, 0, 10, 0, 49, 0, 0, 32, 0, 48, 0, 32, 4, 32, 7, 32, 10, 32, 127, 32, -122, 32, -96, 32, 90, 35, 93, 35, 105, 35, 2, 0, 1, 0, 1, 0, 115, 0, 5, 0, 24, 0, -72, 2, 1, 0, 10, 0, 52, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, 0, 0, 118, 0, -40, 0, -22, 0, -72, 4, 122, 5, -76, 5, -26, 5, 64, 6, 96, 6, -78, 6, 52, 7, 68, 7, 89, 7, -69, 7, -51, 7, -37, 7, 17, 8, 46, 8, 64, 8, -118, 9, -72, 10, -64, 10, -59, 10, -31, 14, -23, 14, 0, 16, -62, 17, -116, 19, 10, 21, -24, 19, 110, 20, -122, 20, -100, 20, -40, 20, -34, 20, 60, 21, 70, 21, 73, 21, 77, 21, -127, 21, -124, 21, -121, 21, -95, 21, -62, 21, -56, 21, -50, 21, -47, 21, 3, 22, 116, 0, 96, 0, 16, 0, -52, 3, -64, 0, 56, 0, 48, 0, 88, 0, 30, 0, 80, 0, -128, 0, 14, 0, 19, 0, 96, 0, 16, 0, 12, 0, 52, 0, 27, 0, 16, 0, 72, 1, 44, 1, 6, 0, 3, 0, 26, 4, 6, 0, -80, 0, -64, 1, -56, 1, 52, 0, 48, 0, -124, 0, 22, 0, 20, 0, 58, 0, 4, 0, 42, 0, 8, 0, 1, 0, 2, 0, 50, 0, 1, 0, 1, 0, 24, 0, 31, 0, 4, 0, 4, 0, 1, 0, 48, 0, 82, 1, -66, -122};
    byte[] mc_32_RH_0532 = new byte[]{0, -120, 119, -98, 1, 5, 1, 80, 0, 11, 0, 50, 0, 0, 32, 0, 48, 0, 32, 4, 32, 7, 32, 10, 32, 13, 32, 31, 41, -86, 41, -79, 41, 3, 42, 37, 42, 49, 42, 2, 0, 1, 0, 1, 0, 1, 0, 16, 9, -119, 0, 5, 0, 80, 0, 32, 0, 10, 0, 52, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, 0, 0, 118, 0, -40, 0, -22, 0, -72, 4, 122, 5, -76, 5, -26, 5, 64, 6, 96, 6, -78, 6, 52, 7, 68, 7, 89, 7, -69, 7, -51, 7, -37, 7, 17, 8, 46, 8, 64, 8, -118, 9, -72, 10, -64, 10, -59, 10, -31, 14, -23, 14, 0, 16, -62, 17, -116, 19, 10, 21, -24, 19, 110, 20, -122, 20, -100, 20, -40, 20, -34, 20, 60, 21, 70, 21, 73, 21, 77, 21, -127, 21, -124, 21, -121, 21, -95, 21, -62, 21, -56, 21, -50, 21, -47, 21, 3, 22, 105, 23, 116, 0, 96, 0, 16, 0, -52, 3, -64, 0, 56, 0, 48, 0, 88, 0, 30, 0, 80, 0, -128, 0, 14, 0, 19, 0, 96, 0, 16, 0, 12, 0, 52, 0, 27, 0, 16, 0, 72, 1, 44, 1, 6, 0, 3, 0, 26, 4, 6, 0, -80, 0, -64, 1, -56, 1, 52, 0, 48, 0, -124, 0, 22, 0, 20, 0, 58, 0, 4, 0, 42, 0, 8, 0, 1, 0, 2, 0, 50, 0, 1, 0, 1, 0, 24, 0, 31, 0, 4, 0, 4, 0, 1, 0, 48, 0, 100, 1, 2, 0, -32, -121};
    byte[] mx_16_RH_0532 = new byte[]{0, 11, -12, -110, 0, 5, 1, 20, 0, 8, 0, 16, 0, 0, 16, 0, 48, 0, 32, 34, 32, 38, 32, 41, 32, 44, 32, 10, 33, 13, 33, 25, 33, 32, 0, 2, 0, 1, 0, 1, 0, -36, 0, 1, 0, 10, 0, 52, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, -1, 0, -1, 0, -1, 0, -1, 0, 0, 0, 35, 0, 47, 0, 97, 0, -127, 0, -103, 0, 31, 1, 65, 1, 83, 1, 88, 1, 104, 1, -88, 1, -58, 1, -37, 1, -15, 1, -12, 1, 33, 0, 10, 0, 48, 0, 30, 0, 22, 0, -124, 0, 32, 0, 16, 0, 3, 0, 14, 0, 62, 0, 28, 0, 19, 0, 20, 0, 1, 0, 1, 0, -41, -3};
    byte[] mx_20_AM_0533 = new byte[]{0, 81, -82, 0, 8, 5, 1, 0, 1, 99, 40, 4, 19, 34, 1, 1, 0, 0, 1, 0, 0, 3, 0, 0, 65, 114, 110, 111, 32, 77, 97, 117, 116, 101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 2, 0, 0, 1, 3, 1, 0, 0, 1, 1, 68, -37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, 1, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 65, 110, 103, 101, 108, 32, 32, 32, 32, 32, 68, 105, 115, 99, 117, 115, 32, 32, 32, 32, 69, 97, 115, 121, 71, 108, 105, 100, 32, 32, 75, 97, 101, 102, 101, 114, 32, 32, 32, 32, 69, 108, 101, 120, 105, 101, 114, 32, 32, 32, 76, 65, 83, 84, 32, 68, 79, 87, 78, 32, 83, 72, 65, 68, 79, 87, 32, 32, 32, 32, 88, 112, 101, 114, 105, 101, 110, 99, 101, 32, 76, 111, 103, 111, 53, 48, 48, 32, 32, 32, 84, 69, 83, 84, 32, 32, 32, 32, 32, 32, 67, 97, 114, 105, 115, 109, 97, 32, 32, 32, 74, 117, 110, 105, 111, 114, 65, 110, 100, 32, 83, 107, 121, 32, 32, 32, 32, 32, 32, 32, 75, 97, 116, 97, 110, 97, 32, 32, 32, 32, 73, 110, 115, 105, 100, 101, 114, 32, 32, 32, 65, 66, 67, 69, 70, 71, 72, 73, 74, 32, 71, 114, 111, 98, 32, 49, 48, 57, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83, 99, 104, -127, 108, 101, 114, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    byte[] mx_20_RH_0533 = new byte[]{0, 12, -13, -72, 2, 5, 1, 1, 1, 1, 1, 0, 1, 0, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 84, 82, 65, 73, 78, 69, 82, 32, 32, 32, 65, 83, 87, 32, 32, 32, 32, 32, 32, 32, 74, 79, 68, 69, 76, 32, 82, 79, 66, 32, 84, 65, 88, 73, 32, 67, 85, 80, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, -116, -116, -124, -124, -114, -114, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 0, 0, 1, 0, 1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 1, 1, 56, 1, 30, 0, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, -1, -1, 0, -1, 5};
    byte[] mc_32_RH_0533 = new byte[]{0, -119, 118, 0, 8, 5, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 82, 54, 86, 49, 45, 48, 50, 57, 32, 32, 32, 32, 79, 114, 99, 97, 95, 69, 88, 32, 32, 32, 32, 32, 32, 84, 45, 82, 54, 32, 86, 49, 48, 50, 57, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83, 85, 75, 72, 79, 89, 51, 32, 32, 32, 32, 32, 32, 83, 85, 75, 72, 79, 89, 51, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    byte[] mx_16_RH_0533 = new byte[]{0, 12, -13, -36, 0, 5, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, -1, -1, -1, -1, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 45, 82, 69, 88, 54, 48, 48, 78, 84, 45, 82, 69, 88, 32, 53, 53, 48, 86, 73, 83, 73, 79, 78, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 84, 82, 65, 32, 51, 51, 48, 69, 80, 83, 73, 76, 79, 78, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 7, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 19, 122};

    /*
     * Opcode count of 14253 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public HoTTAdapterSerialPort(HoTTAdapter currentDevice, DataExplorer currentApplication) {
        super((IDevice)currentDevice, currentApplication);
    }

    /*
     * Opcode count of 14252 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public HoTTAdapterSerialPort(DeviceConfiguration deviceConfiguration) {
        super(deviceConfiguration);
    }

    public synchronized byte[] getData(boolean checkBeginEndSignature) throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[this.DATA_LENGTH];
        byte[] tmp = new byte[1];
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "-----> getData entry");
        }
        try {
            if (!HoTTAdapter.IS_SLAVE_MODE) {
                this.write(QUERY_SENSOR_DATA);
                try {
                    this.read(tmp, 1000, false);
                    data[0] = tmp[0];
                }
                catch (Exception e) {
                    data[0] = ANSWER[0];
                    log.warning("failed ==> receive single wire echo 0x80");
                }
                WaitTimer.delay((long)4L);
                this.write(this.SENSOR_TYPE);
                try {
                    this.read(tmp, 1000, false);
                }
                catch (Exception e) {
                    log.warning("failed ==> receive single wire echo sensor byte");
                }
                HoTTAdapterSerialPort.ANSWER[0] = this.SENSOR_TYPE[0];
                data[1] = ANSWER[0];
            } else {
                data[0] = QUERY_SENSOR_DATA[0];
                HoTTAdapterSerialPort.ANSWER[0] = this.SENSOR_TYPE[0];
                data[1] = ANSWER[0];
            }
            this.read(this.ANSWER_DATA, 1000, true);
            WaitTimer.delay((long)30L);
            if (checkBeginEndSignature && HoTTAdapter.IS_SLAVE_MODE) {
                this.synchronizeDataBlock(data, checkBeginEndSignature);
            } else {
                System.arraycopy(this.ANSWER_DATA, 0, data, HoTTAdapter.IS_SLAVE_MODE ? 0 : 2, this.ANSWER_DATA.length);
            }
            if (!this.isInterruptedByUser && checkBeginEndSignature && (data[2] != 124 || data[data.length - 2] != 125)) {
                this.addXferError();
                log.logp(Level.WARNING, $CLASS_NAME, "getData", "=====> data start or end does not match, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 1000) {
                    throw new SerialPortException("Number of tranfer error exceed the acceptable limit of 1000");
                }
                WaitTimer.delay((long)30L);
                data = this.getData(true);
            }
            this.isQueryRetry = false;
        }
        catch (FailedQueryException e) {
            if (!this.isQueryRetry) {
                this.isQueryRetry = true;
                WaitTimer.delay((long)30L);
                data = this.getData(true);
            }
            this.isQueryRetry = false;
            WaitTimer.delay((long)30L);
            TimeOutException te = new TimeOutException(Messages.getString((String)"GDE_MSGE0011", (Object[])new Object[]{this.ANSWER_DATA.length, 1000}));
            log.log(Level.SEVERE, te.getMessage(), te);
            throw te;
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "getData", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
        }
        return data;
    }

    private synchronized byte[] synchronizeDataBlock(byte[] data, boolean checkBeginEndSignature) throws IOException, TimeOutException {
        if (this.ANSWER_DATA[2] != 124 || this.ANSWER_DATA[this.ANSWER_DATA.length - 2] != 125) {
            int index = 0;
            for (byte b : this.ANSWER_DATA) {
                if (b == 124) break;
                ++index;
            }
            log.log(Level.FINER, "index = " + index + " begin part size = " + (this.ANSWER_DATA.length - index + 2) + " end part size = " + (index - 2));
            if (index >= 2 && index < this.ANSWER_DATA.length) {
                System.arraycopy(this.ANSWER_DATA, index - 2, data, 0, this.ANSWER_DATA.length - index + 2);
                System.arraycopy(this.ANSWER_DATA, 0, data, this.ANSWER_DATA.length - index + 2, index - 2);
            } else {
                log.log(Level.WARNING, StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
            }
        } else {
            System.arraycopy(this.ANSWER_DATA, 0, data, 0, this.ANSWER_DATA.length);
        }
        return data;
    }

    void sendQuery(byte[] query) throws IOException {
        System.arraycopy(query, 0, cmd1, 0, 7);
        this.write(cmd1);
        WaitTimer.delay((long)5L);
        byte[] cmd2 = new byte[query.length - 7];
        System.arraycopy(query, 7, cmd2, 0, query.length - 7);
        this.write(cmd2);
    }

    public synchronized int getDataSize() throws IOException, TimeOutException {
        this.sendCmd(this.QUERY_SENSOR_TYPE);
        return this.read(new byte[this.ANSWER_DATA.length], 1000, 5, this.ANSWER_DATA.length).length;
    }

    public synchronized byte[] getData() throws IOException, TimeOutException {
        String $METHOD_NAME = "getData";
        byte[] answer = new byte[this.ANSWER_DATA.length];
        byte[] data = new byte[this.DATA_LENGTH];
        try {
            this.sendCmd(this.QUERY_SENSOR_TYPE);
            this.read(answer, 1000, true);
            data[0] = this.QUERY_SENSOR_TYPE[1];
            System.arraycopy(answer, 0, data, 1, answer.length);
            if (!this.isInterruptedByUser && (answer[0] != 0 || answer[4] != 0 || answer[5] != 4 || answer[6] != 1 || answer[answer.length - 3] < 0 && answer[answer.length - 3] > 100)) {
                this.addXferError();
                log.logp(Level.WARNING, $CLASS_NAME, "getData", "=====> transmission error occurred, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 1000) {
                    throw new SerialPortException("Number of transfer error exceed the acceptable limit of 1000");
                }
                WaitTimer.delay((long)30L);
                data = this.getData();
            }
            this.isQueryRetry = false;
        }
        catch (FailedQueryException e) {
            if (!this.isQueryRetry) {
                this.isQueryRetry = true;
                data = this.getData();
            }
            this.isQueryRetry = false;
            TimeOutException te = new TimeOutException(Messages.getString((String)"GDE_MSGE0011", (Object[])new Object[]{this.ANSWER_DATA.length, 1000}));
            log.log(Level.SEVERE, te.getMessage(), te);
            throw te;
        }
        return data;
    }

    public void getDataDBM(boolean queryDBM, byte[] bytes) throws IOException, FailedQueryException, TimeOutException {
        String $METHOD_NAME = "getDataDBM";
        if (queryDBM && this.QUERY_SENSOR_TYPE[1] == QUERY_SENSOR_DATA_RECEIVER[1]) {
            int i;
            int rxDBM = 0;
            int txDBM = 0;
            for (i = 0; i < 5; ++i) {
                this.sendCmd(QUERY_SENSOR_DATA_DBM);
                this.read(this.answerDBM, 2000, true);
                if (this.isCheckSumOK(3, this.answerDBM)) break;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINER, $CLASS_NAME, "getDataDBM", StringHelper.byte2FourDigitsIntegerString((byte[])this.answerDBM));
                log.logp(Level.FINE, $CLASS_NAME, "getDataDBM", StringHelper.byte2Hex2CharString((byte[])this.answerDBM, (int)this.answerDBM.length));
            }
            for (i = 0; i < 75; ++i) {
                rxDBM += this.answerDBM[i + 157];
                txDBM += this.answerDBM[i + 82];
            }
            bytes[4] = (byte)(rxDBM /= 75);
            bytes[5] = (byte)(txDBM /= 75);
            System.arraycopy(bytes, 0, answerRx, 0, answerRx.length);
        } else {
            bytes[3] = answerRx[17];
            bytes[4] = answerRx[15];
            bytes[5] = answerRx[10];
        }
    }

    public boolean isCheckSumOK(int startIndex, byte[] bytes) {
        String $METHOD_NAME = "isCheckSumOK";
        short checksum = Checksum.CRC16CCITT((byte[])bytes, (int)startIndex, (int)(bytes.length - 2 - startIndex));
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "isCheckSumOK", String.format("checksum: %b - %04X", (checksum & 0xFF00) >> 8 == (bytes[bytes.length - 1] & 0xFF) && (checksum & 0xFF) == (bytes[bytes.length - 2] & 0xFF), checksum));
        }
        return (checksum & 0xFF00) >> 8 == (bytes[bytes.length - 1] & 0xFF) && (checksum & 0xFF) == (bytes[bytes.length - 2] & 0xFF);
    }

    public synchronized void setSensorType(byte sensorType) {
        this.SENSOR_TYPE[0] = sensorType;
        block0 : switch (this.protocolType) {
            case TYPE_19200_V3: {
                switch (sensorType) {
                    case -128: {
                        log.log(Level.FINE, ">>>Receiver<<<");
                        this.ANSWER_DATA = new byte[HoTTAdapter.IS_SLAVE_MODE ? 17 : 15];
                        this.DATA_LENGTH = 17;
                        break;
                    }
                    case -119: {
                        log.log(Level.FINE, ">>>Vario<<<");
                        this.ANSWER_DATA = new byte[HoTTAdapter.IS_SLAVE_MODE ? 31 : 29];
                        this.DATA_LENGTH = 31;
                        break;
                    }
                    case -118: {
                        log.log(Level.FINE, ">>>GPS<<<");
                        this.ANSWER_DATA = new byte[HoTTAdapter.IS_SLAVE_MODE ? 40 : 38];
                        this.DATA_LENGTH = 40;
                        break;
                    }
                    case -115: {
                        log.log(Level.FINE, ">>>General<<<");
                        this.ANSWER_DATA = new byte[HoTTAdapter.IS_SLAVE_MODE ? 48 : 46];
                        this.DATA_LENGTH = 48;
                        break;
                    }
                    case -114: {
                        log.log(Level.FINE, ">>>Electric<<<");
                        this.ANSWER_DATA = new byte[HoTTAdapter.IS_SLAVE_MODE ? 51 : 49];
                        this.DATA_LENGTH = 51;
                    }
                }
                break;
            }
            case TYPE_115200: {
                switch (sensorType) {
                    case 52: {
                        log.log(Level.FINE, ">>>Receiver<<<");
                        this.ANSWER_DATA = new byte[20];
                        this.QUERY_SENSOR_TYPE = QUERY_SENSOR_DATA_RECEIVER;
                        this.DATA_LENGTH = 21;
                        break;
                    }
                    case 55: {
                        log.log(Level.FINE, ">>>Vario<<<");
                        this.ANSWER_DATA = new byte[50];
                        this.QUERY_SENSOR_TYPE = QUERY_SENSOR_DATA_VARIO;
                        this.DATA_LENGTH = 51;
                        break;
                    }
                    case 56: {
                        log.log(Level.FINE, ">>>GPS<<<");
                        this.ANSWER_DATA = new byte[51];
                        this.QUERY_SENSOR_TYPE = QUERY_SENSOR_DATA_GPS;
                        this.DATA_LENGTH = 52;
                        break;
                    }
                    case 53: {
                        log.log(Level.FINE, ">>>General<<<");
                        this.ANSWER_DATA = new byte[59];
                        this.QUERY_SENSOR_TYPE = QUERY_SENSOR_DATA_GENERAL;
                        this.DATA_LENGTH = 60;
                        break;
                    }
                    case 54: {
                        log.log(Level.FINE, ">>>Electric<<<");
                        this.ANSWER_DATA = new byte[65];
                        this.QUERY_SENSOR_TYPE = QUERY_SENSOR_DATA_ELECTRIC;
                        this.DATA_LENGTH = 66;
                        break;
                    }
                    case 57: {
                        log.log(Level.FINE, ">>>SpeedControl<<<");
                        this.ANSWER_DATA = new byte[34];
                        this.QUERY_SENSOR_TYPE = QUERY_SENSOR_DATA_MOTOR_DRIVER;
                        this.DATA_LENGTH = 35;
                        break;
                    }
                    case 65: {
                        log.log(Level.FINE, ">>>PupilPositions<<<");
                        this.ANSWER_DATA = new byte[61];
                        this.QUERY_SENSOR_TYPE = QUERY_PURPIL_POSITIONS;
                        this.DATA_LENGTH = 62;
                        break;
                    }
                    case 64: {
                        log.log(Level.FINE, ">>>ServoPositions<<<");
                        this.ANSWER_DATA = new byte[73];
                        this.QUERY_SENSOR_TYPE = QUERY_SERVO_POSITIONS;
                        this.DATA_LENGTH = 74;
                        break;
                    }
                    case 66: {
                        log.log(Level.FINE, ">>>ControlPositions1<<<");
                        this.ANSWER_DATA = new byte[178];
                        this.QUERY_SENSOR_TYPE = QUERY_CONTROL_POSITIONS1;
                        this.DATA_LENGTH = 179;
                        break;
                    }
                    case 67: {
                        log.log(Level.FINE, ">>>ControlPositions2<<<");
                        this.ANSWER_DATA = new byte[28];
                        this.QUERY_SENSOR_TYPE = QUERY_CONTROL_POSITIONS2;
                        this.DATA_LENGTH = 29;
                    }
                }
                break;
            }
            case TYPE_19200_V4: {
                switch (sensorType) {
                    case -128: {
                        log.log(Level.FINE, ">>>Receiver<<<");
                        this.ANSWER_DATA = new byte[HoTTAdapter.IS_SLAVE_MODE ? 17 : 15];
                        this.DATA_LENGTH = 17;
                        break block0;
                    }
                    case -119: 
                    case -118: 
                    case -116: 
                    case -115: 
                    case -114: {
                        log.log(Level.FINE, sensorType == -116 ? ">>>SpeedControl<<<" : (sensorType == -114 ? ">>>Electric<<<" : (sensorType == -115 ? ">>>General<<<" : (sensorType == -118 ? ">>>GPS<<<" : (sensorType == -119 ? ">>>Vario<<<" : ">>>Receiver<<<")))));
                        this.ANSWER_DATA = new byte[HoTTAdapter.IS_SLAVE_MODE ? 57 : 55];
                        this.DATA_LENGTH = 57;
                    }
                }
            }
        }
        log.log(Level.FINER, "ANSWER_DATA_LENGTH = " + this.ANSWER_DATA.length + " DATA_LENGTH = " + this.DATA_LENGTH);
    }

    public synchronized void setProtocolType(HoTTAdapter.Protocol newProtocolType) {
        log.log(Level.FINE, "protocolTypeOrdinal = " + newProtocolType.value());
        this.protocolType = newProtocolType;
    }

    public String getProtocolType() {
        return this.protocolType.value();
    }

    private byte[] prepareCmdBytes(byte[] cmd) {
        return this.prepareCmdBytes(cmd, "");
    }

    private byte[] prepareCmdBytes(byte[] cmd, String body) {
        byte[] b = new byte[body.length() == 0 ? body.length() + 9 : body.length() + 10];
        b[0] = 0;
        if (this.cntUp == 254 || this.cntDown == 1) {
            this.cntUp = 0;
            this.cntDown = (byte)-1;
        }
        b[1] = this.cntUp = (byte)(this.cntUp + 1);
        b[2] = this.cntDown = (byte)(this.cntDown - 1);
        b[3] = (byte)(body.length() == 0 ? body.length() & 0xFF : body.length() + 1 & 0xFF);
        b[4] = 0;
        b[5] = cmd[0];
        b[6] = cmd[1];
        for (int i = 7; i < body.length() + 7; ++i) {
            b[i] = (byte)(body.getBytes()[i - 7] & 0xFF);
        }
        if (body.length() > 0) {
            b[i++] = 0;
        }
        short crc16 = Checksum.CRC16CCITT((byte[])b, (int)3, (int)(body.length() == 0 ? body.length() + 4 : body.length() + 5));
        b[i++] = (byte)(crc16 & 0xFF);
        b[i++] = (byte)((crc16 & 0xFF00) >> 8);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINER, StringHelper.byte2Hex2CharString((byte[])b, (int)b.length));
        }
        return b;
    }

    private byte[] prepareLineBytes(byte[] cmd, String line, int number) {
        byte[] b = new byte[line.length() + 10];
        b[0] = 0;
        if (this.cntUp == 255 || this.cntDown == 0) {
            this.cntUp = 0;
            this.cntDown = (byte)-1;
        }
        b[1] = this.cntUp = (byte)(this.cntUp + 1);
        b[2] = this.cntDown = (byte)(this.cntDown - 1);
        b[3] = (byte)(line.length() == 0 ? line.length() & 0xFF : line.length() + 1 & 0xFF);
        b[4] = 0;
        b[5] = cmd[0];
        b[6] = cmd[1];
        b[7] = (byte)(number & 0xFF);
        for (int i = 8; i < line.length() + 8; ++i) {
            b[i] = (byte)(line.getBytes()[i - 8] & 0xFF);
        }
        short crc16 = Checksum.CRC16CCITT((byte[])b, (int)3, (int)(line.length() == 0 ? line.length() + 4 : line.length() + 5));
        b[i++] = (byte)(crc16 & 0xFF);
        b[i++] = (byte)((crc16 & 0xFF00) >> 8);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINER, StringHelper.byte2Hex2CharString((byte[])b, (int)b.length));
        }
        return b;
    }

    private void sendCmd(byte[] cmd) throws IOException {
        byte[] cmdAll = this.prepareCmdBytes(cmd);
        System.arraycopy(cmdAll, 0, cmd1, 0, 7);
        this.write(cmd1);
        WaitTimer.delay((long)5L);
        byte[] cmd2 = new byte[cmdAll.length - 7];
        System.arraycopy(cmdAll, 7, cmd2, 0, cmdAll.length - 7);
        this.write(cmd2);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])cmdAll));
        }
        WaitTimer.delay((long)5L);
    }

    private void sendCmd(byte[] cmd, String body) throws IOException {
        byte[] cmdAll = this.prepareCmdBytes(cmd, body);
        System.arraycopy(cmdAll, 0, cmd1, 0, 7);
        this.write(cmd1);
        WaitTimer.delay((long)5L);
        byte[] cmd2 = new byte[cmdAll.length - 7];
        System.arraycopy(cmdAll, 7, cmd2, 0, cmdAll.length - 7);
        this.write(cmd2);
        WaitTimer.delay((long)5L);
    }

    private void sendLine(byte[] cmd, String line, int number) throws IOException {
        byte[] cmdAll = this.prepareLineBytes(cmd, line, number);
        System.arraycopy(cmdAll, 0, cmd1, 0, 7);
        this.write(cmd1);
        WaitTimer.delay((long)5L);
        byte[] cmd2 = new byte[cmdAll.length - 7];
        System.arraycopy(cmdAll, 7, cmd2, 0, cmdAll.length - 7);
        this.write(cmd2);
        WaitTimer.delay((long)5L);
    }

    private void sendCmd(byte[] cmd, byte[] data) throws IOException {
        byte[] cmdAll = new byte[data.length + 8 + 2 + 7];
        cmdAll[0] = 0;
        if (this.cntUp == 254 || this.cntDown == 1) {
            this.cntUp = 0;
            this.cntDown = (byte)-1;
        }
        cmdAll[1] = this.cntUp = (byte)(this.cntUp + 1);
        cmdAll[2] = this.cntDown = (byte)(this.cntDown - 1);
        cmdAll[3] = (byte)(data.length + 8 & 0xFF);
        cmdAll[4] = (byte)((data.length + 8 & 0xFF00) >> 8);
        cmdAll[5] = cmd[0];
        cmdAll[6] = cmd[1];
        System.arraycopy(String.format("0x%04x ", data.length).getBytes(), 0, cmdAll, 7, 7);
        System.arraycopy(data, 0, cmdAll, 15, data.length);
        short crc16 = Checksum.CRC16CCITT((byte[])cmdAll, (int)3, (int)(cmdAll.length - 5));
        cmdAll[cmdAll.length - 2] = (byte)(crc16 & 0xFF);
        cmdAll[cmdAll.length - 1] = (byte)((crc16 & 0xFF00) >> 8);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])cmdAll, (int)cmdAll.length));
        }
        System.arraycopy(cmdAll, 0, cmd1, 0, 7);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, StringHelper.byte2Hex2CharString((byte[])cmd1, (int)cmd1.length));
        }
        this.write(cmd1);
        WaitTimer.delay((long)5L);
        byte[] cmd2 = new byte[data.length + 8 + 2];
        System.arraycopy(cmdAll, 7, cmd2, 0, cmdAll.length - 7);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, StringHelper.byte2Hex2CharString((byte[])cmd2, (int)cmd2.length));
        }
        this.write(cmd2);
    }

    private void sendMdlCmd(byte[] data) throws IOException {
        byte[] cmdAll = new byte[data.length + 2 + 7];
        cmdAll[0] = 0;
        if (this.cntUp == 255 || this.cntDown == 0) {
            this.cntUp = 0;
            this.cntDown = (byte)-1;
        }
        cmdAll[1] = this.cntUp = (byte)(this.cntUp + 1);
        cmdAll[2] = this.cntDown = (byte)(this.cntDown - 1);
        cmdAll[3] = (byte)(data.length & 0xFF);
        cmdAll[4] = (byte)((data.length & 0xFF00) >> 8);
        cmdAll[5] = QUERY_MDL_NAMES[0];
        cmdAll[6] = QUERY_MDL_NAMES[1];
        System.arraycopy(data, 0, cmdAll, 7, data.length);
        short crc16 = Checksum.CRC16CCITT((byte[])cmdAll, (int)3, (int)(data.length + 4));
        cmdAll[cmdAll.length - 2] = (byte)(crc16 & 0xFF);
        cmdAll[cmdAll.length - 1] = (byte)((crc16 & 0xFF00) >> 8);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])cmdAll, (int)cmdAll.length));
        }
        System.arraycopy(cmdAll, 0, cmd1, 0, 7);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])cmd1, (int)cmd1.length));
        }
        this.write(cmd1);
        WaitTimer.delay((long)5L);
        byte[] cmd2 = new byte[data.length + 2];
        System.arraycopy(cmdAll, 7, cmd2, 0, cmdAll.length - 7);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])cmd2, (int)cmd2.length));
        }
        this.write(cmd2);
    }

    public synchronized void prepareSdCard(int retryCount) throws Exception {
        try {
            this.sendCmd(PREPARE_FILE_TRANSFER);
            WaitTimer.delay((long)30L);
            this.ANSWER_DATA = this.read(new byte[9], 1000);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, StringHelper.byte2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
            }
            this.sendCmd(SELECT_SD_CARD);
            WaitTimer.delay((long)30L);
            this.ANSWER_DATA = this.read(new byte[10], 1000);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, StringHelper.byte2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
            }
        }
        catch (Exception e) {
            if (retryCount < 10) {
                log.log(Level.WARNING, e.getMessage());
                this.prepareSdCard(++retryCount);
            }
            throw e;
        }
    }

    public synchronized long[] querySdCardSizes(int retryCount) throws Exception {
        long[] ret = new long[2];
        try {
            this.sendCmd(QUERY_SD_SIZES);
            this.ANSWER_DATA = this.read(new byte[50], 1000, 5);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "SD size info : " + StringHelper.byte2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "SD size info : " + StringHelper.byte2hex2int((byte[])this.ANSWER_DATA, (int)9, (int)8) + " KBytes total - " + StringHelper.byte2hex2int((byte[])this.ANSWER_DATA, (int)21, (int)8) + " KBytes free");
            }
            if (this.ANSWER_DATA[6] == 2 && retryCount < 3) {
                log.log(Level.WARNING, "querySdCardSizes failed, check SD card");
                this.ANSWER_DATA = new byte[50];
                for (int i = 0; i < this.ANSWER_DATA.length; ++i) {
                    this.ANSWER_DATA[i] = 48;
                }
            }
            ret = new long[]{StringHelper.byte2hex2int((byte[])this.ANSWER_DATA, (int)9, (int)8), StringHelper.byte2hex2int((byte[])this.ANSWER_DATA, (int)21, (int)8)};
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            if (retryCount < 3) {
                ret = this.querySdCardSizes(++retryCount);
            }
            throw e;
        }
        return ret;
    }

    public synchronized void deleteFiles(String dirPath, String[] files) throws IOException, TimeOutException {
        for (String file : files) {
            this.sendCmd(FILE_DELETE, dirPath + file);
            this.ANSWER_DATA = this.read(new byte[9], 1000);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
        }
    }

    public synchronized String[] querySdDirs(int retryCount) throws Exception {
        StringBuilder sb;
        block6: {
            sb = new StringBuilder();
            try {
                this.sendCmd(CHANGE_DIR, "/");
                root = this.read(new byte[50], 1000, 5);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])root, (int)root.length));
                }
                while (this.ANSWER_DATA[7] != root[7] && this.ANSWER_DATA[8] != root[8]) {
                    this.sendCmd(LIST_DIR);
                    this.ANSWER_DATA = this.read(new byte[256], 1000, 5);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, StringHelper.byte2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                    }
                    for (int i = 19; i < this.ANSWER_DATA.length - 2; ++i) {
                        sb.append(String.format("%c", this.ANSWER_DATA[i]));
                    }
                    sb.append(";");
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, sb.toString());
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                if (retryCount >= 3) break block6;
                return this.querySdDirs(++retryCount);
            }
        }
        return sb.toString().split(";");
    }

    public HashMap<String, String[]> queryListDir(String dirPath, int retryCount) throws Exception {
        HashMap<String, String[]> result;
        block9: {
            StringBuilder folders = new StringBuilder();
            StringBuilder files = new StringBuilder();
            result = new HashMap<String, String[]>();
            int fileIndex = 0;
            this.sendCmd(CHANGE_DIR, dirPath);
            root = this.read(new byte[50], 1000, 5);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, StringHelper.byte2CharString((byte[])root, (int)root.length));
            }
            try {
                this.ANSWER_DATA[3] = 1;
                while (this.ANSWER_DATA[3] != 0) {
                    this.sendCmd(LIST_DIR);
                    this.ANSWER_DATA = this.read(new byte[256], 1000, 5);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, StringHelper.byte2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                    }
                    StringBuilder content = new StringBuilder();
                    for (int i = 19; i < this.ANSWER_DATA.length - 2; ++i) {
                        content.append(String.format("%c", this.ANSWER_DATA[i]));
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "content : " + content.toString());
                    }
                    if (content.indexOf(".") > 0) {
                        files.append(fileIndex++).append(",").append((CharSequence)content).append(",");
                        files.append("20").append(String.format("%c%c-%c%c-%c%c", this.ANSWER_DATA[9], this.ANSWER_DATA[10], this.ANSWER_DATA[11], this.ANSWER_DATA[12], this.ANSWER_DATA[13], this.ANSWER_DATA[14])).append(",");
                        files.append(String.format("%c%c:%c%c", this.ANSWER_DATA[15], this.ANSWER_DATA[16], this.ANSWER_DATA[17], this.ANSWER_DATA[18])).append(";");
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, "files : " + files.toString());
                        continue;
                    }
                    folders.append((CharSequence)content).append(";");
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "folders : " + folders.toString());
                }
                result.put("FOLDER", folders.toString().split(";"));
                if (files.toString().length() > 0) {
                    result.put("FILES", this.queryFilesInfo(dirPath + "/", files.toString().split(";"), 0));
                }
            }
            catch (RuntimeException e) {
                log.log(Level.WARNING, e.getMessage(), e);
                if (retryCount >= 3) break block9;
                result = this.queryListDir(dirPath, ++retryCount);
            }
        }
        return result;
    }

    public String[] queryFilesInfo(String dirPath, String[] files, int retryCount) throws Exception {
        StringBuilder filesInfo = new StringBuilder();
        try {
            for (String file : files) {
                this.sendCmd(FILE_INFO, dirPath + file.split(",")[1]);
                this.ANSWER_DATA = this.read(new byte[100], 1000, 5);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "File size = " + Integer.parseInt(String.format("%02x%02x%02x%02x", this.ANSWER_DATA[10], this.ANSWER_DATA[9], this.ANSWER_DATA[8], this.ANSWER_DATA[7]), 16));
                }
                filesInfo.append(file).append(",").append(Integer.parseInt(String.format("%02x%02x%02x%02x", this.ANSWER_DATA[10], this.ANSWER_DATA[9], this.ANSWER_DATA[8], this.ANSWER_DATA[7]), 16)).append(";");
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, filesInfo.toString());
                }
                WaitTimer.delay((long)5L);
            }
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            if (retryCount < 3) {
                return this.queryFilesInfo(dirPath, files, ++retryCount);
            }
            throw e;
        }
        return filesInfo.toString().split(";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upLoadFiles(String sourceDirPath, String targetDirPath, String[] filesInfo, long totalSize, FileTransferTabItem parent) throws Exception {
        long remainingSize = totalSize;
        try (FilterOutputStream data_out = null;){
            for (String fileInfo : filesInfo) {
                if (this.isInterruptedByUser) continue;
                String[] file = fileInfo.split(",");
                String fileQueryAnswer = this.queryFilesInfo(sourceDirPath, new String[]{fileInfo}, 0)[0];
                long remainingFileSize = Long.parseLong(fileQueryAnswer.split(",")[3]);
                File xferFile = new File(targetDirPath + "/" + file[1]);
                data_out = new DataOutputStream(new FileOutputStream(xferFile));
                this.sendCmd(FILE_XFER_INIT, String.format("0x01 %s%s", sourceDirPath, file[1]));
                this.ANSWER_DATA = this.read(new byte[9], 1000);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                }
                int retries = 0;
                while (!this.isInterruptedByUser && remainingFileSize > 2048L) {
                    try {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "remainingFileSize = " + remainingFileSize);
                        }
                        this.sendCmd(FILE_UPLOAD, String.format("0x%04x", 2048));
                        this.ANSWER_DATA = new byte[7];
                        this.ANSWER_DATA = this.read(this.ANSWER_DATA, 1000, false);
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                        }
                        if (this.ANSWER_DATA[5] == 6 && this.ANSWER_DATA[6] == 1) {
                            this.ANSWER_DATA = new byte[2050];
                            this.ANSWER_DATA = this.read(this.ANSWER_DATA, 5000, false);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                            }
                            ((DataOutputStream)data_out).write(this.ANSWER_DATA, 0, 2048);
                        } else if (retries++ < 3) continue;
                        remainingSize -= 2048L;
                        remainingFileSize -= 2048L;
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "sizeProgress = " + remainingSize + " - " + (totalSize - remainingSize) * 100L / totalSize + " %");
                        }
                        parent.updateFileTransferProgress(totalSize, remainingSize);
                        retries = 0;
                    }
                    catch (TimeOutException e) {
                        if (this.ANSWER_DATA.length >= 64) {
                            int returnedDataSize = 0;
                            for (int i = this.ANSWER_DATA.length - 1; i > 0; --i) {
                                if (this.ANSWER_DATA[i] == 0) continue;
                                returnedDataSize = i - i % 64;
                                break;
                            }
                            log.log(Level.WARNING, file[1] + ": write only " + returnedDataSize + " bytes instead of 2048");
                            ((DataOutputStream)data_out).write(this.ANSWER_DATA, 0, returnedDataSize);
                            remainingFileSize -= 2048L;
                            parent.updateFileTransferProgress(totalSize, remainingSize -= 2048L);
                        }
                        if (retries++ < 3) continue;
                        throw e;
                    }
                }
                if (!this.isInterruptedByUser) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "remainingFileSize = " + remainingFileSize);
                    }
                    this.sendCmd(FILE_UPLOAD, String.format("0x%04x", remainingFileSize));
                    this.ANSWER_DATA = this.read(new byte[7], 1000);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                    }
                    this.ANSWER_DATA = this.read(new byte[(int)(remainingFileSize + 2L)], 1000);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                    }
                    ((DataOutputStream)data_out).write(this.ANSWER_DATA, 0, (int)remainingFileSize);
                    remainingSize -= remainingFileSize;
                }
                data_out.close();
                data_out = null;
                this.sendCmd(FILE_XFER_CLOSE);
                this.ANSWER_DATA = this.read(new byte[9], 1000);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                }
                xferFile.setLastModified(Long.parseLong(file[2]));
                parent.updateFileTransferProgress(totalSize, remainingSize);
                parent.updatePcFolder();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downLoadFiles(String sourceDirPath, String targetDirPath, String[] filesInfo, long totalSize, FileTransferTabItem parent) throws Exception {
        long remainingSize = totalSize;
        FilterInputStream data_in = null;
        int xferDataSize = 2048;
        byte[] XFER_DATA = new byte[2048];
        byte[] xferSize = new byte[4];
        long startTime = System.nanoTime() / 1000000L;
        try {
            for (String fileInfo : filesInfo) {
                if (this.isInterruptedByUser) continue;
                String[] file = fileInfo.split(",");
                File xferFile = new File(targetDirPath + "/" + file[1]);
                data_in = new DataInputStream(new FileInputStream(xferFile));
                long remainingFileSize = xferFile.length();
                this.sendCmd(FILE_XFER_INIT, String.format("0x0b %s%s", sourceDirPath, file[1]));
                this.ANSWER_DATA = this.read(new byte[9], 1000);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                }
                this.sendCmd(FILE_XFER_CLOSE);
                this.ANSWER_DATA = this.read(new byte[9], 1000);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                }
                this.sendCmd(FILE_XFER_INIT, String.format("0x02 %s%s", sourceDirPath, file[1]));
                this.ANSWER_DATA = this.read(new byte[9], 1000);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                }
                int retries = 0;
                while (!this.isInterruptedByUser && remainingFileSize > 2048L) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "remainingFileSize = " + remainingFileSize);
                    }
                    ((DataInputStream)data_in).read(XFER_DATA);
                    this.sendCmd(FILE_DOWNLOAD, XFER_DATA);
                    this.ANSWER_DATA = this.read(new byte[15], 1000);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                    }
                    if (this.ANSWER_DATA[5] == 6 && this.ANSWER_DATA[6] == 1) {
                        System.arraycopy(this.ANSWER_DATA, 9, xferSize, 0, 4);
                        xferDataSize = Integer.parseInt(new String(xferSize), 16);
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "xferDataSize = 0x" + new String(xferSize));
                        }
                    } else if (retries++ < 3) continue;
                    remainingSize -= (long)xferDataSize;
                    remainingFileSize -= (long)xferDataSize;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "sizeProgress = " + remainingSize + " - " + (totalSize - remainingSize) * 100L / totalSize + " %");
                    }
                    parent.updateFileTransferProgress(totalSize, remainingSize);
                    xferDataSize = 2048;
                }
                if (!this.isInterruptedByUser) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "remainingFileSize = " + remainingFileSize);
                    }
                    XFER_DATA = new byte[(int)remainingFileSize];
                    ((DataInputStream)data_in).read(XFER_DATA);
                    this.sendCmd(FILE_DOWNLOAD, XFER_DATA);
                    this.ANSWER_DATA = this.read(new byte[15], 1000);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                    }
                    remainingSize -= remainingFileSize;
                }
                data_in.close();
                data_in = null;
                this.sendCmd(FILE_XFER_CLOSE);
                this.ANSWER_DATA = this.read(new byte[9], 1000);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                }
                parent.updateFileTransferProgress(totalSize, remainingSize);
                XFER_DATA = new byte[2048];
            }
            parent.updateSdFolder(this.querySdCardSizes(0));
            HoTTbinReader.log.log(Level.INFO, "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
        }
        finally {
            if (data_in != null) {
                data_in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadModelData(String selectedPcFolder, FileTransferTabItem parent) throws IOException, TimeOutException {
        try {
            int startIndex;
            this.preModelRead();
            byte[] header = new byte[4096];
            for (int i = 0; i < header.length; ++i) {
                header[i] = -1;
            }
            StringBuilder sb = new StringBuilder();
            this.sendCmd(QUERY_TX_INFO);
            this.ANSWER_DATA = this.read(new byte[100], 1000, 5);
            try {
                this.sendCmd(QUERY_TX_INFO);
                this.ANSWER_DATA = this.read(new byte[100], 1000, 5);
            }
            catch (Exception e) {
                this.sendCmd(QUERY_TX_INFO);
                this.ANSWER_DATA = this.read(new byte[100], 1000, 5);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, StringHelper.byte2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                log.log(Level.FINE, StringHelper.fourDigitsRunningNumber((int)this.ANSWER_DATA.length));
                log.log(Level.FINE, StringHelper.byte2FourDigitsIntegerString((byte[])this.ANSWER_DATA));
                log.log(Level.FINE, StringHelper.byte2Hex4CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
            }
            System.arraycopy(this.ANSWER_DATA, 7, header, 0, 8);
            System.arraycopy(this.ANSWER_DATA, 56, header, 8, 4);
            for (int i = 23; i < 28; ++i) {
                sb.append(String.format("%c", this.ANSWER_DATA[i]));
            }
            sb.append(";");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, sb.toString());
            }
            this.sendCmd(PREPARE_LIST_MDL);
            this.ANSWER_DATA = this.read(new byte[1000], 1000, 5);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, StringHelper.byte2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                log.log(Level.FINE, StringHelper.fourDigitsRunningNumber((int)this.ANSWER_DATA.length));
                log.log(Level.FINE, StringHelper.byte2FourDigitsIntegerString((byte[])this.ANSWER_DATA));
                log.log(Level.FINE, StringHelper.byte2Hex4CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
            }
            int numMdls = this.ANSWER_DATA[7];
            sb.append(numMdls).append(";");
            for (startIndex = 60; startIndex < this.ANSWER_DATA.length - 4 && (this.ANSWER_DATA[startIndex] != 0 || this.ANSWER_DATA[startIndex + 1] != 0 || this.ANSWER_DATA[startIndex + 2] != 0 || this.ANSWER_DATA[startIndex + 3] <= 1 || this.ANSWER_DATA[startIndex + 3] >= 255 || this.ANSWER_DATA[startIndex + 4] != 0); ++startIndex) {
            }
            startIndex -= numMdls * 2 - 1;
            for (int j = 1; startIndex < this.ANSWER_DATA.length - 2 && j <= numMdls; startIndex += 2, ++j) {
                if (this.ANSWER_DATA[startIndex] == 1 || this.ANSWER_DATA[startIndex] == 0) {
                    sb.append(j);
                } else {
                    if (this.ANSWER_DATA[startIndex] != -1) break;
                    sb.append(-1 * j);
                }
                sb.append(";");
            }
            try {
                this.sendCmd(QUERY_MDL_NAMES, new String(new byte[]{0, 8, 0, 0, 13, 32, 0}));
                this.ANSWER_DATA = this.read(new byte[2057], 1000);
            }
            catch (Exception e) {
                this.sendCmd(QUERY_MDL_NAMES, new String(new byte[]{0, 8, 0, 0, 13, 32, 0}));
                this.ANSWER_DATA = this.read(new byte[2057], 1000);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, StringHelper.byte2CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
                log.log(Level.FINE, StringHelper.fourDigitsRunningNumber((int)this.ANSWER_DATA.length));
                log.log(Level.FINE, StringHelper.byte2FourDigitsIntegerString((byte[])this.ANSWER_DATA));
                log.log(Level.FINE, StringHelper.byte2Hex4CharString((byte[])this.ANSWER_DATA, (int)this.ANSWER_DATA.length));
            }
            int modelNameLength = 10;
            switch (Transmitter.fromValue(sb.substring(0, 5).toLowerCase())) {
                case MC_32: {
                    modelNameLength = 13;
                    startIndex = 86;
                    break;
                }
                default: {
                    modelNameLength = 10;
                    startIndex = 195;
                    break;
                }
                case MX_20: {
                    modelNameLength = 10;
                    startIndex = 177;
                    break;
                }
                case MX_16: 
                case MX_12: {
                    modelNameLength = 9;
                    startIndex = 53;
                }
            }
            int j = 0;
            while (startIndex < this.ANSWER_DATA.length - 2) {
                if (j % modelNameLength != 0) {
                    sb.append(String.format("%c", Character.valueOf((char)this.ANSWER_DATA[startIndex])));
                } else if (j != 0) {
                    sb.append(String.format("%c", Character.valueOf((char)this.ANSWER_DATA[startIndex]))).append(";");
                }
                ++startIndex;
                ++j;
            }
            sb.append(";");
            log.log(Level.FINE, sb.toString());
            Vector<String> vModels = new Vector<String>();
            int numValidMdls = 0;
            String[] sModels = sb.toString().split(";");
            for (int i = 0; i < numMdls; ++i) {
                if (Integer.parseInt(sModels[i + 2].trim()) > 0) {
                    Object mdlName = sModels[i + 2 + numMdls].trim();
                    if (((String)mdlName).length() == 0) {
                        mdlName = i + 1 + "_NAME";
                    }
                    vModels.add((String)mdlName);
                    ++numValidMdls;
                    continue;
                }
                vModels.add("-");
            }
            log.log(Level.FINE, vModels.size() + " - " + vModels.toString());
            String dirName = selectedPcFolder + "/backup_" + sModels[0].toLowerCase();
            FileUtils.checkDirectoryAndCreate((String)dirName);
            if (!FileUtils.checkDirectoryAndCreate((String)dirName)) {
                throw new RuntimeException("Failed create directory " + dirName);
            }
            long remainingSize = 0L;
            long totalSize = 0L;
            switch (Transmitter.fromValue(sb.substring(0, 5).toLowerCase())) {
                default: {
                    remainingSize = numValidMdls * 12288;
                    totalSize = numValidMdls * 12288;
                    break;
                }
                case MX_16: 
                case MX_12: {
                    remainingSize = numValidMdls * 8192;
                    totalSize = numValidMdls * 8192;
                }
            }
            parent.updateFileTransferProgress(totalSize, remainingSize);
            byte[] queryModels = new byte[]{0, 8, 0, 0, 0, 48, 0, 0};
            int iQueryModels = 48;
            block27: for (String modelName : vModels) {
                if (!modelName.equals("-")) {
                    String outputFile = dirName + "/a" + modelName + ".mdl";
                    DataOutputStream out = new DataOutputStream(new FileOutputStream(outputFile));
                    log.log(Level.FINE, "writing " + outputFile);
                    out.write(header);
                    switch (Transmitter.fromValue(sb.substring(0, 5).toLowerCase())) {
                        default: {
                            int i;
                            for (i = 0; i < 4; ++i) {
                                this.queryModelConfigurationData(queryModels, 0);
                                out.write(this.ANSWER_DATA, 7, 2048);
                                queryModels[5] = (byte)((iQueryModels += 8) & 0xFF & 0xFF);
                                queryModels[6] = (byte)((iQueryModels & 0xFF00) >> 8 & 0xFF);
                            }
                            break;
                        }
                        case MX_16: 
                        case MX_12: {
                            int i;
                            for (i = 0; i < 2; ++i) {
                                this.queryModelConfigurationData(queryModels, 0);
                                queryModels[5] = (byte)((iQueryModels += 8) & 0xFF & 0xFF);
                                queryModels[6] = (byte)((iQueryModels & 0xFF00) >> 8 & 0xFF);
                            }
                        }
                    }
                    out.close();
                    out = null;
                    parent.updateFileTransferProgress(totalSize, remainingSize -= 12288L);
                    continue;
                }
                switch (Transmitter.fromValue(sb.substring(0, 5).toLowerCase())) {
                    default: {
                        for (int i = 0; i < 4; ++i) {
                            queryModels[5] = (byte)((iQueryModels += 8) & 0xFF & 0xFF);
                            queryModels[6] = (byte)((iQueryModels & 0xFF00) >> 8 & 0xFF);
                        }
                        continue block27;
                    }
                    case MX_16: 
                    case MX_12: {
                        for (int i = 0; i < 2; ++i) {
                            queryModels[5] = (byte)((iQueryModels += 8) & 0xFF & 0xFF);
                            queryModels[6] = (byte)((iQueryModels & 0xFF00) >> 8 & 0xFF);
                        }
                        continue block27;
                    }
                }
            }
        }
        finally {
            this.postModelRead();
        }
    }

    public void queryModelConfigurationData(byte[] queryModels, int retryCount) throws IOException, TimeOutException {
        String $METHOD_NAME = "queryModelConfigurationData()";
        try {
            this.sendMdlCmd(queryModels);
            this.ANSWER_DATA = this.read(new byte[2057], 1000);
        }
        catch (TimeOutException e) {
            if (++retryCount < 3) {
                log.logp(Level.WARNING, $CLASS_NAME, "queryModelConfigurationData()", "retryCount = " + retryCount);
                this.queryModelConfigurationData(queryModels, retryCount);
                return;
            }
            throw e;
        }
    }

    private void preModelRead() throws IOException, TimeOutException {
        byte[] answer = new byte[9];
        this.sendCmd(CLEAR_SCREEN);
        answer = this.read(answer, 1000);
        this.sendCmd(RESET_SCREEN);
        answer = this.read(answer, 1000);
        this.sendLine(WRITE_SCREEN, "---------------------", 0);
        answer = this.read(answer, 1000);
        this.sendLine(WRITE_SCREEN, "*   Model Data      *", 1);
        answer = this.read(answer, 1000);
        this.sendLine(WRITE_SCREEN, "*   Read Start      *", 2);
        answer = this.read(answer, 1000);
        this.sendLine(WRITE_SCREEN, "*   Please Wait.... *", 3);
        answer = this.read(answer, 1000);
        this.sendLine(WRITE_SCREEN, "---------------------", 4);
        answer = this.read(answer, 1000);
    }

    private void postModelRead() throws IOException, TimeOutException {
        byte[] answer = new byte[9];
        this.sendCmd(CLOSE_SCREEN);
        answer = this.read(answer, 1000);
    }
}

