/* 
    Copyright (C) 2024, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptpulse";
declare description "pulse amp filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.10";
declare license "GPL 3.0 or later";

//link the librarys
si = library("signals.lib");
ba = library("basics.lib");
ma = library("maths.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
	     nchannels = 2;// number of channels; 1 for mono, 2 for stereo
	   };

// the pulse
pulse = ba.pulsen(n,p)
with {
  // a slider for the pulse length
  lengthn = hslider("[1]pulse length",1,0.01,1,0.01);

  n = ma.SR * lengthn; //the pulse length in samples
  p = n*2; //the period
};

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par(i, constant.nchannels, cptbasics.bargraphinput(i) :
				     cptbasics.drywetmono (pulse * _) :
				     cptbasics.bargraphoutput(i));
