/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptreverb";
declare description "reverb filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.13";
declare license "GPL 3.0 or later";

//link the librarys
si = library("signals.lib");
re = library("reverbs.lib");
co = library("compressors.lib");
cptbasics = library("lib/basics.lib");

// constanta used in this program
constant = environment {
	     nchannels = 2;// number of channels; 1 for mono, 2 for stereo
			 fb1 = 1;// coefficient of the lowpass comb filters
			 fb2 = 1;// coefficient of the allpass comb filters
	   };

// a function for the reverb
reverb = re.mono_freeverb(fb1, fb2,damp,spread)
with {
  fb1 = hslider("[1]lowpass comb",1,0,1,0.01) : si.smoo;
  fb2 = hslider("[2]allpass comb",1,0,1,0.01) : si.smoo;
  damp = hslider("[3]lowpass comp damp",1,0,1,0.01) : si.smoo;
  spread = hslider("[4]spatial spread",0,0,1000,1);
};

// the process, that is going to be executed; contains the functions that are described before
//process = drywet(par(i, constant.nchannels, reverb ):limiter);
process = par(i,  constant.nchannels, cptbasics.bargraphinput(i) :

				      //cptbasics.Ndrywetmonofx(i, reverb) : //for N number of channels
				      
				      cptbasics.stereodrywetmonofx(i,reverb) ://for 2 channels only; enables effect balance slider
				      cptbasics.bargraphoutput(i));
