/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptphaser";
declare description "phaser filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.12";
declare license "GPL 3.0 or later";

//link the librarys
ma = library("math.lib");
en = library("envelopes.lib");
ba = library("basics.lib");
cptbasics = library("lib/basics.lib");

// constant variables used in this program
constant = environment {
	     nchannels = 2;// number of channels; 1 for mono, 2 for stereo
	   };

// phaser
phaser = _ <: @(ma.SR*phase)*(en.ar(atrt,atrt,pulse)),(_) :> _
with {
  phase = hslider("[1]phase", 1, 1, 1000, 1)/1000;
  atrt =  ba.samp2sec(ma.SR)*phase;
  pulse = ba.pulsen(phase*ma.SR,2*phase*ma.SR);
};

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par(i, constant.nchannels, cptbasics.bargraphinput(i) :

				     //cptbasics.Ndrywetmonofx(i, phaser) : //for N number of channels
				     
				     cptbasics.stereodrywetmonofx(i, phaser) ://for 2 channels only; enables effect balance slider
     	                             cptbasics.bargraphoutput(i));
