/* 
    Copyright (C) 2024, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptreverb";
declare description "reverb filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.11";
declare license "GPL 3.0 or later";

//link the librarys
si = library("signals.lib");
re = library("reverbs.lib");
co = library("compressors.lib");
cptbasics = library("lib/basics.lib");

// constanta used in this program
constant = environment {
	     nchannels = 2;// number of channels; 1 for mono, 2 for stereo
			 fb1 = 1;// coefficient of the lowpass comb filters
			 fb2 = 1;// coefficient of the allpass comb filters
	   };

// a function for the reverb
reverb = re.mono_freeverb(constant.fb1, constant.fb2,damp,spread)
with {
  damp = hslider("[1][lv2:integer]damp",0,0,127,1)/127 : si.smoo;
  spread = hslider("[2]spatial spread",0,0,100,1);
};

// the process, that is going to be executed; contains the functions that are described before
//process = drywet(par(i, constant.nchannels, reverb ):limiter);
process = par(i,  constant.nchannels, cptbasics.bargraphinput(i) :
				      cptbasics.drywetmono(reverb) :
				      cptbasics.bargraphoutput(i));
