/* 
    Copyright (C) 2024, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptdelay";
declare description "delay filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.11";
declare license "GPL 3.0 or later";

//link the librarys
si = library("signals.lib");
fi = library("effect.lib");
ma = library("maths.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
	     nchannels = 2; //number of channels; 1 for mono, 2 for stereo
	   };

//a slider for the gain
gain = hslider("[1]gain",1,0,1,0.01) : si.smoo;

//a slider for the feedback
feedback = hslider("[2]feedback", 0.5,0,1,0.01) : si.smoo;

//a slider for the delay
M = 60 / hslider("[3][lv2: integer]delay bpm",120,1,300,1);// M in seconds
//M = hslider("[5]delay left",1,1,10,0.5);

//calculating the echo
monoecho(d,f) = +~bounce(d,f) with {
    bounce(d,f) = @(d) : *(f);
};

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par( i, constant.nchannels,(cptbasics.bargraphinput(i) :
				     cptbasics.drywetmono(monoecho(ma.SR*M,feedback) * gain) ) :
	                             cptbasics.bargraphoutput(i));

