#ifndef PROCESSA_H
#define PROCESSA_H

#include <opencv2/opencv.hpp>
#include "definitions.h"

class Processa
{
private:
    int NBloks;
    int Type;
    bool *Reset;

    cv::Mat AccMean;
    int CountMean;

    cv::Mat AccS2;
    int CountStd;

    cv::Mat AccGavd;
    cv::Mat frame_old;
    int CountGavd;

    cv::Mat filter_mean(const cv::Mat frame);
    cv::Mat filter_std(const cv::Mat frame);
    cv::Mat filter_gavd(const cv::Mat frame);
public:
    Processa(void);
    void mat_release(void);
    void set_reset_handle(bool *reset);
    void set_count(int count);
    void set_type(int type);
    void set_nbloks(int nbloks);
    cv::Mat filter(const cv::Mat frame);
};

#endif // PROCESSA_H
