/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/***************************************************************************
 *            main.c
 *
 *  Sat Aug 21 23:02:47 2004
 *  Copyright  2004  Gergely Polonkai
 *  polesz@techinfo.hu
 ****************************************************************************/

#include "botcommander.h"

#include <gtk/gtk.h>
#include <netdb.h>
#include <string.h>
#include <arpa/inet.h>
#include <errno.h>
#include <unistd.h>

#include "variables.h"
#include "functions.h"

static_data_t StaticData;
gchar *PackageVersion;
gchar *PackageVersionFeed;
gchar CurrentMode;
gboolean Connected;

/*
 * ExitCleanly()
 * Exits cleanly, closes all connections, destroys widgets.
 */
void
ExitCleanly(void)
{
	if (Connected)
	{
		return;
	}

	gtk_main_quit();
}

/*
 * ChangeMode()
 * Changes the current mode, and does all the stuff this requires (changing menu
 * and toolbar items, updating status bar
 */
gboolean
ChangeMode(gchar mode)
{
	GtkWidget *item = NULL;
	
	switch (mode)
	{
		case 'B':
			item = gtk_item_factory_get_item(StaticData.main_factory, "/Mode/BotCommander command");
			if (ConfigData.debug_mode)
			{
				FeedInfoToTerminal(TRUE, "Changed to BotCommander command mode.");
			}
			break;
		case 'M':
			item = gtk_item_factory_get_item(StaticData.main_factory, "/Mode/Message");
			if (ConfigData.debug_mode)
			{
				FeedInfoToTerminal(TRUE, "Changed to Message mode.");
			}
			break;
		case 'E':
			item = gtk_item_factory_get_item(StaticData.main_factory, "/Mode/Eggdrop command");
			if (ConfigData.debug_mode)
			{
				FeedInfoToTerminal(TRUE, "Changed to Eggdrop command mode.");
			}
			break;
		default:
			item = NULL;
	}
	
	if (item != NULL)
	{
		gtk_signal_emit_by_name(GTK_OBJECT(item), "activate");
		CurrentMode = mode;
	}
	else
	{
		return FALSE;
	}
	
	return TRUE;
}

signed int
Connect(gchar *hostname, short port)
{
	struct hostent *h;
	
	if ((h = gethostbyname(hostname)) == NULL)
	{
		FeedErrorToTerminal(TRUE, "Cannot resolve %s", hostname);
		return FALSE;
	}
	
	ConnectData.sin_family = AF_INET;
	ConnectData.sin_addr = *((struct in_addr *)h->h_addr);
	ConnectData.sin_port = htons(port);
	memset(&(ConnectData.sin_zero), 0, 8);
	
	FeedInfoToTerminal(TRUE, "Connecting to %s:%d...", inet_ntoa(ConnectData.sin_addr), ntohs(ConnectData.sin_port));
	
	if ((StaticData.socket = socket(PF_INET, SOCK_STREAM, 0)) < 0)
	{
		FeedErrorToTerminal(TRUE, "Unable to create socket.");
		return -1;
	}
	
	if (connect(StaticData.socket, (struct sockaddr *)&ConnectData, sizeof(struct sockaddr)) < 0)
	{
		FeedErrorToTerminal(TRUE, "Unable to connect to the remote host.");
		return -1;
	}
	
	if (ConfigData.debug_mode)
	{
		FeedInfoToTerminal(TRUE, "Connected.");
	}
	
	if (ConfigData.change_to_message)
	{
		ChangeMode('M');
	}
	
	Connected = TRUE;
	
	return 0;
}

/*
 * DataReady()
 * Called when data is ready on the network socket
 */
void
DataReady(gpointer data, gint source, GdkInputCondition cond)
{
	gchar buf[3000];
	gint numbytes;
	
	if ((numbytes = recv(StaticData.socket, buf, 2048, 0)) == -1)
	{
		FeedErrorToTerminal(TRUE, strerror(errno));
		return;
	}
	
	buf[numbytes] = '\0';
	
	if (numbytes == 0)
	{
		FeedInfoToTerminal(TRUE, "Disconnected.");
		close(StaticData.socket);
		ChangeMode('B');
		Connected = FALSE;
		return;
	}
	
	/* The following code is from php source code. I know I have to clean it, but it works :) */
	char *src = g_strdup((char *)&buf);
	int src_len = strlen((char *)&buf);
	int nl;
	int *new_len = &nl;

	char *outbuf = 0;

	if (src && src_len)
	{
		int outlen = src_len;
    int outlenleft = src_len;
		int inlenleft = src_len;
		iconv_t ic = iconv_open("UTF-8", "ISO-8859-2");
		char* src_ptr = (char*)src;
		char* out_ptr = 0;

		if(ic != (iconv_t)-1)
		{
			size_t st;
			outbuf = (char*)g_malloc(outlen + 1);
			if(outbuf)
			{
				out_ptr = (char*)outbuf;
				while(inlenleft)
				{
					st = iconv(ic, &src_ptr, &inlenleft, &out_ptr, &outlenleft);
					if(st == -1)
					{
            if(errno == E2BIG)
						{
              int diff = out_ptr - outbuf;
              outlen += inlenleft;
              outlenleft += inlenleft;
              outbuf = (char*)realloc(outbuf, outlen + 1);
              if(!outbuf)
							{
                break;
              }
              out_ptr = outbuf + diff;
            }
            else
						{
              free(outbuf);
              outbuf = 0;
              break;
            }
					}
				}
			}
			iconv_close(ic);
		}
		outlen -= outlenleft;

		if(new_len)
		{
			*new_len = outbuf ? outlen : 0;
		}
		if(outbuf)
		{
			outbuf[outlen] = 0;
		}
	}
	FeedMessageToTerminal(TRUE, outbuf);
}

/*
 * main()
 * Do I really have to tell you what this function for?
 */
int
main(int argc, char **argv)
{
	gtk_init(&argc, &argv);
	
	PackageVersion = CreateVersionString(FALSE);
	PackageVersionFeed = CreateVersionString(TRUE);
	Connected = FALSE;
	
	if (!ConfigInit())
	{
		ExitCleanly();
		return 1;
	}
	
	if (!CreateMainWindow())
	{
		GtkWidget *dialog;
		
		dialog = gtk_message_dialog_new(NULL,
		                                0,
		                                GTK_MESSAGE_ERROR,
		                                GTK_BUTTONS_OK,
		                                "There was an error while creating the main window.");
		gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
		gtk_dialog_run(GTK_DIALOG(dialog));

		return 1;
	}
	
	ChangeMode('B');
	
	FeedMessageToTerminal(TRUE, PackageVersionFeed);
	gtk_main();

	return (0);
}
