/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/***************************************************************************
 *            typedefs.h
 *
 *  Sat Aug 21 23:48:44 2004
 *  Copyright  2004  Gergely Polonkai
 *  polesz@techinfo.hu
 ****************************************************************************/

#ifndef _BC_TYPEDEFS_H
# define _BC_TYPEDEFS_H

# include <gtk/gtk.h>
# include <vte/vte.h>
# include <stdio.h>
# include <iconv.h>

# include "defines.h"

typedef struct {
	GtkWidget *main_window;
	GtkWidget *main_vbox;
	GtkWidget *main_commandline;
	VteTerminal *main_vte;
	GtkWidget *main_menu;
	GtkItemFactory *main_factory;
	int socket;
	gint socket_tag;
	gchar CurrentMode;
} static_data_t;

typedef struct {
	/* Scrolls to the bottom of the terminal when data arrives */
	gboolean scroll_on_output;
	/* Terminal's background is transparent */
	gboolean transparent_background;
	/* If it is, here is the saturation */
	gfloat background_saturation;
	/* We are in debug mode, thus printing a bit more information (can be annoying :) ) */
	gboolean debug_mode;
	/* A pango font name, used by the terminal widget only */
	gchar *vte_font;
	/* Change to message mode after connected. */
	gboolean change_to_message;
} OldTConfigData;

typedef struct {
	char *name;
	int type;
	union {
		gboolean bool_val;
		gint int_val;
		gfloat float_val;
		gchar *string_val;
	} value;
} config_data_t;

typedef struct {
	/* The command word */
	gchar *command;
	/* The type of the command. 0 - Internal, 1 - Got from a module, 2 - Got from a script */
	gint type;
	/* The command's callback function */
	BC_COMMAND_DEF(func);
} command_t;

#endif /* _BC_TYPEDEFS_H */
