# SPEC file for package libbiddy1 and libbiddy1-devel
# Usage: rpmbuild -bb biddy.spec
#
# You may have to create/change your ~/.rpmmacros
# http://rpm5.org/docs/api/macros.html
#
# Here is my ~/.rpmmacros which has only a single line:
# %_topdir        /home/meolic/biddy/rpm
#
# This file has been constructed using the following examples:
#
# http://www.rpm-based.org/how-to-create-rpm-package
# http://www.rpm.org/max-rpm/
# http://kmymoney2.sourceforge.net/phb/rpm-example.html
# http://dries.ulyssis.org/apt/packages/gnunet/gnunet-spec.html
# 

Summary: A multi-platform academic BDD package
Name: libbiddy1
Version: THISVERSION
Release: THISRELEASE
License: GPL
Group: Other
URL: http://lms.uni-mb.si/biddy/
Source: libbiddy1-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}
Packager: meolic

%description
Biddy is a special purpose mathematical library (Binary Decision Diagrams package).

 Biddy uses ROBDDs with complement edges.
 Biddy is oriented towards readable and comprehensible source code in C.
 Biddy is used in EST, a tool for formal verification of systems.

http://lms.uni-mb.si/biddy/

%package devel
Requires: libbiddy1 = %{version}-%{release}
Summary: A multi-platform academic BDD package (development files)
Group: Other

%description devel
Biddy is a special purpose mathematical library (Binary Decision Diagrams package).

 Biddy uses ROBDDs with complement edges.
 Biddy is oriented towards readable and comprehensible source code in C.
 Biddy is used in EST, a tool for formal verification of systems.

http://lms.uni-mb.si/biddy/

This package contains the development headers, only.

%prep
echo "Preparing %{name}-%{version}-%{release}"
%setup -q
echo "Sources OK. Let's go building!"

%build
%{__make} dynamic "BINDIR=`pwd`"

%install
%{__rm} -rf %{buildroot}
%{__make} DESTDIR=%{buildroot}/usr install "BINDIR=`pwd`"
%{__make} DESTDIR=%{buildroot}/usr installdev "BINDIR=`pwd`"

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-, root, root, 0755)
%doc VERSION CHANGES COPYING
%{_libdir}/libbiddy.so.%{version}
%{_libdir}/libbiddy.so.1

%files devel
%defattr(-, root, root, 0755)
%{_includedir}/
%{_libdir}/libbiddy.so

%changelog
