/**CHeaderFile*************************************************************
  PackageName [Biddy]
  Synopsis    [Biddy provides data structures and algorithms
               for the representation and manipulation of Boolean
               functions with ROBDDs. A hash table is used for quick
               search of nodes. Complement edges decreases the number
               of nodes. Function ITE is given for manipulation of
               boolean functions. An automatic garbage collection with
               a formulae counter is implemented.]

  FileName    [biddyInt.h]
  Revision    [$Revision: 27 $]
  Date        [$Date: 2010-07-22 12:55:07 +0200 (Thu, 22 Jul 2010) $]
  Authors     [Robert Meolic (meolic@uni-mb.si),
               Ales Casar (casar@uni-mb.si)]
  Description [File biddyInt.h contains declaration of internal
               data structures.]
  SeeAlso     [biddy.h]

  Copyright   [This file is part of Biddy.
               Copyright (C) 2006, 2007, 2008, 2009, 2010 UM-FERI
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               Biddy is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               Biddy is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

#ifndef _BIDDYINT
#define _BIDDYINT

#include "biddy.h"

/* sleep() is not included in modern version of MINGW */
/* #define sleep(sec) (Sleep ((sec) * 1000), 0) */

#ifdef WIN32
#define sleep(sec) 0
#endif

/*-----------------------------------------------------------------------*/
/* Constant declarations                                                 */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Type declarations                                                     */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Structure declarations                                                */
/*-----------------------------------------------------------------------*/

/* NODE TABLE = a hash table with chaining */
typedef struct BiddyNode {
  struct BiddyNode *prev, *next;  /* !!!MUST BE FIRST AND SECOND */
  struct BiddyNode *list;         /* list of nodes (previously named new) */
  Biddy_Variable v;               /* variable                    */
  Biddy_Edge f, t;                /* f = else, t = then          */
  int count;                      /* formulae counter            */
} BiddyNode;

typedef struct {
  BiddyNode **table;
  BiddyNode **blocklist;  /* table of allocated memory blocks */
  int size;               /* size of node table */
  int max;                /* maximal number of nodes in node table */
  int num;                /* number of nodes currently in node table */
  int numf;               /* number of fortified nodes */
  int foa;                /* number of calls to Biddy_FoaNode */
  int compare;            /* number of comparisons made by Biddy_FoaNode */
  int add;                /* number of adds made by Biddy_FoaNode */
  int garbage;            /* number of garbage collections */
  int generated;          /* number of free nodes generated */
  int blocknumber;        /* number of allocated memory blocks */
} BiddyNodeTable;

/* VARIABLE TABLE = dynamicaly allocated table */
typedef struct {
  Biddy_String name;             /* name of variable             */
  int order;                     /* order of variable            */
  Biddy_Edge term;               /* pointer to terminal          */
  Biddy_Boolean value;           /* value = 0,1                  */
} BiddyVariable;

typedef struct {
  BiddyVariable *table;
  int size;                      /* size of variable table */
} BiddyVariableTable;

/* CACHE LIST = unidirectional list */
typedef struct BiddyCacheList {
  struct BiddyCacheList *next;
  Biddy_UserFunction gc;
} BiddyCacheList;

/* ITE Cache = a fixed-size hash table */
typedef struct {
  BiddyNode *f, *g, *h;
  Biddy_Edge result;
  Biddy_Boolean hmark;
  Biddy_Boolean ok;     /* FALSE = not valid record! */
} BiddyIteCache;

typedef struct {
  BiddyIteCache *table;
  int size;
  int search;
  int find;
  int overwrite;
} BiddyIteCacheTable;

/* EAX Cache = a fixed-size hash table */
typedef struct {
  BiddyNode *f;
  BiddyVariable v;
  Biddy_Edge result;
  Biddy_Boolean fmark;
  Biddy_Boolean ok;     /* FALSE = not valid record! */
} BiddyEAxCache;

typedef struct {
  BiddyEAxCache *table;
  int size;
  int search;
  int find;
  int overwrite;
} BiddyEAxCacheTable;

/*-----------------------------------------------------------------------*/
/* Variable declarations                                                 */
/*-----------------------------------------------------------------------*/

extern int biddyCount;

extern unsigned int biddyBlockSize;

extern unsigned int biddyIteCacheSize;

extern unsigned int biddyEAxCacheSize;

extern BiddyNodeTable biddyNodeTable;

extern BiddyVariableTable biddyVariableTable;

extern BiddyCacheList *biddyCacheList;

extern BiddyNode *biddyNewNodes;

extern BiddyNode *biddyFirstNewNode;

extern BiddyNode *biddyFreshNodes;

extern BiddyNode *biddyFreeNodes;

extern BiddyIteCacheTable biddyIteCache;

extern BiddyEAxCacheTable biddyEAxCache;

/**AutomaticStart*********************************************************/

/*-----------------------------------------------------------------------*/
/* Function prototypes                                                   */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* INTERNAL FUNCTIONS DEFINED IN biddyMain.c                             */
/*-----------------------------------------------------------------------*/

extern void BiddyExchange(Biddy_Edge *f, Biddy_Edge *g);

extern void BiddyExchangeNeg(Biddy_Edge *f, Biddy_Edge *g);

/*-----------------------------------------------------------------------*/
/* INTERNAL FUNCTIONS DEFINED IN biddyStat.c                             */
/*-----------------------------------------------------------------------*/

/**AutomaticEnd***********************************************************/

#endif  /* _BIDDYINT */
