@echo off

REM  Author: Robert Meolic (meolic@uni-mb.si)
REM  $Revision: 13 $
REM  $Date: 2010-07-22 13:17:11 +0200 (Thu, 22 Jul 2010) $
REM
REM  This file is part of Bdd Scout package.
REM  Copyright (C) 2008, 2009, 2010 UM-FERI
REM  UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia
REM
REM  Bdd Scout is free software; you can redistribute it and/or modify
REM  it under the terms of the GNU General Public License as
REM  published by the Free Software Foundation; either version 2
REM  of the License, or (at your option) any later version.
REM
REM  Bdd Scout is distributed in the hope that it will be useful,
REM  but WITHOUT ANY WARRANTY; without even the implied warranty of
REM  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
REM  GNU General Public License for more details.
REM
REM  You should have received a copy of the GNU General Public
REM  License along with this program; if not, write to the Free
REM  Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
REM  Boston, MA 02110-1301 USA.]

SET NAME=bddscout
FOR /F "USEBACKQ" %%T IN (`TYPE VERSION`) DO SET VVERSION=%%T
SET VERSION=%VVERSION:.=-%
SET MYZIP=N:\info-zip\zip.exe -o -q
SET MAKESFX=N:\FreeExtractor\MakeSFX.exe

rm -f %NAME%-bin-%VERSION%-Win.zip
rm -f %NAME%-%VERSION%-Win.zip

rm -fr .\%NAME%-%VERSION%

cd ..\biddy
make static "BINDIR = ../bddscout/%NAME%-%VERSION%"
make clean "BINDIR = ../bddscout/%NAME%-%VERSION%"
cp biddy.h ../bddscout/%NAME%-%VERSION%
cp CHANGES ../bddscout/%NAME%-%VERSION%/CHANGES_biddy

cd ..\bddview
cp bddview.tcl ../bddscout/%NAME%-%VERSION%
cp CHANGES ../bddscout/%NAME%-%VERSION%/CHANGES_bddview
cp example.bddview ../bddscout/%NAME%-%VERSION%

cd ..\bddscout
cp bddscout.def ./%NAME%-%VERSION%
cp bddscout.h ./%NAME%-%VERSION%
cp bddscout.c ./%NAME%-%VERSION%
cp bddscout.tcl ./%NAME%-%VERSION%
cp pkgIndex.tcl ./%NAME%-%VERSION%
cp bddscoutIFIP.def ./%NAME%-%VERSION%
cp bddscoutIFIP.c ./%NAME%-%VERSION%
cp bddscoutIFIP.tcl ./%NAME%-%VERSION%
cp pkgExtensionIFIP.tcl ./%NAME%-%VERSION%
cp Makefile ./%NAME%-%VERSION%
cp Makefile.MINGW ./%NAME%-%VERSION%
cp CHANGES ./%NAME%-%VERSION%/CHANGES_bddscout
cp example.bf ./%NAME%-%VERSION%
cp example.bdd ./%NAME%-%VERSION%

cd ./%NAME%-%VERSION%
make package -f Makefile.MINGW "BIDDYDIR = ." "BIDDYLIB = ." "BINDIR = ."
make clean "BINDIR = ."

cd ..
cp COPYING ./%NAME%-%VERSION%
cp README ./%NAME%-%VERSION%
cp README.MINGW ./%NAME%-%VERSION%

echo "Creating %NAME%-%VERSION%-Win.exe ..."

%MYZIP% %NAME%-%VERSION%-Win.zip .\%NAME%-%VERSION%\*
%MYZIP% %NAME%-%VERSION%-Win.zip IFIP\* -x .svn
%MYZIP% %NAME%-%VERSION%-Win.zip IFIP\*\* -x .svn

%MAKESFX% /zip="%NAME%-%VERSION%-Win.zip" /sfx="%NAME%-%VERSION%-Win.exe" /title="BDD Scout" /website="http://lms.uni-mb.si/biddy/" /intro="Version %VVERSION%\n\nBDD Scout is a demo application demonstrating the capability\n of BDD package Biddy and Tcl/Tk BDD viewer bddview.\n\nThis is free software. See GNU GPL (version 2).\n\nYou need ActiveTcl and graphviz installed on your computer.\nTo start the program click bddscout.tcl in target folder.\n\nFreeExtractor Wizard will extract files into the target folder.\n\nNOTE: No registry entry will be changed and no file will be\n            created outside the target folder. You can uninstall\n            this software by simply deleting the target folder.\n\nRobert Meolic (meolic@uni-mb.si)" /defaultpath="C:\Program Files\bddscout" /shortcut="$desktop$\BDDSCOUT.LNK|$targetdir$\%NAME%-%VERSION%\bddscout.tcl" /overwrite

rm -fr .\%NAME%-%VERSION%
rm -f %NAME%-%VERSION%-Win.zip

echo *******************
echo PACKAGES COMPLETED!
echo *******************
