<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Bibledit-Web Installation</title>
<link rel="stylesheet" href="stylesheet.css" type="text/css" />
</head>
<body>
<h1><img src="../assets/bibledit.png"> <a href="http://bibledit.org/">Bibledit-Web</a></h1>
<?php


error_reporting (E_ALL);


@include ("credentials.php");


// Get the credentials from the form.
if (isset ($_POST ['name'])) $database_name = $_POST ['name'];
if (isset ($_POST ['user'])) $database_user = $_POST ['user'];
if (isset ($_POST ['pass'])) $database_pass = $_POST ['pass'];
if (isset ($_POST ['host'])) $database_host = $_POST ['host'];


// Create a configuration out of the credentials.
$contents = <<<EOD
<?php
// Credentials for accessing the MySQL database.
// You can modify these to suit your installation.
// Be sure to only change the text within the double quotes.
// The double quotes themselves should remain in place.

// Host: This is the server where the database runs.
database_host = "$database_host";
// Name: This is the name of the database.
database_name = "$database_name";
// User: This is the username of the database administrator.
database_user = "$database_user";
// Pass: This is the password of the database administrator.
database_pass = "$database_pass";

?>
EOD;
$contents = str_replace (array ('database_host =',  'database_name =',  'database_user',   'database_pass ='),
                         array ('$database_host =', '$database_name =', '$database_user', '$database_pass ='),
                         $contents);


// Save the credentials to the database file.
@$success = file_put_contents ("credentials.php", $contents);
if ($success === false) {

  // Error handler for saving to file.
  $error = error_get_last ();
  $error = $error ["message"];
  ?>
  <h1>Error writing database credentials to file</h1>
  <p>This means that Bibledit-Web does not have permission to write the information to file <code><?php echo realpath ("credentials.php"); ?></code>.</p>
  <ul>
    <li>Are you sure you have permission to write to the file?</li>
    <li>Would you be able to create the file by hand?</li>
  </ul>
  <p>The technical message is this: <?php echo $error ?></p>
  <p>If you're unsure what these terms mean you can contact your hosting provider.</p>
  <p>Bibledit-Web tried to store the following code into that file:</p>
  <div><?php highlight_string ($contents); ?></div>
  <p><a href="database.php" class="button button-large">Try again</a></p>
  <?php

} else {

  // Contact the database server.
  @$mysqli = new mysqli ($database_host, $database_user, $database_pass);
  if ($mysqli->connect_errno) {

    // Error handling contacting database server.
    ?>
    <h1>Error establishing a database server connection</h1>
    <p>This either means that the username and password information in your <code>credentials.php</code> file is incorrect or Bibledit-Web can't contact the database server. This could mean your host's database server is down.</p>
    <ul>
      <li>Are you sure you have the correct username and password?</li>
      <li>Are you sure that you have typed the correct hostname?</li>
      <li>Are you sure that the database server is running?</li>
    </ul>
    <p>The technical message is this: <?php echo $mysqli->connect_error ?></p>
    <p>If you're unsure what these terms mean you can contact your hosting provider.</p>
    <p><a href="database.php" class="button button-large">Try again</a></p>
    <?php

  } else {

    // Connect to the database.
    $errors = array ();
    $connected = $mysqli->select_db ($database_name);
    if (!$connected) {
      $errors [] = $mysqli->error;
      // The database was not found. Create it. Use utf8 unicode by default.
      $mysqli->query ("CREATE DATABASE `$database_name` DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci;");
      if ($mysqli->errno) {
        $errors [] = $mysqli->error;
      }
      $connected = $mysqli->select_db ($database_name);
    }
    if (!$connected) {

      // Display page about connection error to the database.
      ?>
      <h1>Error connecting to the database table</h1>
      <p>This probably means that the username and password in your <code>credentials.php</code> do not have sufficient permissions to create a database table on the database server.</p>
      <ul>
        <li>Are you sure you have sufficient permissions for the username and password to create a table?</li>
        <li>Would you be able you manually create table <code><?php echo $name ?></code> on the database server?</li>
      </ul>
      <p>The technical messages are the following:</p>
      <ul>
      <?php foreach ($errors as $error) echo "<li>$error</li>"; ?>
      </ul>
      <p>If you're unsure what these terms mean you can contact your hosting provider.</p>
      <p><a href="database.php" class="button button-large">Try again</a></p>
      <?php

    } else {

      // Display a page saying all went well with the database.
      ?>
      <p>Well done! You have made it through this part of the installation. Bibledit-Web can now communicate with your database. If you are ready, let's continue the installation.</p>
      <p class="step"><a href="libraries.php" class="button button-large">Continue installing</a></p>
      <?php

    }

  }

}


?>
</body>
</html>
