<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


error_reporting (E_ALL);
ini_set('display_errors', '1');


require_once ("../database/sqlite.php");
require_once ("../database/sqliteinjection.php");
require_once ("../database/config/general.php");
require_once ("../database/config/user.php");


$database_config_general = Database_Config_General::getInstance ();
$database_config_general->create ();


$database_config_user = Database_Config_User::getInstance ();
$database_config_user->create ();


if (!file_exists ("credentials.php")) return;


require_once ("mysql.php");


// Import config_general from MySQL to SQLite when SQLite has no data yet.
$count = 0;
$query = "SELECT value FROM config_general;";
$result = Database_SQLite::query ($database_config_general->db, $query);
foreach ($result as $row) $count++;
if ($count == 0) {
  $database = Setup_MySQL::getInstance ();
  $query = "SELECT * FROM config_general;";
  $result = $database->runQuery ($query);
  for ($i = 0; $i < $result->num_rows; $i++) {
    $row = $result->fetch_assoc ();
    $ident = $row ['ident'];
    $ident = Database_SQLiteInjection::no ($ident);
    $value = $row ['value'];
    $value = Database_SQLiteInjection::no ($value);
    $offset = $row ['offset'];
    $query = "INSERT INTO config_general (ident, value, offset) VALUES ('$ident', '$value', $offset);";
    Database_SQLite::exec ($database_config_general->db, $query);
  }
}


// Import config_user from MySQL to SQLite when SQLite has no data yet.
$count = 0;
$query = "SELECT value FROM config_user;";
$result = Database_SQLite::query ($database_config_user->db, $query);
foreach ($result as $row) $count++;
if ($count == 0) {
  $database = Setup_MySQL::getInstance ();
  $query = "SELECT * FROM config_user;";
  $result = $database->runQuery ($query);
  for ($i = 0; $i < $result->num_rows; $i++) {
    $row = $result->fetch_assoc ();
    $username = $row ['username'];
    $username = Database_SQLiteInjection::no ($username);
    $bible = $row ['bible'];
    $bible = Database_SQLiteInjection::no ($bible);
    $ident = $row ['ident'];
    $ident = Database_SQLiteInjection::no ($ident);
    $value = $row ['value'];
    $value = Database_SQLiteInjection::no ($value);
    $offset = $row ['offset'];
    $query = "INSERT INTO config_user (username, bible, ident, value, offset) VALUES ('$username', '$bible', '$ident', '$value', $offset);";
    Database_SQLite::exec ($database_config_user->db, $query);
  }
}




?>
