<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("../bootstrap/bootstrap.php");
page_access_level ((Filter_Roles::MANAGER_LEVEL));
$header = new Assets_Header (gettext ("Download resource"));
$header->run ();
$view = new Assets_View (__FILE__);


$database_resources = Database_Resources::getInstance ();
$database_offlineresources = Database_OfflineResources::getInstance ();


@$name = $_GET['name'];
$view->view->name = $name;


if (isset ($_GET ['download'])) {
  $timer_logger = new Timer_Logger ();
  $arguments = array ($name);
  $timer_logger->startProcess (dirname (__FILE__), "php", "downloadcli.php", $arguments, "download", true);
  $database_logger = Database_Logger::getInstance ();
  // Downloading some resources takes time, but it should be limited to 3 days.
  $database_logger->updateTimeToLive ("download", 36);
  header ("Location: ../manage/logbook.php");
  die;
}


if (isset ($_GET ['clear'])) {
  $database_offlineresources->delete ($name);
}


$count = $database_offlineresources->count ($name);
$view->view->count = $count;


$view->render ("download.php");


Assets_Page::footer ();


?>
