-- Copyright (©) 2003-2013 Teus Benschop.

-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


USE `BIBLEDITDATABASE`;


CREATE TABLE IF NOT EXISTS logger (
  pid int,
  logfile varchar(1024)
) engine = MyISAM;


DROP PROCEDURE IF EXISTS upgrade_one;
DELIMITER //
CREATE PROCEDURE upgrade_one () 
BEGIN
  SET @version := (SELECT version FROM version WHERE NAME = 'logger');
  IF @version IS NULL THEN 
    ALTER TABLE logger ADD timestamp int;
    INSERT INTO version VALUES (NULL, 'logger', 1);
  END IF;
END;
//
DELIMITER ;
CALL upgrade_one ();
DROP PROCEDURE upgrade_one;


DROP PROCEDURE IF EXISTS upgrade_two;
DELIMITER //
CREATE PROCEDURE upgrade_two () 
BEGIN
  SET @version := (SELECT version FROM version WHERE NAME = 'logger');
  IF @version = 1 THEN 
    ALTER TABLE logger CHANGE timestamp expire int;
    ALTER TABLE logger ADD process varchar (256);
    UPDATE version SET version = 2 WHERE name = 'logger';
  END IF;
END;
//
DELIMITER ;
CALL upgrade_two ();
DROP PROCEDURE upgrade_two;

