<h1><?php echo gettext ("Scrum-based Translation") ?></h1>
<h2><?php echo gettext ("Introduction") ?></h2>
<p>
 <?php echo gettext ("What is Scrum-based translation?") ?>
 <?php echo gettext ("A translation team that works with Scrum frequently releases portions of translated Scripture.") ?>
 <?php echo gettext ("This makes it clear to involved parties where the translation project is going.") ?>
 <?php echo gettext ("It enables the translation team to make course corrections based on the facts.") ?>
 <?php echo gettext ("Burndown charts and the product backlog provide the product owner and others with a permanent overview over the translation status and progress.") ?>
 <?php echo gettext ("Scrum is an agile process that enables self-organizing translation teams to deliver high translation output and accuracy in a short time.") ?>
 <?php echo gettext ("Using iterative translation, it releases portions of translated Scripture every iteration, that is, every month.") ?>
 <?php echo gettext ("At the end of the every sprint, anyone can see the translated portion, and decide whether to release it to the congregations and community for feedback or continue to enhance it.") ?>
</p>
<br>
<p>
 <?php echo gettext ("The introduction and the following explanation just outlines the mechanics of Scrum-based Translation.") ?>
 <?php echo gettext ("It does not make clear what difficulties and issues you will run into trying to implement it.") ?>
 <?php echo gettext ("It only hints at the agile spirit that's required to make it work.") ?>
 <?php echo gettext ("If you're interested in implementing Scrum-based translation, do some reading, watch videos, follow a course, find a mentor or coach.") ?>
</p>
<h2><?php echo gettext ("Product Owner") ?></h2>
<p>
 <?php echo gettext ("The Product Owner represents the stakeholders.") ?>
 <?php echo gettext ("He or she is the voice of the target audience, that is the Bible reader.") ?>
 <?php echo gettext ("He understands the requirements for the Bible.") ?>
 <?php echo gettext ("The Product Owner may also be a group of people in a committee.") ?>
</p>
<br>
<p>
 <?php echo gettext ("He is responsible for ensuring that the team delivers accuracy and reliability to the Bible translation.") ?>
 <?php echo gettext ("He knows about accuracy and reliability.") ?>
</p>
<br>
<p>
 <?php echo gettext ("He defines items that focus on desired features.") ?>
 <?php echo gettext ("He makes decisions as to whether to implement footnotes or leave them out.") ?>
 <?php echo gettext ("In the same way, he defines other features, like headers, introductions, or decides to leave them out.") ?>
 <?php echo gettext ("He decides about use or non-use of a dialect.") ?>
</p>
<br>
<p>
 <?php echo gettext ("He sets the priorities for the work to be done.") ?>
 <?php echo gettext ("He adds the items to the product backlog.") ?>
</p>
<br>
<p>
 <?php echo gettext ("Scrum teams should have one Product Owner.") ?>
 <?php echo gettext ("The Product Owner may be part of the Translation Team, but it is recommended that his role not be combined with the role of Scrum Master.") ?>
</p>

<h2><?php echo gettext ("Release Planning") ?></h2>
<p>
 <?php echo gettext ("The release planning shows which parts of the Bible will be translated and delivered during which Sprint.") ?>
 <?php echo gettext ("It is convenient to define a Sprint in months, so that the release planning mentions January, February, and so on.") ?>
</p>
<br>
<p>
 <?php echo gettext ("It is often helpful to stick the release planning to the wall so that everybody can see the grand picture.") ?>
</p>
<br>
<p><?php echo gettext ("The advantages of a release planning are:") ?></p>
<p><?php echo gettext ("1. It gives the team a common vision about what needs to be achieved, and when.") ?></p>
<p><?php echo gettext ("2. It guides the team to make decisions during detailed planning.") ?></p>
<p><?php echo gettext ("3. It helps prioritize the actions.") ?></p>
<p><?php echo gettext ("4. It resolves conflicts and guides the teams toward the right balance on trade-offs.") ?></p>
<br>
<p>
 <?php echo gettext ("Release each completed Bible book to the community and get their feedback.") ?>
 <?php echo gettext ("This implements the important principle of continual improvement.") ?>
</p>
<br>
<p>
  <?php echo gettext ("The release planning is a simple way of doing top-down planning.") ?>
  <?php echo gettext ("It is an estimate, simple and quick to do.") ?>
  <?php echo gettext ("It is based on the Product Backlog.") ?>
</p>

<h2><?php echo gettext ("Product Backlog") ?></h2>
<p>
  <?php echo gettext ("The product backlog is an ordered list of requirements that is maintained for the Bible translation.") ?>
  <?php echo gettext ("It consists of translation tasks, checking tasks, testing tasks, comprehension tasks, whatever needs to be done to deliver a reliable manuscript.") ?>
</p>
<p>
  <?php echo gettext ("The Product Owner prioritizes the items on this list.") ?>
  <?php echo gettext ("It is used to determine the work for the next sprints.") ?>
  <?php echo gettext ("Each item has an associated estimated time to complete.") ?>
</p>

<h2><?php echo gettext ("Sprint") ?></h2>
<p>
 <?php echo gettext ("A sprint typically takes one month.") ?>
</p>
<br>
<p>
 <?php echo gettext ("This is where the translaton work (translate, review, approve, test) occurs.") ?>
</p>
<br>
<p>
 <?php echo gettext ("Each member of the team translates independently and in a responsible manner.") ?>
 <?php echo gettext ("In case a translator is sure of a required change, he enters it without consulting others.") ?>
 <?php echo gettext ("If a translator thinks a proposed change needs discussion, he notifies his colleagues.") ?>
</p>
<br>
<p>
 <?php echo gettext ("All members of the translation team review the changes made by the team.") ?>
 <?php echo gettext ("This is to make sure that all changes are reviewed by all members, that no mistakes occur.") ?>
 <?php echo gettext ("The reviews take place every day.") ?>
</p>
<br>
<p>
 <?php echo gettext ("This way of working is based on personal responsibility and mutual trust.") ?>
 <?php echo gettext ("It speeds up the translation procedure because there's more actual translation work going on, and less discussions.") ?>
 <?php echo gettext ("The newer members of the team learn from the more experienced ones through the daily reviews.") ?>
</p>
<br>
<p>
 <?php echo gettext ("Bibledit-Web has the concept of daily Change Notifications.") ?>
 <?php echo gettext ("A member can opt to receive the Change Notifications through email.") ?>
 <?php echo gettext ("This email can be viewed online also.") ?>
 <?php echo gettext ("Or a member can opt to have the Change Notifications generated for him online, and can review and approve them there.") ?>
</p>

<h2><?php echo gettext ("Sprint Planning Meeting") ?></h2>
<p><?php echo gettext ("During this meeting the team selects the portions to translate, review and test it believes it can commit to in a sprint.") ?></p>
<p><?php echo gettext ("The team breaks the portions down into tasks and provided estimates for those tasks as to the time it takes to complete them.") ?></p>

<h2><?php echo gettext ("Sprint Backlog") ?></h2>
<p>
  <?php echo gettext ("The sprint backlog is a list of tasks to be completed in a sprint.") ?>
  <?php echo gettext ("The tasks are created by breaking down the product backlog items during the planning meeting.") ?></p>
  <?php echo gettext ("The tasks have estimates in hours or days associated with them.") ?>
</p>
<br>
<p>
 <?php echo gettext ("For a team it is vitally important to have a clear goal to work towards.") ?>
 <?php echo gettext ("Thus everybody is focused on the desired outcome, and keeps a good pace.") ?>
 <?php echo gettext ("Without a clear goal, the team may still do a lot of things and work hard, but the produced results may have the desired value.") ?>
</p>

<h2><?php echo gettext ("Team") ?></h2>
<p>
  <?php echo gettext ("The team consistes of the Bible translators, their assistants, and the consultants.") ?>
</p>
<p>
  <?php echo gettext ("The team organizes itself to carry out the work and deliver a reliable and good Bible translation.") ?>
</p>

<h2><?php echo gettext ("Scrum Master") ?></h2>
<p>
  <?php echo gettext ("The scrum master organizes the translation process.") ?>
</p>
<p>
  <?php echo gettext ("He or she keeps track of the progress of the translation team.") ?>
</p>
<p>
  <?php echo gettext ("He removes obstacles from the path of the team.") ?>
</p>

<h2><?php echo gettext ("Daily Scrum Meeting") ?></h2>
<p>
 <?php echo gettext ("On each day of a sprint, the Bible translation team holds daily meetings.") ?>
 <?php echo gettext ("These meetings are called: Daily scrum meetings.") ?>
 <?php echo gettext ("The scrum meetings are held in the same place and at the same time.") ?>
 <?php echo gettext ("The meetings are typically held in front of Task Board.") ?>
 <?php echo gettext ("The daily scrum meeting is best held in the morning, because it assists in setting the context for the work of that day.") ?>
 <?php echo gettext ("During the meeting, all members stand, as this keeps the discussion short and relevant.") ?>
 <?php echo gettext ("The scrum meeting is strictly time-boxed to 15 minutes.") ?>
</p>
<br>
<p>
 <?php echo gettext ("There is a difference between people who are 'committed' to the Bible translation project, and those who are 'involved' in it.") ?>
 <?php echo gettext ("Scrum affords special status to those who are committed.") ?>
 <?php echo gettext ("Many teams enforce a rule in which only those who are committed are allowed to talk during the daily scrum meeting.") ?>
</p>
<br>
<p>
 <?php echo gettext ("All team members are required to attend the scrum meetings.") ?>
 <?php echo gettext ("The Scrum Master and the and Product Owner (usually the Bible Translation Manager) are committed team members.") ?>
 <?php echo gettext ("They are expected to attend and participate.") ?>
 <?php echo gettext ("Anyone else, for example a Church leader, a Committee member, or a Translator from another team, is allowed to attend but is there to listen only.") ?>
 <?php echo gettext ("This makes the daily scrum meeting an excellent way for a scrum team to disseminate information.") ?>
 <?php echo gettext ("If you are interested in hearing the status of the project, attend that day's meeting.") ?>
</p>
<br>
<p>
 <?php echo gettext ("The scrum meeting is not the place for solving problems or resolving issues.") ?>
 <?php echo gettext ("Issues that are raised are usually dealt with by one or two team members immediately after the scrum.") ?>
</p>
<br>
<p><?php echo gettext ("During the daily Scrum, each team member answers the following three questions:") ?></p>
<p>1. <?php echo gettext ("What did you do yesterday?") ?></p>
<p>2. <?php echo gettext ("What are you going to do today?") ?></p>
<p>3. <?php echo gettext ("Are there any impediments in your way?") ?></p>
<p><?php echo gettext ("The Scrum Master asks each team member to answer these questions, the member speaks, the Scrum Master thanks the member, and then goes to the next member.") ?></p>
<br>
<p>
 <?php echo gettext ("By focusing on what each person did yesterday and will do today, the team gains an understanding of what work has been done and what work remains.") ?>
 <?php echo gettext ("The daily scrum meeting is not a status update meeting in which the boss is finding out about who is slow in his work.") ?>
 <?php echo gettext ("Rather, it is a meeting in which team members make commitments to each other.") ?>
 <?php echo gettext ("If a translator says: Today, I will prepare chapter 10 and 11 of Matthew, everyone knows that in tomorrow's meeting, he will say whether or not he did finish.") ?>
 <?php echo gettext ("This has the wonderful effect of helping a team realize the significance of these commitments, and that their commitments are to each other, and not to anyone else.") ?>
</p>
<br>
<p>
 <?php echo gettext ("Any impediments that are raised in the daily scrums become the Scrum Master's responsibility to resolve as quickly as possible.") ?>
 <?php echo gettext ("Typical impediments are:") ?>
</p>
<p>1. <?php echo gettext ("My ... broke and I need a new one today.") ?></p>
<p>2. <?php echo gettext ("I still haven't got the ... I requested a month ago.") ?></p>
<p>3. <?php echo gettext ("I'm struggling to understand ... and would like to discuss it with someone.") ?></p>
<p>4. <?php echo gettext ("The ... has asked me to work on something else for a few days.") ?></p>
<p>
 <?php echo gettext ("In cases where the Scrum Master cannot remove these impediments directly himself, he still takes responsibility for making sure someone on the team does quickly resolve the issue.") ?>
</p>
<br>
<p>
 <?php echo gettext ("Every day a different person leads the daily scrum meeting.") ?>
 <?php echo gettext ("This gets the entire team involved.") ?>
 <?php echo gettext ("It opens up new channels for communication.") ?>
 <?php echo gettext ("It builds trust between the Translators and the Scrum Master.") ?>
 <?php echo gettext ("Team members can learn from one another's techniques.") ?>
 <?php echo gettext ("The Scrum Master ensures to set a good example for leading the daily scrum meeting.") ?>
</p>
<br>
<p>
  <?php echo gettext ("The scrum master uses the information from the meeting to update the burndown chart illustrating progress.") ?>
</p>
<br>
<p>
  <?php echo gettext ("Side conversations are taken offline.") ?>
</p>
<br>
<p><a href="http://en.wikipedia.org/wiki/Stand-up_meeting" target="_blank"><?php echo gettext ("External reference") ?></a></p>

<h2><?php echo gettext ("Burn down chart") ?></h2>
<p>
 <?php echo gettext ("A burn down chart is a graphical representation of work left to do versus time.") ?>
 <?php echo gettext ("The outstanding work is on the vertical axis.") ?>
 <?php echo gettext ("The days of the sprint are on the horizontal axis.") ?>
 <?php echo gettext ("It is useful for predicting when all of the work will be completed.") ?>
</p>
<br>
<p><a href="http://en.wikipedia.org/wiki/Burn_down_chart" target="_blank"><?php echo gettext ("External reference") ?></a></p>

<h2><?php echo gettext ("Sprint Review") ?></h2>
<p><?php echo gettext ("The Product Owner looks through the sprint’s work and provides feedback.") ?></p>
<p><?php echo gettext ("The Translators may demonstrate features.") ?></p>
<p><?php echo gettext ("The Team owns up to deficiencies with the translation, helping to build trust with the Product Owner.") ?></p>

<h2><?php echo gettext ("Sprint Retrospective") ?></h2>
<p><?php echo gettext ("The Team reviews what went well and what went poorly.") ?></p>
<p><?php echo gettext ("They use retrospection techniques to find potential for improvement.") ?></p>
<p><?php echo gettext ("They pick one or two areas to focus for improvement.") ?></p>
