/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.outerj.daisy.diff.DaisyDiff;
import org.outerj.daisy.diff.HtmlCleaner;
import org.outerj.daisy.diff.XslFilter;
import org.outerj.daisy.diff.html.HTMLDiffer;
import org.outerj.daisy.diff.html.HtmlSaxDiffOutput;
import org.outerj.daisy.diff.html.TextNodeComparator;
import org.outerj.daisy.diff.html.dom.DomTreeBuilder;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Main {
    static boolean quietMode = false;

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) throws URISyntaxException {
        if (stringArray.length < 2) {
            Main.help();
        }
        boolean bl = true;
        boolean bl2 = true;
        String string = "daisydiff.htm";
        String[] stringArray2 = new String[]{};
        try {
            void var8_17;
            for (int i = 2; i < stringArray.length; ++i) {
                String[] stringArray3 = stringArray[i].split("=");
                if (stringArray3[0].equalsIgnoreCase("--file")) {
                    string = stringArray3[1];
                    continue;
                }
                if (stringArray3[0].equalsIgnoreCase("--type")) {
                    if (!stringArray3[1].equalsIgnoreCase("tag")) continue;
                    bl = false;
                    continue;
                }
                if (stringArray3[0].equalsIgnoreCase("--css")) {
                    stringArray2 = stringArray3[1].split(";");
                    continue;
                }
                if (stringArray3[0].equalsIgnoreCase("--output")) {
                    if (!stringArray3[1].equalsIgnoreCase("xml")) continue;
                    bl2 = false;
                    continue;
                }
                if (stringArray3[0].equals("--q")) {
                    quietMode = true;
                    continue;
                }
                Main.help();
            }
            if (!quietMode) {
                System.out.println("            ______________");
                System.out.println("           /Daisy Diff 1.0\\");
                System.out.println("          /________________\\");
                System.out.println();
                System.out.println(" -= http://code.google.com/p/daisydiff/ =-");
                System.out.println("");
                System.out.println();
                System.out.println("Comparing documents:");
                System.out.println("  " + stringArray[0]);
                System.out.println("and");
                System.out.println("  " + stringArray[1]);
                System.out.println();
                if (bl) {
                    System.out.println("Diff type: html");
                } else {
                    System.out.println("Diff type: tag");
                }
                System.out.println("Writing " + (bl2 ? "html" : "xml") + " output to " + string);
            }
            if (stringArray2.length > 0) {
                if (!quietMode) {
                    System.out.println("Adding external css files:");
                }
                for (String object2 : stringArray2) {
                    System.out.println("  " + object2);
                }
            }
            if (!quietMode) {
                System.out.println("");
                System.out.print(".");
            }
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
            transformerHandler.setResult(new StreamResult(new File(string)));
            InputStream inputStream = stringArray[0].startsWith("http://") ? new URI(stringArray[0]).toURL().openStream() : new FileInputStream(stringArray[0]);
            if (stringArray[1].startsWith("http://")) {
                InputStream inputStream2 = new URI(stringArray[1]).toURL().openStream();
            } else {
                FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            }
            XslFilter xslFilter = new XslFilter();
            if (bl) {
                TransformerHandler transformerHandler2 = bl2 ? xslFilter.xsl(transformerHandler, "org/outerj/daisy/diff/htmlheader.xsl") : transformerHandler;
                Locale locale = Locale.getDefault();
                String string2 = "diff";
                HtmlCleaner htmlCleaner = new HtmlCleaner();
                InputSource inputSource = new InputSource(inputStream);
                InputSource inputSource2 = new InputSource((InputStream)var8_17);
                DomTreeBuilder domTreeBuilder = new DomTreeBuilder();
                htmlCleaner.cleanAndParse(inputSource, domTreeBuilder);
                System.out.print(".");
                TextNodeComparator textNodeComparator = new TextNodeComparator(domTreeBuilder, locale);
                DomTreeBuilder domTreeBuilder2 = new DomTreeBuilder();
                htmlCleaner.cleanAndParse(inputSource2, domTreeBuilder2);
                System.out.print(".");
                TextNodeComparator textNodeComparator2 = new TextNodeComparator(domTreeBuilder2, locale);
                transformerHandler2.startDocument();
                transformerHandler2.startElement("", "diffreport", "diffreport", new AttributesImpl());
                Main.doCSS(stringArray2, transformerHandler2);
                transformerHandler2.startElement("", "diff", "diff", new AttributesImpl());
                HtmlSaxDiffOutput htmlSaxDiffOutput = new HtmlSaxDiffOutput(transformerHandler2, string2);
                HTMLDiffer hTMLDiffer = new HTMLDiffer(htmlSaxDiffOutput);
                hTMLDiffer.diff(textNodeComparator, textNodeComparator2);
                System.out.print(".");
                transformerHandler2.endElement("", "diff", "diff");
                transformerHandler2.endElement("", "diffreport", "diffreport");
                transformerHandler2.endDocument();
            } else {
                TransformerHandler transformerHandler3 = bl2 ? xslFilter.xsl(transformerHandler, "org/outerj/daisy/diff/tagheader.xsl") : transformerHandler;
                transformerHandler3.startDocument();
                transformerHandler3.startElement("", "diffreport", "diffreport", new AttributesImpl());
                transformerHandler3.startElement("", "diff", "diff", new AttributesImpl());
                System.out.print(".");
                DaisyDiff.diffTag(new BufferedReader(new InputStreamReader(inputStream)), new BufferedReader(new InputStreamReader((InputStream)var8_17)), (ContentHandler)transformerHandler3);
                System.out.print(".");
                transformerHandler3.endElement("", "diff", "diff");
                transformerHandler3.endElement("", "diffreport", "diffreport");
                transformerHandler3.endDocument();
            }
        }
        catch (Throwable throwable) {
            if (quietMode) {
                System.out.println(throwable);
            }
            throwable.printStackTrace();
            if (throwable.getCause() != null) {
                throwable.getCause().printStackTrace();
            }
            if (throwable instanceof SAXException) {
                ((SAXException)throwable).getException().printStackTrace();
            }
            Main.help();
        }
        if (quietMode) {
            System.out.println();
        } else {
            System.out.println("done");
        }
    }

    private static void doCSS(String[] stringArray, ContentHandler contentHandler) throws SAXException {
        contentHandler.startElement("", "css", "css", new AttributesImpl());
        for (String string : stringArray) {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "href", "href", "CDATA", string);
            attributesImpl.addAttribute("", "type", "type", "CDATA", "text/css");
            attributesImpl.addAttribute("", "rel", "rel", "CDATA", "stylesheet");
            contentHandler.startElement("", "link", "link", attributesImpl);
            contentHandler.endElement("", "link", "link");
        }
        contentHandler.endElement("", "css", "css");
    }

    private static void help() {
        System.out.println("==========================");
        System.out.println("DAISY DIFF HELP:");
        System.out.println("java -jar daisydiff.jar [oldHTML] [newHTML]");
        System.out.println("--file=[filename] - Write output to the specified file.");
        System.out.println("--type=[html/tag] - Use the html (default) diff algorithm or the tag diff.");
        System.out.println("--css=[cssfile1;cssfile2;cssfile3] - Add external CSS files.");
        System.out.println("--output=[html/xml] - Write html (default) or xml output.");
        System.out.println("--q  - Generate less console output.");
        System.out.println("");
        System.out.println("EXAMPLES: ");
        System.out.println("(1)");
        System.out.println("java -jar daisydiff.jar http://web.archive.org/web/20070107145418/http://news.bbc.co.uk/ http://web.archive.org/web/20070107182640/http://news.bbc.co.uk/ --css=http://web.archive.org/web/20070107145418/http://news.bbc.co.uk/nol/shared/css/news_r5.css");
        System.out.println("(2)");
        System.out.println("java -jar daisydiff.jar http://cocoondev.org/wiki/291-cd/version/15/part/SimpleDocumentContent/data http://cocoondev.org/wiki/291-cd/version/17/part/SimpleDocumentContent/data --css=http://cocoondev.org/resources/skins/daisysite/css/daisy.css --output=xml --file=daisysite.htm");
        System.out.println("==========================");
        System.exit(0);
    }
}

