/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.subscribers;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;

public class SubscriberChangeEvent
implements ISubscriberChangeEvent {
    private final Subscriber subscriber;
    private final int flags;
    private final IResource resource;

    public SubscriberChangeEvent(Subscriber subscriber, int flags, IResource resource) {
        this.subscriber = subscriber;
        this.flags = flags;
        this.resource = resource;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public static SubscriberChangeEvent[] asSyncChangedDeltas(Subscriber subscriber, IResource[] resources) {
        SubscriberChangeEvent[] deltas = new SubscriberChangeEvent[resources.length];
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            deltas[i] = new SubscriberChangeEvent(subscriber, 1, resource);
            ++i;
        }
        return deltas;
    }
}

