﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {

/**
 * <p>Describes a route in a transit gateway route table.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TransitGatewayRouteTableRoute">AWS
 * API Reference</a></p>
 */
class TransitGatewayRouteTableRoute {
 public:
  AWS_EC2_API TransitGatewayRouteTableRoute() = default;
  AWS_EC2_API TransitGatewayRouteTableRoute(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_EC2_API TransitGatewayRouteTableRoute& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_EC2_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_EC2_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The CIDR block used for destination matches.</p>
   */
  inline const Aws::String& GetDestinationCidr() const { return m_destinationCidr; }
  inline bool DestinationCidrHasBeenSet() const { return m_destinationCidrHasBeenSet; }
  template <typename DestinationCidrT = Aws::String>
  void SetDestinationCidr(DestinationCidrT&& value) {
    m_destinationCidrHasBeenSet = true;
    m_destinationCidr = std::forward<DestinationCidrT>(value);
  }
  template <typename DestinationCidrT = Aws::String>
  TransitGatewayRouteTableRoute& WithDestinationCidr(DestinationCidrT&& value) {
    SetDestinationCidr(std::forward<DestinationCidrT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The state of the route.</p>
   */
  inline const Aws::String& GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  template <typename StateT = Aws::String>
  void SetState(StateT&& value) {
    m_stateHasBeenSet = true;
    m_state = std::forward<StateT>(value);
  }
  template <typename StateT = Aws::String>
  TransitGatewayRouteTableRoute& WithState(StateT&& value) {
    SetState(std::forward<StateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The route origin. The following are the possible values:</p> <ul> <li>
   * <p>static</p> </li> <li> <p>propagated</p> </li> </ul>
   */
  inline const Aws::String& GetRouteOrigin() const { return m_routeOrigin; }
  inline bool RouteOriginHasBeenSet() const { return m_routeOriginHasBeenSet; }
  template <typename RouteOriginT = Aws::String>
  void SetRouteOrigin(RouteOriginT&& value) {
    m_routeOriginHasBeenSet = true;
    m_routeOrigin = std::forward<RouteOriginT>(value);
  }
  template <typename RouteOriginT = Aws::String>
  TransitGatewayRouteTableRoute& WithRouteOrigin(RouteOriginT&& value) {
    SetRouteOrigin(std::forward<RouteOriginT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the prefix list.</p>
   */
  inline const Aws::String& GetPrefixListId() const { return m_prefixListId; }
  inline bool PrefixListIdHasBeenSet() const { return m_prefixListIdHasBeenSet; }
  template <typename PrefixListIdT = Aws::String>
  void SetPrefixListId(PrefixListIdT&& value) {
    m_prefixListIdHasBeenSet = true;
    m_prefixListId = std::forward<PrefixListIdT>(value);
  }
  template <typename PrefixListIdT = Aws::String>
  TransitGatewayRouteTableRoute& WithPrefixListId(PrefixListIdT&& value) {
    SetPrefixListId(std::forward<PrefixListIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the route attachment.</p>
   */
  inline const Aws::String& GetAttachmentId() const { return m_attachmentId; }
  inline bool AttachmentIdHasBeenSet() const { return m_attachmentIdHasBeenSet; }
  template <typename AttachmentIdT = Aws::String>
  void SetAttachmentId(AttachmentIdT&& value) {
    m_attachmentIdHasBeenSet = true;
    m_attachmentId = std::forward<AttachmentIdT>(value);
  }
  template <typename AttachmentIdT = Aws::String>
  TransitGatewayRouteTableRoute& WithAttachmentId(AttachmentIdT&& value) {
    SetAttachmentId(std::forward<AttachmentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the resource for the route attachment.</p>
   */
  inline const Aws::String& GetResourceId() const { return m_resourceId; }
  inline bool ResourceIdHasBeenSet() const { return m_resourceIdHasBeenSet; }
  template <typename ResourceIdT = Aws::String>
  void SetResourceId(ResourceIdT&& value) {
    m_resourceIdHasBeenSet = true;
    m_resourceId = std::forward<ResourceIdT>(value);
  }
  template <typename ResourceIdT = Aws::String>
  TransitGatewayRouteTableRoute& WithResourceId(ResourceIdT&& value) {
    SetResourceId(std::forward<ResourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource type for the route attachment.</p>
   */
  inline const Aws::String& GetResourceType() const { return m_resourceType; }
  inline bool ResourceTypeHasBeenSet() const { return m_resourceTypeHasBeenSet; }
  template <typename ResourceTypeT = Aws::String>
  void SetResourceType(ResourceTypeT&& value) {
    m_resourceTypeHasBeenSet = true;
    m_resourceType = std::forward<ResourceTypeT>(value);
  }
  template <typename ResourceTypeT = Aws::String>
  TransitGatewayRouteTableRoute& WithResourceType(ResourceTypeT&& value) {
    SetResourceType(std::forward<ResourceTypeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_destinationCidr;

  Aws::String m_state;

  Aws::String m_routeOrigin;

  Aws::String m_prefixListId;

  Aws::String m_attachmentId;

  Aws::String m_resourceId;

  Aws::String m_resourceType;
  bool m_destinationCidrHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_routeOriginHasBeenSet = false;
  bool m_prefixListIdHasBeenSet = false;
  bool m_attachmentIdHasBeenSet = false;
  bool m_resourceIdHasBeenSet = false;
  bool m_resourceTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
