/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JakartaOsonContext;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.JsonpOsonContext;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public class OsonArrayImpl
extends OsonAbstractArray
implements OracleJsonArray {
    public OsonArrayImpl(OsonContext ctx, int pos) {
        super(ctx, pos);
    }

    @Override
    public Iterator<OracleJsonValue> iterator() {
        return new OsonAbstractArray.ValueIter<OracleJsonValue>();
    }

    @Override
    public OracleJsonValue get(int index) {
        return (OracleJsonValue)this.getInternal(index);
    }

    @Override
    public ListIterator<OracleJsonValue> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public List<OracleJsonValue> subList(int fromIndex, int toIndex) {
        return super.sublist(fromIndex, toIndex);
    }

    @Override
    public ListIterator<OracleJsonValue> listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return new OsonAbstractArray.ListIter<OracleJsonValue>(index);
    }

    @Override
    public <T> T wrap(Class<T> c) {
        OsonContext newCtx = Jsonp.isJakartaJson(c) ? new JakartaOsonContext(this.ctx) : new JsonpOsonContext(this.ctx);
        return c.cast(newCtx.valueFactory.createArray(newCtx, this.pos));
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        JsonSerializerImpl ser = new JsonSerializerImpl(writer);
        ser.write(this);
        ser.close();
        return writer.toString();
    }

    @Override
    public <T extends OracleJsonValue> List<T> getValuesAs(Class<T> c) {
        return this;
    }

    @Override
    public double getDouble(int index) {
        int childOffset = this.getOffsetWithError(index);
        return ((OracleJsonNumberImpl)this.getValueInternal(childOffset)).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        int childOffset = this.getOffsetWithError(index);
        return ((OracleJsonNumberImpl)this.getValueInternal(childOffset)).bigDecimalValue();
    }

    @Override
    public long getLong(int index) {
        int childOffset = this.getOffsetWithError(index);
        return ((OracleJsonNumberImpl)this.getValueInternal(childOffset)).longValue();
    }

    @Override
    public LocalDateTime getLocalDateTime(int index) {
        OracleJsonValue o = (OracleJsonValue)this.getValueInternal(this.getOffsetWithError(index));
        if (o.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return ((OracleJsonDate)o).getLocalDateTime();
        }
        return ((OracleJsonTimestamp)o).getLocalDateTime();
    }

    @Override
    public OffsetDateTime getOffsetDateTime(int index) {
        OracleJsonValue o = (OracleJsonValue)this.getValueInternal(this.getOffsetWithError(index));
        return ((OracleJsonTimestampTZ)o).getOffsetDateTime();
    }

    @Override
    public byte[] getBytes(int index) {
        int childOffset = this.getOffsetWithError(index);
        OracleJsonBinary bin = (OracleJsonBinary)this.getValueInternal(childOffset);
        return bin.getBytes();
    }

    @Override
    public boolean add(OracleJsonValue e) {
        throw this.createNotModifiable();
    }

    @Override
    public boolean addAll(Collection<? extends OracleJsonValue> c) {
        throw this.createNotModifiable();
    }

    @Override
    public boolean addAll(int index, Collection<? extends OracleJsonValue> c) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int index, OracleJsonValue element) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(int index, OracleJsonValue element) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue remove(int index) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int index, String value) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(String value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int index, int value) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(int value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int index, double value) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(double value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int index, boolean value) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(boolean value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue setNull(int index) {
        throw this.createNotModifiable();
    }

    @Override
    public void addNull() {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int index, LocalDateTime value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int index, OffsetDateTime value) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(LocalDateTime value) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(OffsetDateTime value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int index, byte[] value) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(byte[] value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int index, long value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue set(int index, BigDecimal value) throws OracleJsonException {
        throw this.createNotModifiable();
    }

    @Override
    public void add(long value) {
        throw this.createNotModifiable();
    }

    @Override
    public void add(BigDecimal value) {
        throw this.createNotModifiable();
    }

    private UnsupportedOperationException createNotModifiable() {
        throw OracleJsonExceptions.ARR_NOT_MUTABLE.create(OracleJsonExceptions.ORACLE_FACTORY, new Object[0]);
    }
}

