/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.AbstractParameter;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.ParameterType;
import org.linuxsampler.lscp.Parser;

public class StringParameter
extends AbstractParameter<String> {
    public StringParameter() {
        this.setType(ParameterType.STRING);
        this.setMultiplicity(false);
    }

    public StringParameter(String string) {
        this(string, null);
    }

    public StringParameter(String string, String string2) {
        this();
        this.setName(string);
        this.setValue(string2);
    }

    protected StringParameter(String[] stringArray) throws LscpException {
        this();
        this.parseLines(stringArray);
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (super.parse(string)) {
            return true;
        }
        if (string.startsWith("DEFAULT: ")) {
            string = string.substring("DEFAULT: ".length());
            this.setDefault(Parser.removeQuotation(string));
            return true;
        }
        if (string.startsWith("POSSIBILITIES: ")) {
            string = string.substring("POSSIBILITIES: ".length());
            this.setPossibilities(Parser.parseStringList(string));
            return true;
        }
        return false;
    }

    @Override
    public void parseValue(String string) throws LscpException {
        if (string == null || string.length() == 0) {
            this.setValue(string);
        } else if (string.charAt(0) != '\'' || string.charAt(string.length() - 1) != '\'') {
            throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
        }
        this.setValue(string.substring(1, string.length() - 1));
    }

    @Override
    public String getStringValue() {
        return '\'' + (String)this.getValue() + '\'';
    }
}

