/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.scroll;

import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.utils.Sideable;

public class SubstanceScrollButton
extends JButton
implements UIResource,
Sideable {
    private int orientation;

    public SubstanceScrollButton(int orientation) {
        this.setRequestFocusEnabled(false);
        this.setMargin(new Insets(0, 0, 0, 2));
        this.orientation = orientation;
        this.putClientProperty("substancelaf.useThemedDefaultIcons", Boolean.FALSE);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public SubstanceConstants.Side getSide() {
        switch (this.orientation) {
            case 1: {
                return SubstanceConstants.Side.BOTTOM;
            }
            case 7: {
                return SubstanceConstants.Side.RIGHT;
            }
            case 5: {
                return SubstanceConstants.Side.TOP;
            }
            case 3: {
                return SubstanceConstants.Side.LEFT;
            }
        }
        return null;
    }

    static {
        FadeConfigurationManager.getInstance().disallowFades(FadeKind.GHOSTING_BUTTON_PRESS, SubstanceScrollButton.class);
        FadeConfigurationManager.getInstance().disallowFades(FadeKind.GHOSTING_ICON_ROLLOVER, SubstanceScrollButton.class);
    }
}

