"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ledvanceTz = exports.ledvanceFz = void 0;
exports.ledvanceOnOff = ledvanceOnOff;
exports.ledvanceLight = ledvanceLight;
const zigbee_herdsman_1 = require("zigbee-herdsman");
const utils = __importStar(require("../lib/utils"));
const modernExtend = __importStar(require("./modernExtend"));
const utils_1 = require("./utils");
const manufacturerOptions = { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.OSRAM_SYLVANIA };
exports.ledvanceFz = {
    pbc_level_to_action: {
        cluster: "genLevelCtrl",
        type: ["commandMoveWithOnOff", "commandStopWithOnOff", "commandMove", "commandStop", "commandMoveToLevelWithOnOff"],
        convert: (model, msg, publish, options, meta) => {
            if (utils.hasAlreadyProcessedMessage(msg, model))
                return;
            const lookup = {
                commandMoveWithOnOff: "hold",
                commandMove: "hold",
                commandStopWithOnOff: "release",
                commandStop: "release",
                commandMoveToLevelWithOnOff: "toggle",
            };
            return { [utils.postfixWithEndpointName("action", msg, model, meta)]: lookup[msg.type] };
        },
    },
};
exports.ledvanceTz = {
    ledvance_commands: {
        /* deprecated osram_*/
        key: ["set_transition", "remember_state", "osram_set_transition", "osram_remember_state"],
        convertSet: async (entity, key, value, meta) => {
            if (key === "osram_set_transition" || key === "set_transition") {
                if (value) {
                    utils.assertNumber(value, key);
                    const transition = value > 1 ? Number((Math.round(Number((value * 2).toFixed(1))) / 2).toFixed(1)) * 10 : 1;
                    const payload = { 18: { value: transition, type: 0x21 }, 19: { value: transition, type: 0x21 } };
                    await entity.write("genLevelCtrl", payload);
                }
            }
            else if (key === "osram_remember_state" || key === "remember_state") {
                if (value === true) {
                    await entity.command("manuSpecificOsram", "saveStartupParams", {}, manufacturerOptions);
                }
                else if (value === false) {
                    await entity.command("manuSpecificOsram", "resetStartupParams", {}, manufacturerOptions);
                }
            }
        },
    },
};
// Ledvance OTAs are not valid against the Zigbee spec, the last image element fails to parse but the
// update succeeds even without sending it. Therefore set suppressElementImageParseFailure to true
// https://github.com/Koenkk/zigbee2mqtt/issues/16900
function ledvanceOnOff(args) {
    // biome-ignore lint/style/noParameterAssign: ignored using `--suppress`
    args = { ota: { suppressElementImageParseFailure: true }, ...args };
    return modernExtend.onOff(args);
}
function ledvanceLight(args) {
    // biome-ignore lint/style/noParameterAssign: ignored using `--suppress`
    args = { powerOnBehavior: false, ota: { suppressElementImageParseFailure: true }, ...args };
    if (args.colorTemp)
        args.colorTemp.startup = false;
    if (args.color)
        args.color = { modes: ["xy", "hs"], ...((0, utils_1.isObject)(args.color) ? args.color : {}) };
    const result = modernExtend.light(args);
    result.toZigbee.push(exports.ledvanceTz.ledvance_commands);
    return result;
}
//# sourceMappingURL=ledvance.js.map