/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util;

import com.jogamp.common.util.Bitfield;

public class Int32ArrayBitfield
implements Bitfield {
    private static final int UNIT_SHIFT = 5;
    private final int[] storage;
    private final int bitSize;

    public Int32ArrayBitfield(int n) {
        int n2 = Math.max(1, n + 31 >>> 5);
        this.storage = new int[n2];
        this.bitSize = n2 << 5;
    }

    @Override
    public int size() {
        return this.bitSize;
    }

    @Override
    public final void clearField(boolean bl) {
        int n = bl ? -1 : 0;
        for (int i = this.storage.length - 1; i >= 0; --i) {
            this.storage[i] = n;
        }
    }

    private static final void check(int n, int n2) throws IndexOutOfBoundsException {
        if (0 > n2 || n2 >= n) {
            throw new IndexOutOfBoundsException("Bitnum should be within [0.." + (n - 1) + "], but is " + n2);
        }
    }

    @Override
    public final int get32(int n, int n2) throws IndexOutOfBoundsException {
        if (0 > n2 || n2 > 32) {
            throw new IndexOutOfBoundsException("length should be within [0..32], but is " + n2);
        }
        Int32ArrayBitfield.check(this.bitSize - n2 + 1, n);
        int n3 = n >>> 5;
        int n4 = 32 - (n - (n3 << 5));
        if (32 == n4) {
            int n5 = Bitfield.Util.getBitMask(n2);
            return n5 & this.storage[n3];
        }
        int n6 = Math.min(n2, n4);
        int n7 = (1 << n6) - 1;
        int n8 = n7 & this.storage[n3] >>> n;
        int n9 = n2 - n6;
        if (n9 > 0) {
            int n10 = (1 << n9) - 1;
            return n8 | (n10 & this.storage[n3 + 1]) << n6;
        }
        return n8;
    }

    @Override
    public final void put32(int n, int n2, int n3) throws IndexOutOfBoundsException {
        if (0 > n2 || n2 > 32) {
            throw new IndexOutOfBoundsException("length should be within [0..32], but is " + n2);
        }
        Int32ArrayBitfield.check(this.bitSize - n2 + 1, n);
        int n4 = n >>> 5;
        int n5 = 32 - (n - (n4 << 5));
        if (32 == n5) {
            int n6 = Bitfield.Util.getBitMask(n2);
            this.storage[n4] = ~n6 & this.storage[n4] | n6 & n3;
        } else {
            int n7 = Math.min(n2, n5);
            int n8 = (1 << n7) - 1;
            this.storage[n4] = ~(n8 << n) & this.storage[n4] | (n8 & n3) << n;
            int n9 = n2 - n7;
            if (n9 > 0) {
                int n10 = (1 << n9) - 1;
                this.storage[n4 + 1] = ~n10 & this.storage[n4 + 1] | n10 & n3 >>> n7;
            }
        }
    }

    @Override
    public final int copy32(int n, int n2, int n3) throws IndexOutOfBoundsException {
        int n4 = this.get32(n, n3);
        this.put32(n2, n3, n4);
        return n4;
    }

    @Override
    public final boolean get(int n) throws IndexOutOfBoundsException {
        Int32ArrayBitfield.check(this.bitSize, n);
        int n2 = n >>> 5;
        int n3 = n - (n2 << 5);
        return 0 != (this.storage[n2] & 1 << n3);
    }

    @Override
    public final boolean put(int n, boolean bl) throws IndexOutOfBoundsException {
        boolean bl2;
        Int32ArrayBitfield.check(this.bitSize, n);
        int n2 = n >>> 5;
        int n3 = n - (n2 << 5);
        int n4 = 1 << n3;
        boolean bl3 = bl2 = 0 != (this.storage[n2] & n4);
        if (bl2 != bl) {
            if (bl) {
                int n5 = n2;
                this.storage[n5] = this.storage[n5] | n4;
            } else {
                int n6 = n2;
                this.storage[n6] = this.storage[n6] & ~n4;
            }
        }
        return bl2;
    }

    @Override
    public final void set(int n) throws IndexOutOfBoundsException {
        Int32ArrayBitfield.check(this.bitSize, n);
        int n2 = n >>> 5;
        int n3 = n - (n2 << 5);
        int n4 = 1 << n3;
        int n5 = n2;
        this.storage[n5] = this.storage[n5] | n4;
    }

    @Override
    public final void clear(int n) throws IndexOutOfBoundsException {
        Int32ArrayBitfield.check(this.bitSize, n);
        int n2 = n >>> 5;
        int n3 = n - (n2 << 5);
        int n4 = 1 << n3;
        int n5 = n2;
        this.storage[n5] = this.storage[n5] & ~n4;
    }

    @Override
    public final boolean copy(int n, int n2) throws IndexOutOfBoundsException {
        Int32ArrayBitfield.check(this.bitSize, n);
        Int32ArrayBitfield.check(this.bitSize, n2);
        int n3 = n >>> 5;
        int n4 = n - (n3 << 5);
        boolean bl = 0 != (this.storage[n3] & 1 << n4);
        n3 = n2 >>> 5;
        n4 = n2 - (n3 << 5);
        int n5 = 1 << n4;
        if (bl) {
            int n6 = n3;
            this.storage[n6] = this.storage[n6] | n5;
        } else {
            int n7 = n3;
            this.storage[n7] = this.storage[n7] & ~n5;
        }
        return bl;
    }

    @Override
    public int bitCount() {
        int n = 0;
        for (int i = this.storage.length - 1; i >= 0; --i) {
            n += Bitfield.Util.bitCount(this.storage[i]);
        }
        return n;
    }
}

