# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_qrtool_global_optspecs
	string join \n h/help V/version
end

function __fish_qrtool_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_qrtool_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_qrtool_using_subcommand
	set -l cmd (__fish_qrtool_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c qrtool -n "__fish_qrtool_needs_command" -s h -l help -d 'Print help'
complete -c qrtool -n "__fish_qrtool_needs_command" -s V -l version -d 'Print version'
complete -c qrtool -n "__fish_qrtool_needs_command" -f -a "encode" -d 'Encode input data in a QR code'
complete -c qrtool -n "__fish_qrtool_needs_command" -f -a "decode" -d 'Detect and decode a QR code'
complete -c qrtool -n "__fish_qrtool_needs_command" -f -a "completion" -d 'Generate shell completion'
complete -c qrtool -n "__fish_qrtool_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -s o -l output -d 'Output the result to a file' -r -F
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -s r -l read-from -d 'Read input data from a file' -r -F
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -s s -l size -d 'The module size in pixels' -r
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -s l -l error-correction-level -l level -d 'Error correction level' -r -f -a "l\t'Level L'
m\t'Level M'
q\t'Level Q'
h\t'Level H'"
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -s v -l symbol-version -l symversion -d 'The version of the symbol' -r
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -s m -l margin -d 'The width of margin' -r
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -s t -l type -d 'The format of the output' -r -f -a "png\t'Portable Network Graphics'
svg\t'Scalable Vector Graphics'
pic\t'PIC markup language'
ansi\t'To the terminal using 4-bit ANSI escape sequences'
ansi256\t'To the terminal using 8-bit ANSI escape sequences'
ansi-true-color\t'To the terminal using 24-bit ANSI escape sequences'
ascii\t'To the terminal as ASCII string'
ascii-invert\t'To the terminal as ASCII string'
unicode\t'To the terminal as UTF-8 string'
unicode-invert\t'To the terminal as UTF-8 string'"
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -l optimize-png -d 'Set the optimization level for a PNG image' -r -f -a "0\t'Level 0'
1\t'Level 1'
2\t'Level 2'
3\t'Level 3'
4\t'Level 4'
5\t'Level 5'
6\t'Level 6'"
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -l zopfli -d 'Use Zopfli to compress PNG image' -r
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -l mode -d 'The mode of the output' -r -f -a "numeric\t'All digits'
alphanumeric\t'Alphanumerics and few symbols'
byte\t'Arbitrary binary data'
kanji\t'Shift JIS text'"
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -l variant -d 'The type of QR code' -r -f -a "normal\t'Normal QR code'
micro\t'Micro QR code'"
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -l foreground -d 'Foreground color' -r
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -l background -d 'Background color' -r
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -l verbose -d 'Also print the metadata'
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c qrtool -n "__fish_qrtool_using_subcommand encode" -s V -l version -d 'Print version'
complete -c qrtool -n "__fish_qrtool_using_subcommand decode" -s t -l type -d 'The format of the input' -r -f -a "bmp\t'Windows Bitmap'
dds\t'DirectDraw Surface'
farbfeld\t'Farbfeld'
gif\t'Graphics Interchange Format'
hdr\t'Radiance RGBE'
ico\t'ICO file format'
jpeg\t'JPEG'
openexr\t'OpenEXR'
png\t'Portable Network Graphics'
pnm\t'Portable Anymap Format'
qoi\t'Quite OK Image Format'
svg\t'Scalable Vector Graphics'
tga\t'Truevision TGA'
tiff\t'Tag Image File Format'
webp\t'WebP'
xbm\t'X BitMap'"
complete -c qrtool -n "__fish_qrtool_using_subcommand decode" -l verbose -d 'Also print the metadata'
complete -c qrtool -n "__fish_qrtool_using_subcommand decode" -l metadata -d 'Print only the metadata'
complete -c qrtool -n "__fish_qrtool_using_subcommand decode" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c qrtool -n "__fish_qrtool_using_subcommand decode" -s V -l version -d 'Print version'
complete -c qrtool -n "__fish_qrtool_using_subcommand completion" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c qrtool -n "__fish_qrtool_using_subcommand completion" -s V -l version -d 'Print version'
complete -c qrtool -n "__fish_qrtool_using_subcommand help; and not __fish_seen_subcommand_from encode decode completion help" -f -a "encode" -d 'Encode input data in a QR code'
complete -c qrtool -n "__fish_qrtool_using_subcommand help; and not __fish_seen_subcommand_from encode decode completion help" -f -a "decode" -d 'Detect and decode a QR code'
complete -c qrtool -n "__fish_qrtool_using_subcommand help; and not __fish_seen_subcommand_from encode decode completion help" -f -a "completion" -d 'Generate shell completion'
complete -c qrtool -n "__fish_qrtool_using_subcommand help; and not __fish_seen_subcommand_from encode decode completion help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
