/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.JvmType;
import com.strobel.core.StringUtilities;

public final class JavaPrimitiveCast {
    public static Object cast(JvmType targetType, Object input) {
        switch (targetType) {
            case Boolean: {
                if (input instanceof Boolean) {
                    return input;
                }
                if (input instanceof Number) {
                    if (input instanceof Float || input instanceof Double) break;
                    return ((Number)input).longValue() != 0L;
                }
                if (input instanceof Character) {
                    return ((Character)input).charValue() != '\u0000';
                }
                if (!(input instanceof String)) break;
                return StringUtilities.isTrue((String)input);
            }
            case Byte: {
                if (input instanceof Number) {
                    return ((Number)input).byteValue();
                }
                if (input instanceof Character) {
                    return (byte)((Character)input).charValue();
                }
                if (!(input instanceof String)) break;
                return Byte.parseByte((String)input);
            }
            case Character: {
                if (input instanceof Character) {
                    return input;
                }
                if (input instanceof Number) {
                    return Character.valueOf((char)((Number)input).intValue());
                }
                if (!(input instanceof String)) break;
                String stringValue = (String)input;
                return Character.valueOf(stringValue.length() == 0 ? (char)'\u0000' : stringValue.charAt(0));
            }
            case Short: {
                if (input instanceof Number) {
                    return ((Number)input).shortValue();
                }
                if (input instanceof Character) {
                    return (short)((Character)input).charValue();
                }
                if (!(input instanceof String)) break;
                return Short.parseShort((String)input);
            }
            case Integer: {
                if (input instanceof Number) {
                    return ((Number)input).intValue();
                }
                if (input instanceof Boolean) {
                    return (Boolean)input != false ? 1 : 0;
                }
                if (input instanceof String) {
                    return Integer.parseInt((String)input);
                }
                if (!(input instanceof Character)) break;
                return (int)((Character)input).charValue();
            }
            case Long: {
                if (input instanceof Number) {
                    return ((Number)input).longValue();
                }
                if (input instanceof Character) {
                    return (long)((Character)input).charValue();
                }
                if (!(input instanceof String)) break;
                return Long.parseLong((String)input);
            }
            case Float: {
                if (input instanceof Number) {
                    return Float.valueOf(((Number)input).floatValue());
                }
                if (input instanceof Character) {
                    return Float.valueOf(((Character)input).charValue());
                }
                if (!(input instanceof String)) break;
                return Float.valueOf(Float.parseFloat((String)input));
            }
            case Double: {
                if (input instanceof Number) {
                    return ((Number)input).doubleValue();
                }
                if (input instanceof Character) {
                    return (double)((Character)input).charValue();
                }
                if (!(input instanceof String)) break;
                return Double.parseDouble((String)input);
            }
            default: {
                return input;
            }
        }
        throw new ClassCastException();
    }
}

