/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;

public class SimpleJsonResponseFormatter
extends JsonResponseFormatter<QueryResult> {
    public SimpleJsonResponseFormatter(JsonResponseFormatter.Style style) {
        super(style);
    }

    @Override
    public Object buildJsonObject(QueryResult response) {
        JsonResponse.JsonResponseBuilder json = JsonResponse.builder();
        json.total(response.size()).size(response.size());
        response.columnNameTypes().forEach((name, type2) -> json.column(new Column((String)name, (String)type2)));
        json.datarows(this.fetchDataRows(response));
        return json.build();
    }

    private Object[][] fetchDataRows(QueryResult response) {
        Object[][] rows = new Object[response.size()][];
        int i = 0;
        for (Object[] values2 : response) {
            rows[i++] = values2;
        }
        return rows;
    }

    public static class JsonResponse {
        private final List<Column> schema;
        private final Object[][] datarows;
        private long total;
        private long size;

        @Generated
        JsonResponse(List<Column> schema, Object[][] datarows, long total, long size) {
            this.schema = schema;
            this.datarows = datarows;
            this.total = total;
            this.size = size;
        }

        @Generated
        public static JsonResponseBuilder builder() {
            return new JsonResponseBuilder();
        }

        @Generated
        public List<Column> getSchema() {
            return this.schema;
        }

        @Generated
        public Object[][] getDatarows() {
            return this.datarows;
        }

        @Generated
        public long getTotal() {
            return this.total;
        }

        @Generated
        public long getSize() {
            return this.size;
        }

        @Generated
        public static class JsonResponseBuilder {
            @Generated
            private ArrayList<Column> schema;
            @Generated
            private Object[][] datarows;
            @Generated
            private long total;
            @Generated
            private long size;

            @Generated
            JsonResponseBuilder() {
            }

            @Generated
            public JsonResponseBuilder column(Column column) {
                if (this.schema == null) {
                    this.schema = new ArrayList();
                }
                this.schema.add(column);
                return this;
            }

            @Generated
            public JsonResponseBuilder schema(Collection<? extends Column> schema) {
                if (schema == null) {
                    throw new NullPointerException("schema cannot be null");
                }
                if (this.schema == null) {
                    this.schema = new ArrayList();
                }
                this.schema.addAll(schema);
                return this;
            }

            @Generated
            public JsonResponseBuilder clearSchema() {
                if (this.schema != null) {
                    this.schema.clear();
                }
                return this;
            }

            @Generated
            public JsonResponseBuilder datarows(Object[][] datarows) {
                this.datarows = datarows;
                return this;
            }

            @Generated
            public JsonResponseBuilder total(long total) {
                this.total = total;
                return this;
            }

            @Generated
            public JsonResponseBuilder size(long size) {
                this.size = size;
                return this;
            }

            @Generated
            public JsonResponse build() {
                return new JsonResponse(switch (this.schema == null ? 0 : this.schema.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.schema.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<Column>(this.schema));
                }, this.datarows, this.total, this.size);
            }

            @Generated
            public String toString() {
                return "SimpleJsonResponseFormatter.JsonResponse.JsonResponseBuilder(schema=" + String.valueOf(this.schema) + ", datarows=" + Arrays.deepToString((Object[])this.datarows) + ", total=" + this.total + ", size=" + this.size + ")";
            }
        }
    }

    public static class Column {
        private final String name;
        private final String type;

        @Generated
        public Column(String name, String type2) {
            this.name = name;
            this.type = type2;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }
    }
}

