/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import shaded.com.google.common.base.Strings;
import shaded.com.google.common.collect.ImmutableMap;

public enum Format {
    JDBC("jdbc"),
    CSV("csv"),
    RAW("raw"),
    VIZ("viz"),
    SIMPLE("simple"),
    STANDARD("standard"),
    EXTENDED("extended"),
    COST("cost");

    private final String formatName;
    public static final Map<String, Format> RESPONSE_FORMATS;
    public static final Map<String, Format> EXPLAIN_FORMATS;

    public static Optional<Format> of(String formatName) {
        String format = Strings.isNullOrEmpty(formatName) ? "jdbc" : formatName.toLowerCase();
        return Optional.ofNullable(RESPONSE_FORMATS.getOrDefault(format, null));
    }

    public static Optional<Format> ofExplain(String formatName) {
        String format = Strings.isNullOrEmpty(formatName) ? "standard" : formatName.toLowerCase();
        return Optional.ofNullable(EXPLAIN_FORMATS.getOrDefault(format, null));
    }

    @Generated
    private Format(String formatName) {
        this.formatName = formatName;
    }

    @Generated
    public String getFormatName() {
        return this.formatName;
    }

    static {
        ImmutableMap.Builder<String, Format> builder = new ImmutableMap.Builder<String, Format>();
        builder.put(Format.JDBC.formatName, JDBC);
        builder.put(Format.CSV.formatName, CSV);
        builder.put(Format.RAW.formatName, RAW);
        builder.put(Format.VIZ.formatName, VIZ);
        RESPONSE_FORMATS = builder.build();
        builder = new ImmutableMap.Builder();
        builder.put(Format.SIMPLE.formatName, SIMPLE);
        builder.put(Format.STANDARD.formatName, STANDARD);
        builder.put(Format.EXTENDED.formatName, EXTENDED);
        builder.put(Format.COST.formatName, COST);
        EXPLAIN_FORMATS = builder.build();
    }
}

