/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import lombok.Generated;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.ScriptQueryBuilder;
import org.opensearch.script.Script;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.opensearch.storage.script.core.ExpressionScript;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.LikeQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.LuceneQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.NestedQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.RangeQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.TermQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.MatchBoolPrefixQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.MatchPhrasePrefixQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.MatchPhraseQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.MatchQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.MultiMatchQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.QueryQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.QueryStringQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.SimpleQueryStringQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.WildcardQuery;
import org.opensearch.sql.opensearch.storage.serialization.ExpressionSerializer;
import shaded.com.google.common.collect.ImmutableMap;

public class FilterQueryBuilder
extends ExpressionNodeVisitor<QueryBuilder, Object> {
    private final ExpressionSerializer serializer;
    private final Map<FunctionName, LuceneQuery> luceneQueries = ImmutableMap.builder().put(BuiltinFunctionName.EQUAL.getName(), new TermQuery()).put(BuiltinFunctionName.LESS.getName(), (TermQuery)((Object)new RangeQuery(RangeQuery.Comparison.LT))).put(BuiltinFunctionName.GREATER.getName(), (TermQuery)((Object)new RangeQuery(RangeQuery.Comparison.GT))).put(BuiltinFunctionName.LTE.getName(), (TermQuery)((Object)new RangeQuery(RangeQuery.Comparison.LTE))).put(BuiltinFunctionName.GTE.getName(), (TermQuery)((Object)new RangeQuery(RangeQuery.Comparison.GTE))).put(BuiltinFunctionName.LIKE.getName(), (TermQuery)((Object)new LikeQuery())).put(BuiltinFunctionName.MATCH.getName(), (TermQuery)((Object)new MatchQuery())).put(BuiltinFunctionName.MATCH_PHRASE.getName(), (TermQuery)((Object)new MatchPhraseQuery())).put(BuiltinFunctionName.MATCHPHRASE.getName(), (TermQuery)((Object)new MatchPhraseQuery())).put(BuiltinFunctionName.MATCHPHRASEQUERY.getName(), (TermQuery)((Object)new MatchPhraseQuery())).put(BuiltinFunctionName.QUERY.getName(), (TermQuery)((Object)new QueryQuery())).put(BuiltinFunctionName.MATCH_QUERY.getName(), (TermQuery)((Object)new MatchQuery())).put(BuiltinFunctionName.MATCHQUERY.getName(), (TermQuery)((Object)new MatchQuery())).put(BuiltinFunctionName.MULTI_MATCH.getName(), (TermQuery)((Object)new MultiMatchQuery())).put(BuiltinFunctionName.MULTIMATCH.getName(), (TermQuery)((Object)new MultiMatchQuery())).put(BuiltinFunctionName.MULTIMATCHQUERY.getName(), (TermQuery)((Object)new MultiMatchQuery())).put(BuiltinFunctionName.SIMPLE_QUERY_STRING.getName(), (TermQuery)((Object)new SimpleQueryStringQuery())).put(BuiltinFunctionName.QUERY_STRING.getName(), (TermQuery)((Object)new QueryStringQuery())).put(BuiltinFunctionName.MATCH_BOOL_PREFIX.getName(), (TermQuery)((Object)new MatchBoolPrefixQuery())).put(BuiltinFunctionName.MATCH_PHRASE_PREFIX.getName(), (TermQuery)((Object)new MatchPhrasePrefixQuery())).put(BuiltinFunctionName.WILDCARD_QUERY.getName(), (TermQuery)((Object)new WildcardQuery())).put(BuiltinFunctionName.WILDCARDQUERY.getName(), (TermQuery)((Object)new WildcardQuery())).put(BuiltinFunctionName.NESTED.getName(), (TermQuery)((Object)new NestedQuery())).build();

    public QueryBuilder build(Expression expr) {
        return expr.accept(this, null);
    }

    @Override
    public QueryBuilder visitFunction(FunctionExpression func, Object context) {
        FunctionName name = func.getFunctionName();
        switch (name.getFunctionName()) {
            case "and": {
                return this.buildBoolQuery(func, context, BoolQueryBuilder::filter);
            }
            case "or": {
                return this.buildBoolQuery(func, context, BoolQueryBuilder::should);
            }
            case "not": {
                return this.buildBoolQuery(func, context, BoolQueryBuilder::mustNot);
            }
            case "nested": {
                throw new SyntaxCheckException("Invalid syntax used for nested function in WHERE clause: nested(field | field, path) OPERATOR LITERAL");
            }
        }
        LuceneQuery query = this.luceneQueries.get(name);
        if (query != null && query.canSupport(func)) {
            return query.build(func);
        }
        if (query != null && query.isNestedPredicate(func)) {
            NestedQuery nestedQuery = (NestedQuery)this.luceneQueries.get(((FunctionExpression)func.getArguments().get(0)).getFunctionName());
            return nestedQuery.buildNested(func, query);
        }
        return this.buildScriptQuery(func);
    }

    private BoolQueryBuilder buildBoolQuery(FunctionExpression node, Object context, BiFunction<BoolQueryBuilder, QueryBuilder, QueryBuilder> accumulator) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (Expression arg : node.getArguments()) {
            accumulator.apply(boolQuery, arg.accept(this, context));
        }
        return boolQuery;
    }

    private ScriptQueryBuilder buildScriptQuery(FunctionExpression node) {
        Set<ReferenceExpression> fields2 = ExpressionScript.extractFields(node);
        if (fields2.stream().anyMatch(field -> field.getType() == ExprCoreType.STRUCT)) {
            throw new ScriptQueryUnSupportedException("Script query does not support fields of struct type in OpenSearch.");
        }
        return new ScriptQueryBuilder(new Script(Script.DEFAULT_SCRIPT_TYPE, "opensearch_query_expression", this.serializer.serialize(node), Collections.emptyMap()));
    }

    @Generated
    public FilterQueryBuilder(ExpressionSerializer serializer) {
        this.serializer = serializer;
    }

    public static class ScriptQueryUnSupportedException
    extends RuntimeException {
        public ScriptQueryUnSupportedException(String message) {
            super(message);
        }
    }
}

