/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.type;

import java.util.List;
import java.util.Map;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import shaded.com.google.common.collect.ImmutableMap;

public class OpenSearchTextType
extends OpenSearchDataType {
    private static final OpenSearchTextType instance = new OpenSearchTextType();
    Map<String, OpenSearchDataType> fields = ImmutableMap.of();

    private OpenSearchTextType() {
        super(OpenSearchDataType.MappingType.Text);
        this.exprCoreType = ExprCoreType.UNKNOWN;
    }

    public static OpenSearchTextType of(Map<String, OpenSearchDataType> fields2) {
        OpenSearchTextType res = new OpenSearchTextType();
        res.fields = fields2;
        return res;
    }

    public static OpenSearchTextType of() {
        return instance;
    }

    @Override
    public List<ExprType> getParent() {
        return List.of(ExprCoreType.STRING);
    }

    @Override
    public boolean shouldCast(ExprType other) {
        return false;
    }

    public Map<String, OpenSearchDataType> getFields() {
        return this.fields;
    }

    @Override
    protected OpenSearchDataType cloneEmpty() {
        return OpenSearchTextType.of(Map.copyOf(this.fields));
    }

    public static String convertTextToKeyword(String fieldName, ExprType fieldType) {
        if (fieldType instanceof OpenSearchTextType && ((OpenSearchTextType)fieldType).getFields().size() > 0) {
            return fieldName + ".keyword";
        }
        return fieldName;
    }
}

